/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.ErrorTextProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.ExternalProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.PlausiElementCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.ProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.ReferenceFunctionProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.java.ThemenbereichConstructorGenerator;
import de.statspez.pleditor.generator.codegen.java.ThemenbereichParentInterfaceGenerator;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.codegen.support.LiteralManager;
import de.statspez.pleditor.generator.codegen.support.NamespaceHelper;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public class ThemenbereichCodeGenerator
extends PlausiElementCodeGenerator {
    private CodegenContext context = null;
    private LiteralManager literalManager = null;
    private Scope scope = null;
    private int numOfFields;
    private Stack segments;
    private Vector fields;

    public synchronized void generate(CodegenContext aContext, MetaThemenbereich aTb, Scope tbScope) {
        this.context = aContext;
        this.scope = tbScope;
        this.numOfFields = 0;
        this.segments = new Stack();
        this.fields = new Vector();
        this.context.putContextInfo("TOPIC_CLASS_NAME_KEY", this.getTbClass(aTb));
        aTb.accept(this);
        this.checkForErrors();
        this.out.flush();
        this.context.putContextInfo("TOPIC_CLASS_NAME_KEY", null);
    }

    public void setLiteralManager(LiteralManager aManager) {
        this.literalManager = aManager;
    }

    private void createTbConstructor(MetaThemenbereich tb, String className, boolean superIsNotBaseClass, Vector fieldsToInit) {
        ThemenbereichConstructorGenerator codeGen = new ThemenbereichConstructorGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(this.context.getMessageContext());
        codeGen.generate(this.context, tb, className, superIsNotBaseClass, this.withinSegment(), fieldsToInit.iterator());
    }

    private void createSetInitValuesMethod(MetaThemenbereich aTb) {
        if (aTb.sizeOfInitialisierungswerte() > 0) {
            MetaCustomInitwert anInitwert;
            this.indentNewLine();
            this.indentNewLine();
            this.out.print("public void ");
            this.out.print("setInitValues");
            this.out.print("(");
            this.out.print("PlausiRuntimeContext");
            this.out.print(" context");
            Iterator it = aTb.getInitialisierungswerte();
            while (it.hasNext()) {
                anInitwert = (MetaCustomInitwert)it.next();
                this.out.print(", ");
                if (anInitwert.getListe()) {
                    this.out.print("Array ");
                } else {
                    this.out.print("Value ");
                }
                this.out.print(StringHelper.getEscapedName(anInitwert.getName()));
            }
            this.out.print(")");
            this.openBlock();
            it = aTb.getInitialisierungswerte();
            while (it.hasNext()) {
                anInitwert = (MetaCustomInitwert)it.next();
                String varname = StringHelper.getEscapedName(anInitwert.getName());
                if (anInitwert.getListe()) {
                    this.indentNewLine();
                    this.out.print("SupportLib.copyArray(");
                    this.out.print(varname);
                    this.out.print(", this.");
                    this.out.print(varname);
                    this.out.print(", context);");
                    continue;
                }
                this.indentNewLine();
                this.out.print("this.");
                this.out.print(varname);
                this.out.print(".set(context, ");
                this.out.print(varname);
                this.out.print(");");
            }
            this.endMethodDefinition();
        }
    }

    private void createGetInstanceMethod(MetaThemenbereich aTb) {
        this.indentNewLine();
        this.defineMethod("public", "TopicField", "getInstance", "int[] indizes");
        this.indentNewLine();
        this.out.print("return new ");
        this.out.print(this.getTbClass(aTb));
        this.out.print("(");
        this.out.print("getVorgaenger");
        this.out.print("(), ");
        this.out.print("getFeldDeskriptor");
        this.out.print("(), indizes);");
        this.endMethodDefinition();
    }

    private void startNewSegment() {
        String baseClassName = "TopicField";
        if (this.withinSegment()) {
            baseClassName = ((SegmentInfo)this.segments.peek()).className;
        }
        String className = this.context.getNextPlausiSegmentClassName();
        String filename = className + ".java";
        Writer writer = this.context.createWriter(filename);
        this.segments.push(new SegmentInfo(className, filename, writer, this.out, this.indentLevel()));
        this.setOutput(writer);
        this.setIndentLevel(0);
        this.out.print("package ");
        this.out.print(this.context.getPlausiPackage());
        this.out.print(";");
        this.indentNewLine();
        this.indentNewLine();
        this.out.print("import ");
        this.out.print("de.statspez.pleditor.generator.runtime.");
        this.out.print("*;");
        this.indentNewLine();
        this.out.print("import ");
        this.out.print("de.statspez.pleditor.generator.runtime.plausi.");
        this.out.print("*;");
        this.indentNewLine();
        this.defineClass(className, "public abstract", baseClassName);
    }

    private void startNewSegmentIfNecessary(MetaElement element) {
        if (this.numOfFields >= this.context.getMaxElementsInSegment(5)) {
            this.numOfFields = 1;
            this.startNewSegment();
        } else {
            ++this.numOfFields;
        }
        if (this.withinSegment() && !(element instanceof MetaTBMaterialReferenz)) {
            ((SegmentInfo)this.segments.peek()).fields.add(element);
        } else {
            this.fields.add(element);
        }
    }

    private void closeCurrentSegment(MetaThemenbereich tb) {
        if (this.withinSegment()) {
            SegmentInfo segment = (SegmentInfo)this.segments.peek();
            this.indentNewLine();
            this.createTbConstructor(tb, segment.className, this.segments.size() > 1, segment.fields);
            this.endClassDefinition();
            this.out.flush();
            this.segments.pop();
            this.context.destroyWriter(segment.filename, segment.writer);
            this.out = segment.previousOut;
            this.setIndentLevel(segment.previousIndentLevel);
        }
    }

    private boolean withinSegment() {
        return !this.segments.isEmpty();
    }

    private void createPruefungFehlerMethod(MetaCustomPruefung pruefung, String[] referenzFeldStruktur, String[] referenzFeldTypen, int[][] referenzFeldIndizes) {
        String programName = pruefung.getMetaSpezifikation().name();
        String key = pruefung.getPruefschluessel();
        this.defineMethod("protected", "void", "fehler_" + programName, "PlausiRuntimeContext context, int errorNum, Throwable thr");
        this.indentNewLine();
        this.out.print("PlausiFehler");
        this.out.print(" fehler = createPlausiFehler(\"");
        this.out.print(key);
        this.out.print("\");");
        this.indentNewLine();
        this.out.print("fehler.setFehlerInfoTyp(errorNum);");
        this.indentNewLine();
        this.out.print("context.writeSectionInfosToError(fehler);");
        MetaProgram errorTextShortProgram = this.context.getTextResource().getFehlertextKurzProgram(pruefung);
        MetaProgram errorTextLongProgram = this.context.getTextResource().getFehlertextLangProgram(pruefung);
        MetaProgram correctionAdviceProgram = this.context.getTextResource().getKorrekturhinweisProgram(pruefung);
        this.printErrorTextProgram("setFehlertextKurz", errorTextShortProgram);
        this.printErrorTextProgram("setFehlertextLang", errorTextLongProgram);
        this.printErrorTextProgram("setFehlerKorrekturhinweis", correctionAdviceProgram);
        boolean referenzFeldHatListen = false;
        if (referenzFeldStruktur != null && referenzFeldStruktur.length > 0) {
            for (int i = 0; i < referenzFeldIndizes.length; ++i) {
                if (referenzFeldIndizes[i] == null || referenzFeldIndizes[i].length <= 0) continue;
                referenzFeldHatListen = true;
                break;
            }
            if (referenzFeldHatListen) {
                this.indentNewLine();
                this.out.print("try");
                this.openBlock();
            }
            this.indentNewLine();
            this.out.print("FeatureVariable __refField = ");
            StringBuffer refFieldBuf = new StringBuffer();
            for (int i = 0; i < referenzFeldStruktur.length; ++i) {
                boolean referenzFeldIstMehrfachantwort;
                if (i > 0) {
                    refFieldBuf.append('.');
                }
                boolean referenzFeldIstListe = referenzFeldIndizes[i] != null && referenzFeldIndizes[i].length > 0;
                boolean bl = referenzFeldIstMehrfachantwort = referenzFeldIndizes[i] != null && referenzFeldIndizes[i].length == 0;
                if (referenzFeldIstListe) {
                    refFieldBuf.insert(0, "(" + referenzFeldTypen[i] + ") ");
                    if (i != referenzFeldStruktur.length - 1) {
                        refFieldBuf.insert(0, '(');
                    }
                }
                refFieldBuf.append(StringHelper.getEscapedName(referenzFeldStruktur[i]));
                if (referenzFeldIstListe) {
                    refFieldBuf.append(".getElement(context, new int[]{");
                    for (int j = 0; j < referenzFeldIndizes[i].length; ++j) {
                        int index;
                        if (j > 0) {
                            refFieldBuf.append(",");
                        }
                        if ((index = referenzFeldIndizes[i][j]) > 0) {
                            --index;
                        }
                        refFieldBuf.append(index);
                    }
                    refFieldBuf.append("})");
                    if (i == referenzFeldStruktur.length - 1) continue;
                    refFieldBuf.append(')');
                    continue;
                }
                if (!referenzFeldIstMehrfachantwort) continue;
                refFieldBuf.append(".getFeatureVariable()");
            }
            refFieldBuf.append(";");
            this.out.print(refFieldBuf.toString());
            this.indentNewLine();
            this.out.print("fehler.setFehlerId(__refField.hierarchyAsString() + \"#" + key + "\");");
            this.indentNewLine();
            this.out.print("fehler.setReferenzFeld(__refField);");
            if (referenzFeldHatListen) {
                this.closeBlock();
                this.indentNewLine();
                this.out.print("catch (IndexOutOfBoundsException ex)");
                this.openBlock();
                this.indentNewLine();
                this.out.print("context.getLogger().error(\"Fehler beim Zugriff auf Indizes im Hauptbezugsfeld von " + programName + "\",ex);");
            }
        }
        if (referenzFeldHatListen || referenzFeldStruktur == null || referenzFeldStruktur.length == 0) {
            this.indentNewLine();
            this.out.print("fehler.setFehlerId(context.getCurrentField() != null ? ");
            this.out.print("context.getCurrentField().hierarchyAsString()");
            this.out.print("+ \"#" + key + "\"");
            this.out.print(" : \"#" + key + "\"");
            this.out.print(");");
            this.indentNewLine();
            this.out.print("fehler.setReferenzFeld(context.getCurrentField());");
        }
        if (referenzFeldHatListen) {
            this.closeBlock();
            this.indentNewLine();
        }
        this.indentNewLine();
        this.out.print("fehler.setLaufzeitFehlerAufgetreten(thr != null);");
        this.indentNewLine();
        this.out.print("fehler.setLaufzeitException(thr);");
        this.indentNewLine();
        this.out.print("context.getLogger().trace(\"FehlerID angeschrieben: \" + fehler.getFehlerId());");
        this.indentNewLine();
        this.out.print("context.getPlausiKontext().setFehler(fehler);");
        this.endMethodDefinition();
    }

    private void printErrorTextProgram(String setMethodName, MetaProgram defaultProgram) {
        if (defaultProgram != null) {
            this.indentNewLine();
            this.out.print("try");
            this.openBlock();
            ErrorTextProgramCodeGenerator prgGen = new ErrorTextProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            prgGen.setLiteralManager(this.literalManager);
            prgGen.preGenerate();
            this.indentNewLine();
            this.out.print("fehler.");
            this.out.print(setMethodName);
            this.out.print("(");
            prgGen.generate(this.context, defaultProgram, this.scope, false);
            this.out.print(");");
            this.closeBlock();
            this.indentNewLine();
            this.out.print("catch (Exception ex)");
            this.openBlock();
            this.closeBlock();
        }
    }

    private void createAddFehlwerteMethod(MetaThemenbereich tb) {
        this.defineMethod("public", "void", "addFehlwerte", "PlausiRuntimeContext context, java.util.Vector fehlwerte");
        boolean firstArray = true;
        boolean firstValue = true;
        boolean firstClassification = true;
        Iterator iter = tb.getFelder();
        while (iter.hasNext()) {
            MetaCustomTBFeld feld = (MetaCustomTBFeld)iter.next();
            if (feld.getKlasse() instanceof MetaThemenbereich) {
                int i;
                if (!CodegenUtil.containsMissingValues((MetaThemenbereich)feld.getKlasse())) continue;
                if (feld.dimensions() == null || feld.dimensions().length == 0) {
                    this.indentNewLine();
                    this.out.print(StringHelper.getEscapedName(feld.getName()));
                    this.out.print(".addFehlwerte(context, fehlwerte);");
                    continue;
                }
                String indices = "null";
                for (i = 0; i < feld.dimensions().length; ++i) {
                    char iterVar = (char)(105 + i);
                    String lengthVar = iterVar + "_length";
                    this.indentNewLine();
                    this.out.print("for (int ");
                    this.out.print(iterVar);
                    this.out.print(" = 0, ");
                    this.out.print(lengthVar);
                    this.out.print(" = ");
                    this.out.print(StringHelper.getEscapedName(feld.getName()));
                    this.out.print(".getLengthOfDimension(context, ");
                    this.out.print(indices);
                    this.out.print("); ");
                    this.out.print(iterVar);
                    this.out.print(" < ");
                    this.out.print(lengthVar);
                    this.out.print("; ");
                    this.out.print(iterVar);
                    this.out.print("++)");
                    indices = "new int[] {";
                    for (int j = 0; j <= i; ++j) {
                        if (j > 0) {
                            indices = indices + ", ";
                        }
                        indices = indices + (char)(105 + j);
                    }
                    indices = indices + "}";
                    this.openBlock();
                }
                this.indentNewLine();
                this.out.print("((TopicField) ");
                this.out.print(StringHelper.getEscapedName(feld.getName()));
                this.out.print(".getElement(context, ");
                this.out.print(indices);
                this.out.print(")).addFehlwerte(context, fehlwerte);");
                for (i = 0; i < feld.dimensions().length; ++i) {
                    this.closeBlock();
                }
                continue;
            }
            MetaMerkmal merkmal = (MetaMerkmal)feld.getKlasse();
            if (merkmal.getKlasseFehlwerte() == null) continue;
            String escapedName = StringHelper.getEscapedName(feld.getName());
            if (feld.dimensions() == null || feld.dimensions().length == 0) {
                this.indentNewLine();
                if (firstValue) {
                    this.out.print("Value ");
                    firstValue = false;
                }
                this.out.print("value = ");
                if (feld.getMehrfachantworten()) {
                    this.out.print("((FeatureVariable) ");
                }
                this.out.print(escapedName);
                if (feld.getMehrfachantworten()) {
                    this.out.print(".getElement(context, new int[] {0}))");
                }
                this.out.print(".get(context);");
                this.indentNewLine();
                if (firstClassification) {
                    this.out.print("Classification ");
                    firstClassification = false;
                }
                this.out.print("cls = ");
                this.out.print("((ClassificationGroup) classificationByCode(\"");
                this.out.print("#");
                this.out.print(merkmal.getKlasseFehlwerte().getName());
                this.out.print("\")).getFromClassifications(value);");
                this.indentNewLine();
                this.out.print("if (cls != null) fehlwerte.add(new Fehlwert(");
                if (feld.getMehrfachantworten()) {
                    this.out.print("(FeatureVariable) ");
                }
                this.out.print(escapedName);
                if (feld.getMehrfachantworten()) {
                    this.out.print(".getElement(context, new int[] {0})");
                }
                this.out.print(", value.asString(), cls.value().asString()));");
                continue;
            }
            this.indentNewLine();
            if (firstArray) {
                this.out.print("ArrayIterator ");
                firstArray = false;
            }
            this.out.print("iter = SupportLib.forceArrayIteratorFor(");
            this.out.print(StringHelper.getEscapedName(feld.getName()));
            this.out.print(", context);");
            this.indentNewLine();
            this.out.print("while (iter.hasNext())");
            this.openBlock();
            this.indentNewLine();
            this.out.print("FeatureVariable feld = (FeatureVariable) iter.next();");
            this.indentNewLine();
            this.out.print("Value nextValue = feld.get(context);");
            this.indentNewLine();
            this.out.print("Classification nextCls = ");
            this.out.print("((ClassificationGroup) classificationByCode(\"");
            this.out.print("#");
            this.out.print(merkmal.getKlasseFehlwerte().getName());
            this.out.print("\")).getFromClassifications(nextValue);");
            this.indentNewLine();
            this.out.print("if (nextCls != null) fehlwerte.add(new Fehlwert(feld, nextValue.asString(), nextCls.value().asString()));");
            this.closeBlock();
        }
        this.endMethodDefinition();
    }

    private void createFieldErrorTextesMethods(MetaThemenbereich tb) {
        Iterator iter = tb.getFelder();
        while (iter.hasNext()) {
            MetaProgram korrekturhinweisProgram;
            MetaProgram fehlertextLangProgram;
            MetaCustomTBFeld feld = (MetaCustomTBFeld)iter.next();
            if (!(feld.getKlasse() instanceof MetaMerkmal)) continue;
            MetaProgram fehlertextKurzProgram = this.context.getTextResource().getFehlertextKurzProgram(feld);
            if (fehlertextKurzProgram != null) {
                this.defineMethod("private", "String", "errShort_" + StringHelper.getEscapedName(feld.getName()), "PlausiRuntimeContext context");
                ErrorTextProgramCodeGenerator prgGen = new ErrorTextProgramCodeGenerator();
                prgGen.setOutput(this.out);
                prgGen.setIndentLevel(this.indentLevel());
                prgGen.setLiteralManager(this.literalManager);
                prgGen.preGenerate();
                this.indentNewLine();
                this.print("return ");
                prgGen.generate(this.context, fehlertextKurzProgram, this.scope, false);
                this.print(";");
                this.closeBlock();
            }
            if ((fehlertextLangProgram = this.context.getTextResource().getFehlertextLangProgram(feld)) != null) {
                this.defineMethod("private", "String", "errLong_" + StringHelper.getEscapedName(feld.getName()), "PlausiRuntimeContext context");
                ErrorTextProgramCodeGenerator prgGen = new ErrorTextProgramCodeGenerator();
                prgGen.setOutput(this.out);
                prgGen.setIndentLevel(this.indentLevel());
                prgGen.setLiteralManager(this.literalManager);
                prgGen.preGenerate();
                this.indentNewLine();
                this.print("return ");
                prgGen.generate(this.context, fehlertextLangProgram, this.scope, false);
                this.print(";");
                this.closeBlock();
            }
            if ((korrekturhinweisProgram = this.context.getTextResource().getKorrekturhinweisProgram(feld)) == null) continue;
            this.defineMethod("private", "String", "corrAdv_" + StringHelper.getEscapedName(feld.getName()), "PlausiRuntimeContext context");
            ErrorTextProgramCodeGenerator prgGen = new ErrorTextProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            prgGen.setLiteralManager(this.literalManager);
            prgGen.preGenerate();
            this.indentNewLine();
            this.print("return ");
            prgGen.generate(this.context, korrekturhinweisProgram, this.scope, false);
            this.print(";");
            this.closeBlock();
        }
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        boolean extend;
        if (((MetaCustomThemenbereich)tb).hasReferenceFunctions()) {
            ThemenbereichParentInterfaceGenerator tbParentIfcGenerator = new ThemenbereichParentInterfaceGenerator();
            tbParentIfcGenerator.setOutput(this.out);
            tbParentIfcGenerator.setIndentLevel(this.indentLevel());
            tb.accept(tbParentIfcGenerator);
            this.newLine();
        }
        List<MetaCustomThemenbereich> subTbsWithReferenceFunctions = CodegenUtil.getSubTbsWithReferenceFunctions((MetaCustomThemenbereich)tb);
        ArrayList<String> tbClassInterfaces = new ArrayList<String>();
        for (MetaCustomThemenbereich subTb : subTbsWithReferenceFunctions) {
            String ifcName = ThemenbereichCodeGenerator.getParentInterfaceNameFor(subTb);
            tbClassInterfaces.add(ifcName);
        }
        if (tb.sizeOfFelder() + tb.sizeOfVariablen() + tb.sizeOfMaterialreferenzen() + tb.sizeOfInitialisierungswerte() > this.context.getMaxElementsInSegment(5)) {
            extend = true;
            this.startNewSegment();
        } else {
            extend = false;
            this.defineClass(this.getTbClass(tb), "public", "TopicField", tbClassInterfaces);
        }
        this.visitElements(tb.getFelder());
        this.visitElements(tb.getVariablen());
        this.visitElements(tb.getMaterialreferenzen());
        this.visitElements(tb.getInitialisierungswerte());
        if (extend) {
            String className = ((SegmentInfo)this.segments.peek()).className;
            while (this.withinSegment()) {
                this.closeCurrentSegment(tb);
            }
            this.defineClass(this.getTbClass(tb), "public", className, tbClassInterfaces);
        }
        this.createTbConstructor(tb, this.getTbClass(tb), extend, this.fields);
        this.createGetInstanceMethod(tb);
        this.createSetInitValuesMethod(tb);
        if (((MetaCustomThemenbereich)tb).referencedByErhebung()) {
            this.visitElements(tb.getPruefungen());
            this.visitElements(tb.getAblaeufe());
            this.visitElements(tb.getFunktionen());
        }
        if (CodegenUtil.containsMissingValues(tb)) {
            this.createAddFehlwerteMethod(tb);
        }
        this.createFieldErrorTextesMethods(tb);
        this.endClassDefinition();
    }

    protected static String getParentInterfaceNameFor(MetaThemenbereich tb) {
        String tbName = tb.getName();
        String parentIfcName = "TB_P_" + StringHelper.getEscapedName(tbName);
        return parentIfcName;
    }

    @Override
    public void visitTBFeld(MetaTBFeld aFeld) {
        this.startNewSegmentIfNecessary(aFeld);
        MetaCustomTBFeld feld = (MetaCustomTBFeld)aFeld;
        String type = null;
        if (feld.getKlasse() instanceof MetaMerkmal) {
            type = aFeld.getListe() ? "FeatureArray" : "FeatureVariable";
        } else if (feld.getKlasse() instanceof MetaThemenbereich) {
            if (aFeld.getListe()) {
                type = "TopicArray";
            } else {
                type = this.getTbClass((MetaThemenbereich)feld.getKlasse());
                if (this.withinSegment()) {
                    type = this.context.getPlausiClassName() + "." + type;
                }
            }
        } else {
            this.error(aFeld, "Das Feld " + feld.getName() + " hat eine ungueltige Feld-Klasse (" + aFeld.getKlasse() + ")");
        }
        this.indentNewLine();
        this.out.print("public transient ");
        this.out.print(type);
        this.out.print(" ");
        this.out.print(StringHelper.getEscapedName(aFeld.getName()));
        this.out.print(";");
    }

    @Override
    public void visitTBMaterialReferenz(MetaTBMaterialReferenz materialReferenz) {
        this.startNewSegmentIfNecessary(materialReferenz);
        MetaPLMaterial material = materialReferenz.getMaterialbeschreibung();
        MetaCustomThemenbereich materialTb = (MetaCustomThemenbereich)material.getThemenbereich();
        this.indentNewLine();
        this.out.print("public transient ");
        if (this.withinSegment()) {
            this.out.print(this.context.getPlausiClassName());
            this.out.print(".");
        }
        this.out.print("Material");
        this.out.print(this.getTbClass(materialTb));
        this.out.print(" ");
        this.out.print("__material_ref_");
        this.out.print(StringHelper.getEscapedName(materialReferenz.getName()));
        this.out.print(";");
    }

    @Override
    public void visitPLPruefung(MetaPLPruefung aPruefung) {
        MetaCustomPruefung pruefung = (MetaCustomPruefung)aPruefung;
        this.indentNewLine();
        ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        prgGen.setLiteralManager(this.literalManager);
        prgGen.setErrorContext(new ElementMessageContext(1, pruefung.getId(), pruefung.getPruefschluessel(), 6, pruefung.getThemenbereich().getId(), pruefung.getThemenbereich().getName()));
        prgGen.generate(this.context, pruefung.getMetaSpezifikation(), this.scope, false, true, new Short(pruefung.getFehlergewicht()));
        this.indentNewLine();
        String[] referenzFeldStrings = null;
        String[] referenzFeldTypen = null;
        Object referenzFeldIndizes = null;
        if (pruefung.sizeOfHauptBezugsfeld() > 0) {
            MetaIdentifier referenzFeld = null;
            Iterator it = pruefung.getHauptBezugsfeld();
            int anzahlBezugsfelder = pruefung.sizeOfHauptBezugsfeld();
            referenzFeldTypen = new String[anzahlBezugsfelder];
            referenzFeldIndizes = new int[anzahlBezugsfelder][];
            boolean ok = true;
            NamespaceHelper nsHelper = new NamespaceHelper();
            int strukturTiefe = 0;
            while (ok && it.hasNext()) {
                ++strukturTiefe;
                referenzFeld = new MetaIdentifier(((MetaStatspezObjekt)it.next()).getName());
                if (!this.scope.isDefined(referenzFeld, nsHelper.namespace())) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' ist nicht definiert");
                    ok = false;
                }
                SymbolDescriptor sd = this.scope.symbolDescriptor(referenzFeld, nsHelper.namespace());
                if (ok && strukturTiefe == anzahlBezugsfelder && sd.isArray() && !sd.isMehrfachantwort() && (pruefung.hauptbezugsfeldIndex() == null || pruefung.hauptbezugsfeldIndex().length == 0)) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Listenfeld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' wurde kein Index angegeben.");
                    ok = false;
                }
                if (ok && strukturTiefe == anzahlBezugsfelder && sd.isArray() && !sd.isMehrfachantwort() && pruefung.hauptbezugsfeldIndex() != null) {
                    if (pruefung.hauptbezugsfeldIndex().length != sd.dimensions()) {
                        this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Listenfeld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' hat nicht die richtige Dimension " + sd.dimensions() + ".");
                        ok = false;
                    } else {
                        for (int j = 0; j < sd.dimensions() && ok; ++j) {
                            if ((sd.dimension(j) < 0 || sd.dimension(j) >= pruefung.hauptbezugsfeldIndex()[j]) && pruefung.hauptbezugsfeldIndex()[j] > 0) continue;
                            String def = sd.dimension(j) >= 0 ? "" + sd.dimension(j) : "N";
                            String ind = pruefung.hauptbezugsfeldIndex()[j] >= 0 ? "" + pruefung.hauptbezugsfeldIndex()[j] : "N";
                            this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Listenfeld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' hat einen inkonsistenten Index " + ind + " au\u00dferhalb des Bereichs bis " + def + ".");
                            ok = false;
                        }
                    }
                }
                if (ok && !sd.isTbField()) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' ist kein Themenbereichs-Feld");
                    ok = false;
                }
                if (ok && it.hasNext() && !sd.fieldReferencesTb()) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' referenziert keinen Themenbereich");
                    ok = false;
                }
                if (ok && !it.hasNext() && sd.fieldReferencesTb()) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' referenziert einen Themenbereich");
                    ok = false;
                }
                if (ok && sd.isArray()) {
                    if (sd.isMehrfachantwort()) {
                        referenzFeldIndizes[strukturTiefe - 1] = new int[0];
                    } else if (strukturTiefe == anzahlBezugsfelder) {
                        referenzFeldIndizes[strukturTiefe - 1] = pruefung.hauptbezugsfeldIndex();
                    } else {
                        int[] dims = new int[sd.dimensions()];
                        for (int i = 0; i < dims.length; ++i) {
                            dims[i] = 1;
                        }
                        referenzFeldIndizes[strukturTiefe - 1] = dims;
                    }
                    referenzFeldTypen[strukturTiefe - 1] = sd.fieldReferencesTb() ? StringHelper.getEscapedName("TB_" + sd.getMerkmal()) : "FeatureVariable";
                }
                if (!ok) continue;
                nsHelper.enterSubNamespace(referenzFeld.value());
            }
            referenzFeldStrings = ok ? nsHelper.namespaceAsArray() : null;
        }
        this.createPruefungFehlerMethod(pruefung, referenzFeldStrings, referenzFeldTypen, (int[][])referenzFeldIndizes);
    }

    @Override
    public void visitPLAblauf(MetaPLAblauf ablauf) {
        MetaCustomAblauf a = (MetaCustomAblauf)ablauf;
        this.indentNewLine();
        ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        prgGen.setLiteralManager(this.literalManager);
        prgGen.setErrorContext(new ElementMessageContext(2, a.getId(), a.getName(), 6, a.getThemenbereich().getId(), a.getThemenbereich().getName()));
        prgGen.generate(this.context, a.getMetaSpezifikation(), this.scope, false);
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion funktion) {
        MetaCustomFunktion f = (MetaCustomFunktion)funktion;
        this.indentNewLine();
        String art = f.getArt();
        if ("extern".equals(art)) {
            ExternalProgramCodeGenerator externalProgramGenerator = new ExternalProgramCodeGenerator();
            externalProgramGenerator.setOutput(this.out);
            externalProgramGenerator.setIndentLevel(this.indentLevel());
            f.accept(externalProgramGenerator);
        } else if ("ref".equals(art)) {
            if (this.context == null) {
                throw new IllegalStateException("context ist null.");
            }
            ReferenceFunctionProgramCodeGenerator refFunctionProgramGenerator = new ReferenceFunctionProgramCodeGenerator(this.context);
            refFunctionProgramGenerator.setOutput(this.out);
            refFunctionProgramGenerator.setIndentLevel(this.indentLevel());
            f.accept(refFunctionProgramGenerator);
        } else {
            ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            prgGen.setLiteralManager(this.literalManager);
            int contextType = 4;
            if (f.getFunctionType() == 1) {
                contextType = 3;
            }
            prgGen.setErrorContext(new ElementMessageContext(contextType, f.getId(), f.getName(), 6, f.getThemenbereich().getId(), f.getThemenbereich().getName()));
            prgGen.generate(this.context, f.getMetaSpezifikation(), this.scope, true);
        }
    }

    @Override
    public void visitPLVariable(MetaPLVariable variable) {
        this.startNewSegmentIfNecessary(variable);
        this.indentNewLine();
        this.out.print("public transient ");
        if (variable.getListe()) {
            this.out.print("GlobalArray");
        } else {
            this.out.print("GlobalVariable");
        }
        this.out.print(" ");
        this.out.print(StringHelper.getEscapedName(variable.getName()));
        this.out.print(";");
    }

    @Override
    public void visitPLInitwert(MetaPLInitwert initwert) {
        this.startNewSegmentIfNecessary(initwert);
        this.indentNewLine();
        this.out.print("protected transient ");
        if (initwert.getListe()) {
            this.out.print("GlobalArray");
        } else {
            this.out.print("GlobalVariable");
        }
        this.out.print(" ");
        this.out.print(StringHelper.getEscapedName(initwert.getName()));
        this.out.print(";");
    }

    private class SegmentInfo {
        public String className;
        public String filename;
        public Writer writer;
        public PrintWriter previousOut;
        private int previousIndentLevel;
        private Vector fields;

        public SegmentInfo(String className, String filename, Writer writer, PrintWriter previousOut, int previousIndentLevel) {
            this.className = className;
            this.filename = filename;
            this.writer = writer;
            this.previousOut = previousOut;
            this.previousIndentLevel = previousIndentLevel;
            this.fields = new Vector();
        }
    }
}

