/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.html;

import de.statspez.pleditor.generator.codegen.analysis.CrossReferenceBuilder;
import de.statspez.pleditor.generator.codegen.doku.Settings;
import de.statspez.pleditor.generator.codegen.html.Assignment;
import de.statspez.pleditor.generator.codegen.html.FieldsExtractor;
import de.statspez.pleditor.generator.codegen.html.HtmlGeneratorUtil;
import de.statspez.pleditor.generator.codegen.html.HtmlProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.html.Precondition;
import de.statspez.pleditor.generator.codegen.html.PreconditionFieldsExtractor;
import de.statspez.pleditor.generator.codegen.html.PreconditionRefelementsExtractor;
import de.statspez.pleditor.generator.codegen.html.PreconditionWriter;
import de.statspez.pleditor.generator.codegen.html.TocItem;
import de.statspez.pleditor.generator.codegen.html.UsedPlFunctionsExtractor;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.codegen.support.StructureTraverser;
import de.statspez.pleditor.generator.codegen.support.TbScopeBuilder;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomVariable;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForEachCheck;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionIdentifier;
import de.statspez.pleditor.generator.meta.MetaHierarchicalForEachLoop;
import de.statspez.pleditor.generator.meta.MetaIdentifiesFunction;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaValueAccess;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.werum.prosi.common.io.IoUtil;
import de.werum.prosi.common.xml.XmlWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;

public class HtmlAblaufDocGenerator {
    private static final String STYLE_ID_TOC_CONTAINER = "toc_container";
    private static final String STYLE_CLASS_TOC_TITLE = "toc_title";
    private static final String STYLE_CLASS_TOC_LIST = "toc_list";
    public static final String STYLE_CLASS_CODE = "code";
    public static final String STYLE_CLASS_CODE_TITLE = "code-title";
    public static final String STYLE_CLASS_SECTION_TITLE = "section-title";
    public static final String STYLE_CLASS_PL_OBJ = "pl-obj";
    private static final String STYLE_CLASS_FELD = "feld";
    public static final String STYLE_CLASS_ABLAUF = "ablauf";
    private static final String STYLE_CLASS_PRUEFUNG = "pruefung";
    private static final String STYLE_CLASS_EIGENSCHAFT = "eigenschaft";
    private static final String STYLE_CLASS_FUNKTION = "funktion";
    private static final String STYLE_CLASS_PLVAR = "plvar";
    private static final String STYLE_CLASS_LOKALVAR = "lokalvar";
    private static final String STYLE_CLASS_INITWERT = "initwert";
    private static final String HREF_CSS_DOC = "css/doc.css";
    private static final String HREF_CSS_DOC_PAGE = "../css/doc.css";
    private static final String HREF_CSS_CODE_PAGE = "../css/code.css";
    private static final String FILE_NAME_TOC = "toc.html";
    private static final String FILE_NAME_INDEX = "index.html";
    private static final String FRAME_NAME_INHALT = "inhalt";
    private static final String FRAME_NAME_NAVIGATION = "navigation";
    private static final String IMG_DIR = "/de/statspez/pleditor/generator/images/";
    private static final String IMG_ABLAUF = "ablauf.gif";
    private static final String IMG_PRUEFUNG = "pruefung.gif";
    private static final String IMG_EIGENSCHAFT = "eigenschaft.gif";
    private static final String IMG_TBFELD = "tbfeld.gif";
    private static final String IMG_FUNKTION = "funktion.gif";
    private static final String IMG_PLVAR = "plvar.gif";
    private static final String IMG_LOKALVAR = "lokalvar.gif";
    private static final String IMG_INITWERT = "initwert.gif";
    private static final String EIGENSCHAFT_PREFIX_KODE = "WENN\n";
    private static final String EIGENSCHAFT_POSTFIX_KODE = "\nDANN RUECKGABE WAHR SONST RUECKGABE FALSCH ENDE";
    private static final String PRUEFUNG_PREFIX_KODE = "WENN\n";
    private static final String PRUEFUNG_INFIX_KODE = "\nDANN";
    private static final String PRUEFUNG_POSTFIX_KODE = "\nFEHLER\nENDE";
    private final HtmlProgramCodeGenerator htmlProgramCodeGenerator = new HtmlProgramCodeGenerator();
    private final PreconditionWriter preconditionWriter = new PreconditionWriter();
    private File docDir;
    private Stack<Precondition> preconditionStack;
    private List<Assignment> assignments;
    private String currentNamespace = null;
    private String currentAblaufNamespace = null;
    private TocItem rootTocItem;
    private TocItem currentTocItem;
    private MetaCustomAblauf currentAblauf;

    public File generate(File outputDir, MetaCustomAblauf ablauf, MetaCustomPlausibilisierung plausi) throws Exception {
        File imgDir;
        File cssDir;
        TbScopeBuilder scopeBuilder = new TbScopeBuilder(new GenericSymbolDescriptorFactory());
        Hashtable tbScopes = new Hashtable();
        ScopeImpl scope = (ScopeImpl)scopeBuilder.createScopes(plausi, tbScopes);
        CrossReferenceBuilder crossReferenceBuilder = new CrossReferenceBuilder();
        crossReferenceBuilder.buildCrossReference(plausi, scope, tbScopes);
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        this.docDir = new File(outputDir, "doc");
        if (!this.docDir.exists()) {
            this.docDir.mkdir();
        }
        if (!(cssDir = new File(outputDir, "css")).exists()) {
            cssDir.mkdir();
        }
        if (!(imgDir = new File(outputDir, "img")).exists()) {
            imgDir.mkdir();
        }
        this.copyResourceFile("code.css", new File(cssDir, "code.css"));
        this.copyResourceFile("doc.css", new File(cssDir, "doc.css"));
        this.copyResourceFile("/de/statspez/pleditor/generator/images/ablauf.gif", new File(imgDir, IMG_ABLAUF));
        this.copyResourceFile("/de/statspez/pleditor/generator/images/pruefung.gif", new File(imgDir, IMG_PRUEFUNG));
        this.copyResourceFile("/de/statspez/pleditor/generator/images/eigenschaft.gif", new File(imgDir, IMG_EIGENSCHAFT));
        this.copyResourceFile("/de/statspez/pleditor/generator/images/tbfeld.gif", new File(imgDir, IMG_TBFELD));
        this.copyResourceFile("/de/statspez/pleditor/generator/images/funktion.gif", new File(imgDir, IMG_FUNKTION));
        this.copyResourceFile("/de/statspez/pleditor/generator/images/plvar.gif", new File(imgDir, IMG_PLVAR));
        this.copyResourceFile("/de/statspez/pleditor/generator/images/lokalvar.gif", new File(imgDir, IMG_LOKALVAR));
        this.copyResourceFile("/de/statspez/pleditor/generator/images/initwert.gif", new File(imgDir, IMG_INITWERT));
        this.currentAblauf = ablauf;
        this.currentTocItem = this.rootTocItem = new TocItem(null, "Inhaltsverzeichnis", null, null, null);
        this.preconditionStack = new Stack();
        this.assignments = new ArrayList<Assignment>();
        TocItem hauptAblaufItem = this.generatePageHauptAblauf(outputDir, ablauf);
        PLAblaufCodeTraverser codeTraverser = new PLAblaufCodeTraverser();
        ablauf.getMetaSpezifikation().accept(codeTraverser);
        this.generatePageToc(outputDir, hauptAblaufItem);
        File indexHtml = new File(outputDir, FILE_NAME_INDEX);
        this.generatePageIndex(indexHtml, hauptAblaufItem, ablauf);
        return indexHtml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePageIndex(File indexHtml, TocItem hauptAblaufItem, MetaCustomAblauf ablauf) throws Exception {
        FileOutputStream fOut = new FileOutputStream(indexHtml);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fOut, "UTF-8");
            try {
                BufferedWriter buf = new BufferedWriter(writer);
                try {
                    XmlWriter out = new XmlWriter((Writer)buf, false);
                    try {
                        out.startTag("html");
                        this.startHead(out, HREF_CSS_DOC);
                        this.writeHeadTitle(out, ablauf.getName(), ablauf.getThemenbereich().getName(), "img\\ablauf.gif");
                        out.endTag();
                        out.startTag("frameset");
                        out.writeAttribute("cols", "25%, *");
                        out.startTag("frame");
                        out.writeAttribute("src", FILE_NAME_TOC);
                        out.writeAttribute("name", FRAME_NAME_NAVIGATION);
                        out.endTag();
                        out.startTag("frame");
                        out.writeAttribute("src", hauptAblaufItem.getHref());
                        out.writeAttribute("name", FRAME_NAME_INHALT);
                        out.endTag();
                        out.endTag();
                        out.endTag();
                        out.flush();
                        out.close();
                    }
                    finally {
                        IoUtil.closeQuietly((Closeable)out);
                    }
                }
                finally {
                    IoUtil.closeQuietly((Closeable)buf);
                }
            }
            finally {
                IoUtil.closeQuietly((Closeable)fOut);
            }
        }
        finally {
            IoUtil.closeQuietly((Closeable)fOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePageToc(File outputDir, TocItem hauptAblaufItem) throws Exception {
        FileOutputStream fOut = new FileOutputStream(new File(outputDir, FILE_NAME_TOC));
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fOut, "UTF-8");
            try {
                BufferedWriter buf = new BufferedWriter(writer);
                try {
                    XmlWriter out = new XmlWriter((Writer)buf, false);
                    try {
                        out.startTag("html");
                        this.startHead(out, HREF_CSS_DOC);
                        out.endTag();
                        out.startTag("body");
                        out.startTag("div");
                        out.writeAttribute("id", STYLE_ID_TOC_CONTAINER);
                        out.startTag("p");
                        out.writeAttribute("class", STYLE_CLASS_TOC_TITLE);
                        this.writeLink(out, hauptAblaufItem);
                        out.endTag();
                        out.startTag("p");
                        out.writeAttribute("class", STYLE_CLASS_TOC_TITLE);
                        out.write("Reihenfolge PL-Pr\u00fcfungen");
                        out.endTag();
                        this.writeTocItemChildren(out, this.rootTocItem.getChildren());
                        out.endTag();
                        out.endTag();
                        out.endTag();
                        out.flush();
                        out.close();
                    }
                    finally {
                        IoUtil.closeQuietly((Closeable)out);
                    }
                }
                finally {
                    IoUtil.closeQuietly((Closeable)buf);
                }
            }
            finally {
                IoUtil.closeQuietly((Closeable)fOut);
            }
        }
        finally {
            IoUtil.closeQuietly((Closeable)fOut);
        }
    }

    private void generatePageAblauf(File outputDir, MetaCustomAblauf ablauf, String themenbereich) throws Exception {
        String number = this.generateNextNumber();
        File homeHtml = this.createPageFile(number);
        String title = themenbereich != null ? "Themenbereich \"" + themenbereich + "\" mit Ablauf \"" + ablauf.getName() + "\"" : "Ablauf " + ablauf.getThemenbereich().getName() + "." + ablauf.getName();
        TocItem tocItem = new TocItem(number, title, "doc\\" + homeHtml.getName(), STYLE_CLASS_ABLAUF, null);
        this.currentTocItem.addChild(tocItem);
        this.currentTocItem = tocItem;
        this.generateAblaufFile(homeHtml, number, ablauf);
    }

    private TocItem generatePageHauptAblauf(File outputDir, MetaCustomAblauf ablauf) throws Exception {
        File homeHtml = new File(this.docDir, "home.html");
        String number = null;
        String title = "Ablauf " + ablauf.getThemenbereich().getName() + "." + ablauf.getName();
        TocItem tocItem = new TocItem(number, title, "doc\\" + homeHtml.getName(), STYLE_CLASS_ABLAUF, null);
        this.generateAblaufFile(homeHtml, number, ablauf);
        return tocItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePageFeldpruefung(MetaCustomTBFeld tbfeld, MetaValueAccess metaValueAccess) throws Exception {
        MetaCustomMerkmal merkmal = (MetaCustomMerkmal)tbfeld.getKlasse();
        String number = this.generateNextNumber();
        File file = this.createPageFile(number);
        TocItem tocItem = new TocItem(number, "Feldpr\u00fcfung " + tbfeld.getThemenbereich().getName() + "." + tbfeld.getName(), "doc\\" + file.getName(), STYLE_CLASS_FELD, this.getRelativeNamespace());
        this.currentTocItem.addChild(tocItem);
        FileOutputStream fOut = new FileOutputStream(file);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fOut, "UTF-8");
            try {
                BufferedWriter buf = new BufferedWriter(writer);
                try {
                    XmlWriter out = new XmlWriter((Writer)buf, false);
                    try {
                        out.startTag("html");
                        this.startHead(out, HREF_CSS_DOC_PAGE, HREF_CSS_CODE_PAGE);
                        this.writeHeadTitle(out, tbfeld.getName(), tbfeld.getThemenbereich().getName(), "..\\img\\tbfeld.gif");
                        out.endTag();
                        out.startTag("body");
                        this.writeStartTable(out);
                        this.writeRowName(out, "Pr\u00fcfungsname:", number, tbfeld.getName(), tbfeld.getThemenbereich(), STYLE_CLASS_FELD);
                        this.writeRow(out, "Verwendungskontext:", this.currentNamespace);
                        this.writeRowVorbeding(out);
                        this.writeRowSpezifikationen(out, this.findeSpezifikationenVorbedingung());
                        this.writeRowAssignments(out, metaValueAccess);
                        out.startTag("tr");
                        out.startTag("th");
                        out.write("Pr\u00fcfbedingung:");
                        out.endTag();
                        out.startTag("td");
                        out.write("Typ: " + Settings.FELD_TYP[merkmal.getTyp() - 1]);
                        out.write(", L\u00e4nge: " + merkmal.getLaenge());
                        out.write(merkmal.getLeer() ? ", leer erlaubt" : ", leer nicht erlaubt");
                        if (tbfeld.getMehrfachantworten()) {
                            out.write(", Mehrfachnennung");
                        }
                        if (merkmal.getKlasseWertebereich() != null) {
                            out.write(", Auspr\u00e4gungsgruppe: " + merkmal.getKlasseWertebereich().getName());
                        } else if (merkmal.getWertebereich() != null && merkmal.getWertebereich().trim().length() > 0) {
                            out.write(", Wertebereich: " + merkmal.getWertebereich());
                        }
                        out.endTag();
                        out.endTag();
                        this.writeRow(out, "Pr\u00fcfungsart:", "Muss-Fehler");
                        this.writeRow(out, "Fehlertext(kurz):", merkmal.getFehlertextKurz());
                        out.endTag();
                        out.endTag();
                        out.endTag();
                        out.flush();
                        out.close();
                    }
                    finally {
                        IoUtil.closeQuietly((Closeable)out);
                    }
                }
                finally {
                    IoUtil.closeQuietly((Closeable)buf);
                }
            }
            finally {
                IoUtil.closeQuietly((Closeable)fOut);
            }
        }
        finally {
            IoUtil.closeQuietly((Closeable)fOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePagePruefung(MetaCustomPruefung pruefung, MetaElement metaIdentifiesFunction) throws Exception {
        String number = this.generateNextNumber();
        File file = this.createPageFile(number);
        TocItem tocItem = new TocItem(number, "Pr\u00fcfung " + pruefung.getThemenbereich().getName() + "." + pruefung.getName(), "doc\\" + file.getName(), STYLE_CLASS_PRUEFUNG, this.getRelativeNamespace());
        this.currentTocItem.addChild(tocItem);
        FileOutputStream fOut = new FileOutputStream(file);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fOut, "UTF-8");
            try {
                BufferedWriter buf = new BufferedWriter(writer);
                try {
                    XmlWriter out = new XmlWriter((Writer)buf, false);
                    try {
                        out.startTag("html");
                        this.startHead(out, HREF_CSS_DOC_PAGE, HREF_CSS_CODE_PAGE);
                        this.writeHeadTitle(out, pruefung.getName(), pruefung.getThemenbereich().getName(), "..\\img\\pruefung.gif");
                        out.endTag();
                        out.startTag("body");
                        this.writeStartTable(out);
                        this.writeRowName(out, "Pr\u00fcfungsname:", number, pruefung.getName(), pruefung.getThemenbereich(), STYLE_CLASS_PRUEFUNG);
                        this.writeRow(out, "Verwendungskontext:", this.currentNamespace);
                        this.writeRowVorbeding(out);
                        this.writeRowSpezifikationen(out, this.findeSpezifikationenVorbedingung());
                        this.writeRowAssignments(out, metaIdentifiesFunction);
                        String bedingung = this.extractPruefBedingung(pruefung.getPLSpezifikation());
                        this.writeRowCode(out, "Pr\u00fcfbedingung:", bedingung);
                        MetaConditionalStatement conditionalStatement = (MetaConditionalStatement)pruefung.getMetaSpezifikation().statements().statementAt(0);
                        this.writeRowSpezifikationen(out, this.getUsedPlFunctions(conditionalStatement.condition()));
                        String anweisung = this.extractPruefAnweisung(pruefung.getPLSpezifikation());
                        if (anweisung != null && anweisung.trim().length() > 0) {
                            this.writeRowCode(out, "Maschinelle Korr.:", anweisung);
                            if (conditionalStatement.ifTrue() != null) {
                                this.writeRowSpezifikationen(out, this.getUsedPlFunctions(conditionalStatement.ifTrue()));
                            }
                        }
                        this.writeRow(out, "Pr\u00fcfungsart:", Settings.FEHLERTEXTE[pruefung.getPruefungsart() - 1]);
                        this.writeRow(out, "Fehlertext(kurz):", pruefung.getFehlertextKurz());
                        out.endTag();
                        out.endTag();
                        out.endTag();
                        out.flush();
                        out.close();
                    }
                    finally {
                        IoUtil.closeQuietly((Closeable)out);
                    }
                }
                finally {
                    IoUtil.closeQuietly((Closeable)buf);
                }
            }
            finally {
                IoUtil.closeQuietly((Closeable)fOut);
            }
        }
        finally {
            IoUtil.closeQuietly((Closeable)fOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAblaufFile(File homeHtml, String number, MetaCustomAblauf ablauf) throws Exception {
        FileOutputStream fOut = new FileOutputStream(homeHtml);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fOut, "UTF-8");
            try {
                BufferedWriter buf = new BufferedWriter(writer);
                try {
                    XmlWriter out = new XmlWriter((Writer)buf, false);
                    try {
                        out.startTag("html");
                        this.startHead(out, HREF_CSS_DOC_PAGE, HREF_CSS_CODE_PAGE);
                        this.writeHeadTitle(out, ablauf.getName(), ablauf.getThemenbereich().getName(), "..\\img\\ablauf.gif");
                        out.endTag();
                        out.startTag("body");
                        this.writeStartTable(out);
                        this.writeRowName(out, "Ablaufname:", number, ablauf.getName(), ablauf.getThemenbereich(), STYLE_CLASS_ABLAUF);
                        this.writeRow(out, "Verwendungskontext:", this.currentNamespace);
                        this.writeRow(out, "Kommentar:", ablauf.getKommentar());
                        if (this.preconditionStack != null && this.preconditionStack.size() > 0) {
                            this.writeRowVorbeding(out);
                            this.writeRowSpezifikationen(out, this.findeSpezifikationenVorbedingung());
                        }
                        this.writeRowCode(out, "Ablaufspezifikation:", ablauf.getSpezifikation());
                        out.endTag();
                        out.endTag();
                        out.endTag();
                        out.flush();
                        out.close();
                    }
                    finally {
                        IoUtil.closeQuietly((Closeable)out);
                    }
                }
                finally {
                    IoUtil.closeQuietly((Closeable)buf);
                }
            }
            finally {
                IoUtil.closeQuietly((Closeable)fOut);
            }
        }
        finally {
            IoUtil.closeQuietly((Closeable)fOut);
        }
    }

    private void writeRowName(XmlWriter out, String title, String number, String name, MetaThemenbereich themenbereich, String styleClass) throws IOException {
        out.startTag("tr");
        out.startTag("th");
        out.write(title);
        out.endTag();
        out.startTag("th");
        if (number != null) {
            out.write(number + " ");
        }
        out.startTag("span");
        out.writeAttribute("class", "pl-obj " + styleClass);
        if (themenbereich != null) {
            out.write(themenbereich.getName() + ".");
        }
        out.write(name);
        out.endTag();
        out.endTag();
        out.endTag();
    }

    private void writeRowVorbeding(XmlWriter out) throws IOException {
        if (this.preconditionStack.size() > 0) {
            out.startTag("tr");
            out.startTag("th");
            out.write("Vorbeding. in Ablauf:");
            out.endTag();
            out.startTag("td");
            this.preconditionWriter.writePreconditions(out, this.preconditionStack);
            out.endTag();
            out.endTag();
        }
    }

    private void writeRowAssignments(XmlWriter out, MetaElement metaElement) throws IOException {
        ArrayList<String> fields = new ArrayList<String>();
        Collection<String> fields_1 = new FieldsExtractor().extractFields(metaElement, this.currentAblauf, this.currentNamespace);
        fields.addAll(fields_1);
        if (this.preconditionStack.size() > 0) {
            Collection<String> fields_2 = new PreconditionFieldsExtractor().extractFields(this.preconditionStack);
            for (String tmp : fields_2) {
                if (fields.contains(tmp)) continue;
                fields.add(tmp);
            }
        }
        if (fields.size() > 0) {
            ArrayList<Assignment> assignmentList = new ArrayList<Assignment>();
            for (String field : fields) {
                for (Assignment assignment : this.assignments) {
                    boolean istSetzungDesFeldes;
                    if (assignment.getFieldWithNamespace().equals(field)) {
                        istSetzungDesFeldes = true;
                    } else {
                        String str1 = this.removeIndices(assignment.getFieldWithNamespace());
                        String str2 = this.removeIndices(field);
                        istSetzungDesFeldes = str1.equals(str2);
                    }
                    if (!istSetzungDesFeldes) continue;
                    assignmentList.add(assignment);
                }
            }
            if (assignmentList.size() > 0) {
                out.startTag("tr");
                out.startTag("td");
                out.write("Zuweisungen:");
                out.endTag();
                out.startTag("td");
                for (int i = 0; i < assignmentList.size(); ++i) {
                    Assignment assignment = (Assignment)assignmentList.get(i);
                    this.writeAssignment(out, assignment);
                }
                out.endTag();
                out.endTag();
                ArrayList<MetaElement> refElements = new ArrayList<MetaElement>();
                for (Assignment setzung : assignmentList) {
                    List<MetaElement> refs = this.getUsedPlFunctions(setzung.getAssignment());
                    for (MetaElement tmp : refs) {
                        if (refElements.contains(tmp)) continue;
                        refElements.add(tmp);
                    }
                }
                this.writeRowSpezifikationen(out, refElements);
            }
        }
    }

    private void writeRowSpezifikationen(XmlWriter out, List<MetaElement> refElements) throws IOException {
        if (refElements.size() > 0) {
            out.startTag("tr");
            out.startTag("td");
            out.write("Spezifikationen:");
            out.endTag();
            out.startTag("td");
            for (MetaElement metaElement : refElements) {
                this.writeSpezifikation(out, metaElement);
            }
            out.endTag();
            out.endTag();
        }
    }

    private void writeRowCode(XmlWriter out, String title, String code) throws IOException {
        out.startTag("tr");
        out.startTag("th");
        out.write(title);
        out.endTag();
        out.startTag("td");
        if (code != null && code.trim().length() > 0) {
            out.startTag("div").writeAttribute("class", STYLE_CLASS_CODE);
            this.htmlProgramCodeGenerator.generateHtml(code, out);
            out.endTag();
        }
        out.endTag();
        out.endTag();
    }

    private void writeRow(XmlWriter out, String title, String text) throws IOException {
        if (text != null && text.trim().length() > 0) {
            out.startTag("tr");
            out.startTag("td");
            out.write(title);
            out.endTag();
            out.startTag("td");
            out.write(text);
            out.endTag();
            out.endTag();
        }
    }

    private void writeTocItem(XmlWriter out, TocItem tocItem) throws IOException {
        out.startTag("li");
        if (tocItem.getNumber() != null) {
            out.write(tocItem.getNumber() + " ");
        }
        if (tocItem.getHref() != null) {
            this.writeLink(out, tocItem);
        } else {
            out.write(tocItem.getTitle());
        }
        this.writeTocItemChildren(out, tocItem.getChildren());
        out.endTag();
    }

    private void writeLink(XmlWriter out, TocItem tocItem) throws IOException {
        out.startTag("a");
        out.writeAttribute("class", "pl-obj " + tocItem.getStyleClass());
        out.writeAttribute("href", tocItem.getHref());
        out.writeAttribute("target", FRAME_NAME_INHALT);
        out.write(tocItem.getTitle());
        if (tocItem.getVerwendungskontext() != null) {
            out.write(" f\u00fcr ");
            out.write(tocItem.getVerwendungskontext());
        }
        out.endTag();
    }

    private void writeTocItemChildren(XmlWriter out, List<TocItem> childer) throws IOException {
        if (childer.size() > 0) {
            out.startTag("ul");
            out.writeAttribute("class", STYLE_CLASS_TOC_LIST);
            for (int i = 0; i < childer.size(); ++i) {
                TocItem child = childer.get(i);
                this.writeTocItem(out, child);
            }
            out.endTag();
        }
    }

    private void writeSpezifikation(XmlWriter out, MetaElement refElement) throws IOException {
        if (refElement instanceof MetaCustomFunktion) {
            MetaCustomFunktion function = (MetaCustomFunktion)refElement;
            String displayName = function.getThemenbereich() != null ? function.getThemenbereich().getName() + "." + function.getName() : function.getName();
            boolean isEigenschaft = function.getFunctionType() == 1;
            String code = isEigenschaft ? this.extractEigenschaftBedingung(function.getAnweisungen()) : function.getAnweisungen();
            out.startTag("div").writeAttribute("class", STYLE_CLASS_CODE_TITLE);
            out.startTag("span").writeAttribute("class", "pl-obj " + (isEigenschaft ? STYLE_CLASS_EIGENSCHAFT : STYLE_CLASS_FUNKTION));
            out.write(isEigenschaft ? "Eigenschaft " : "Funktion ");
            out.write(displayName);
            out.endTag();
            out.endTag();
            out.startTag("div").writeAttribute("class", STYLE_CLASS_CODE);
            this.htmlProgramCodeGenerator.generateHtml(code, out);
            out.endTag();
        } else if (refElement instanceof MetaCustomPruefung) {
            MetaCustomPruefung pruefung = (MetaCustomPruefung)refElement;
            String bedingung = this.extractPruefBedingung(pruefung.getPLSpezifikation());
            out.startTag("div").writeAttribute("class", STYLE_CLASS_CODE_TITLE);
            out.startTag("span").writeAttribute("class", "pl-obj pruefung");
            out.write("Pr\u00fcfung ");
            out.write(pruefung.getThemenbereich().getName() + "." + pruefung.getName());
            out.endTag();
            out.endTag();
            out.startTag("div").writeAttribute("class", STYLE_CLASS_CODE);
            this.htmlProgramCodeGenerator.generateHtml(bedingung, out);
            out.endTag();
        }
    }

    private void writeAssignment(XmlWriter out, Assignment assignment) throws IOException {
        out.startTag("div").writeAttribute("class", STYLE_CLASS_SECTION_TITLE);
        out.startTag("span");
        if (assignment.getReferredElement() instanceof MetaTBFeld) {
            out.writeAttribute("class", "pl-obj feld");
        } else if (assignment.getReferredElement() instanceof MetaCustomVariable) {
            out.writeAttribute("class", "pl-obj plvar");
        } else if (assignment.getReferredElement() instanceof MetaCustomInitwert) {
            out.writeAttribute("class", "pl-obj initwert");
        } else {
            out.writeAttribute("class", "pl-obj lokalvar");
        }
        out.write(assignment.getField());
        out.endTag();
        out.endTag();
        if (assignment.getPreconditions().isEmpty()) {
            PreconditionWriter.writeAblaufAsTitle(out, assignment.getAblauf());
            out.startTag("div").writeAttribute("class", STYLE_CLASS_CODE);
            this.htmlProgramCodeGenerator.generateHtml(assignment.getCode(), out);
            out.endTag();
        } else {
            this.preconditionWriter.writeCodeWithPreconditions(out, assignment.getPreconditions(), assignment.getCode());
        }
    }

    private void startHead(XmlWriter out, String ... cssFiles) throws IOException {
        out.startTag("head");
        out.startTag("meta");
        out.writeAttribute("charset", "UTF-8");
        out.endTag();
        for (String cssFile : cssFiles) {
            out.startTag("link");
            out.writeAttribute("rel", "stylesheet");
            out.writeAttribute("href", cssFile);
            out.endTag();
        }
    }

    private void writeHeadTitle(XmlWriter out, String name, String themenbereichName, String icon) throws IOException {
        out.startTag("title");
        out.write("Ablaufdokumentation ");
        out.write(name);
        out.write(" (");
        out.write(themenbereichName);
        out.write(")");
        out.endTag();
        out.startTag("link");
        out.writeAttribute("rel", "icon");
        out.writeAttribute("href", icon);
        out.endTag();
    }

    private void writeStartTable(XmlWriter out) throws IOException {
        out.startTag("table");
        out.startTag("colgroup");
        out.startTag("col");
        out.writeAttribute("width", "20%");
        out.endTag();
        out.endTag();
    }

    private File createPageFile(String number) {
        return new File(this.docDir, "chapter" + number + ".html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceFile(String source, File destination) throws IOException {
        BufferedInputStream fis = null;
        BufferedOutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(destination));
            try {
                fis = new BufferedInputStream(this.getClass().getResourceAsStream(source));
                byte[] buffer = new byte[1024];
                int length = 0;
                while ((length = ((InputStream)fis).read(buffer)) != -1) {
                    ((OutputStream)fos).write(buffer, 0, length);
                }
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(fis);
                throw throwable;
            }
            IoUtil.closeQuietly((Closeable)fis);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(fos);
            throw throwable;
        }
        IoUtil.closeQuietly((Closeable)fos);
    }

    private String extractPruefBedingung(String pruefkode) {
        int dann_index;
        String bedingung = null;
        if (pruefkode.startsWith("WENN\n") && (dann_index = pruefkode.indexOf(PRUEFUNG_INFIX_KODE)) > 0) {
            bedingung = pruefkode.substring("WENN\n".length(), dann_index);
        }
        return bedingung;
    }

    private String extractPruefAnweisung(String pruefkode) {
        int anweisung_ende_index;
        int anweisung_start_index;
        int dann_index;
        String anweisung = null;
        if (pruefkode.startsWith("WENN\n") && (dann_index = pruefkode.indexOf(PRUEFUNG_INFIX_KODE)) > 0 && (anweisung_start_index = dann_index + PRUEFUNG_INFIX_KODE.length()) < (anweisung_ende_index = pruefkode.indexOf(PRUEFUNG_POSTFIX_KODE)) && (anweisung = pruefkode.substring(anweisung_start_index, anweisung_ende_index)) != null && anweisung.startsWith("\n")) {
            anweisung = anweisung.substring(1);
        }
        return anweisung;
    }

    private String extractEigenschaftBedingung(String pruefkode) {
        int dann_index;
        String bedingung = null;
        if (pruefkode.startsWith("WENN\n") && (dann_index = pruefkode.indexOf(EIGENSCHAFT_POSTFIX_KODE)) > 0) {
            bedingung = pruefkode.substring("WENN\n".length(), dann_index);
        }
        return bedingung;
    }

    private String generateNextNumber() {
        StringBuilder result = new StringBuilder();
        if (this.currentTocItem.getNumber() != null) {
            result.append(this.currentTocItem.getNumber());
            result.append('.');
        }
        result.append(this.currentTocItem.getChildren().size() + 1);
        return result.toString();
    }

    private String getRelativeNamespace() {
        String result = this.currentAblaufNamespace == null ? this.currentNamespace : (this.currentNamespace.length() > this.currentAblaufNamespace.length() ? this.currentNamespace.substring(this.currentAblaufNamespace.length() + 1) : null);
        return result;
    }

    private List<MetaElement> findeSpezifikationenVorbedingung() {
        PreconditionRefelementsExtractor refelementExtractor = new PreconditionRefelementsExtractor();
        List<MetaElement> refElements = refelementExtractor.extractRefelements(this.preconditionStack);
        return refElements;
    }

    private List<MetaElement> getUsedPlFunctions(MetaElement code) {
        UsedPlFunctionsExtractor refelementExtractor = new UsedPlFunctionsExtractor();
        List<MetaElement> refElements = refelementExtractor.getUsedPlFunctions(code);
        return refElements;
    }

    private String removeIndices(String field) {
        StringBuilder str = new StringBuilder();
        boolean indexSegment = false;
        for (int i = 0; i < field.length(); ++i) {
            char ch = field.charAt(i);
            if (ch == '[') {
                str.append(ch);
                indexSegment = true;
                continue;
            }
            if (ch == ']') {
                str.append(ch);
                indexSegment = false;
                continue;
            }
            if (indexSegment) continue;
            str.append(ch);
        }
        return str.toString();
    }

    private class PLAblaufCodeTraverser
    extends Traverser {
        private PLAblaufCodeTraverser() {
        }

        @Override
        public void visitAblaufStatement(MetaAblaufStatement aStatement) {
            String previousAblaufNamespace = HtmlAblaufDocGenerator.this.currentAblaufNamespace;
            TocItem previousTocItem = HtmlAblaufDocGenerator.this.currentTocItem;
            MetaCustomAblauf previousAblauf = HtmlAblaufDocGenerator.this.currentAblauf;
            String previousNamespace = this.enterStructure((MetaElement)((Object)aStatement.function().adaptedObject()));
            String themenbereich = this.getThemenbereich(aStatement);
            HtmlAblaufDocGenerator.this.currentAblaufNamespace = HtmlAblaufDocGenerator.this.currentNamespace;
            MetaCustomAblauf subablauf = (MetaCustomAblauf)aStatement.referredElement();
            HtmlAblaufDocGenerator.this.currentAblauf = subablauf;
            try {
                HtmlAblaufDocGenerator.this.generatePageAblauf(HtmlAblaufDocGenerator.this.docDir, subablauf, themenbereich);
                subablauf.getMetaSpezifikation().accept(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            HtmlAblaufDocGenerator.this.currentTocItem = previousTocItem;
            HtmlAblaufDocGenerator.this.currentNamespace = previousNamespace;
            HtmlAblaufDocGenerator.this.currentAblauf = previousAblauf;
            HtmlAblaufDocGenerator.this.currentAblaufNamespace = previousAblaufNamespace;
        }

        @Override
        public void visitWhileLoop(MetaWhileLoop aStatement) {
            HtmlAblaufDocGenerator.this.preconditionStack.push(new Precondition(aStatement, HtmlAblaufDocGenerator.this.currentAblauf, HtmlAblaufDocGenerator.this.currentNamespace, false));
            aStatement.loopBody().accept(this);
            HtmlAblaufDocGenerator.this.preconditionStack.pop();
        }

        @Override
        public void visitForNextLoop(MetaForNextLoop aStatement) {
            HtmlAblaufDocGenerator.this.preconditionStack.push(new Precondition(aStatement, HtmlAblaufDocGenerator.this.currentAblauf, HtmlAblaufDocGenerator.this.currentNamespace, false));
            aStatement.loopBody().accept(this);
            HtmlAblaufDocGenerator.this.preconditionStack.pop();
        }

        @Override
        public void visitForEachLoop(MetaForEachLoop aStatement) {
            HtmlAblaufDocGenerator.this.preconditionStack.push(new Precondition(aStatement, HtmlAblaufDocGenerator.this.currentAblauf, HtmlAblaufDocGenerator.this.currentNamespace, false));
            aStatement.loopBody().accept(this);
            HtmlAblaufDocGenerator.this.preconditionStack.pop();
        }

        @Override
        public void visitForEachCheck(MetaForEachCheck aStatement) {
            HtmlAblaufDocGenerator.this.preconditionStack.push(new Precondition(aStatement, HtmlAblaufDocGenerator.this.currentAblauf, HtmlAblaufDocGenerator.this.currentNamespace, false));
            super.visitForEachCheck(aStatement);
            HtmlAblaufDocGenerator.this.preconditionStack.pop();
        }

        @Override
        public void visitHierarchicalForEachLoop(MetaHierarchicalForEachLoop aStatement) {
            HtmlAblaufDocGenerator.this.preconditionStack.push(new Precondition(aStatement, HtmlAblaufDocGenerator.this.currentAblauf, HtmlAblaufDocGenerator.this.currentNamespace, false));
            String namespace = this.enterStructure((MetaElement)((Object)aStatement.value().adaptedObject()), true);
            aStatement.loopBody().accept(this);
            HtmlAblaufDocGenerator.this.currentNamespace = namespace;
            HtmlAblaufDocGenerator.this.preconditionStack.pop();
        }

        @Override
        public void visitConditionalStatement(MetaConditionalStatement aStatement) {
            aStatement.condition().accept(this);
            HtmlAblaufDocGenerator.this.preconditionStack.push(new Precondition(aStatement, HtmlAblaufDocGenerator.this.currentAblauf, HtmlAblaufDocGenerator.this.currentNamespace, false));
            aStatement.ifTrue().accept(this);
            HtmlAblaufDocGenerator.this.preconditionStack.pop();
            HtmlAblaufDocGenerator.this.preconditionStack.push(new Precondition(aStatement, HtmlAblaufDocGenerator.this.currentAblauf, HtmlAblaufDocGenerator.this.currentNamespace, true));
            aStatement.ifFalse().accept(this);
            HtmlAblaufDocGenerator.this.preconditionStack.pop();
        }

        @Override
        public void visitCheckFeldStatement(MetaCheckFeldStatement aStatement) {
            String namespace = this.enterStructure(aStatement.field());
            MetaCustomTBFeld tbfeld = (MetaCustomTBFeld)aStatement.referredElement();
            try {
                HtmlAblaufDocGenerator.this.generatePageFeldpruefung(tbfeld, aStatement.field());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            HtmlAblaufDocGenerator.this.currentNamespace = namespace;
        }

        @Override
        public void visitPruefeStatement(MetaPruefeStatement aStatement) {
            String namespace = this.enterStructure((MetaElement)((Object)aStatement.function().adaptedObject()));
            MetaCustomPruefung pruefung = (MetaCustomPruefung)aStatement.referredElement();
            try {
                HtmlAblaufDocGenerator.this.generatePagePruefung(pruefung, (MetaElement)((Object)aStatement.function().adaptedObject()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            HtmlAblaufDocGenerator.this.currentNamespace = namespace;
        }

        @Override
        public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
            ArrayList<Precondition> precondList = new ArrayList<Precondition>(HtmlAblaufDocGenerator.this.preconditionStack.size());
            precondList.addAll(HtmlAblaufDocGenerator.this.preconditionStack);
            Assignment setzung = new Assignment(anAssignment, precondList, HtmlAblaufDocGenerator.this.currentAblauf, HtmlAblaufDocGenerator.this.currentNamespace, 0);
            HtmlAblaufDocGenerator.this.assignments.add(setzung);
            super.visitSingleAssignment(anAssignment);
        }

        @Override
        public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
            ArrayList<Precondition> precondList = new ArrayList<Precondition>(HtmlAblaufDocGenerator.this.preconditionStack.size());
            precondList.addAll(HtmlAblaufDocGenerator.this.preconditionStack);
            for (int i = 0; i < anAssignment.numberOfLeftValues(); ++i) {
                Assignment setzung = new Assignment(anAssignment, precondList, HtmlAblaufDocGenerator.this.currentAblauf, HtmlAblaufDocGenerator.this.currentNamespace, i);
                HtmlAblaufDocGenerator.this.assignments.add(setzung);
            }
            super.visitMultiAssignment(anAssignment);
        }

        private void enterNamespace(MetaElement element) {
            String subns = null;
            if (element instanceof MetaFieldAccess) {
                subns = ((MetaFieldAccess)element).accessedField().value();
            } else if (element instanceof MetaArrayAccess) {
                subns = HtmlGeneratorUtil.getCodeSegment(HtmlAblaufDocGenerator.this.currentAblauf.getSpezifikation(), element);
            } else {
                throw new RuntimeException("ungueltiges Struktur-Element: " + element.getClass().getSimpleName());
            }
            if (HtmlAblaufDocGenerator.this.currentNamespace == null) {
                HtmlAblaufDocGenerator.this.currentNamespace = subns;
            } else {
                HtmlAblaufDocGenerator.this.currentNamespace = HtmlAblaufDocGenerator.this.currentNamespace + "." + subns;
            }
        }

        private String enterStructure(MetaElement element) {
            return this.enterStructure(element, false);
        }

        private String enterStructure(MetaElement element, final boolean enterLastStructureElement) {
            String previousNamespace = HtmlAblaufDocGenerator.this.currentNamespace;
            if (element instanceof MetaStructureAccess) {
                final StructureTraverser traverser = new StructureTraverser((MetaStructureAccess)element);
                traverser.eachElement(new StructureTraverser.CodeBlock(){

                    @Override
                    public void doForStructureElement(MetaValueAccess anAccess) {
                        PLAblaufCodeTraverser.this.enterNamespace(anAccess);
                    }

                    @Override
                    public void doForLastStructureElement(MetaValueAccess anAccess) {
                        if (enterLastStructureElement) {
                            PLAblaufCodeTraverser.this.enterNamespace(anAccess);
                        } else {
                            anAccess.accept(traverser);
                        }
                    }
                });
            } else if (enterLastStructureElement) {
                this.enterNamespace(element);
            }
            return previousNamespace;
        }

        private String getThemenbereich(MetaAblaufStatement aStatement) {
            final StringBuilder tbName = new StringBuilder();
            AbstractElementVisitor tbNameBuilder = new AbstractElementVisitor(){

                @Override
                public void visitStructureAccess(MetaStructureAccess anAccess) {
                    anAccess.structureAccess().accept(this);
                }

                @Override
                public void visitFieldAccess(MetaFieldAccess anAccess) {
                    this.addSubNamespace(anAccess.accessedField().value());
                }

                @Override
                public void visitArrayAccess(MetaArrayAccess anAccess) {
                    String subns = HtmlGeneratorUtil.getCodeSegment(HtmlAblaufDocGenerator.this.currentAblauf.getSpezifikation(), anAccess);
                    this.addSubNamespace(subns);
                }

                private void addSubNamespace(String subns) {
                    if (tbName.length() > 0) {
                        tbName.append(".");
                    }
                    tbName.append(subns);
                }
            };
            MetaFunctionIdentifier identifier = aStatement.function();
            MetaIdentifiesFunction function = identifier.adaptedObject();
            if (function != null && function instanceof MetaElement) {
                ((MetaElement)((Object)function)).accept(tbNameBuilder);
            }
            return tbName.length() == 0 ? null : tbName.toString();
        }
    }
}

