/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDialect
extends JdbcDialectImpl {
    private final String flagsRegexp = "^(\\(\\?([a-zA-Z])\\)).*$";
    private final Pattern flagsPattern = Pattern.compile("^(\\(\\?([a-zA-Z])\\)).*$");
    private final String escapeRegexp = "(\\\\Q([^\\\\Q]+)\\\\E)";
    private final Pattern escapePattern = Pattern.compile("(\\\\Q([^\\\\Q]+)\\\\E)");
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(MySqlDialect.class, Dialect.DatabaseProduct.MYSQL){

        protected boolean acceptsConnection(Connection connection) {
            try {
                return super.acceptsConnection(connection) && !MySqlDialect.isInfobright(connection.getMetaData());
            }
            catch (SQLException e) {
                throw Util.newError(e, "Error while instantiating dialect");
            }
        }
    };

    public MySqlDialect(Connection connection) throws SQLException {
        super(connection);
    }

    public static boolean isInfobright(DatabaseMetaData databaseMetaData) {
        Statement statement = null;
        try {
            ResultSet resultSet;
            String productVersion = databaseMetaData.getDatabaseProductVersion();
            if (productVersion.compareTo("5.1") >= 0 && (resultSet = (statement = databaseMetaData.getConnection().createStatement()).executeQuery("select * from INFORMATION_SCHEMA.engines where ENGINE = 'BRIGHTHOUSE'")).next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "while running query to detect Brighthouse engine");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    protected String deduceProductName(DatabaseMetaData databaseMetaData) {
        String productName = super.deduceProductName(databaseMetaData);
        if (MySqlDialect.isInfobright(databaseMetaData)) {
            return "MySQL (Infobright)";
        }
        return productName;
    }

    @Override
    protected String deduceIdentifierQuoteString(DatabaseMetaData databaseMetaData) {
        String quoteIdentifierString = super.deduceIdentifierQuoteString(databaseMetaData);
        if (quoteIdentifierString == null) {
            quoteIdentifierString = "`";
        }
        return quoteIdentifierString;
    }

    @Override
    protected boolean deduceSupportsSelectNotInGroupBy(Connection connection) throws SQLException {
        boolean supported = false;
        String sqlmode = this.getCurrentSqlMode(connection);
        if (sqlmode == null) {
            supported = true;
        } else if (!sqlmode.contains("ONLY_FULL_GROUP_BY")) {
            supported = true;
        }
        return supported;
    }

    private String getCurrentSqlMode(Connection connection) throws SQLException {
        return this.getSqlMode(connection, Scope.SESSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSqlMode(Connection connection, Scope scope) throws SQLException {
        String sqlmode = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            if (s.execute("SELECT @@" + (Object)((Object)scope) + ".sql_mode") && (rs = s.getResultSet()).next()) {
                sqlmode = rs.getString(1);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return sqlmode;
    }

    @Override
    public void appendHintsAfterFromClause(StringBuilder buf, Map<String, String> hints) {
        String forcedIndex;
        if (hints != null && (forcedIndex = hints.get("force_index")) != null) {
            buf.append(" FORCE INDEX (");
            buf.append(forcedIndex);
            buf.append(")");
        }
    }

    @Override
    public boolean requiresAliasForFromQuery() {
        return true;
    }

    @Override
    public boolean allowsFromQuery() {
        return this.productVersion.compareTo("4.") >= 0;
    }

    @Override
    public boolean allowsCompoundCountDistinct() {
        return true;
    }

    @Override
    public void quoteStringLiteral(StringBuilder buf, String value) {
        buf.append('\'');
        String s0 = Util.replace(value, "'", "''");
        String s1 = Util.replace(s0, "\\", "\\\\");
        buf.append(s1);
        buf.append('\'');
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, valueList.isEmpty() ? "from (select 1) as t" : null, false);
    }

    @Override
    protected String generateOrderByNulls(String expr, boolean ascending, boolean collateNullsLast) {
        if (collateNullsLast) {
            if (ascending) {
                return "ISNULL(" + expr + ") ASC, " + expr + " ASC";
            }
            return expr + " DESC";
        }
        if (ascending) {
            return expr + " ASC";
        }
        return "ISNULL(" + expr + ") DESC, " + expr + " DESC";
    }

    @Override
    public boolean requiresHavingAlias() {
        return true;
    }

    @Override
    public boolean supportsMultiValueInExpr() {
        return true;
    }

    @Override
    public boolean allowsRegularExpressionInWhereClause() {
        return true;
    }

    @Override
    public String generateRegularExpression(String source, String javaRegex) {
        String flags;
        try {
            Pattern.compile(javaRegex);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        Matcher flagsMatcher = this.flagsPattern.matcher(javaRegex);
        boolean caseSensitive = true;
        if (flagsMatcher.matches() && (flags = flagsMatcher.group(2)).contains("i")) {
            caseSensitive = false;
        }
        if (flagsMatcher.matches()) {
            javaRegex = javaRegex.substring(0, flagsMatcher.start(1)) + javaRegex.substring(flagsMatcher.end(1));
        }
        Matcher escapeMatcher = this.escapePattern.matcher(javaRegex);
        while (escapeMatcher.find()) {
            javaRegex = javaRegex.replace(escapeMatcher.group(1), escapeMatcher.group(2));
        }
        StringBuilder sb = new StringBuilder();
        if (caseSensitive) {
            sb.append(source);
        } else {
            sb.append("UPPER(");
            sb.append(source);
            sb.append(")");
        }
        sb.append(" REGEXP ");
        if (caseSensitive) {
            this.quoteStringLiteral(sb, javaRegex);
        } else {
            this.quoteStringLiteral(sb, javaRegex.toUpperCase());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Scope {
        SESSION,
        GLOBAL;

    }
}

