/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.recorder.MessageRecorder;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Recognizer {
    private static final MondrianResource mres = MondrianResource.instance();
    private static final Logger LOGGER = Logger.getLogger(Recognizer.class);
    protected final RolapStar star;
    protected final JdbcSchema.Table dbFactTable;
    protected final JdbcSchema.Table aggTable;
    protected final MessageRecorder msgRecorder;
    protected boolean returnValue;

    protected Recognizer(RolapStar star, JdbcSchema.Table dbFactTable, JdbcSchema.Table aggTable, MessageRecorder msgRecorder) {
        this.star = star;
        this.dbFactTable = dbFactTable;
        this.aggTable = aggTable;
        this.msgRecorder = msgRecorder;
        this.returnValue = true;
    }

    public boolean check() {
        this.checkIgnores();
        this.checkFactCount();
        int nosMeasures = this.checkMeasures();
        this.checkMeasureCount(nosMeasures);
        this.generateImpliedMeasures();
        List<JdbcSchema.Table.Column.Usage> notSeenForeignKeys = this.checkForeignKeys();
        this.checkLevels(notSeenForeignKeys);
        if (this.returnValue) {
            this.checkUnusedColumns();
        }
        return this.returnValue;
    }

    protected abstract Matcher getIgnoreMatcher();

    protected void checkIgnores() {
        Matcher ignoreMatcher = this.getIgnoreMatcher();
        for (JdbcSchema.Table.Column aggColumn : this.aggTable.getColumns()) {
            if (!ignoreMatcher.matches(aggColumn.getName())) continue;
            this.makeIgnore(aggColumn);
        }
    }

    protected void makeIgnore(JdbcSchema.Table.Column aggColumn) {
        JdbcSchema.Table.Column.Usage usage = aggColumn.newUsage(JdbcSchema.UsageType.IGNORE);
        usage.setSymbolicName("Ignore");
    }

    protected abstract Matcher getFactCountMatcher();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFactCount() {
        this.msgRecorder.pushContextName("Recognizer.checkFactCount");
        try {
            String msg;
            Matcher factCountMatcher = this.getFactCountMatcher();
            int nosOfFactCounts = 0;
            for (JdbcSchema.Table.Column aggColumn : this.aggTable.getColumns()) {
                if (aggColumn.hasUsage(JdbcSchema.UsageType.IGNORE) || !factCountMatcher.matches(aggColumn.getName())) continue;
                if (aggColumn.getDatatype().isNumeric()) {
                    this.makeFactCount(aggColumn);
                    ++nosOfFactCounts;
                    continue;
                }
                String msg2 = Recognizer.mres.NonNumericFactCountColumn.str(this.aggTable.getName(), this.dbFactTable.getName(), aggColumn.getName(), aggColumn.getTypeName());
                this.msgRecorder.reportError(msg2);
                this.returnValue = false;
            }
            if (nosOfFactCounts == 0) {
                msg = Recognizer.mres.NoFactCountColumns.str(this.aggTable.getName(), this.dbFactTable.getName());
                this.msgRecorder.reportError(msg);
                this.returnValue = false;
            } else if (nosOfFactCounts > 1) {
                msg = Recognizer.mres.TooManyFactCountColumns.str(this.aggTable.getName(), this.dbFactTable.getName(), nosOfFactCounts);
                this.msgRecorder.reportError(msg);
                this.returnValue = false;
            }
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    protected abstract int checkMeasures();

    protected void makeFactCount(JdbcSchema.Table.Column aggColumn) {
        JdbcSchema.Table.Column.Usage usage = aggColumn.newUsage(JdbcSchema.UsageType.FACT_COUNT);
        usage.setSymbolicName("Fact Count");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkMeasureCount(int measureCount) {
        this.msgRecorder.pushContextName("Recognizer.checkNosMeasures");
        try {
            if (measureCount == 0) {
                String msg = Recognizer.mres.NoMeasureColumns.str(this.aggTable.getName(), this.dbFactTable.getName());
                this.msgRecorder.reportError(msg);
                this.returnValue = false;
            }
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    protected void generateImpliedMeasures() {
        for (JdbcSchema.Table.Column factColumn : this.aggTable.getColumns()) {
            JdbcSchema.Table.Column.Usage sumFactUsage = null;
            JdbcSchema.Table.Column.Usage avgFactUsage = null;
            Iterator<JdbcSchema.Table.Column.Usage> mit = factColumn.getUsages(JdbcSchema.UsageType.MEASURE);
            while (mit.hasNext()) {
                JdbcSchema.Table.Column.Usage factUsage = mit.next();
                if (factUsage.getAggregator() == RolapAggregator.Avg) {
                    avgFactUsage = factUsage;
                    continue;
                }
                if (factUsage.getAggregator() != RolapAggregator.Sum) continue;
                sumFactUsage = factUsage;
            }
            if (avgFactUsage == null || sumFactUsage == null) continue;
            JdbcSchema.Table.Column.Usage sumAggUsage = null;
            JdbcSchema.Table.Column.Usage avgAggUsage = null;
            int seenCount = 0;
            Iterator<JdbcSchema.Table.Column.Usage> mit2 = this.aggTable.getColumnUsages(JdbcSchema.UsageType.MEASURE);
            while (mit2.hasNext()) {
                JdbcSchema.Table.Column.Usage aggUsage = mit2.next();
                if (aggUsage.rMeasure == avgFactUsage.rMeasure) {
                    avgAggUsage = aggUsage;
                    ++seenCount;
                    continue;
                }
                if (aggUsage.rMeasure != sumFactUsage.rMeasure) continue;
                sumAggUsage = aggUsage;
                ++seenCount;
            }
            if (seenCount != true) continue;
            if (avgAggUsage != null) {
                this.makeMeasure(sumFactUsage, avgAggUsage);
            }
            if (sumAggUsage == null) continue;
            this.makeMeasure(avgFactUsage, sumAggUsage);
        }
    }

    protected void makeMeasure(JdbcSchema.Table.Column.Usage factUsage, JdbcSchema.Table.Column.Usage aggSiblingUsage) {
        JdbcSchema.Table.Column aggColumn = aggSiblingUsage.getColumn();
        JdbcSchema.Table.Column.Usage aggUsage = aggColumn.newUsage(JdbcSchema.UsageType.MEASURE);
        aggUsage.setSymbolicName(factUsage.getSymbolicName());
        RolapAggregator ra = this.convertAggregator(aggUsage, factUsage.getAggregator(), aggSiblingUsage.getAggregator());
        aggUsage.setAggregator(ra);
        aggUsage.rMeasure = factUsage.rMeasure;
    }

    protected void makeMeasure(JdbcSchema.Table.Column.Usage factUsage, JdbcSchema.Table.Column aggColumn) {
        JdbcSchema.Table.Column.Usage aggUsage = aggColumn.newUsage(JdbcSchema.UsageType.MEASURE);
        aggUsage.setSymbolicName(factUsage.getSymbolicName());
        RolapAggregator ra = this.convertAggregator(aggUsage, factUsage.getAggregator());
        aggUsage.setAggregator(ra);
        aggUsage.rMeasure = factUsage.rMeasure;
    }

    protected abstract int matchForeignKey(JdbcSchema.Table.Column.Usage var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<JdbcSchema.Table.Column.Usage> checkForeignKeys() {
        this.msgRecorder.pushContextName("Recognizer.checkForeignKeys");
        try {
            List<JdbcSchema.Table.Column.Usage> notSeenForeignKeys = Collections.emptyList();
            Iterator<JdbcSchema.Table.Column.Usage> it = this.dbFactTable.getColumnUsages(JdbcSchema.UsageType.FOREIGN_KEY);
            while (it.hasNext()) {
                JdbcSchema.Table.Column.Usage factUsage = it.next();
                int matchCount = this.matchForeignKey(factUsage);
                if (matchCount > 1) {
                    String msg = Recognizer.mres.TooManyMatchingForeignKeyColumns.str(this.aggTable.getName(), this.dbFactTable.getName(), matchCount, factUsage.getColumn().getName());
                    this.msgRecorder.reportError(msg);
                    this.returnValue = false;
                    continue;
                }
                if (matchCount != 0) continue;
                if (notSeenForeignKeys.isEmpty()) {
                    notSeenForeignKeys = new ArrayList<JdbcSchema.Table.Column.Usage>();
                }
                notSeenForeignKeys.add(factUsage);
            }
            List<JdbcSchema.Table.Column.Usage> list = notSeenForeignKeys;
            return list;
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    protected void checkLevels(List<JdbcSchema.Table.Column.Usage> notSeenForeignKeys) {
        for (RolapCube cube : this.findCubes()) {
            List<? extends RolapCubeDimension> dims = cube.getDimensionList();
            for (int j = 1; j < dims.size(); ++j) {
                Dimension dim = dims.get(j);
                String dimName = dim.getName();
                for (Hierarchy hierarchy : dim.getHierarchyList()) {
                }
            }
        }
    }

    boolean inNotSeenForeignKeys(String foreignKey, List<JdbcSchema.Table.Column.Usage> notSeenForeignKeys) {
        for (JdbcSchema.Table.Column.Usage usage : notSeenForeignKeys) {
            if (!usage.getColumn().getName().equals(foreignKey)) continue;
            return true;
        }
        return false;
    }

    private void printNotSeenForeignKeys(List notSeenForeignKeys) {
        LOGGER.debug((Object)("Recognizer.printNotSeenForeignKeys: " + this.aggTable.getName()));
        for (JdbcSchema.Table.Column.Usage usage : notSeenForeignKeys) {
            LOGGER.debug((Object)("  " + usage.getColumn().getName()));
        }
    }

    protected void makeForeignKey(JdbcSchema.Table.Column.Usage factUsage, JdbcSchema.Table.Column aggColumn, String rightJoinConditionColumnName) {
        JdbcSchema.Table.Column.Usage aggUsage = aggColumn.newUsage(JdbcSchema.UsageType.FOREIGN_KEY);
        aggUsage.setSymbolicName("FOREIGN_KEY");
        aggUsage.rTable = factUsage.rTable;
        aggUsage.rightJoinConditionColumnName = rightJoinConditionColumnName;
        aggUsage.rColumn = factUsage.rColumn;
    }

    protected abstract void matchLevels(Hierarchy var1, HierarchyUsage var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeLevel(JdbcSchema.Table.Column aggColumn, Hierarchy hierarchy, HierarchyUsage hierarchyUsage, String factColumnName, String levelColumnName, String symbolicName, boolean isCollapsed, RolapLevel rLevel) {
        this.msgRecorder.pushContextName("Recognizer.makeLevel");
        try {
            if (aggColumn.hasUsage(JdbcSchema.UsageType.LEVEL)) {
                Iterator<JdbcSchema.Table.Column.Usage> uit = aggColumn.getUsages(JdbcSchema.UsageType.LEVEL);
                while (uit.hasNext()) {
                    JdbcSchema.Table.Column.Usage aggUsage = uit.next();
                    RolapSchema.PhysRelation rel = hierarchyUsage.getJoinTable();
                    String cName = levelColumnName;
                    if (aggUsage.relation.equals(rel) && aggColumn.column.name.equals(cName)) continue;
                    String msg = Recognizer.mres.DoubleMatchForLevel.str(this.aggTable.getName(), this.dbFactTable.getName(), aggColumn.getName(), aggUsage.relation.toString(), aggColumn.column.name, rel.toString(), cName);
                    this.msgRecorder.reportError(msg);
                    this.returnValue = false;
                    this.msgRecorder.throwRTException();
                }
            } else {
                RolapStar.Column rc;
                JdbcSchema.Table.Column.Usage aggUsage = aggColumn.newUsage(JdbcSchema.UsageType.LEVEL);
                aggUsage.relation = hierarchyUsage.getJoinTable();
                aggUsage.levelColumnName = levelColumnName;
                aggUsage.collapsed = isCollapsed;
                aggUsage.level = rLevel;
                aggUsage.setSymbolicName(symbolicName);
                String tableAlias = aggUsage.relation.getAlias();
                RolapStar.Table factTable = this.star.getFactTable();
                RolapStar.Table descTable = factTable.findDescendant(tableAlias);
                if (descTable == null) {
                    StringBuilder buf = new StringBuilder(256);
                    buf.append("descendant table is null for factTable=");
                    buf.append(factTable.getAlias());
                    buf.append(", tableAlias=");
                    buf.append(tableAlias);
                    this.msgRecorder.reportError(buf.toString());
                    this.returnValue = false;
                    this.msgRecorder.throwRTException();
                }
                if ((rc = descTable.lookupColumn(factColumnName)) == null) {
                    rc = this.lookupInChildren(descTable, factColumnName);
                }
                if (rc == null) {
                    StringBuilder buf = new StringBuilder(256);
                    buf.append("Rolap.Column not found (null) for tableAlias=");
                    buf.append(tableAlias);
                    buf.append(", factColumnName=");
                    buf.append(factColumnName);
                    buf.append(", levelColumnName=");
                    buf.append(levelColumnName);
                    buf.append(", symbolicName=");
                    buf.append(symbolicName);
                    this.msgRecorder.reportError(buf.toString());
                    this.returnValue = false;
                    this.msgRecorder.throwRTException();
                } else {
                    aggUsage.rColumn = rc;
                }
            }
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    protected RolapStar.Column lookupInChildren(RolapStar.Table table, String factColumnName) {
        for (RolapStar.Table child : table.getChildren()) {
            RolapStar.Column rc = child.lookupColumn(factColumnName);
            if (rc != null) {
                return rc;
            }
            rc = this.lookupInChildren(child, factColumnName);
            if (rc == null) continue;
            return rc;
        }
        return null;
    }

    protected void checkUnusedColumns() {
        this.msgRecorder.pushContextName("Recognizer.checkUnusedColumns");
        TreeMap<String, String> unusedColumnMsgs = new TreeMap<String, String>();
        for (JdbcSchema.Table.Column aggColumn : this.aggTable.getColumns()) {
            if (aggColumn.hasUsage()) continue;
            String msg = Recognizer.mres.AggUnknownColumn.str(this.aggTable.getName(), this.dbFactTable.getName(), aggColumn.getName());
            unusedColumnMsgs.put(aggColumn.getName(), msg);
        }
        for (String msg : unusedColumnMsgs.values()) {
            this.msgRecorder.reportWarning(msg);
        }
        this.msgRecorder.popContextName();
    }

    protected RolapAggregator convertAggregator(JdbcSchema.Table.Column.Usage aggUsage, RolapAggregator factAgg) {
        if (factAgg == RolapAggregator.Avg) {
            String columnExpr = this.getFactCountExpr(aggUsage);
            return new RolapAggregator.AvgFromSum(columnExpr);
        }
        if (factAgg == RolapAggregator.DistinctCount) {
            return RolapAggregator.DistinctCount;
        }
        return factAgg;
    }

    protected RolapAggregator convertAggregator(JdbcSchema.Table.Column.Usage aggUsage, RolapAggregator factAgg, RolapAggregator siblingAgg) {
        this.msgRecorder.pushContextName("Recognizer.convertAggregator");
        RolapAggregator rollupAgg = null;
        String columnExpr = this.getFactCountExpr(aggUsage);
        if (factAgg == RolapAggregator.Avg) {
            if (siblingAgg == RolapAggregator.Avg) {
                rollupAgg = new RolapAggregator.AvgFromAvg(columnExpr);
            } else if (siblingAgg == RolapAggregator.Sum) {
                rollupAgg = new RolapAggregator.AvgFromSum(columnExpr);
            }
        } else if (factAgg == RolapAggregator.Sum) {
            if (siblingAgg == RolapAggregator.Avg) {
                rollupAgg = new RolapAggregator.SumFromAvg(columnExpr);
            } else if (siblingAgg instanceof RolapAggregator.AvgFromAvg) {
                rollupAgg = new RolapAggregator.SumFromAvg(columnExpr);
            }
        }
        if (rollupAgg == null) {
            rollupAgg = factAgg.getRollup();
        }
        if (rollupAgg == null) {
            String msg = Recognizer.mres.NoAggregatorFound.str(aggUsage.getSymbolicName(), factAgg.getName(), siblingAgg.getName());
            this.msgRecorder.reportError(msg);
        }
        this.msgRecorder.popContextName();
        return rollupAgg;
    }

    private String getFactCountExpr(JdbcSchema.Table.Column.Usage aggUsage) {
        JdbcSchema.Table aggTable = aggUsage.getColumn().getTable();
        Iterator<JdbcSchema.Table.Column.Usage> it = aggTable.getColumnUsages(JdbcSchema.UsageType.FACT_COUNT);
        it.hasNext();
        JdbcSchema.Table.Column.Usage usage = it.next();
        String factCountColumnName = usage.getColumn().getName();
        String tableName = aggTable.getName();
        MondrianDef.Column column = new MondrianDef.Column(tableName, factCountColumnName);
        SqlQuery sqlQuery = new SqlQuery(this.star.getSqlQueryDialect());
        return null;
    }

    protected List<RolapCube> findCubes() {
        String name = this.dbFactTable.getName();
        ArrayList<RolapCube> list = new ArrayList<RolapCube>();
        RolapSchema schema = this.star.getSchema();
        block0: for (RolapCube cube : schema.getCubeList()) {
            for (Member member : cube.getMeasuresMembers()) {
                RolapStoredMeasure measure;
                RolapStar cubeStar;
                String factTableName;
                if (!(member instanceof RolapStoredMeasure) || !name.equals(factTableName = (cubeStar = (measure = (RolapStoredMeasure)member).getStarMeasure().getStar()).getFactTable().getAlias())) continue;
                list.add(cube);
                continue block0;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getColumnName(RolapSchema.PhysExpr expr) {
        this.msgRecorder.pushContextName("Recognizer.getColumnName");
        try {
            if (expr instanceof RolapSchema.PhysRealColumn) {
                RolapSchema.PhysRealColumn column = (RolapSchema.PhysRealColumn)expr;
                String string = column.name;
                return string;
            }
            String string = expr.toString();
            return string;
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    @Deprecated
    protected static class HierarchyUsage {
        protected HierarchyUsage() {
        }

        public String getForeignKey() {
            return null;
        }

        public RolapSchema.PhysRelation getJoinTable() {
            return null;
        }

        public String getUsagePrefix() {
            return null;
        }
    }

    public static interface Matcher {
        public boolean matches(String var1);
    }
}

