/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mondrian.rolap.RolapStar;
import mondrian.rolap.agg.CellRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrillThroughCellRequest
extends CellRequest {
    private final Map<RolapStar.Column, String> drillThroughColumns = new LinkedHashMap<RolapStar.Column, String>();
    private final List<RolapStar.Measure> drillThroughMeasures = new ArrayList<RolapStar.Measure>();

    public DrillThroughCellRequest(RolapStar.Measure measure, boolean extendedContext) {
        super(measure, extendedContext, true);
    }

    public void addDrillThroughColumn(RolapStar.Column column, String alias) {
        if (!this.drillThroughColumns.containsKey(column)) {
            this.drillThroughColumns.put(column, alias);
        }
    }

    @Override
    public RolapStar.Column[] getConstrainedColumns() {
        RolapStar.Column[] columns;
        ArrayList<RolapStar.Column> orderedConstrainedColumns = new ArrayList<RolapStar.Column>();
        orderedConstrainedColumns.addAll(this.drillThroughColumns.keySet());
        for (RolapStar.Column col : columns = super.getConstrainedColumns()) {
            if (orderedConstrainedColumns.contains(col)) continue;
            orderedConstrainedColumns.add(col);
        }
        return orderedConstrainedColumns.toArray(new RolapStar.Column[orderedConstrainedColumns.size()]);
    }

    public boolean includeInSelect(RolapStar.Column column) {
        return this.drillThroughColumns.containsKey(column);
    }

    public void addDrillThroughMeasure(RolapStar.Measure measure, String alias) {
        this.drillThroughMeasures.add(measure);
    }

    public boolean includeInSelect(RolapStar.Measure measure) {
        return this.drillThroughMeasures.contains(measure);
    }

    public List<RolapStar.Measure> getDrillThroughMeasures() {
        return Collections.unmodifiableList(this.drillThroughMeasures);
    }

    public String getColumnAlias(RolapStar.Column column) {
        return this.drillThroughColumns.get(column);
    }
}

