/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.regex.Pattern;
import mondrian.olap.Access;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.BatchLoader;
import mondrian.rolap.RestrictedMemberReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapAttribute;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapGalaxy;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStarSet;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.Predicates;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.Clause;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.SqlQueryBuilder;
import mondrian.spi.Dialect;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlConstraintUtils {
    private static final Pattern MULTIPLE_WHITESPACE_PATTERN = Pattern.compile("[\n ]+");

    private SqlConstraintUtils() {
    }

    public static void addContextConstraint(SqlQueryBuilder queryBuilder, RolapStarSet starSet, RolapEvaluator evaluator, boolean restrictMemberTypes) {
        CellRequest request;
        List<RolapMember> members = Arrays.asList(evaluator.getNonAllMembers());
        if (queryBuilder.fact != null) {
            SqlConstraintUtils.setMeasureForCellRequest(members, queryBuilder.fact);
        }
        if (restrictMemberTypes) {
            if (SqlConstraintUtils.containsCalculatedMember(members)) {
                throw Util.newInternal("can not restrict SQL to calculated Members");
            }
            if (SqlConstraintUtils.hasMultiPositionSlicer(evaluator)) {
                throw Util.newInternal("can not restrict SQL to context with multi-position slicer");
            }
        } else {
            members = new ArrayList<RolapMember>(members);
            SqlConstraintUtils.removeCalculatedAndDefaultMembers(members);
            SqlConstraintUtils.removeMultiPositionSlicerMembers(members, evaluator);
        }
        if ((request = RolapAggregationManager.makeRequest(members.toArray(new RolapMember[members.size()]))) == null) {
            if (restrictMemberTypes) {
                throw Util.newInternal("CellRequest is null - why?");
            }
            return;
        }
        RolapStar.Column[] columns = request.getConstrainedColumns();
        Object[] values = request.getSingleValues();
        if (starSet.getAggMeasureGroup() != null) {
            RolapGalaxy galaxy = evaluator.getCube().galaxy;
            BatchLoader.StarConverterImpl starConverter = new BatchLoader.StarConverterImpl(galaxy, starSet.getStar(), starSet.getAggMeasureGroup().getStar(), Collections.EMPTY_MAP);
            columns = starConverter.convertColumnArray(columns);
        }
        SqlConstraintUtils.addColumnValueConstraints(queryBuilder, Pair.zip(columns, values));
        SqlConstraintUtils.addRoleAccessConstraints(queryBuilder, starSet, restrictMemberTypes, evaluator);
    }

    private static void setMeasureForCellRequest(List<RolapMember> members, RolapMeasureGroup fact) {
        assert (fact.factCountMeasure != null);
        for (int i = 0; i < members.size(); ++i) {
            if (!members.get(i).isMeasure()) continue;
            members.set(i, fact.factCountMeasure);
            break;
        }
    }

    public static Map<Level, List<RolapMember>> getRoleConstraintMembers(SchemaReader schemaReader, Member[] members) {
        LinkedHashMap<Level, List<RolapMember>> roleMembers = new LinkedHashMap<Level, List<RolapMember>>();
        block0: for (Member member : members) {
            if (!(member instanceof RolapHierarchy.LimitedRollupMember) && !(member instanceof RestrictedMemberReader.MultiCardinalityDefaultMember)) continue;
            List<Level> hierarchyLevels = schemaReader.getHierarchyLevels(member.getHierarchy());
            for (Level affectedLevel : hierarchyLevels) {
                ArrayList<RolapMember> slicerMembers = new ArrayList<RolapMember>();
                boolean hasCustom = false;
                List<Member> availableMembers = schemaReader.getLevelMembers(affectedLevel, false);
                Role role = schemaReader.getRole();
                for (Member availableMember : availableMembers) {
                    if (!availableMember.isAll()) {
                        slicerMembers.add((RolapMember)availableMember);
                    }
                    hasCustom |= role.getAccess(availableMember) == Access.CUSTOM;
                }
                if (!slicerMembers.isEmpty()) {
                    roleMembers.put(affectedLevel, slicerMembers);
                }
                if (hasCustom) continue;
                continue block0;
            }
        }
        return roleMembers;
    }

    private static void addRoleAccessConstraints(SqlQueryBuilder queryBuilder, RolapStarSet starSet, boolean restrictMemberTypes, Evaluator evaluator) {
        Map<Level, List<RolapMember>> roleMembers = SqlConstraintUtils.getRoleConstraintMembers(evaluator.getSchemaReader(), evaluator.getMembers());
        for (Map.Entry<Level, List<RolapMember>> entry : roleMembers.entrySet()) {
            StringBuilder where = new StringBuilder("(");
            SqlConstraintUtils.generateSingleValueInExpr(where, queryBuilder, evaluator.getMeasureGroup(), starSet.getAggStar(), entry.getValue(), (RolapCubeLevel)entry.getKey(), restrictMemberTypes, false);
            if (where.length() <= 1) continue;
            where.append(")");
            queryBuilder.sqlQuery.addWhere(where.toString());
        }
    }

    private static void addColumnValueConstraints(SqlQueryBuilder queryBuilder, List<Pair<RolapStar.Column, Object>> columnValues) {
        StringBuilder buf = new StringBuilder();
        for (Pair<RolapStar.Column, Object> columnValue : columnValues) {
            RolapStar.Column column = (RolapStar.Column)columnValue.left;
            String expr = column.getExpression().toSql();
            String value = String.valueOf(columnValue.right);
            buf.setLength(0);
            if (RolapUtil.mdxNullLiteral().equalsIgnoreCase(value) || value.equalsIgnoreCase(RolapUtil.sqlNullValue.toString())) {
                buf.append(expr).append(" is null");
            } else {
                Dialect dialect = queryBuilder.getDialect();
                try {
                    buf.append(expr).append(" = ");
                    dialect.quote(buf, value, column.getDatatype());
                }
                catch (NumberFormatException e) {
                    buf.setLength(0);
                    dialect.quoteBooleanLiteral(buf, false);
                }
            }
            queryBuilder.addColumn(queryBuilder.column(column.getExpression(), column.getTable()), Clause.FROM);
            queryBuilder.sqlQuery.addWhere(buf.toString());
        }
    }

    public static boolean hasMultiPositionSlicer(RolapEvaluator evaluator) {
        HashMap<RolapCubeHierarchy, RolapMember> mapOfSlicerMembers = new HashMap<RolapCubeHierarchy, RolapMember>();
        for (RolapMember slicerMember : evaluator.getSlicerMembers()) {
            RolapCubeHierarchy hierarchy = slicerMember.getHierarchy();
            if (mapOfSlicerMembers.containsKey(hierarchy)) {
                return true;
            }
            mapOfSlicerMembers.put(hierarchy, slicerMember);
        }
        return false;
    }

    protected static void removeMultiPositionSlicerMembers(List<RolapMember> memberList, Evaluator evaluator) {
        List<RolapMember> slicerMembers = null;
        if (evaluator instanceof RolapEvaluator) {
            slicerMembers = ((RolapEvaluator)evaluator).getSlicerMembers();
        }
        if (slicerMembers != null) {
            Hierarchy hierarchy;
            HashMap mapOfSlicerMembers = new HashMap();
            for (Member member : slicerMembers) {
                hierarchy = member.getHierarchy();
                if (!mapOfSlicerMembers.containsKey(hierarchy)) {
                    mapOfSlicerMembers.put(hierarchy, new HashSet());
                }
                ((Set)mapOfSlicerMembers.get(hierarchy)).add(member);
            }
            for (int i = 0; i < memberList.size(); ++i) {
                RolapMember rolapMember = memberList.get(i);
                hierarchy = rolapMember.getHierarchy();
                if (!mapOfSlicerMembers.containsKey(hierarchy) || ((Set)mapOfSlicerMembers.get(hierarchy)).size() < 2) continue;
                memberList.remove(i--);
            }
        }
    }

    private static void removeCalculatedAndDefaultMembers(List<RolapMember> memberList) {
        for (int i = 0; i < memberList.size(); ++i) {
            RolapMember member = memberList.get(i);
            if (member.isCalculated() && !member.isParentChildLeaf()) {
                memberList.remove(i--);
                continue;
            }
            if (i <= 0 || !member.getHierarchy().getDefaultMember().equals(member)) continue;
            memberList.remove(i--);
        }
    }

    static List<Member> removeCalculatedMembers(List<Member> members) {
        return Util.copyWhere(members, new Util.Predicate1<Member>(){

            @Override
            public boolean test(Member member) {
                return !member.isCalculated() || member.isParentChildLeaf();
            }
        });
    }

    public static boolean containsCalculatedMember(Member[] members) {
        for (Member member : members) {
            if (!member.isCalculated()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsCalculatedMember(Iterable<? extends Member> members) {
        for (Member member : members) {
            if (!member.isCalculated()) continue;
            return true;
        }
        return false;
    }

    public static void joinLevelTableToFactTable(SqlQuery sqlQuery, RolapStarSet starSet, Evaluator e, RolapCubeLevel level) {
        Util.deprecated(false, false);
    }

    public static void addMemberConstraint(SqlQueryBuilder queryBuilder, RolapStarSet starSet, RolapMember parent, boolean restrictMemberTypes) {
        List<RolapMember> list = Collections.singletonList(parent);
        boolean exclude = false;
        SqlConstraintUtils.addMemberConstraint(queryBuilder, starSet, list, restrictMemberTypes, false, exclude);
    }

    public static void addMemberConstraint(SqlQueryBuilder queryBuilder, RolapStarSet starSet, List<RolapMember> members, boolean restrictMemberTypes, boolean crossJoin, boolean exclude) {
        RolapMember member;
        RolapMember firstUniqueParent;
        assert (starSet != null);
        if (members.size() == 0) {
            StringBuilder buf = new StringBuilder();
            queryBuilder.sqlQuery.getDialect().quoteBooleanLiteral(buf, exclude);
            queryBuilder.sqlQuery.addWhere(buf.toString());
            return;
        }
        RolapCubeLevel firstUniqueParentLevel = null;
        for (firstUniqueParent = member = members.get(0); firstUniqueParent != null; firstUniqueParent = firstUniqueParent.getParentMember()) {
        }
        if (firstUniqueParent != null) {
            firstUniqueParentLevel = firstUniqueParent.getLevel();
        }
        StringBuilder condition = new StringBuilder("(");
        boolean added = false;
        if (crossJoin && !SqlConstraintUtils.membersAreCrossProduct(members)) {
            assert (member.getParentMember() != null);
            added = SqlConstraintUtils.constrainMultiLevelMembers(queryBuilder, condition, starSet.getMeasureGroup(), starSet.getAggStar(), members, firstUniqueParentLevel, restrictMemberTypes, exclude);
        } else {
            SqlConstraintUtils.generateSingleValueInExpr(condition, queryBuilder, starSet.getMeasureGroup(), starSet.getAggStar(), members, firstUniqueParentLevel, restrictMemberTypes, exclude);
            boolean bl = added = condition.length() > 1;
        }
        if (added) {
            condition.append(")");
            queryBuilder.sqlQuery.addWhere(condition.toString());
        }
    }

    private static StarPredicate getColumnPredicates(RolapMeasureGroup measureGroup, RolapSchema.PhysSchema physSchema, Collection<RolapMember> members) {
        int i = members.size();
        if (i == 0) {
            return LiteralStarPredicate.FALSE;
        }
        RolapMember member1 = members.iterator().next();
        RolapCubeLevel level = member1.getLevel();
        RolapSchema.CubeRouter router = new RolapSchema.CubeRouter(measureGroup, level.getDimension());
        if (i == 1) {
            return Predicates.memberPredicate(router, member1);
        }
        return Predicates.list(physSchema, router, level, new ArrayList<RolapMember>(members));
    }

    private static LinkedHashSet<RolapMember> getUniqueParentMembers(Collection<RolapMember> members) {
        LinkedHashSet<RolapMember> set = new LinkedHashSet<RolapMember>();
        for (RolapMember m : members) {
            if ((m = m.getParentMember()) == null) continue;
            set.add(m);
        }
        return set;
    }

    private static boolean constrainMultiLevelMembers(SqlQueryBuilder queryBuilder, StringBuilder condition, RolapMeasureGroup measureGroup, AggStar aggStar, List<RolapMember> members, RolapCubeLevel fromLevel, boolean restrictMemberTypes, boolean exclude) {
        int initial = condition.length();
        LinkedHashMap<RolapMember, List<RolapMember>> parentChildrenMap = new LinkedHashMap<RolapMember, List<RolapMember>>();
        StringBuilder condition1 = new StringBuilder();
        if (exclude) {
            condition.append("not (");
        }
        if (queryBuilder.getDialect().supportsMultiValueInExpr()) {
            condition1.append(SqlConstraintUtils.generateMultiValueInExpr(queryBuilder, measureGroup, aggStar, members, fromLevel, restrictMemberTypes, parentChildrenMap));
            if (parentChildrenMap.isEmpty()) {
                condition.append(condition1.toString());
                if (exclude) {
                    condition.append(SqlConstraintUtils.strip(")\n    or "));
                    SqlConstraintUtils.generateMultiValueIsNullExprs(condition, members.get(0), fromLevel);
                }
                return condition.length() > initial;
            }
        } else {
            for (RolapMember m : members) {
                if (m.isCalculated()) {
                    if (!restrictMemberTypes) continue;
                    throw Util.newInternal("addMemberConstraint: cannot restrict SQL to calculated member :" + m);
                }
                RolapMember p = m.getParentMember();
                ArrayList<RolapMember> childrenList = (ArrayList<RolapMember>)parentChildrenMap.get(p);
                if (childrenList == null) {
                    childrenList = new ArrayList<RolapMember>();
                    parentChildrenMap.put(p, childrenList);
                }
                childrenList.add(m);
            }
        }
        StringBuilder condition2 = new StringBuilder();
        if (condition1.length() > 0) {
            condition.append(condition1.toString());
            condition.append(SqlConstraintUtils.strip("\n    or "));
        }
        RolapCubeLevel memberLevel = members.get(0).getLevel();
        for (RolapMember p : parentChildrenMap.keySet()) {
            List children;
            assert (p != null);
            if (condition2.length() > 0) {
                condition2.append(SqlConstraintUtils.strip("\n    or "));
            }
            condition2.append("(");
            int levelCount = 0;
            if (Util.deprecated(true, false).booleanValue()) {
                RolapAttribute attribute = p.getLevel().getAttribute();
                for (Pair<RolapSchema.PhysColumn, Comparable> pair : Pair.iterate(attribute.getKeyList(), p.getKeyAsList())) {
                    RolapSchema.PhysColumn physColumn = (RolapSchema.PhysColumn)pair.left;
                    Comparable o = (Comparable)pair.right;
                    RolapStar.Column column = measureGroup.getRolapStarColumn(p.getDimension(), physColumn);
                    if (column != null) {
                        if (aggStar != null) {
                            int bitPos = column.getBitPosition();
                            AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                            AggStar.Table table = aggColumn.getTable();
                            table.addToFrom(queryBuilder.sqlQuery, false, true);
                        } else {
                            queryBuilder.addColumn(queryBuilder.column(physColumn, p.getDimension()), Clause.FROM);
                        }
                    } else {
                        assert (aggStar == null);
                        Util.deprecated("todo", false);
                    }
                    if (levelCount++ > 0) {
                        condition2.append(SqlConstraintUtils.strip("\n    and "));
                    }
                    Util.deprecated("obsolete", false);
                    condition2.append(SqlConstraintUtils.constrainLevel(physColumn, queryBuilder.getDialect(), SqlConstraintUtils.getColumnValue(o, queryBuilder.getDialect(), physColumn.getDatatype()), false));
                }
            }
            if (!(children = (List)parentChildrenMap.get(p)).isEmpty()) {
                HashMap<RolapMember, List<RolapMember>> tmpParentChildrenMap = new HashMap<RolapMember, List<RolapMember>>();
                if (levelCount > 0) {
                    condition2.append(SqlConstraintUtils.strip("\n    and "));
                }
                RolapCubeLevel childrenLevel = p.getLevel().getChildLevel();
                if (queryBuilder.getDialect().supportsMultiValueInExpr() && childrenLevel != memberLevel) {
                    condition2.append(SqlConstraintUtils.generateMultiValueInExpr(queryBuilder, measureGroup, aggStar, children, childrenLevel, restrictMemberTypes, tmpParentChildrenMap));
                    assert (tmpParentChildrenMap.isEmpty());
                } else {
                    assert (childrenLevel == memberLevel);
                    SqlConstraintUtils.generateSingleValueInExpr(condition2, queryBuilder, measureGroup, aggStar, children, childrenLevel, restrictMemberTypes, false);
                }
            }
            condition2.append(")");
        }
        condition.append(condition2.toString());
        if (exclude) {
            condition.append(SqlConstraintUtils.strip(")\n       or ("));
            SqlConstraintUtils.generateMultiValueIsNullExprs(condition, members.get(0), fromLevel);
            condition.append(" and not(");
            condition.append(condition2.toString());
            condition.append("))");
        }
        return condition.length() > initial;
    }

    public static boolean membersAreCrossProduct(List<RolapMember> members) {
        int crossProdSize = SqlConstraintUtils.getNumUniqueMemberKeys(members);
        LinkedHashSet<RolapMember> parents = SqlConstraintUtils.getUniqueParentMembers(members);
        while (!parents.isEmpty()) {
            crossProdSize *= parents.size();
            parents = SqlConstraintUtils.getUniqueParentMembers(parents);
        }
        return crossProdSize == members.size();
    }

    private static int getNumUniqueMemberKeys(List<RolapMember> members) {
        HashSet<Comparable> set = new HashSet<Comparable>();
        for (RolapMember m : members) {
            set.add(m.getKey());
        }
        return set.size();
    }

    private static String getColumnValue(Comparable key, Dialect dialect, Dialect.Datatype datatype) {
        if (key != RolapUtil.sqlNullValue) {
            return key.toString();
        }
        return RolapUtil.mdxNullLiteral();
    }

    public static String constrainLevel(RolapSchema.PhysColumn exp, Dialect dialect, String columnValue, boolean caseSensitive) {
        String constraint;
        Util.deprecated("TODO unify inside-star and outside-star code paths", false);
        Dialect.Datatype datatype = exp.getDatatype();
        String columnString = exp.toSql();
        if (RolapUtil.mdxNullLiteral().equalsIgnoreCase(columnValue)) {
            constraint = columnString + " is null";
        } else {
            if (datatype.isNumeric()) {
                try {
                    Double.valueOf(columnValue);
                }
                catch (NumberFormatException e) {
                    return "FALSE";
                }
            }
            StringBuilder buf = new StringBuilder();
            dialect.quote(buf, columnValue, datatype);
            String value = buf.toString();
            if (caseSensitive && datatype == Dialect.Datatype.String && !MondrianProperties.instance().CaseSensitive.get()) {
                columnString = dialect.toUpper(columnString);
                value = dialect.toUpper(value);
            }
            constraint = columnString + " = " + value;
        }
        return constraint;
    }

    public static void constrainLevel2(SqlQueryBuilder queryBuilder, RolapSchema.PhysColumn exp, RolapCubeDimension dimension, Comparable columnValue) {
        StringBuilder buf = new StringBuilder(exp.toSql());
        if (columnValue == RolapUtil.sqlNullValue) {
            buf.append(" is null");
        } else {
            try {
                buf.append(" = ");
                queryBuilder.getDialect().quote(buf, columnValue, exp.getDatatype());
            }
            catch (NumberFormatException e) {
                buf.setLength(0);
                queryBuilder.getDialect().quoteBooleanLiteral(buf, false);
            }
        }
        queryBuilder.addColumn(queryBuilder.column(exp, dimension), Clause.FROM);
        queryBuilder.sqlQuery.addWhere(buf.toString());
    }

    private static String generateMultiValueInExpr(SqlQueryBuilder queryBuilder, RolapMeasureGroup measureGroup, AggStar aggStar, List<RolapMember> members, RolapCubeLevel fromLevel, boolean restrictMemberTypes, Map<RolapMember, List<RolapMember>> parentWithNullToChildrenMap) {
        StringBuilder columnBuf = new StringBuilder();
        StringBuilder valueBuf = new StringBuilder();
        StringBuilder memberBuf = new StringBuilder();
        columnBuf.append("(");
        RolapMember member = members.get(0);
        RolapCubeLevel level = member.getLevel();
        ArrayList<RolapStar.Column> columns = new ArrayList<RolapStar.Column>();
        for (RolapSchema.PhysColumn key : level.attribute.getKeyList()) {
            columns.add(measureGroup.getRolapStarColumn(level.cubeDimension, key));
        }
        ArrayList<String> columnList = new ArrayList<String>();
        if (columns != null) {
            if (aggStar != null) {
                for (RolapStar.Column column : columns) {
                    int bitPos = column.getBitPosition();
                    AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                    AggStar.Table table = aggColumn.getTable();
                    table.addToFrom(queryBuilder.sqlQuery, false, true);
                    columnList.add(aggColumn.getExpression().toSql());
                }
            } else {
                for (RolapStar.Column column : columns) {
                    queryBuilder.addColumn(queryBuilder.column(column.getExpression(), column.getTable()), Clause.FROM);
                    columnList.add(column.getExpression().toSql());
                }
            }
        } else {
            assert (aggStar == null);
            RolapSchema.PhysColumn nameExp = level.getAttribute().getNameExp();
            columnList.add(nameExp.toSql());
        }
        columnBuf.append(Util.commaList(columnList));
        columnBuf.append(")");
        valueBuf.append("(");
        int memberOrdinal = 0;
        for (RolapMember m : members) {
            if (m.isCalculated()) {
                if (!restrictMemberTypes) continue;
                throw Util.newInternal("addMemberConstraint: cannot restrict SQL to calculated member :" + m);
            }
            memberBuf.setLength(0);
            memberBuf.append("(");
            boolean containsNull = false;
            int ordinalInMultiple = 0;
            for (Pair<RolapSchema.PhysColumn, Comparable> pair : Pair.iterate(level.attribute.getKeyList(), m.getKeyAsList())) {
                Comparable o = (Comparable)pair.right;
                Dialect.Datatype datatype = ((RolapSchema.PhysColumn)pair.left).getDatatype();
                String value = SqlConstraintUtils.getColumnValue(o, queryBuilder.getDialect(), datatype);
                if (RolapUtil.mdxNullLiteral().equalsIgnoreCase(value)) {
                    List<RolapMember> childrenList = parentWithNullToChildrenMap.get(m);
                    if (childrenList == null) {
                        childrenList = new ArrayList<RolapMember>();
                        parentWithNullToChildrenMap.put(m, childrenList);
                    }
                    containsNull = true;
                    break;
                }
                if (ordinalInMultiple++ > 0) {
                    memberBuf.append(", ");
                }
                queryBuilder.getDialect().quote(memberBuf, value, datatype);
            }
            if (containsNull) continue;
            memberBuf.append(")");
            if (memberOrdinal++ > 0) {
                valueBuf.append(", ");
            }
            valueBuf.append((CharSequence)memberBuf);
        }
        StringBuilder condition = new StringBuilder();
        if (memberOrdinal > 0) {
            condition.append((CharSequence)columnBuf);
            condition.append(" in ");
            condition.append((CharSequence)valueBuf);
            condition.append(")");
        }
        return condition.toString();
    }

    private static void generateMultiValueIsNullExprs(StringBuilder buf, RolapMember member, RolapLevel fromLevel) {
        buf.append("(");
        int levelInMultiple = 0;
        for (RolapMember m = member; m != null; m = m.getParentMember()) {
            if (m.isAll()) continue;
            if (levelInMultiple++ > 0) {
                buf.append(SqlConstraintUtils.strip("\n        or "));
            }
            buf.append(m.getLevel().getAttribute().getNameExp().toSql()).append(" is null");
            if (m.getLevel() == fromLevel) break;
        }
        buf.append(")");
    }

    private static void generateSingleValueInExpr(StringBuilder buf, SqlQueryBuilder queryBuilder, RolapMeasureGroup measureGroup, AggStar aggStar, List<RolapMember> members, RolapCubeLevel fromLevel, boolean restrictMemberTypes, boolean exclude) {
        int maxConstraints = MondrianProperties.instance().MaxConstraints.get();
        Dialect dialect = queryBuilder.getDialect();
        int levelCount = 0;
        SequencedCollection<RolapMember> members2 = members;
        RolapMember m = null;
        while (!members2.isEmpty()) {
            m = (RolapMember)members2.iterator().next();
            if (!m.isAll()) {
                if (m.isNull()) {
                    dialect.quoteBooleanLiteral(buf, false);
                    return;
                }
                if (!m.isCalculated() || m.isParentChildLeaf()) break;
                if (restrictMemberTypes) {
                    throw Util.newInternal("addMemberConstraint: cannot restrict SQL to calculated member :" + m);
                }
            }
            members2 = SqlConstraintUtils.getUniqueParentMembers(members2);
        }
        boolean containsNullKey = false;
        for (RolapMember member : members2) {
            m = member;
            if (m.getKey() != RolapUtil.sqlNullValue) continue;
            containsNullKey = true;
        }
        RolapCubeLevel level = m.getLevel();
        for (RolapSchema.PhysColumn key : level.getAttribute().getKeyList()) {
            String q;
            if (measureGroup != null) {
                RolapStar.Column column = measureGroup.getRolapStarColumn(level.cubeDimension, key, true);
                if (aggStar != null) {
                    int bitPos = column.getBitPosition();
                    AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                    if (aggColumn == null) {
                        throw Util.newInternal("AggStar " + aggStar + " has no column for " + column + " (bitPos " + bitPos + ")");
                    }
                    AggStar.Table table = aggColumn.getTable();
                    table.addToFrom(queryBuilder.sqlQuery, false, true);
                    q = aggColumn.getExpression().toSql();
                } else {
                    queryBuilder.addColumn(queryBuilder.column(column.getExpression(), column.getTable()), Clause.FROM);
                    q = column.getExpression().toSql();
                }
            } else {
                assert (aggStar == null);
                queryBuilder.addRelation(queryBuilder.table(key.relation, level.cubeDimension), SqlQueryBuilder.NullJoiner.INSTANCE);
                q = key.toSql();
            }
            StarPredicate cc = SqlConstraintUtils.getColumnPredicates(measureGroup, level.getAttribute().getKeyList().get((int)0).relation.getSchema(), members2);
            if (dialect.supportsUnlimitedValueList() || !(cc instanceof ListColumnPredicate) || ((ListColumnPredicate)cc).getPredicates().size() <= maxConstraints) {
                Util.deprecated("obsolete", false);
                String where = Predicates.toSql(cc, dialect);
                if (!where.equals("true")) {
                    if (levelCount++ > 0) {
                        buf.append(SqlConstraintUtils.strip(exclude ? "\n    or " : "\n    and "));
                    }
                    if (exclude) {
                        where = "not (" + where + ")";
                        if (!containsNullKey) {
                            where = "(" + where + SqlConstraintUtils.strip("\n        or (") + q + " is null))";
                        }
                    }
                    buf.append(where);
                }
            }
            if (exclude) continue;
            break;
        }
    }

    private static String strip(String s) {
        if (!MondrianProperties.instance().GenerateFormattedSql.get()) {
            s = MULTIPLE_WHITESPACE_PATTERN.matcher(s).replaceAll(" ");
        }
        return s;
    }
}

