/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.List;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianException;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaLoader;
import org.eigenbase.xom.Location;
import org.eigenbase.xom.NodeDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RolapSchemaLoaderHandlerImpl
implements RolapSchemaLoader.Handler {
    private int errorCount;

    @Override
    public RolapSchema.XmlLocation locate(NodeDef node, String attributeName) {
        if (node == null) {
            return null;
        }
        Location location = node.getLocation();
        if (location == null) {
            return null;
        }
        return new RolapSchema.XmlLocationImpl(node, location, attributeName);
    }

    @Override
    public void warning(String message, NodeDef node, String attributeName) {
        this.warning(message, node, attributeName, null);
    }

    @Override
    public void warning(String message, NodeDef node, String attributeName, Throwable cause) {
        RolapSchema.XmlLocation xmlLocation = this.locate(node, attributeName);
        RolapSchema.MondrianSchemaException ex = new RolapSchema.MondrianSchemaException(message, this.describe(node), xmlLocation, RolapSchema.Severity.WARNING, cause);
        List<RolapSchema.MondrianSchemaException> warningList = this.getWarningList();
        if (warningList == null) {
            throw ex;
        }
        warningList.add(ex);
    }

    protected abstract List<RolapSchema.MondrianSchemaException> getWarningList();

    private String describe(NodeDef node) {
        if (node == null) {
            return null;
        }
        if (node instanceof MondrianDef.NamedElement) {
            return node.getName() + " '" + ((MondrianDef.NamedElement)node).getNameAttribute() + "'";
        }
        return node.getName();
    }

    @Override
    public void error(String message, NodeDef node, String attributeName) {
        RolapSchema.XmlLocation xmlLocation = this.locate(node, attributeName);
        Throwable cause = null;
        RolapSchema.MondrianSchemaException ex = new RolapSchema.MondrianSchemaException(message, this.describe(node), xmlLocation, RolapSchema.Severity.ERROR, cause);
        List<RolapSchema.MondrianSchemaException> warningList = this.getWarningList();
        if (warningList != null) {
            ++this.errorCount;
        } else {
            throw ex;
        }
        warningList.add(ex);
    }

    @Override
    public void error(MondrianException message, NodeDef node, String attributeName) {
        this.error(message.toString(), node, attributeName);
    }

    @Override
    public RuntimeException fatal(String message, NodeDef node, String attributeName) {
        RolapSchema.XmlLocation xmlLocation = this.locate(node, attributeName);
        Throwable cause = null;
        return new RolapSchema.MondrianSchemaException(message, this.describe(node), xmlLocation, RolapSchema.Severity.FATAL, cause);
    }

    @Override
    public void check() {
        if (this.errorCount > 0) {
            throw new RolapSchemaLoader.MondrianMultipleSchemaException("There were schema errors", this.getWarningList());
        }
    }
}

