/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mondrian.olap.Id;
import mondrian.olap.Larder;
import mondrian.olap.Larders;
import mondrian.olap.LevelBase;
import mondrian.olap.MatchType;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RolapAttribute;
import mondrian.rolap.RolapClosure;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaLoader;
import mondrian.spi.MemberFormatter;
import org.apache.log4j.Logger;
import org.olap4j.metadata.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapLevel
extends LevelBase {
    private static final Logger LOGGER = Logger.getLogger(RolapLevel.class);
    protected RolapAttribute attribute;
    private final List<RolapProperty> inheritedProperties = new ArrayList<RolapProperty>();
    private final HideMemberCondition hideMemberCondition;
    final String nullParentValue;
    final RolapClosure closure;
    final RolapAttribute parentAttribute;
    private final Larder larder;
    final Map<String, List<Larders.Resource>> resourceMap;
    private final List<RolapSchema.PhysColumn> orderByList;
    static final RolapProperty KEY_PROPERTY = new RolapProperty(Property.KEY.name, null, null, Property.Datatype.TYPE_STRING, null, true, Larders.EMPTY);
    static final RolapProperty NAME_PROPERTY = new RolapProperty(Property.NAME.name, null, null, Property.Datatype.TYPE_STRING, null, true, Larders.EMPTY);
    static final RolapProperty ORDINAL_PROPERTY = new RolapProperty("$ordinal", null, null, Property.Datatype.TYPE_STRING, null, true, Larders.EMPTY);

    RolapLevel(RolapHierarchy hierarchy, String name, boolean visible, int depth, RolapAttribute attribute, RolapAttribute parentAttribute, List<RolapSchema.PhysColumn> orderByList, String nullParentValue, RolapClosure closure, HideMemberCondition hideMemberCondition, Larder larder, Map<String, List<Larders.Resource>> resourceMap) {
        super(hierarchy, name, visible, depth);
        this.larder = larder;
        this.resourceMap = resourceMap;
        this.attribute = attribute;
        this.orderByList = orderByList;
        this.parentAttribute = parentAttribute;
        this.nullParentValue = nullParentValue;
        this.closure = closure;
        this.hideMemberCondition = hideMemberCondition;
        assert (larder != null);
        assert (orderByList != null);
        assert (hideMemberCondition != null);
        assert (parentAttribute != null || nullParentValue == null);
        assert (parentAttribute != null || closure == null);
    }

    @Override
    public Level.Type getLevelType() {
        return this.attribute.getLevelType();
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return (RolapHierarchy)this.hierarchy;
    }

    @Override
    public Larder getLarder() {
        return this.larder;
    }

    @Override
    public MemberFormatter getMemberFormatter() {
        return this.attribute.getMemberFormatter();
    }

    @Override
    public RolapLevel getParentLevel() {
        return (RolapLevel)super.getParentLevel();
    }

    @Override
    public RolapLevel getChildLevel() {
        return (RolapLevel)super.getChildLevel();
    }

    @Override
    public RolapDimension getDimension() {
        return (RolapDimension)this.hierarchy.getDimension();
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public RolapAttribute getAttribute() {
        return this.attribute;
    }

    public String getNullParentValue() {
        return this.nullParentValue;
    }

    public RolapClosure getClosure() {
        return this.closure;
    }

    HideMemberCondition getHideMemberCondition() {
        return this.hideMemberCondition;
    }

    public final boolean isUnique() {
        return true;
    }

    int getOrderByKeyArity() {
        return this.orderByList.size();
    }

    public RolapAttribute getParentAttribute() {
        return this.parentAttribute;
    }

    public boolean isParentChild() {
        return this.parentAttribute != null;
    }

    private Property lookupProperty(List<RolapProperty> list, String propertyName) {
        for (Property property : list) {
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    void initLevel(RolapSchemaLoader schemaLoader) {
        for (RolapLevel level = this; level != null; level = level.getParentLevel()) {
            for (RolapProperty levelProperty : level.attribute.getProperties()) {
                Property existingProperty = this.lookupProperty(this.inheritedProperties, levelProperty.getName());
                if (existingProperty == null) {
                    this.inheritedProperties.add(levelProperty);
                    continue;
                }
                if (existingProperty.getType() == levelProperty.getType()) continue;
                throw Util.newError("Property " + this.getName() + "." + levelProperty.getName() + " overrides a " + "property with the same name but different type");
            }
        }
    }

    @Override
    public final boolean isAll() {
        return this.attribute.getLevelType() == Level.Type.ALL;
    }

    @Override
    public boolean areMembersUnique() {
        return this.depth == 0 || this.depth == 1 && this.hierarchy.hasAll();
    }

    public RolapProperty[] getProperties() {
        List<RolapProperty> properties = this.attribute.getProperties();
        return properties.toArray(new RolapProperty[properties.size()]);
    }

    @Override
    public Property[] getInheritedProperties() {
        return this.inheritedProperties.toArray(new Property[this.inheritedProperties.size()]);
    }

    @Override
    public int getApproxRowCount() {
        if (this.approxRowCount > 0) {
            return this.approxRowCount;
        }
        return this.attribute.getApproxRowCount();
    }

    public List<RolapSchema.PhysColumn> getOrderByList() {
        return this.orderByList;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment name) {
        return this.lookupChild(schemaReader, name, MatchType.EXACT);
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment name, MatchType matchType) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HideMemberCondition {
        Never,
        IfBlankName,
        IfParentsName;

    }
}

