/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.Larder;
import mondrian.olap.Member;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.spi.CellFormatter;
import mondrian.spi.Dialect;

public class RolapBaseCubeMeasure
extends RolapMemberBase
implements RolapStoredMeasure {
    private final RolapSchema.PhysColumn expression;
    private final RolapAggregator aggregator;
    private RolapStar.Measure starMeasure;
    private RolapResult.ValueFormatter formatter;
    private final RolapMeasureGroup measureGroup;
    private final Dialect.Datatype datatype;

    RolapBaseCubeMeasure(RolapMeasureGroup measureGroup, RolapCubeLevel level, String key, String uniqueName, RolapSchema.PhysColumn expression, RolapAggregator aggregator, Dialect.Datatype datatype, Larder larder) {
        super(null, level, (Comparable)((Object)key), Member.MemberType.MEASURE, uniqueName, larder);
        assert (larder != null);
        this.larder = larder;
        this.measureGroup = measureGroup;
        assert (measureGroup.getCube() == level.cube);
        RolapSchema.PhysRelation factRelation = measureGroup.getFactRelation();
        assert (factRelation != null);
        assert (expression == null || expression.relation == factRelation) : "inconsistent fact: " + expression + " vs. " + factRelation;
        this.expression = expression;
        this.aggregator = aggregator;
        this.datatype = datatype;
    }

    public RolapSchema.PhysColumn getExpr() {
        return this.expression;
    }

    public RolapAggregator getAggregator() {
        return this.aggregator;
    }

    public RolapMeasureGroup getMeasureGroup() {
        return this.measureGroup;
    }

    public RolapResult.ValueFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(CellFormatter cellFormatter) {
        this.formatter = new RolapResult.CellFormatterValueFormatter(cellFormatter);
    }

    public RolapStar.Measure getStarMeasure() {
        return this.starMeasure;
    }

    void setStarMeasure(RolapStar.Measure starMeasure) {
        this.starMeasure = starMeasure;
    }

    public Dialect.Datatype getDatatype() {
        return this.datatype;
    }
}

