/*
 * Decompiled with CFR 0.152.
 */
package mondrian.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.CellProperty;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunTable;
import mondrian.olap.Id;
import mondrian.olap.Literal;
import mondrian.olap.MemberProperty;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.QueryPart;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.parser.MdxParserImplConstants;
import mondrian.parser.MdxParserImplTokenManager;
import mondrian.parser.MdxParserValidator;
import mondrian.parser.ParseException;
import mondrian.parser.SimpleCharStream;
import mondrian.parser.Token;
import mondrian.resource.MondrianResource;
import mondrian.server.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdxParserImpl
implements MdxParserImplConstants {
    private MdxParserValidator.QueryPartFactory factory;
    private Statement statement;
    private FunTable funTable;
    private boolean strictValidation;
    private static final MemberProperty[] EmptyMemberPropertyArray = new MemberProperty[0];
    private static final Exp[] EmptyExpArray = new Exp[0];
    private static final Formula[] EmptyFormulaArray = new Formula[0];
    private static final Id[] EmptyIdArray = new Id[0];
    private static final QueryPart[] EmptyQueryPartArray = new QueryPart[0];
    private static final QueryAxis[] EmptyQueryAxisArray = new QueryAxis[0];
    private static final String DQ = "\"";
    private static final String DQDQ = "\"\"";
    public MdxParserImplTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[57];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[8];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public MdxParserImpl(MdxParserValidator.QueryPartFactory factory, Statement statement, String queryString, boolean debug, FunTable funTable, boolean strictValidation) {
        this(new StringReader(MdxParserImpl.term(queryString)));
        this.factory = factory;
        this.statement = statement;
        this.funTable = funTable;
        this.strictValidation = strictValidation;
    }

    private static String term(String s) {
        return s.endsWith("\n") ? s : s + "\n";
    }

    public void setTabSize(int tabSize) {
        this.jj_input_stream.setTabSize(tabSize);
    }

    Exp recursivelyParseExp(String s) throws ParseException {
        MdxParserImpl parser = new MdxParserImpl(this.factory, this.statement, s, false, this.funTable, this.strictValidation);
        return parser.expression();
    }

    static Id[] toIdArray(List<Id> idList) {
        if (idList == null || idList.size() == 0) {
            return EmptyIdArray;
        }
        return idList.toArray(new Id[idList.size()]);
    }

    static Exp[] toExpArray(List<Exp> expList) {
        if (expList == null || expList.size() == 0) {
            return EmptyExpArray;
        }
        return expList.toArray(new Exp[expList.size()]);
    }

    static Formula[] toFormulaArray(List<Formula> formulaList) {
        if (formulaList == null || formulaList.size() == 0) {
            return EmptyFormulaArray;
        }
        return formulaList.toArray(new Formula[formulaList.size()]);
    }

    static MemberProperty[] toMemberPropertyArray(List<MemberProperty> mpList) {
        if (mpList == null || mpList.size() == 0) {
            return EmptyMemberPropertyArray;
        }
        return mpList.toArray(new MemberProperty[mpList.size()]);
    }

    static QueryPart[] toQueryPartArray(List<QueryPart> qpList) {
        if (qpList == null || qpList.size() == 0) {
            return EmptyQueryPartArray;
        }
        return qpList.toArray(new QueryPart[qpList.size()]);
    }

    static QueryAxis[] toQueryAxisArray(List<QueryAxis> qpList) {
        if (qpList == null || qpList.size() == 0) {
            return EmptyQueryAxisArray;
        }
        return qpList.toArray(new QueryAxis[qpList.size()]);
    }

    private static String stripQuotes(String s, String prefix, String suffix, String quoted) {
        assert (s.startsWith(prefix) && s.endsWith(suffix));
        s = s.substring(prefix.length(), s.length() - suffix.length());
        s = Util.replace(s, quoted, suffix);
        return s;
    }

    private Exp createCall(Exp left, Id.Segment segment, List<Exp> argList) {
        Syntax syntax;
        String name;
        String string = name = segment instanceof Id.NameSegment ? ((Id.NameSegment)segment).name : null;
        if (argList != null) {
            if (left != null) {
                argList.add(0, left);
                return new UnresolvedFunCall(name, Syntax.Method, MdxParserImpl.toExpArray(argList));
            }
            return new UnresolvedFunCall(name, Syntax.Function, MdxParserImpl.toExpArray(argList));
        }
        boolean call = false;
        switch (segment.quoting) {
            case UNQUOTED: {
                syntax = Syntax.Property;
                call = this.funTable.isProperty(name);
                break;
            }
            case QUOTED: {
                syntax = Syntax.QuotedProperty;
                break;
            }
            default: {
                syntax = Syntax.AmpersandQuotedProperty;
            }
        }
        if (left instanceof Id && !call) {
            return ((Id)left).append(segment);
        }
        if (left == null) {
            return new Id(segment);
        }
        return new UnresolvedFunCall(name, syntax, new Exp[]{left});
    }

    public final QueryPart statementEof() throws ParseException {
        QueryPart qp = this.statement();
        this.jj_consume_token(0);
        return qp;
    }

    public final Exp expressionEof() throws ParseException {
        Exp e = this.expression();
        this.jj_consume_token(0);
        return e;
    }

    public final Id.Segment identifier() throws ParseException {
        Id.Segment segment;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 30: 
            case 80: 
            case 81: {
                segment = this.nameSegment();
                break;
            }
            case 82: 
            case 83: {
                segment = this.keyIdentifier();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return segment;
    }

    public final Id.NameSegment nameSegment() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 30: {
                String id = this.keyword();
                return new Id.NameSegment(id, Id.Quoting.UNQUOTED);
            }
            case 80: {
                this.jj_consume_token(80);
                return new Id.NameSegment(this.token.image, Id.Quoting.UNQUOTED);
            }
            case 81: {
                this.jj_consume_token(81);
                return new Id.NameSegment(MdxParserImpl.stripQuotes(this.token.image, "[", "]", "]]"), Id.Quoting.QUOTED);
            }
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Id.KeySegment keyIdentifier() throws ParseException {
        ArrayList<Id.NameSegment> list = new ArrayList<Id.NameSegment>();
        block3: while (true) {
            Id.NameSegment key = this.ampId();
            list.add(key);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 82: 
                case 83: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[2] = this.jj_gen;
        return new Id.KeySegment(list);
    }

    public final Id.NameSegment ampId() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 82: {
                this.jj_consume_token(82);
                return new Id.NameSegment(MdxParserImpl.stripQuotes(this.token.image, "&[", "]", "]]"), Id.Quoting.QUOTED);
            }
            case 83: {
                this.jj_consume_token(83);
                return new Id.NameSegment(this.token.image.substring(1), Id.Quoting.UNQUOTED);
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String keyword() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                return "Dimension";
            }
            case 30: {
                this.jj_consume_token(30);
                return "Properties";
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Id compoundId() throws ParseException {
        ArrayList<Id.Segment> list = new ArrayList<Id.Segment>();
        Id.Segment i = this.identifier();
        list.add(i);
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            this.jj_consume_token(59);
            i = this.identifier();
            list.add(i);
        }
        return new Id(list);
    }

    public final Exp unaliasedExpression() throws ParseException {
        Exp x;
        block9: {
            x = this.term5();
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: 
                    case 39: 
                    case 56: {
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        this.jj_consume_token(27);
                        Exp y = this.term5();
                        x = new UnresolvedFunCall("OR", Syntax.Infix, new Exp[]{x, y});
                        continue block8;
                    }
                    case 39: {
                        this.jj_consume_token(39);
                        Exp y = this.term5();
                        x = new UnresolvedFunCall("XOR", Syntax.Infix, new Exp[]{x, y});
                        continue block8;
                    }
                    case 56: {
                        this.jj_consume_token(56);
                        Exp y = this.term5();
                        x = new UnresolvedFunCall(":", Syntax.Infix, new Exp[]{x, y});
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[6] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return x;
    }

    public final Exp term5() throws ParseException {
        Exp x = this.term4();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(1);
            Exp y = this.term4();
            x = new UnresolvedFunCall("AND", Syntax.Infix, new Exp[]{x, y});
        }
        return x;
    }

    public final Exp term4() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 5: 
            case 9: 
            case 25: 
            case 30: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: {
                Exp x = this.term3();
                return x;
            }
            case 24: {
                this.jj_consume_token(24);
                Exp x = this.term4();
                return new UnresolvedFunCall("NOT", Syntax.Prefix, new Exp[]{x});
            }
        }
        this.jj_la1[8] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Exp term3() throws ParseException {
        Exp x;
        block26: {
            x = this.term2();
            block22: while (true) {
                Exp y;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: 
                    case 19: 
                    case 20: 
                    case 24: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 64: 
                    case 66: 
                    case 68: {
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        break block26;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 60: 
                    case 61: 
                    case 62: 
                    case 64: 
                    case 66: 
                    case 68: {
                        Token op;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 60: {
                                this.jj_consume_token(60);
                                op = this.token;
                                break;
                            }
                            case 68: {
                                this.jj_consume_token(68);
                                op = this.token;
                                break;
                            }
                            case 66: {
                                this.jj_consume_token(66);
                                op = this.token;
                                break;
                            }
                            case 62: {
                                this.jj_consume_token(62);
                                op = this.token;
                                break;
                            }
                            case 64: {
                                this.jj_consume_token(64);
                                op = this.token;
                                break;
                            }
                            case 61: {
                                this.jj_consume_token(61);
                                op = this.token;
                                break;
                            }
                            default: {
                                this.jj_la1[10] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        y = this.term2();
                        x = new UnresolvedFunCall(op.image, Syntax.Infix, new Exp[]{x, y});
                        continue block22;
                    }
                }
                this.jj_la1[11] = this.jj_gen;
                if (this.jj_2_2(2)) {
                    this.jj_consume_token(19);
                    this.jj_consume_token(25);
                    x = new UnresolvedFunCall("IS NULL", Syntax.Postfix, new Exp[]{x});
                    continue;
                }
                if (this.jj_2_3(2)) {
                    this.jj_consume_token(19);
                    y = this.term2();
                    x = new UnresolvedFunCall("IS", Syntax.Infix, new Exp[]{x, y});
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: {
                        this.jj_consume_token(19);
                        this.jj_consume_token(12);
                        x = new UnresolvedFunCall("IS EMPTY", Syntax.Postfix, new Exp[]{x});
                        continue block22;
                    }
                    case 20: {
                        this.jj_consume_token(20);
                        y = this.term2();
                        x = new UnresolvedFunCall("MATCHES", Syntax.Infix, new Exp[]{x, y});
                        continue block22;
                    }
                }
                this.jj_la1[12] = this.jj_gen;
                if (this.jj_2_4(2)) {
                    this.jj_consume_token(24);
                    this.jj_consume_token(20);
                    y = this.term2();
                    x = new UnresolvedFunCall("NOT", Syntax.Prefix, new Exp[]{new UnresolvedFunCall("MATCHES", Syntax.Infix, new Exp[]{x, y})});
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        this.jj_consume_token(18);
                        y = this.term2();
                        x = new UnresolvedFunCall("IN", Syntax.Infix, new Exp[]{x, y});
                        continue block22;
                    }
                    case 24: {
                        this.jj_consume_token(24);
                        this.jj_consume_token(18);
                        y = this.term2();
                        x = new UnresolvedFunCall("NOT", Syntax.Prefix, new Exp[]{new UnresolvedFunCall("IN", Syntax.Infix, new Exp[]{x, y})});
                        continue block22;
                    }
                }
                break;
            }
            this.jj_la1[13] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return x;
    }

    public final Exp term2() throws ParseException {
        Exp x;
        block9: {
            x = this.term();
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 58: 
                    case 67: 
                    case 69: {
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 69: {
                        this.jj_consume_token(69);
                        Exp y = this.term();
                        x = new UnresolvedFunCall("+", Syntax.Infix, new Exp[]{x, y});
                        continue block8;
                    }
                    case 67: {
                        this.jj_consume_token(67);
                        Exp y = this.term();
                        x = new UnresolvedFunCall("-", Syntax.Infix, new Exp[]{x, y});
                        continue block8;
                    }
                    case 58: {
                        this.jj_consume_token(58);
                        Exp y = this.term();
                        x = new UnresolvedFunCall("||", Syntax.Infix, new Exp[]{x, y});
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[15] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return x;
    }

    public final Exp term() throws ParseException {
        Exp x;
        block8: {
            x = this.factor();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 54: 
                    case 72: {
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 54: {
                        this.jj_consume_token(54);
                        Exp y = this.factor();
                        x = new UnresolvedFunCall("*", Syntax.Infix, new Exp[]{x, y});
                        continue block7;
                    }
                    case 72: {
                        this.jj_consume_token(72);
                        Exp y = this.factor();
                        x = new UnresolvedFunCall("/", Syntax.Infix, new Exp[]{x, y});
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[17] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return x;
    }

    public final Exp factor() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 5: 
            case 9: 
            case 25: 
            case 30: 
            case 63: 
            case 65: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: {
                Exp p = this.primary();
                return p;
            }
            case 69: {
                this.jj_consume_token(69);
                Exp p = this.primary();
                return p;
            }
            case 67: {
                this.jj_consume_token(67);
                Exp p = this.primary();
                return new UnresolvedFunCall("-", Syntax.Prefix, new Exp[]{p});
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Exp primary() throws ParseException {
        Exp e = this.atom();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(59);
            e = this.segmentOrFuncall(e);
        }
        return e;
    }

    public final Exp segmentOrFuncall(Exp left) throws ParseException {
        List<Exp> argList = null;
        Id.Segment segment = this.identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: {
                this.jj_consume_token(65);
                argList = this.jj_2_5(Integer.MAX_VALUE) ? Collections.emptyList() : this.expOrEmptyList();
                this.jj_consume_token(71);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        return this.createCall(left, segment, argList);
    }

    public final Literal numericLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 75: {
                this.jj_consume_token(75);
                return Literal.create(new BigDecimal(this.token.image));
            }
            case 73: {
                this.jj_consume_token(73);
                return Literal.create(new BigDecimal(this.token.image));
            }
            case 74: {
                this.jj_consume_token(74);
                return Literal.create(new BigDecimal(this.token.image));
            }
        }
        this.jj_la1[21] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Exp atom() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 77: {
                this.jj_consume_token(77);
                return Literal.createString(MdxParserImpl.stripQuotes(this.token.image, "'", "'", "''"));
            }
            case 78: {
                this.jj_consume_token(78);
                return Literal.createString(MdxParserImpl.stripQuotes(this.token.image, DQ, DQ, DQDQ));
            }
            case 73: 
            case 74: 
            case 75: {
                Literal e = this.numericLiteral();
                return e;
            }
            case 25: {
                this.jj_consume_token(25);
                return Literal.nullValue;
            }
            case 5: {
                this.jj_consume_token(5);
                this.jj_consume_token(65);
                Exp e = this.unaliasedExpression();
                this.jj_consume_token(2);
                Id.NameSegment segment = this.nameSegment();
                this.jj_consume_token(71);
                return new UnresolvedFunCall("CAST", Syntax.Cast, new Exp[]{e, Literal.createSymbol(segment.name)});
            }
            case 65: {
                this.jj_consume_token(65);
                List<Exp> lis = this.expList();
                this.jj_consume_token(71);
                return new UnresolvedFunCall("()", Syntax.Parentheses, MdxParserImpl.toExpArray(lis));
            }
            case 63: {
                List<Exp> lis;
                this.jj_consume_token(63);
                if (this.jj_2_6(Integer.MAX_VALUE)) {
                    lis = Collections.emptyList();
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 4: 
                        case 5: 
                        case 9: 
                        case 24: 
                        case 25: 
                        case 30: 
                        case 63: 
                        case 65: 
                        case 67: 
                        case 69: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 77: 
                        case 78: 
                        case 80: 
                        case 81: {
                            lis = this.expList();
                            break;
                        }
                        default: {
                            this.jj_la1[22] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                this.jj_consume_token(70);
                return new UnresolvedFunCall("{}", Syntax.Braces, MdxParserImpl.toExpArray(lis));
            }
            case 4: {
                Exp e = this.caseExpression();
                return e;
            }
            case 9: 
            case 30: 
            case 80: 
            case 81: {
                List<Object> lis;
                Id.NameSegment segment = this.nameSegment();
                block20: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 55: {
                            break;
                        }
                        default: {
                            this.jj_la1[23] = this.jj_gen;
                            break block20;
                        }
                    }
                    this.jj_consume_token(55);
                    segment = this.nameSegment();
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 65: {
                        this.jj_consume_token(65);
                        lis = this.jj_2_7(Integer.MAX_VALUE) ? Collections.emptyList() : this.expOrEmptyList();
                        this.jj_consume_token(71);
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                        lis = null;
                    }
                }
                return this.createCall(null, segment, lis);
            }
        }
        this.jj_la1[25] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Exp caseExpression() throws ParseException {
        Exp e;
        ArrayList<Exp> list = new ArrayList<Exp>();
        boolean match = false;
        this.jj_consume_token(4);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 5: 
            case 9: 
            case 24: 
            case 25: 
            case 30: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: {
                e = this.expression();
                match = true;
                list.add(e);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: {
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(37);
            e = this.expression();
            this.jj_consume_token(36);
            Exp e2 = this.expression();
            list.add(e);
            list.add(e2);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                e = this.expression();
                list.add(e);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        this.jj_consume_token(13);
        if (match) {
            return new UnresolvedFunCall("_CaseMatch", Syntax.Case, MdxParserImpl.toExpArray(list));
        }
        return new UnresolvedFunCall("_CaseTest", Syntax.Case, MdxParserImpl.toExpArray(list));
    }

    public final Exp expression() throws ParseException {
        Exp e = this.unaliasedExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: {
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(2);
            Id.Segment i = this.identifier();
            Id id = new Id(i);
            e = new UnresolvedFunCall("AS", Syntax.Infix, new Exp[]{e, id});
        }
        return e;
    }

    public final Exp expressionOrEmpty() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 5: 
            case 9: 
            case 24: 
            case 25: 
            case 30: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: {
                Exp e = this.expression();
                return e;
            }
        }
        this.jj_la1[30] = this.jj_gen;
        return new UnresolvedFunCall("", Syntax.Empty, new Exp[0]);
    }

    public final List<Exp> expOrEmptyList() throws ParseException {
        LinkedList<Exp> list = new LinkedList<Exp>();
        Exp e = this.expressionOrEmpty();
        list.add(e);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 57: {
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(57);
            e = this.expressionOrEmpty();
            list.add(e);
        }
        return list;
    }

    public final List<Exp> expList() throws ParseException {
        LinkedList<Exp> list = new LinkedList<Exp>();
        Exp e = this.expression();
        list.add(e);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 57: {
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(57);
            e = this.expression();
            list.add(e);
        }
        return list;
    }

    public final QueryPart statement() throws ParseException {
        QueryPart qp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: 
            case 40: {
                qp = this.selectStatement();
                break;
            }
            case 10: {
                qp = this.drillthroughStatement();
                break;
            }
            case 14: {
                qp = this.explainStatement();
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return qp;
    }

    public final QueryPart selectOrDrillthroughStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: 
            case 40: {
                Query qp = this.selectStatement();
                return qp;
            }
            case 10: {
                QueryPart qp = this.drillthroughStatement();
                return qp;
            }
        }
        this.jj_la1[34] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Query selectStatement() throws ParseException {
        ArrayList<Formula> f = new ArrayList<Formula>();
        Exp w = null;
        ArrayList<QueryAxis> a = new ArrayList<QueryAxis>();
        ArrayList<QueryPart> cellPropList = new ArrayList<QueryPart>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                block28: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 22: {
                            Formula e = this.memberSpecification();
                            f.add(e);
                            break;
                        }
                        case 35: {
                            Formula e = this.setSpecification();
                            f.add(e);
                            break;
                        }
                        default: {
                            this.jj_la1[35] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 22: 
                        case 35: {
                            continue block28;
                        }
                    }
                    break;
                }
                this.jj_la1[36] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        this.jj_consume_token(34);
        block10 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 5: 
            case 9: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: {
                QueryAxis i = this.axisSpecification();
                a.add(i);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 57: {
                            break;
                        }
                        default: {
                            this.jj_la1[38] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.jj_consume_token(57);
                    i = this.axisSpecification();
                    a.add(i);
                }
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        this.jj_consume_token(17);
        Id c = this.compoundId();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                this.jj_consume_token(38);
                w = this.expression();
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        block19 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 30: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        this.jj_consume_token(6);
                        break;
                    }
                    default: {
                        this.jj_la1[41] = this.jj_gen;
                    }
                }
                this.jj_consume_token(30);
                Id p = this.compoundId();
                cellPropList.add(new CellProperty(p.getSegments()));
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 57: {
                            break;
                        }
                        default: {
                            this.jj_la1[42] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.jj_consume_token(57);
                    p = this.compoundId();
                    cellPropList.add(new CellProperty(p.getSegments()));
                }
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        String cubeName = ((Id.NameSegment)c.getElement((int)0)).name;
        return this.factory.makeQuery(this.statement, MdxParserImpl.toFormulaArray(f), MdxParserImpl.toQueryAxisArray(a), cubeName, w, MdxParserImpl.toQueryPartArray(cellPropList), this.strictValidation);
    }

    public final Formula memberSpecification() throws ParseException {
        ArrayList<MemberProperty> l = new ArrayList<MemberProperty>();
        this.jj_consume_token(22);
        Id m = this.compoundId();
        this.jj_consume_token(2);
        Exp e = this.formulaExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 57: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(57);
            MemberProperty mp = this.memberPropertyDefinition();
            l.add(mp);
        }
        return new Formula(m, e, MdxParserImpl.toMemberPropertyArray(l));
    }

    public final Exp formulaExpression() throws ParseException {
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            this.jj_consume_token(77);
            return this.recursivelyParseExp(MdxParserImpl.stripQuotes(this.token.image, "'", "'", "''"));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 5: 
            case 9: 
            case 24: 
            case 25: 
            case 30: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: {
                Exp e = this.unaliasedExpression();
                return e;
            }
        }
        this.jj_la1[45] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final MemberProperty memberPropertyDefinition() throws ParseException {
        Id.NameSegment id = this.nameSegment();
        this.jj_consume_token(60);
        Exp e = this.expression();
        return new MemberProperty(id.name, e);
    }

    public final Formula setSpecification() throws ParseException {
        this.jj_consume_token(35);
        Id n = this.compoundId();
        this.jj_consume_token(2);
        Exp e = this.formulaExpression();
        return new Formula(n, e);
    }

    public final QueryAxis axisSpecification() throws ParseException {
        AxisOrdinal axis;
        boolean nonEmpty = false;
        ArrayList<Id> dp = new ArrayList<Id>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                this.jj_consume_token(12);
                nonEmpty = true;
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
            }
        }
        Exp e = this.expression();
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 30: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        this.jj_consume_token(9);
                        break;
                    }
                    default: {
                        this.jj_la1[47] = this.jj_gen;
                    }
                }
                this.jj_consume_token(30);
                Id p = this.compoundId();
                dp.add(p);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 57: {
                            break;
                        }
                        default: {
                            this.jj_la1[48] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(57);
                    p = this.compoundId();
                    dp.add(p);
                }
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        this.jj_consume_token(26);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                axis = AxisOrdinal.StandardAxisOrdinal.COLUMNS;
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                axis = AxisOrdinal.StandardAxisOrdinal.ROWS;
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                axis = AxisOrdinal.StandardAxisOrdinal.PAGES;
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                axis = AxisOrdinal.StandardAxisOrdinal.SECTIONS;
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                axis = AxisOrdinal.StandardAxisOrdinal.CHAPTERS;
                break;
            }
            case 3: 
            case 73: 
            case 74: 
            case 75: {
                Literal n;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 73: 
                    case 74: 
                    case 75: {
                        n = this.numericLiteral();
                        break;
                    }
                    case 3: {
                        this.jj_consume_token(3);
                        this.jj_consume_token(65);
                        n = this.numericLiteral();
                        this.jj_consume_token(71);
                        break;
                    }
                    default: {
                        this.jj_la1[50] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Number number = (Number)n.getValue();
                if (number.doubleValue() < 0.0 || number.doubleValue() != (double)number.intValue()) {
                    throw MondrianResource.instance().InvalidAxis.ex(number.doubleValue());
                }
                axis = AxisOrdinal.StandardAxisOrdinal.forLogicalOrdinal(number.intValue());
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new QueryAxis(nonEmpty, e, axis, QueryAxis.SubtotalVisibility.Undefined, MdxParserImpl.toIdArray(dp));
    }

    public final QueryPart drillthroughStatement() throws ParseException {
        int m = 0;
        int f = 0;
        List<Exp> rl = null;
        this.jj_consume_token(10);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                this.jj_consume_token(73);
                m = Integer.valueOf(this.token.image);
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                this.jj_consume_token(73);
                f = Integer.valueOf(this.token.image);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
            }
        }
        Query s = this.selectStatement();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                rl = this.returnItemList();
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        return this.factory.makeDrillThrough(s, m, f, rl);
    }

    public final List<Exp> returnItemList() throws ParseException {
        ArrayList<Exp> list = new ArrayList<Exp>();
        Id i = this.returnItem();
        list.add(i);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 57: {
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(57);
            i = this.returnItem();
            list.add(i);
        }
        return list;
    }

    public final Id returnItem() throws ParseException {
        Id i = this.compoundId();
        return i;
    }

    public final QueryPart explainStatement() throws ParseException {
        QueryPart qp;
        this.jj_consume_token(14);
        this.jj_consume_token(29);
        this.jj_consume_token(16);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: 
            case 40: {
                qp = this.selectStatement();
                break;
            }
            case 10: {
                qp = this.drillthroughStatement();
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.factory.makeExplain(qp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    private boolean jj_3R_37() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_40()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_41()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_42()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_40() {
        return this.jj_scan_token(75);
    }

    private boolean jj_3_7() {
        return this.jj_scan_token(71);
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(81);
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(80);
    }

    private boolean jj_3R_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_44()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_45()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_43() {
        return this.jj_3R_46();
    }

    private boolean jj_3_8() {
        return this.jj_scan_token(77);
    }

    private boolean jj_3_1() {
        return this.jj_scan_token(59);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_36() {
        return this.jj_3R_39();
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3_6() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_26() {
        return this.jj_3R_27();
    }

    private boolean jj_3R_35() {
        return this.jj_3R_38();
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_25() {
        return this.jj_scan_token(67);
    }

    private boolean jj_3R_24() {
        return this.jj_scan_token(69);
    }

    private boolean jj_3R_34() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_48() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_23() {
        return this.jj_3R_26();
    }

    private boolean jj_3R_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_23()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_24()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_25()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_47() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_47()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_48()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_33() {
        return this.jj_scan_token(65);
    }

    private boolean jj_3R_32() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_31() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_21() {
        return this.jj_3R_22();
    }

    private boolean jj_3R_30() {
        return this.jj_3R_37();
    }

    private boolean jj_3R_29() {
        return this.jj_scan_token(78);
    }

    private boolean jj_3R_28() {
        return this.jj_scan_token(77);
    }

    private boolean jj_3R_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_29()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_30()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_31()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_32()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_33()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_34()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_35()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_36()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_42() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_41() {
        return this.jj_scan_token(73);
    }

    private boolean jj_3R_38() {
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_20() {
        return this.jj_3R_21();
    }

    private boolean jj_3_5() {
        return this.jj_scan_token(71);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x40000200, 0x40000200, 0, 0, 0x40000200, 0x8000000, 0x8000000, 2, 1124074032, 0x11C0000, 0, 0, 0x180000, 0x1040000, 0, 0, 0, 0, 1107296816, 0, 0, 0, 1124074032, 0, 0, 1107296816, 1124074032, 0, 2048, 4, 1124074032, 0, 0, 17408, 1024, 0x400000, 0x400000, 0, 0, 1132462640, 0, 64, 0, 0x40000040, 0, 1124074032, 0x800000, 512, 0, 0x40000200, 8, 0x10000188, 0x200000, 32768, Integer.MIN_VALUE, 0, 1024};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0x1000080, 0x1000080, 0, Integer.MIN_VALUE, 0x70000000, 0x70000000, 0x70000000, 0, 0, 0x4000000, 0x4000000, 0x400000, 0x400000, Integer.MIN_VALUE, 0x8000000, 0, 0, Integer.MIN_VALUE, 0x800000, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 32, 0, 0, Integer.MIN_VALUE, 0x2000000, 0x2000000, 260, 260, 8, 8, 256, 0x2000000, Integer.MIN_VALUE, 64, 0, 0x2000000, 0, 0x2000000, Integer.MIN_VALUE, 0, 0, 0x2000000, 0, 0, 3, 0, 0, 0, 0x2000000, 260};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{983040, 196608, 786432, 786432, 0, 0, 0, 0, 224810, 21, 21, 21, 0, 0, 40, 40, 256, 256, 224810, 0, 2, 3584, 224810, 0, 2, 224770, 224810, 0, 0, 0, 224810, 0, 0, 0, 0, 0, 0, 0, 0, 224810, 0, 0, 0, 0, 0, 224810, 0, 0, 0, 0, 3584, 3584, 0, 0, 0, 0, 0};
    }

    public MdxParserImpl(InputStream stream) {
        this(stream, null);
    }

    public MdxParserImpl(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new MdxParserImplTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 57; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 57; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public MdxParserImpl(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new MdxParserImplTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 57; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 57; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public MdxParserImpl(MdxParserImplTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 57; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(MdxParserImplTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 57; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[86];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 57; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 86; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 8; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        MdxParserImpl.jj_la1_init_0();
        MdxParserImpl.jj_la1_init_1();
        MdxParserImpl.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

