/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

public class RunTransServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static final long serialVersionUID = 1192413943669836776L;
    private static Class<?> PKG = RunTransServlet.class;
    public static final String CONTEXT_PATH = "/kettle/runTrans";

    public RunTransServlet() {
    }

    public RunTransServlet(TransformationMap transformationMap) {
        super(transformationMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"RunTransServlet.Log.RunTransRequested", (String[])new String[0]));
        }
        String[] knownOptions = new String[]{"trans", "level"};
        String transOption = request.getParameter("trans");
        String levelOption = request.getParameter("level");
        response.setStatus(200);
        String encoding = System.getProperty("KETTLE_DEFAULT_SERVLET_ENCODING", null);
        if (encoding != null && !Utils.isEmpty((CharSequence)encoding.trim())) {
            response.setCharacterEncoding(encoding);
            response.setContentType("text/html; charset=" + encoding);
        }
        PrintWriter out = response.getWriter();
        try {
            Repository repository = this.transformationMap.getSlaveServerConfig().getRepository();
            TransMeta transMeta = this.loadTrans(repository, transOption);
            String[] parameters = transMeta.listParameters();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameter = (String)parameterNames.nextElement();
                String[] values = request.getParameterValues(parameter);
                if (Const.indexOfString((String)parameter, (String[])knownOptions) >= 0) continue;
                if (Const.indexOfString((String)parameter, (String[])parameters) < 0) {
                    transMeta.setVariable(parameter, values[0]);
                    continue;
                }
                transMeta.setParameterValue(parameter, values[0]);
            }
            TransExecutionConfiguration transExecutionConfiguration = new TransExecutionConfiguration();
            LogLevel logLevel = LogLevel.getLogLevelForCode((String)levelOption);
            transExecutionConfiguration.setLogLevel(logLevel);
            TransConfiguration transConfiguration = new TransConfiguration(transMeta, transExecutionConfiguration);
            String carteObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.CARTE, null);
            servletLoggingObject.setContainerObjectId(carteObjectId);
            servletLoggingObject.setLogLevel(logLevel);
            Trans trans = this.createTrans(transMeta, servletLoggingObject);
            trans.setRepository(repository);
            trans.setServletPrintWriter(out);
            trans.setServletReponse(response);
            trans.setServletRequest(request);
            trans.initializeVariablesFrom(null);
            trans.getTransMeta().setInternalKettleVariables(trans);
            trans.injectVariables(transConfiguration.getTransExecutionConfiguration().getVariables());
            trans.copyParametersFrom(transMeta);
            transMeta.activateParameters();
            trans.setSocketRepository(this.getSocketRepository());
            this.getTransformationMap().addTransformation(trans.getName(), carteObjectId, trans, transConfiguration);
            String message = "Transformation '" + trans.getName() + "' was added to the list with id " + carteObjectId;
            this.logBasic(message);
            try {
                trans.execute(null);
                this.finishProcessing(trans, out);
            }
            catch (Exception executionException) {
                String logging = KettleLogStore.getAppender().getBuffer(trans.getLogChannelId(), false).toString();
                throw new KettleException("Error executing Transformation: " + logging, (Throwable)executionException);
            }
        }
        catch (Exception ex) {
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"RunTransServlet.Error.UnexpectedError", (String[])new String[]{Const.CR + Const.getStackTracker((Throwable)ex)})));
        }
    }

    Trans createTrans(TransMeta transMeta, SimpleLoggingObject servletLoggingObject) {
        return new Trans(transMeta, (LoggingObjectInterface)servletLoggingObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransMeta loadTrans(Repository repository, String transformationName) throws KettleException {
        if (repository == null) {
            throw new KettleException("Repository required.");
        }
        Repository repository2 = repository;
        synchronized (repository2) {
            String name;
            String directoryPath;
            int lastSlash = transformationName.lastIndexOf("/");
            if (lastSlash < 0) {
                directoryPath = "/";
                name = transformationName;
            } else {
                directoryPath = transformationName.substring(0, lastSlash);
                name = transformationName.substring(lastSlash + 1);
            }
            RepositoryDirectoryInterface directory = repository.loadRepositoryDirectoryTree().findDirectory(directoryPath);
            ObjectId transformationId = repository.getTransformationID(name, directory);
            TransMeta transMeta = repository.loadTransformation(transformationId, null);
            return transMeta;
        }
    }

    @VisibleForTesting
    void finishProcessing(Trans trans, PrintWriter out) {
        if (trans.getSteps().stream().anyMatch(step -> step.meta.passDataToServletOutput())) {
            trans.waitUntilFinished();
        } else {
            WebResult webResult = new WebResult("OK", "Transformation started", trans.getContainerObjectId());
            out.println(webResult.getXML());
            out.flush();
        }
    }

    public String toString() {
        return "Run Transformation";
    }

    @Override
    public String getService() {
        return "/kettle/runTrans (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

