/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.symmetriccrypto.secretkeygenerator;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.symmetriccrypto.secretkeygenerator.SecretKeyGeneratorData;
import org.pentaho.di.trans.steps.symmetriccrypto.secretkeygenerator.SecretKeyGeneratorMeta;
import org.pentaho.di.trans.steps.symmetriccrypto.symmetricalgorithm.CryptoException;
import org.pentaho.di.trans.steps.symmetriccrypto.symmetricalgorithm.SymmetricCrypto;
import org.pentaho.di.trans.steps.symmetriccrypto.symmetricalgorithm.SymmetricCryptoMeta;

public class SecretKeyGenerator
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SecretKeyGeneratorMeta.class;
    private SecretKeyGeneratorMeta meta;
    private SecretKeyGeneratorData data;

    public SecretKeyGenerator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] rowIn = null;
        if (this.data.readsRows) {
            rowIn = this.getRow();
            if (rowIn == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.prevNrField = this.getInputRowMeta().size();
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            }
        } else if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
        }
        for (int i = 0; i < this.data.nr && !this.isStopped(); ++i) {
            for (int j = 0; j < this.data.secretKeyCount[i] && !this.isStopped(); ++j) {
                Object[] row = this.buildEmptyRow();
                this.incrementLinesRead();
                int index = 0;
                try {
                    row[index++] = this.meta.isOutputKeyInBinary() ? (Object)this.data.cryptoTrans[i].generateKey(this.data.secretKeyLen[i]) : this.data.cryptoTrans[i].generateKeyAsHex(this.data.secretKeyLen[i]);
                }
                catch (CryptoException k) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SecretKeyGenerator.KeyGenerationError", (Object[])new Object[]{i}), (Throwable)((Object)k));
                }
                if (this.data.addAlgorithmOutput) {
                    row[index++] = this.meta.getAlgorithm()[i];
                }
                if (this.data.addSecretKeyLengthOutput) {
                    row[index++] = new Long(this.data.secretKeyLen[i]);
                }
                if (this.data.readsRows) {
                    row = RowDataUtil.addRowData((Object[])rowIn, (int)this.data.prevNrField, (Object[])row);
                }
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"SecretKeyGenerator.Log.ValueReturned", (String[])new String[]{this.data.outputRowMeta.getString(row)}));
                }
                this.putRow(this.data.outputRowMeta, row);
            }
        }
        this.setOutputDone();
        return false;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SecretKeyGeneratorMeta)smi;
        this.data = (SecretKeyGeneratorData)sdi;
        if (super.init(smi, sdi)) {
            if (Utils.isEmpty((CharSequence[])this.meta.getAlgorithm())) {
                this.logError(BaseMessages.getString(PKG, (String)"SecretKeyGenerator.Log.NoFieldSpecified", (String[])new String[0]));
                return false;
            }
            if (Utils.isEmpty((CharSequence)this.meta.getSecretKeyFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"SecretKeyGenerator.Log.secretKeyFieldMissing", (String[])new String[0]));
                return false;
            }
            this.data.nr = this.meta.getAlgorithm().length;
            this.data.algorithm = new int[this.data.nr];
            this.data.scheme = new String[this.data.nr];
            this.data.secretKeyLen = new int[this.data.nr];
            this.data.secretKeyCount = new int[this.data.nr];
            for (int i = 0; i < this.data.nr; ++i) {
                this.data.algorithm[i] = SymmetricCryptoMeta.getAlgorithmTypeFromCode(this.meta.getAlgorithm()[i]);
                String len = this.environmentSubstitute(this.meta.getSecretKeyLength()[i]);
                this.data.secretKeyLen[i] = Const.toInt((String)len, (int)-1);
                if (this.data.secretKeyLen[i] < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"SecretKeyGenerator.Log.WrongLength", (String[])new String[]{len, String.valueOf(i)}));
                    return false;
                }
                String size = this.environmentSubstitute(this.meta.getSecretKeyCount()[i]);
                this.data.secretKeyCount[i] = Const.toInt((String)size, (int)-1);
                if (this.data.secretKeyCount[i] < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"SecretKeyGenerator.Log.WrongSize", (String[])new String[]{size, String.valueOf(i)}));
                    return false;
                }
                this.data.scheme[i] = this.environmentSubstitute(this.meta.getScheme()[i]);
            }
            this.data.readsRows = this.getStepMeta().getRemoteInputSteps().size() > 0;
            List<StepMeta> previous = this.getTransMeta().findPreviousSteps(this.getStepMeta());
            if (previous != null && previous.size() > 0) {
                this.data.readsRows = true;
            }
            this.data.addAlgorithmOutput = !Utils.isEmpty((CharSequence)this.meta.getAlgorithmFieldName());
            this.data.addSecretKeyLengthOutput = !Utils.isEmpty((CharSequence)this.meta.getSecretKeyLengthFieldName());
            this.data.cryptoTrans = new SymmetricCrypto[this.data.nr];
            for (int i = 0; i < this.data.nr; ++i) {
                try {
                    SymmetricCryptoMeta cryptoTransMeta = new SymmetricCryptoMeta(this.meta.getAlgorithm()[i]);
                    this.data.cryptoTrans[i] = new SymmetricCrypto(cryptoTransMeta, this.data.scheme[i]);
                    continue;
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"SecretKey.Init.Error", (String[])new String[0]), e);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        super.dispose(smi, sdi);
        if (this.data.cryptoTrans != null) {
            int nr = this.data.cryptoTrans.length;
            for (int i = 0; i < nr; ++i) {
                this.data.cryptoTrans[i].close();
            }
        }
    }
}

