/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.simplemapping;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.StepWithMappingMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.TransStepUtil;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInput;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutput;
import org.pentaho.di.trans.steps.simplemapping.PutRowInterface;
import org.pentaho.di.trans.steps.simplemapping.RowDataInputMapper;
import org.pentaho.di.trans.steps.simplemapping.RowOutputDataMapper;
import org.pentaho.di.trans.steps.simplemapping.SimpleMappingData;
import org.pentaho.di.trans.steps.simplemapping.SimpleMappingMeta;

public class SimpleMapping
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SimpleMappingMeta.class;
    private SimpleMappingMeta meta;
    private SimpleMappingData data;

    public SimpleMapping(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (SimpleMappingMeta)smi;
        this.setData((SimpleMappingData)sdi);
        SimpleMappingData simpleMappingData = this.getData();
        try {
            if (this.first) {
                this.first = false;
                simpleMappingData.wasStarted = true;
                String mappingInputStepname = simpleMappingData.mappingInput.getStepname();
                RowProducer rowProducer = simpleMappingData.mappingTrans.addRowProducer(mappingInputStepname, 0);
                simpleMappingData.rowDataInputMapper = new RowDataInputMapper(this.meta.getInputMapping(), rowProducer);
                String mappingOutputStepname = simpleMappingData.mappingOutput.getStepname();
                StepInterface outputStepInterface = simpleMappingData.mappingTrans.findStepInterface(mappingOutputStepname, 0);
                RowOutputDataMapper outputDataMapper = new RowOutputDataMapper(this.meta.getInputMapping(), this.meta.getOutputMapping(), new PutRowInterface(){

                    @Override
                    public void putRow(RowMetaInterface rowMeta, Object[] rowData) throws KettleStepException {
                        SimpleMapping.this.putRow(rowMeta, rowData);
                    }
                });
                outputStepInterface.addRowListener(outputDataMapper);
                simpleMappingData.mappingTrans.startThreads();
            }
            Object[] row = this.getRow();
            boolean rowWasPut = false;
            if (row != null) {
                while (!this.data.mappingTrans.isFinishedOrStopped() && !rowWasPut) {
                    rowWasPut = this.data.rowDataInputMapper.putRow(this.getInputRowMeta(), row);
                }
            }
            if (!rowWasPut) {
                simpleMappingData.rowDataInputMapper.finished();
                simpleMappingData.mappingTrans.waitUntilFinished();
                this.setOutputDone();
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            if (simpleMappingData.mappingTrans != null) {
                simpleMappingData.mappingTrans.stopAll();
            }
            throw new KettleException(t);
        }
    }

    public void prepareMappingExecution() throws KettleException {
        SimpleMappingData simpleMappingData = this.getData();
        simpleMappingData.mappingTrans = new Trans(simpleMappingData.mappingTransMeta, this);
        StepWithMappingMeta.activateParams(simpleMappingData.mappingTrans, simpleMappingData.mappingTrans, this, simpleMappingData.mappingTransMeta.listParameters(), this.meta.getMappingParameters().getVariable(), this.meta.getMappingParameters().getInputField(), this.meta.getMappingParameters().isInheritingAllVariables());
        if (simpleMappingData.mappingTransMeta.getTransformationType() != TransMeta.TransformationType.Normal) {
            simpleMappingData.mappingTrans.getTransMeta().setUsingThreadPriorityManagment(false);
        }
        simpleMappingData.mappingTrans.setParentTrans(this.getTrans());
        simpleMappingData.mappingTrans.setSafeModeEnabled(this.getTrans().isSafeModeEnabled());
        simpleMappingData.mappingTrans.setGatheringMetrics(this.getTrans().isGatheringMetrics());
        simpleMappingData.mappingTrans.setMappingStepName(this.getStepname());
        this.initServletConfig();
        try {
            simpleMappingData.mappingTrans.prepareExecution(this.getTrans().getArguments());
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SimpleMapping.Exception.UnableToPrepareExecutionOfMapping", (String[])new String[0]), (Throwable)e);
        }
        MappingInput[] mappingInputs = simpleMappingData.mappingTrans.findMappingInput();
        if (mappingInputs.length == 0) {
            throw new KettleException("The simple mapping step needs one Mapping Input step to write to in the sub-transformation");
        }
        if (mappingInputs.length > 1) {
            throw new KettleException("The simple mapping step does not support multiple Mapping Input steps to write to in the sub-transformation");
        }
        simpleMappingData.mappingInput = mappingInputs[0];
        simpleMappingData.mappingInput.setConnectorSteps(new StepInterface[0], new ArrayList<MappingValueRename>(), null);
        MappingOutput[] mappingOutputs = simpleMappingData.mappingTrans.findMappingOutput();
        if (mappingOutputs.length == 0) {
            throw new KettleException("The simple mapping step needs one Mapping Output step to read from in the sub-transformation");
        }
        if (mappingOutputs.length > 1) {
            throw new KettleException("The simple mapping step does not support multiple Mapping Output steps to read from in the sub-transformation");
        }
        simpleMappingData.mappingOutput = mappingOutputs[0];
        this.getTrans().addActiveSubTransformation(this.getStepname(), simpleMappingData.mappingTrans);
    }

    void initServletConfig() {
        TransStepUtil.initServletConfig(this.getTrans(), this.getData().getMappingTrans());
    }

    public static void addInputRenames(List<MappingValueRename> renameList, List<MappingValueRename> addRenameList) {
        for (MappingValueRename rename : addRenameList) {
            if (renameList.indexOf(rename) >= 0) continue;
            renameList.add(rename);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SimpleMappingMeta)smi;
        this.setData((SimpleMappingData)sdi);
        SimpleMappingData simpleMappingData = this.getData();
        if (super.init(smi, sdi)) {
            try {
                this.meta.setRepository(this.getTransMeta().getRepository());
                simpleMappingData.mappingTransMeta = SimpleMappingMeta.loadMappingMeta(this.meta, this.meta.getRepository(), this.meta.getMetaStore(), this, this.meta.getMappingParameters().isInheritingAllVariables());
                if (simpleMappingData.mappingTransMeta != null) {
                    this.prepareMappingExecution();
                    return true;
                }
                this.logError("No valid mapping was specified!");
                return false;
            }
            catch (Exception e) {
                this.logError("Unable to load the mapping transformation because of an error : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.getData().wasStarted) {
            if (!this.getData().mappingTrans.isFinished()) {
                this.getData().mappingTrans.waitUntilFinished();
            }
            this.getTrans().removeActiveSubTransformation(this.getStepname());
            if (this.getData().mappingTrans.getErrors() > 0) {
                this.logError(BaseMessages.getString(PKG, (String)"SimpleMapping.Log.ErrorOccurredInSubTransformation", (String[])new String[0]));
                this.setErrors(1L);
            }
        }
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        if (this.getData().mappingTrans != null) {
            this.getData().mappingTrans.stopAll();
        }
    }

    @Override
    public void stopAll() {
        if (this.getData().mappingTrans != null) {
            this.getData().mappingTrans.stopAll();
        }
        super.stopAll();
    }

    public Trans getMappingTrans() {
        return this.getData().mappingTrans;
    }

    @Override
    public void addRowListener(RowListener rowListener) {
        MappingOutput[] mappingOutputs = this.getData().mappingTrans.findMappingOutput();
        if (mappingOutputs == null || mappingOutputs.length == 0) {
            return;
        }
        for (MappingOutput mappingOutput : mappingOutputs) {
            mappingOutput.addRowListener(rowListener);
        }
    }

    public SimpleMappingData getData() {
        return this.data;
    }

    private void setData(SimpleMappingData data) {
        this.data = data;
    }
}

