/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.evalfilesmetrics;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.simpleeval.JobEntrySimpleEval;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryEvalFilesMetrics
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryEvalFilesMetrics.class;
    public static final BigDecimal ONE = new BigDecimal(1);
    public static final String[] IncludeSubFoldersDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] IncludeSubFoldersCodes = new String[]{"N", "Y"};
    private static final String YES = "Y";
    private static final String NO = "N";
    public static final String[] scaleDesc = new String[]{BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Bytes.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.KBytes.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.MBytes.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.GBytes.Label", (String[])new String[0])};
    public static final String[] scaleCodes = new String[]{"bytes", "kbytes", "mbytes", "gbytes"};
    public static final int SCALE_BYTES = 0;
    public static final int SCALE_KBYTES = 1;
    public static final int SCALE_MBYTES = 2;
    public static final int SCALE_GBYTES = 3;
    public int scale = 0;
    public static final String[] SourceFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.SourceFiles.Files.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.SourceFiles.FilenamesResult.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.SourceFiles.PreviousResult.Label", (String[])new String[0])};
    public static final String[] SourceFilesCodes = new String[]{"files", "filenamesresult", "previousresult"};
    public static final int SOURCE_FILES_FILES = 0;
    public static final int SOURCE_FILES_FILENAMES_RESULT = 1;
    public static final int SOURCE_FILES_PREVIOUS_RESULT = 2;
    public int sourceFiles = 0;
    public static final String[] EvaluationTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.EvaluationType.Size.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.EvaluationType.Count.Label", (String[])new String[0])};
    public static final String[] EvaluationTypeCodes = new String[]{"size", "count"};
    public static final int EVALUATE_TYPE_SIZE = 0;
    public static final int EVALUATE_TYPE_COUNT = 1;
    public int evaluationType = 0;
    private String comparevalue;
    private String minvalue;
    private String maxvalue;
    private int successConditionType = 4;
    private String resultFilenamesWildcard = null;
    public boolean arg_from_previous;
    private String[] sourceFileFolder = null;
    private String[] sourceWildcard = null;
    private String[] sourceIncludeSubfolders = null;
    private BigDecimal evaluationValue;
    private BigDecimal filesCount;
    private long nrErrors;
    private String ResultFieldFile = null;
    private String ResultFieldWildcard = null;
    private String ResultFieldIncludesubFolders = null;
    private BigDecimal compareValue;
    private BigDecimal minValue;
    private BigDecimal maxValue;

    public JobEntryEvalFilesMetrics(String n) {
        super(n, "");
    }

    public JobEntryEvalFilesMetrics() {
        this("");
    }

    public void allocate(int nrFields) {
        this.sourceFileFolder = new String[nrFields];
        this.sourceWildcard = new String[nrFields];
        this.sourceIncludeSubfolders = new String[nrFields];
    }

    @Override
    public Object clone() {
        JobEntryEvalFilesMetrics je = (JobEntryEvalFilesMetrics)super.clone();
        if (this.sourceFileFolder != null) {
            int nrFields = this.sourceFileFolder.length;
            je.allocate(nrFields);
            System.arraycopy(this.sourceFileFolder, 0, je.sourceFileFolder, 0, nrFields);
            System.arraycopy(this.sourceWildcard, 0, je.sourceWildcard, 0, nrFields);
            System.arraycopy(this.sourceIncludeSubfolders, 0, je.sourceIncludeSubfolders, 0, nrFields);
        }
        return je;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"result_filenames_wildcard", (String)this.resultFilenamesWildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"Result_field_file", (String)this.ResultFieldFile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"Result_field_wildcard", (String)this.ResultFieldWildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"Result_field_includesubfolders", (String)this.ResultFieldIncludesubFolders));
        retval.append("      <fields>").append(Const.CR);
        if (this.sourceFileFolder != null) {
            for (int i = 0; i < this.sourceFileFolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"source_filefolder", (String)this.sourceFileFolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.sourceWildcard[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"include_subFolders", (String)this.sourceIncludeSubfolders[i]));
                retval.append("        </field>").append(Const.CR);
                if (this.parentJobMeta == null) continue;
                this.parentJobMeta.getNamedClusterEmbedManager().registerUrl(this.sourceFileFolder[i]);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"comparevalue", (String)this.comparevalue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"minvalue", (String)this.minvalue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"maxvalue", (String)this.maxvalue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"successnumbercondition", (String)JobEntrySimpleEval.getSuccessNumberConditionCode(this.successConditionType)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"source_files", (String)JobEntryEvalFilesMetrics.getSourceFilesCode(this.sourceFiles)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"evaluation_type", (String)JobEntryEvalFilesMetrics.getEvaluationTypeCode(this.evaluationType)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"scale", (String)JobEntryEvalFilesMetrics.getScaleCode(this.scale)));
        return retval.toString();
    }

    public static String getIncludeSubFolders(String tt) {
        if (tt == null) {
            return IncludeSubFoldersCodes[0];
        }
        if (tt.equals(IncludeSubFoldersDesc[1])) {
            return IncludeSubFoldersCodes[1];
        }
        return IncludeSubFoldersCodes[0];
    }

    public static String getIncludeSubFoldersDesc(String tt) {
        if (tt == null) {
            return IncludeSubFoldersDesc[0];
        }
        if (tt.equals(IncludeSubFoldersCodes[1])) {
            return IncludeSubFoldersDesc[1];
        }
        return IncludeSubFoldersDesc[0];
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.sourceFileFolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"source_filefolder");
                this.sourceWildcard[i] = XMLHandler.getTagValue((Node)fnode, (String)"wildcard");
                this.sourceIncludeSubfolders[i] = XMLHandler.getTagValue((Node)fnode, (String)"include_subFolders");
            }
            this.resultFilenamesWildcard = XMLHandler.getTagValue((Node)entrynode, (String)"result_filenames_wildcard");
            this.ResultFieldFile = XMLHandler.getTagValue((Node)entrynode, (String)"result_field_file");
            this.ResultFieldWildcard = XMLHandler.getTagValue((Node)entrynode, (String)"result_field_wildcard");
            this.ResultFieldIncludesubFolders = XMLHandler.getTagValue((Node)entrynode, (String)"result_field_includesubfolders");
            this.comparevalue = XMLHandler.getTagValue((Node)entrynode, (String)"comparevalue");
            this.minvalue = XMLHandler.getTagValue((Node)entrynode, (String)"minvalue");
            this.maxvalue = XMLHandler.getTagValue((Node)entrynode, (String)"maxvalue");
            this.successConditionType = JobEntrySimpleEval.getSuccessNumberConditionByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"successnumbercondition"), (String)""));
            this.sourceFiles = JobEntryEvalFilesMetrics.getSourceFilesByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"source_files"), (String)""));
            this.evaluationType = JobEntryEvalFilesMetrics.getEvaluationTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"evaluation_type"), (String)""));
            this.scale = JobEntryEvalFilesMetrics.getScaleByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"scale"), (String)""));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.Exception.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "source_filefolder");
            this.allocate(argnr);
            for (int a = 0; a < argnr; ++a) {
                this.sourceFileFolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "source_filefolder");
                this.sourceWildcard[a] = rep.getJobEntryAttributeString(id_jobentry, a, "wildcard");
                this.sourceIncludeSubfolders[a] = rep.getJobEntryAttributeString(id_jobentry, a, "include_subFolders");
            }
            this.resultFilenamesWildcard = rep.getJobEntryAttributeString(id_jobentry, "result_filenames_wildcard");
            this.ResultFieldFile = rep.getJobEntryAttributeString(id_jobentry, "result_field_file");
            this.ResultFieldWildcard = rep.getJobEntryAttributeString(id_jobentry, "result_field_wild");
            this.ResultFieldIncludesubFolders = rep.getJobEntryAttributeString(id_jobentry, "result_field_includesubfolders");
            this.comparevalue = rep.getJobEntryAttributeString(id_jobentry, "comparevalue");
            this.minvalue = rep.getJobEntryAttributeString(id_jobentry, "minvalue");
            this.maxvalue = rep.getJobEntryAttributeString(id_jobentry, "maxvalue");
            this.successConditionType = JobEntrySimpleEval.getSuccessNumberConditionByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "successnumbercondition"), (String)""));
            this.sourceFiles = JobEntryEvalFilesMetrics.getSourceFilesByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "source_files"), (String)""));
            this.evaluationType = JobEntryEvalFilesMetrics.getEvaluationTypeByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "evaluation_type"), (String)""));
            this.scale = JobEntryEvalFilesMetrics.getScaleByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "scale"), (String)""));
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.Exception.UnableLoadRep", (String[])new String[0]) + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            if (this.sourceFileFolder != null) {
                for (int i = 0; i < this.sourceFileFolder.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "source_filefolder", this.sourceFileFolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "wildcard", this.sourceWildcard[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "include_subFolders", this.sourceIncludeSubfolders[i]);
                }
            }
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "result_filenames_wildcard", this.resultFilenamesWildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "result_field_file", this.ResultFieldFile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "result_field_wild", this.ResultFieldWildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "result_field_includesubfolders", this.ResultFieldIncludesubFolders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "comparevalue", this.comparevalue);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "minvalue", this.minvalue);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "maxvalue", this.maxvalue);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "successnumbercondition", JobEntrySimpleEval.getSuccessNumberConditionCode(this.successConditionType));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "scale", JobEntryEvalFilesMetrics.getScaleCode(this.scale));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "source_files", JobEntryEvalFilesMetrics.getSourceFilesCode(this.sourceFiles));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "evaluation_type", JobEntryEvalFilesMetrics.getEvaluationTypeCode(this.evaluationType));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.Exception.UnableSaveRep", (String[])new String[0]) + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) throws KettleException {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        if (this.parentJobMeta.getNamedClusterEmbedManager() != null) {
            this.parentJobMeta.getNamedClusterEmbedManager().passEmbeddedMetastoreKey(this, this.parentJobMeta.getEmbeddedMetastoreProviderKey());
        }
        try {
            this.initMetrics();
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.Init", (String[])new String[]{e.toString()}));
            return result;
        }
        String[] vsourcefilefolder = this.sourceFileFolder;
        String[] vwildcard = this.sourceWildcard;
        String[] vincludeSubFolders = this.sourceIncludeSubfolders;
        switch (this.getSourceFiles()) {
            case 2: {
                String realResultFieldFile = this.environmentSubstitute(this.getResultFieldFile());
                String realResultFieldWildcard = this.environmentSubstitute(this.getResultFieldWildcard());
                String realResultFieldIncluseSubfolders = this.environmentSubstitute(this.getResultFieldIncludeSubfolders());
                int indexOfResultFieldFile = -1;
                if (Utils.isEmpty((CharSequence)realResultFieldFile)) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.ResultFieldsFileMissing", (String[])new String[0]));
                    return result;
                }
                int indexOfResultFieldWildcard = -1;
                int indexOfResultFieldIncludeSubfolders = -1;
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
                }
                if (rows == null || rows.size() <= 0) break;
                RowMetaAndData firstRow = (RowMetaAndData)rows.get(0);
                indexOfResultFieldFile = firstRow.getRowMeta().indexOfValue(realResultFieldFile);
                if (indexOfResultFieldFile == -1) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.CanNotFindField", (String[])new String[]{realResultFieldFile}));
                    return result;
                }
                if (!Utils.isEmpty((CharSequence)realResultFieldWildcard) && (indexOfResultFieldWildcard = firstRow.getRowMeta().indexOfValue(realResultFieldWildcard)) == -1) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.CanNotFindField", (String[])new String[]{realResultFieldWildcard}));
                    return result;
                }
                if (!Utils.isEmpty((CharSequence)realResultFieldIncluseSubfolders) && (indexOfResultFieldIncludeSubfolders = firstRow.getRowMeta().indexOfValue(realResultFieldIncluseSubfolders)) == -1) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.CanNotFindField", (String[])new String[]{realResultFieldIncluseSubfolders}));
                    return result;
                }
                for (int iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    String vsourcefilefolder_previous = resultRow.getString(indexOfResultFieldFile, null);
                    String vwildcard_previous = null;
                    if (indexOfResultFieldWildcard > -1) {
                        vwildcard_previous = resultRow.getString(indexOfResultFieldWildcard, null);
                    }
                    String vincludeSubFolders_previous = NO;
                    if (indexOfResultFieldIncludeSubfolders > -1) {
                        vincludeSubFolders_previous = resultRow.getString(indexOfResultFieldIncludeSubfolders, NO);
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.ProcessingRow", (String[])new String[]{vsourcefilefolder_previous, vwildcard_previous}));
                    }
                    this.ProcessFileFolder(vsourcefilefolder_previous, vwildcard_previous, vincludeSubFolders_previous, this.parentJob, result);
                }
                break;
            }
            case 1: {
                List resultFiles = result.getResultFilesList();
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.ResultFilenames.Found", (String[])new String[]{(resultFiles != null ? resultFiles.size() : 0) + ""}));
                }
                if (resultFiles == null || resultFiles.size() <= 0) break;
                Pattern pattern = null;
                String realPattern = this.environmentSubstitute(this.getResultFilenamesWildcard());
                if (!Utils.isEmpty((CharSequence)realPattern)) {
                    pattern = Pattern.compile(realPattern);
                }
                Iterator it = resultFiles.iterator();
                while (it.hasNext() && !this.parentJob.isStopped()) {
                    ResultFile resultFile = (ResultFile)it.next();
                    FileObject file = resultFile.getFile();
                    try {
                        if (file == null || !file.exists()) continue;
                        boolean getIt = true;
                        if (pattern != null) {
                            Matcher matcher = pattern.matcher(file.getName().getBaseName());
                            getIt = matcher.matches();
                        }
                        if (!getIt) continue;
                        this.getFileSize(file, result, this.parentJob);
                    }
                    catch (Exception e) {
                        this.incrementErrors();
                        this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.GettingFileFromResultFilenames", (String[])new String[]{file.toString(), e.toString()}));
                    }
                    finally {
                        if (file == null) continue;
                        try {
                            file.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                break;
            }
            default: {
                if (vsourcefilefolder != null && vsourcefilefolder.length > 0) {
                    for (int i = 0; i < vsourcefilefolder.length && !this.parentJob.isStopped(); ++i) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.ProcessingRow", (String[])new String[]{vsourcefilefolder[i], vwildcard[i]}));
                        }
                        this.ProcessFileFolder(vsourcefilefolder[i], vwildcard[i], vincludeSubFolders[i], this.parentJob, result);
                    }
                    break;
                }
                this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.FilesGridEmpty", (String[])new String[0]));
                return result;
            }
        }
        result.setResult(this.isSuccess());
        result.setNrErrors(this.getNrError());
        this.displayResults();
        return result;
    }

    private void displayResults() {
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.Info.FilesCount", (String[])new String[]{String.valueOf(this.getFilesCount())}));
            if (this.evaluationType == 0) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.Info.FilesSize", (String[])new String[]{String.valueOf(this.getEvaluationValue())}));
            }
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.Info.NrErrors", (String[])new String[]{String.valueOf(this.getNrError())}));
            this.logDetailed("=======================================");
        }
    }

    private long getNrError() {
        return this.nrErrors;
    }

    private BigDecimal getEvaluationValue() {
        return this.evaluationValue;
    }

    private BigDecimal getFilesCount() {
        return this.filesCount;
    }

    public int getSuccessConditionType() {
        return this.successConditionType;
    }

    public void setSuccessConditionType(int successConditionType) {
        this.successConditionType = successConditionType;
    }

    private boolean isSuccess() {
        boolean retval = false;
        switch (this.successConditionType) {
            case 0: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.CompareWithValue", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) == 0;
                break;
            }
            case 1: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.CompareWithValue", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) != 0;
                break;
            }
            case 2: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.CompareWithValue", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) < 0;
                break;
            }
            case 3: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.CompareWithValue", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) <= 0;
                break;
            }
            case 4: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.CompareWithValue", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) > 0;
                break;
            }
            case 5: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.CompareWithValue", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) >= 0;
                break;
            }
            case 6: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.CompareWithValues", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.minValue), String.valueOf(this.maxValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.minValue) >= 0 && this.getEvaluationValue().compareTo(this.maxValue) <= 0;
                break;
            }
        }
        return retval;
    }

    private void initMetrics() throws Exception {
        this.evaluationValue = new BigDecimal(0);
        this.filesCount = new BigDecimal(0);
        this.nrErrors = 0L;
        if (this.successConditionType == 6) {
            this.minValue = new BigDecimal(this.environmentSubstitute(this.getMinValue()));
            this.maxValue = new BigDecimal(this.environmentSubstitute(this.getMaxValue()));
        } else {
            this.compareValue = new BigDecimal(this.environmentSubstitute(this.getCompareValue()));
        }
        if (this.evaluationType == 0) {
            int multyply = 1;
            switch (this.getScale()) {
                case 1: {
                    multyply = 1024;
                    break;
                }
                case 2: {
                    multyply = 0x100000;
                    break;
                }
                case 3: {
                    multyply = 0x40000000;
                    break;
                }
            }
            if (this.successConditionType == 6) {
                this.minValue = this.minValue.multiply(BigDecimal.valueOf(multyply));
                this.maxValue = this.maxValue.multiply(BigDecimal.valueOf(multyply));
            } else {
                this.compareValue = this.compareValue.multiply(BigDecimal.valueOf(multyply));
            }
        }
        this.arg_from_previous = this.getSourceFiles() == 2;
    }

    private void incrementErrors() {
        ++this.nrErrors;
    }

    public int getSourceFiles() {
        return this.sourceFiles;
    }

    private void incrementFilesCount() {
        this.filesCount = this.filesCount.add(ONE);
    }

    public String[] getSourceFileFolder() {
        return this.sourceFileFolder;
    }

    public void setSourceFileFolder(String[] sourceFileFolder) {
        this.sourceFileFolder = sourceFileFolder;
    }

    public String[] getSourceWildcard() {
        return this.sourceWildcard;
    }

    public void setSourceWildcard(String[] sourceWildcard) {
        this.sourceWildcard = sourceWildcard;
    }

    public String[] getSourceIncludeSubfolders() {
        return this.sourceIncludeSubfolders;
    }

    public void setSourceIncludeSubfolders(String[] sourceIncludeSubfolders) {
        this.sourceIncludeSubfolders = sourceIncludeSubfolders;
    }

    public void setSourceFiles(int sourceFiles) {
        this.sourceFiles = sourceFiles;
    }

    public String getResultFieldFile() {
        return this.ResultFieldFile;
    }

    public void setResultFieldFile(String field) {
        this.ResultFieldFile = field;
    }

    public String getResultFieldWildcard() {
        return this.ResultFieldWildcard;
    }

    public void setResultFieldWildcard(String field) {
        this.ResultFieldWildcard = field;
    }

    public String getResultFieldIncludeSubfolders() {
        return this.ResultFieldIncludesubFolders;
    }

    public void setResultFieldIncludeSubfolders(String field) {
        this.ResultFieldIncludesubFolders = field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ProcessFileFolder(String sourcefilefoldername, String wildcard, String includeSubfolders, Job parentJob, Result result) {
        FileObject sourcefilefolder = null;
        FileObject CurrentFile = null;
        String realSourceFilefoldername = this.environmentSubstitute(sourcefilefoldername);
        if (Utils.isEmpty((CharSequence)realSourceFilefoldername)) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.log.FileFolderEmpty", (String[])new String[0]));
            this.incrementErrors();
            return;
        }
        String realWildcard = this.environmentSubstitute(wildcard);
        final boolean include_subfolders = YES.equalsIgnoreCase(includeSubfolders);
        try {
            sourcefilefolder = KettleVFS.getFileObject((String)realSourceFilefoldername, (VariableSpace)this);
            if (sourcefilefolder.exists()) {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.FileExists", (String[])new String[]{sourcefilefolder.toString()}));
                }
                if (sourcefilefolder.getType() == FileType.FILE) {
                    this.getFileSize(sourcefilefolder, result, parentJob);
                } else if (sourcefilefolder.getType() == FileType.FOLDER) {
                    FileObject[] fileObjects = sourcefilefolder.findFiles((FileSelector)new AllFileSelector(){

                        public boolean traverseDescendents(FileSelectInfo info) {
                            return info.getDepth() == 0 || include_subfolders;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public boolean includeFile(FileSelectInfo info) {
                            block18: {
                                boolean bl;
                                FileObject fileObject = info.getFile();
                                try {
                                    if (fileObject == null) {
                                        boolean bl2 = false;
                                        return bl2;
                                    }
                                    if (fileObject.getType() == FileType.FILE) break block18;
                                    bl = false;
                                }
                                catch (Exception ex) {
                                    boolean bl3 = false;
                                    return bl3;
                                }
                                finally {
                                    if (fileObject != null) {
                                        try {
                                            fileObject.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                                return bl;
                            }
                            return true;
                        }
                    });
                    if (fileObjects != null) {
                        for (int j = 0; j < fileObjects.length && !parentJob.isStopped(); ++j) {
                            CurrentFile = fileObjects[j];
                            if (!CurrentFile.getParent().toString().equals(sourcefilefolder.toString())) {
                                if (!include_subfolders || !this.GetFileWildcard(CurrentFile.getName().getBaseName(), realWildcard)) continue;
                                this.getFileSize(CurrentFile, result, parentJob);
                                continue;
                            }
                            if (!this.GetFileWildcard(CurrentFile.getName().getBaseName(), realWildcard)) continue;
                            this.getFileSize(CurrentFile, result, parentJob);
                        }
                    }
                } else {
                    this.incrementErrors();
                    this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.UnknowFileFormat", (String[])new String[]{sourcefilefolder.toString()}));
                }
            } else {
                this.incrementErrors();
                this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.SourceFileNotExists", (String[])new String[]{realSourceFilefoldername}));
            }
        }
        catch (Exception e) {
            this.incrementErrors();
            this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.Exception.Processing", (String[])new String[]{realSourceFilefoldername.toString(), e.getMessage()}));
        }
        finally {
            if (sourcefilefolder != null) {
                try {
                    sourcefilefolder.close();
                }
                catch (IOException iOException) {}
            }
            if (CurrentFile != null) {
                try {
                    CurrentFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void getFileSize(FileObject file, Result result, Job parentJob) {
        try {
            this.incrementFilesCount();
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.GetFile", (String[])new String[]{file.toString(), String.valueOf(this.getFilesCount())}));
            }
            switch (this.evaluationType) {
                case 0: {
                    BigDecimal fileSize = BigDecimal.valueOf(file.getContent().getSize());
                    this.evaluationValue = this.evaluationValue.add(fileSize);
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.AddedFileSize", (String[])new String[]{String.valueOf(fileSize), file.toString()}));
                    }
                    break;
                }
                default: {
                    this.evaluationValue = this.evaluationValue.add(ONE);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.incrementErrors();
            this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.GettingFileSize", (String[])new String[]{file.toString(), e.toString()}));
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Utils.isEmpty((CharSequence)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setMinValue(String minvalue) {
        this.minvalue = minvalue;
    }

    public String getMinValue() {
        return this.minvalue;
    }

    public void setCompareValue(String comparevalue) {
        this.comparevalue = comparevalue;
    }

    public String getCompareValue() {
        return this.comparevalue;
    }

    public void setResultFilenamesWildcard(String resultwildcard) {
        this.resultFilenamesWildcard = resultwildcard;
    }

    public String getResultFilenamesWildcard() {
        return this.resultFilenamesWildcard;
    }

    public void setMaxValue(String maxvalue) {
        this.maxvalue = maxvalue;
    }

    public String getMaxValue() {
        return this.maxvalue;
    }

    public static int getScaleByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < scaleDesc.length; ++i) {
            if (!scaleDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntryEvalFilesMetrics.getScaleByCode(tt);
    }

    public static int getSourceFilesByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < SourceFilesDesc.length; ++i) {
            if (!SourceFilesDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntryEvalFilesMetrics.getSourceFilesByCode(tt);
    }

    public static int getEvaluationTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < EvaluationTypeDesc.length; ++i) {
            if (!EvaluationTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntryEvalFilesMetrics.getEvaluationTypeByCode(tt);
    }

    private static int getScaleByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < scaleCodes.length; ++i) {
            if (!scaleCodes[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getSourceFilesByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < SourceFilesCodes.length; ++i) {
            if (!SourceFilesCodes[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getEvaluationTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < EvaluationTypeCodes.length; ++i) {
            if (!EvaluationTypeCodes[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getScaleDesc(int i) {
        if (i < 0 || i >= scaleDesc.length) {
            return scaleDesc[0];
        }
        return scaleDesc[i];
    }

    public static String getEvaluationTypeDesc(int i) {
        if (i < 0 || i >= EvaluationTypeDesc.length) {
            return EvaluationTypeDesc[0];
        }
        return EvaluationTypeDesc[i];
    }

    public static String getSourceFilesDesc(int i) {
        if (i < 0 || i >= SourceFilesDesc.length) {
            return SourceFilesDesc[0];
        }
        return SourceFilesDesc[i];
    }

    public static String getScaleCode(int i) {
        if (i < 0 || i >= scaleCodes.length) {
            return scaleCodes[0];
        }
        return scaleCodes[i];
    }

    public static String getSourceFilesCode(int i) {
        if (i < 0 || i >= SourceFilesCodes.length) {
            return SourceFilesCodes[0];
        }
        return SourceFilesCodes[i];
    }

    public static String getEvaluationTypeCode(int i) {
        if (i < 0 || i >= EvaluationTypeCodes.length) {
            return EvaluationTypeCodes[0];
        }
        return EvaluationTypeCodes[i];
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.sourceFileFolder.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }
}

