/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.vfs.configuration;

import java.io.IOException;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.util.DelegatingFileSystemOptionsBuilder;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.vfs.configuration.IKettleFileSystemConfigBuilder;

public class KettleGenericFileSystemConfigBuilder
extends FileSystemConfigBuilder
implements IKettleFileSystemConfigBuilder {
    private static final KettleGenericFileSystemConfigBuilder builder = new KettleGenericFileSystemConfigBuilder();
    private static final LogChannelInterface log = new LogChannel("cfgbuilder");

    @Override
    public String parseParameterName(String parameter, String scheme) {
        String result = null;
        int begin = parameter.indexOf(".", parameter.indexOf(".") + 1) + 1;
        int end = -1;
        end = parameter.indexOf(46, begin);
        if (end < 0) {
            end = parameter.length();
        }
        if (end > begin) {
            result = parameter.substring(begin, end);
        }
        return result;
    }

    public static KettleGenericFileSystemConfigBuilder getInstance() {
        return builder;
    }

    public static String extractScheme(String fullParameterName) throws IllegalArgumentException {
        int schemeEnd;
        String result = null;
        if (fullParameterName != null && fullParameterName.length() > 4 && fullParameterName.startsWith("vfs.")) {
            schemeEnd = fullParameterName.indexOf(".", 4);
            if (schemeEnd <= 4) {
                throw new IllegalArgumentException("The configuration parameter does not match a valid scheme: " + fullParameterName);
            }
        } else {
            throw new IllegalArgumentException("The configuration parameter does not match a valid scheme: " + fullParameterName);
        }
        result = fullParameterName.substring(4, schemeEnd);
        return result;
    }

    protected KettleGenericFileSystemConfigBuilder() {
    }

    protected Class<? extends FileSystem> getConfigClass() {
        return FileSystem.class;
    }

    @Override
    public void setParameter(FileSystemOptions opts, String name, String value, String fullParameterName, String vfsUrl) throws IOException {
        String scheme = KettleGenericFileSystemConfigBuilder.extractScheme(fullParameterName);
        try {
            DelegatingFileSystemOptionsBuilder delegateFSOptionsBuilder = new DelegatingFileSystemOptionsBuilder(KettleVFS.getInstance().getFileSystemManager());
            if (scheme != null) {
                delegateFSOptionsBuilder.setConfigString(opts, scheme, name, value);
            } else {
                log.logMinimal("Warning: Cannot process VFS parameters if no scheme is specified: " + vfsUrl);
            }
        }
        catch (FileSystemException e) {
            if (e.getCode() != null && e.getCode().equalsIgnoreCase("vfs.provider/config-key-invalid.error")) {
                log.logMinimal("Warning: The configuration parameter [" + name + "] is not supported by the default configuration builder for scheme: " + scheme);
            }
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }
}

