/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;

public class LoggingObject
implements LoggingObjectInterface {
    private String logChannelId;
    private LoggingObjectType objectType;
    private String objectName;
    private String objectCopy;
    private RepositoryDirectoryInterface repositoryDirectory;
    private String filename;
    private ObjectId objectId;
    private ObjectRevision objectRevision;
    private LogLevel logLevel = DefaultLogLevel.getLogLevel();
    private String containerObjectId;
    private LoggingObjectInterface parent;
    private Date registrationDate;
    private boolean gatheringMetrics;
    private boolean forcingSeparateLogging;

    public LoggingObject(Object object) {
        if (object instanceof LoggingObjectInterface) {
            this.grabLoggingObjectInformation((LoggingObjectInterface)object);
        } else {
            this.grabObjectInformation(object);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LoggingObject)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            boolean sameParents;
            boolean sameCarteFamily;
            LoggingObject loggingObject = (LoggingObject)obj;
            boolean bl = sameCarteFamily = this.getContainerObjectId() == null && loggingObject.getContainerObjectId() == null || this.getContainerObjectId() != null && loggingObject.getContainerObjectId() != null && this.getContainerObjectId().equals(loggingObject.getContainerObjectId());
            if (sameCarteFamily && loggingObject.getObjectId() != null && loggingObject.getObjectId().equals(this.getObjectId())) {
                return true;
            }
            boolean bl2 = sameParents = loggingObject.getParent() == null && this.getParent() == null || loggingObject.getParent() != null && this.getParent() != null && loggingObject.getParent().equals(this.getParent());
            if (sameCarteFamily && !Utils.isEmpty(loggingObject.getFilename()) && loggingObject.getFilename().equals(this.getFilename()) && sameParents && StringUtils.equals((String)loggingObject.getObjectName(), (String)this.getObjectName())) {
                return true;
            }
            if (!sameCarteFamily || loggingObject.getObjectName() == null && this.getObjectName() != null || loggingObject.getObjectName() != null && this.getObjectName() == null) {
                return false;
            }
            if (sameCarteFamily && (loggingObject.getObjectName() == null && this.getObjectName() == null || loggingObject.getObjectName().equals(this.getObjectName())) && loggingObject.getObjectType().equals((Object)this.getObjectType())) {
                if (!Utils.isEmpty(this.getObjectCopy()) && !this.getObjectCopy().equals(loggingObject.getObjectCopy())) {
                    return false;
                }
                LoggingObjectInterface parent1 = loggingObject.getParent();
                LoggingObjectInterface parent2 = this.getParent();
                if (parent1 != null && parent2 == null || parent1 == null && parent2 != null) {
                    return false;
                }
                if (parent1 == null && parent2 == null) {
                    return true;
                }
                if (parent1.equals(parent2)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void grabLoggingObjectInformation(LoggingObjectInterface loggingObject) {
        this.objectType = loggingObject.getObjectType();
        this.objectName = loggingObject.getObjectName();
        this.repositoryDirectory = loggingObject.getRepositoryDirectory();
        this.filename = loggingObject.getFilename();
        this.objectId = loggingObject.getObjectId();
        this.objectRevision = loggingObject.getObjectRevision();
        this.objectCopy = loggingObject.getObjectCopy();
        this.logLevel = loggingObject.getLogLevel();
        this.containerObjectId = loggingObject.getContainerObjectId();
        this.forcingSeparateLogging = loggingObject.isForcingSeparateLogging();
        this.gatheringMetrics = loggingObject.isGatheringMetrics();
        if (loggingObject.getParent() != null) {
            this.getParentLoggingObject(loggingObject.getParent());
            this.containerObjectId = loggingObject.getParent().getContainerObjectId();
        }
    }

    private void grabObjectInformation(Object object) {
        this.objectType = LoggingObjectType.GENERAL;
        this.objectName = object.toString();
        this.parent = null;
    }

    private void getParentLoggingObject(Object parentObject) {
        LoggingObject check;
        if (parentObject == null) {
            return;
        }
        if (parentObject instanceof LoggingObjectInterface) {
            LoggingObjectInterface parentLoggingObject;
            this.parent = (LoggingObjectInterface)parentObject;
            if (this.parent.getLogChannelId() != null && (parentLoggingObject = LoggingRegistry.getInstance().getLoggingObject(this.parent.getLogChannelId())) != null) {
                this.parent = parentLoggingObject;
            }
            return;
        }
        LoggingRegistry registry = LoggingRegistry.getInstance();
        LoggingObjectInterface loggingObject = registry.findExistingLoggingSource(check = new LoggingObject(parentObject));
        if (loggingObject == null) {
            String logChannelId = registry.registerLoggingSource(check);
            loggingObject = check;
            check.setLogChannelId(logChannelId);
        }
        this.parent = loggingObject;
    }

    @Override
    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String name) {
        this.objectName = name;
    }

    @Override
    public RepositoryDirectoryInterface getRepositoryDirectory() {
        return this.repositoryDirectory;
    }

    public void setRepositoryDirectory(RepositoryDirectory repositoryDirectory) {
        this.repositoryDirectory = repositoryDirectory;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public ObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(ObjectId objectId) {
        this.objectId = objectId;
    }

    @Override
    public ObjectRevision getObjectRevision() {
        return this.objectRevision;
    }

    public void setObjectRevision(ObjectRevision objectRevision) {
        this.objectRevision = objectRevision;
    }

    @Override
    public String getLogChannelId() {
        return this.logChannelId;
    }

    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    @Override
    public LoggingObjectInterface getParent() {
        return this.parent;
    }

    public void setParent(LoggingObjectInterface parent) {
        this.parent = parent;
    }

    @Override
    public LoggingObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(LoggingObjectType objectType) {
        this.objectType = objectType;
    }

    @Override
    public String getObjectCopy() {
        return this.objectCopy;
    }

    public void setObjectCopy(String objectCopy) {
        this.objectCopy = objectCopy;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public String getContainerObjectId() {
        return this.containerObjectId;
    }

    public void setCarteObjectId(String carteObjectId) {
        this.containerObjectId = carteObjectId;
    }

    @Override
    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Override
    public boolean isGatheringMetrics() {
        return this.gatheringMetrics;
    }

    @Override
    public void setGatheringMetrics(boolean gatheringMetrics) {
        this.gatheringMetrics = gatheringMetrics;
    }

    @Override
    public boolean isForcingSeparateLogging() {
        return this.forcingSeparateLogging;
    }

    @Override
    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        this.forcingSeparateLogging = forcingSeparateLogging;
    }
}

