/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemCompiler;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.Marker;
import net.sf.jasperreports.components.map.MarkerDataset;
import net.sf.jasperreports.components.map.MarkerItemData;
import net.sf.jasperreports.components.map.MarkerProperty;
import net.sf.jasperreports.components.map.StandardMapComponent;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class MapCompiler
implements ComponentCompiler {
    private static final Map<String, String> addressMap = new HashMap<String, String>();

    @Override
    public void collectExpressions(Component component, JRExpressionCollector collector) {
        List<ItemData> list;
        List<ItemData> pathStyleList;
        MapComponent map = (MapComponent)component;
        collector.addExpression(map.getLatitudeExpression());
        collector.addExpression(map.getLongitudeExpression());
        collector.addExpression(map.getAddressExpression());
        collector.addExpression(map.getZoomExpression());
        collector.addExpression(map.getLanguageExpression());
        this.collectExpressions(map.getLegendItem(), collector);
        this.collectExpressions(map.getResetMapItem(), collector);
        List<MarkerItemData> markerItemDataList = map.getMarkerItemDataList();
        if (markerItemDataList != null && markerItemDataList.size() > 0) {
            for (MarkerItemData markerItemData : markerItemDataList) {
                ItemCompiler.collectExpressions(markerItemData, collector);
                collector.addExpression(markerItemData.getSeriesNameExpression());
                collector.addExpression(markerItemData.getMarkerClusteringExpression());
                collector.addExpression(markerItemData.getMarkerSpideringExpression());
                collector.addExpression(markerItemData.getLegendIconExpression());
            }
        }
        if ((pathStyleList = map.getPathStyleList()) != null && pathStyleList.size() > 0) {
            for (ItemData pathStyle : pathStyleList) {
                ItemCompiler.collectExpressions(pathStyle, collector);
            }
        }
        if ((list = map.getPathDataList()) != null && list.size() > 0) {
            for (ItemData pathData : list) {
                ItemCompiler.collectExpressions(pathData, collector);
            }
        }
    }

    protected void collectExpressions(Item item, JRExpressionCollector collector) {
        List<ItemProperty> itemProperties;
        if (item != null && (itemProperties = item.getProperties()) != null) {
            for (ItemProperty property : itemProperties) {
                collector.addExpression(property.getValueExpression());
            }
        }
    }

    public static void collectExpressions(ItemData data, JRExpressionCollector collector) {
        ItemCompiler.collectExpressions(data, collector);
    }

    public static void collectExpressions(MarkerDataset dataset, JRExpressionCollector collector) {
        if (dataset != null) {
            List<Marker> markers;
            JRExpressionCollector datasetCollector = collector;
            JRDatasetRun datasetRun = dataset.getDatasetRun();
            if (datasetRun != null) {
                collector.collect(datasetRun);
                datasetCollector = collector.getDatasetCollector(datasetRun.getDatasetName());
            }
            if ((markers = dataset.getMarkers()) != null && !markers.isEmpty()) {
                for (Marker marker : markers) {
                    List<MarkerProperty> markerProperties = marker.getProperties();
                    if (markerProperties == null) continue;
                    for (MarkerProperty property : markerProperties) {
                        datasetCollector.addExpression(property.getValueExpression());
                    }
                }
            }
        }
    }

    @Override
    public Component toCompiledComponent(Component component, JRBaseObjectFactory baseFactory) {
        MapComponent map = (MapComponent)component;
        return new StandardMapComponent(map, baseFactory);
    }

    @Override
    public void verify(Component component, JRVerifier verifier) {
        List<ItemData> list;
        List<ItemData> pathStyleList;
        MapComponent map = (MapComponent)component;
        EvaluationTimeEnum evaluationTime = map.getEvaluationTime();
        if (evaluationTime == EvaluationTimeEnum.AUTO) {
            verifier.addBrokenRule("Auto evaluation time is not supported for maps", (Object)map);
        } else if (evaluationTime == EvaluationTimeEnum.GROUP) {
            String evaluationGroup = map.getEvaluationGroup();
            if (evaluationGroup == null || evaluationGroup.length() == 0) {
                verifier.addBrokenRule("No evaluation group set for map", (Object)map);
            } else if (!verifier.getReportDesign().getGroupsMap().containsKey(evaluationGroup)) {
                verifier.addBrokenRule("Map evaluation group \"" + evaluationGroup + " not found", (Object)map);
            }
        }
        if ((map.getLatitudeExpression() == null || map.getLongitudeExpression() == null) && map.getAddressExpression() == null) {
            verifier.addBrokenRule("Missing the latitude and/or the longitude expression for the map center. Try to configure them properly, or configure the equivalent addressExpression for this map.", (Object)map);
        }
        String[] reqNames = new String[]{"latitude", "longitude"};
        List<MarkerItemData> markerItemDataList = map.getMarkerItemDataList();
        if (markerItemDataList != null && markerItemDataList.size() > 0) {
            for (ItemData itemData : markerItemDataList) {
                ItemCompiler.verifyItemData(verifier, itemData, "markerData", reqNames, addressMap);
            }
        }
        if ((pathStyleList = map.getPathStyleList()) != null && pathStyleList.size() > 0) {
            for (ItemData pathStyle : pathStyleList) {
                ItemCompiler.verifyItemData(verifier, pathStyle, "pathStyle", new String[]{"name"}, null);
            }
        }
        if ((list = map.getPathDataList()) != null && list.size() > 0) {
            for (ItemData pathData : list) {
                ItemCompiler.verifyItemData(verifier, pathData, "pathData", reqNames, addressMap);
            }
        }
    }

    static {
        addressMap.put("latitude", "address");
        addressMap.put("longitude", "address");
    }
}

