/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.ResultSetVector;
import org.dbforms.taglib.EmbeddedData;
import org.dbforms.util.StringUtil;

public class TableData
extends EmbeddedData
implements TryCatchFinally {
    private static Log logCat = LogFactory.getLog((String)TableData.class.getName());
    private String foreignTable;
    private String orderBy;
    private String storeField;
    private String visibleFields;

    public void setForeignTable(String foreignTable) {
        this.foreignTable = foreignTable;
    }

    public String getForeignTable() {
        return this.foreignTable;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        logCat.info((Object)("setOrderBy(\"" + orderBy + "\")"));
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setStoreField(String storeField) {
        this.storeField = storeField;
    }

    public String getStoreField() {
        return this.storeField;
    }

    public void setVisibleFields(String visibleFields) {
        this.visibleFields = visibleFields;
    }

    public String getVisibleFields() {
        return this.visibleFields;
    }

    @Override
    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    @Override
    public void doFinally() {
        this.foreignTable = null;
        this.visibleFields = null;
        this.storeField = null;
        this.orderBy = null;
        super.doFinally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List fetchData(Connection con) throws SQLException {
        Vector vf = StringUtil.splitString(this.visibleFields, ",;~");
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("SELECT ");
        queryBuf.append(this.storeField);
        queryBuf.append(", ");
        for (int i = 0; i < vf.size(); ++i) {
            queryBuf.append((String)vf.elementAt(i));
            if (i >= vf.size() - 1) continue;
            queryBuf.append(", ");
        }
        queryBuf.append(" FROM ");
        queryBuf.append(this.foreignTable);
        if (this.orderBy != null) {
            queryBuf.append(" ORDER BY ");
            queryBuf.append(this.orderBy);
        }
        logCat.info((Object)("about to execute:" + queryBuf.toString()));
        ResultSetVector rsv = null;
        try (PreparedStatement ps = con.prepareStatement(queryBuf.toString());){
            rsv = new ResultSetVector();
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            DbEventInterceptorData data = new DbEventInterceptorData(request, this.getConfig(), con, null);
            data.setAttribute("pageContext", this.pageContext);
            rsv.addResultSet(data, ps.executeQuery());
        }
        return this.formatEmbeddedResultRows(rsv);
    }
}

