/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.servlets;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.Field;
import org.dbforms.config.Table;
import org.dbforms.util.FileHolder;
import org.dbforms.util.SqlUtil;
import org.dbforms.util.StringUtil;
import org.dbforms.util.Util;

public class FileServlet
extends HttpServlet {
    private static Log logCat = LogFactory.getLog((String)FileServlet.class.getName());

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DbFormsConfig config = null;
        try {
            config = DbFormsConfigRegistry.instance().lookup();
        }
        catch (Exception e) {
            logCat.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        try {
            String tf = request.getParameter("tf");
            String keyValuesStr = request.getParameter("keyval");
            if (!Util.isNull(keyValuesStr) && !"null".equals(keyValuesStr)) {
                int tableId = Integer.parseInt(StringUtil.getEmbeddedString(tf, 0, '_'));
                Table table = config.getTable(tableId);
                int fieldId = Integer.parseInt(StringUtil.getEmbeddedString(tf, 1, '_'));
                Field field = table.getField(fieldId);
                StringBuffer queryBuf = new StringBuffer();
                String dbConnectionName = request.getParameter("invname_" + tableId);
                Connection con = config.getConnection(dbConnectionName);
                String nameField = request.getParameter("nf");
                InputStream is = null;
                String fileName = null;
                queryBuf.append("SELECT ");
                queryBuf.append(field.getName());
                if (nameField != null) {
                    queryBuf.append(", ");
                    queryBuf.append(nameField);
                }
                queryBuf.append(" FROM ");
                queryBuf.append(table.getName());
                queryBuf.append(" WHERE ");
                queryBuf.append(table.getWhereClauseForKeyFields());
                logCat.info((Object)("::doGet - query is [" + queryBuf + "]"));
                PreparedStatement ps = con.prepareStatement(queryBuf.toString());
                table.populateWhereClauseWithKeyFields(keyValuesStr, ps, 1);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    if (field.getType() == 4200) {
                        fileName = rs.getString(1);
                        is = SqlUtil.readDiskBlob(fileName, field.getDirectory(), request.getParameter("defaultValue"));
                    } else if (field.getType() == 2004) {
                        if (nameField != null) {
                            fileName = rs.getString(2);
                            is = SqlUtil.readDbFieldBlob(rs);
                        } else {
                            FileHolder fh = SqlUtil.readFileHolderBlob(rs);
                            is = fh.getInputStreamFromBuffer();
                            fileName = fh.getFileName();
                        }
                    }
                } else {
                    logCat.info((Object)("::doGet - we have got no result using query " + queryBuf));
                }
                if (is != null) {
                    this.writeToClient(request, response, fileName, is);
                }
                SqlUtil.closeConnection(con);
            }
        }
        catch (SQLException sqle) {
            logCat.error((Object)"::doGet - SQL exception", (Throwable)sqle);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void writeToClient(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream is) throws IOException {
        int read;
        String contentType = request.getSession().getServletContext().getMimeType(fileName);
        logCat.info((Object)("::writeToClient- writing to client:" + fileName + " ct=" + contentType));
        if (!Util.isNull(contentType)) {
            response.setContentType(contentType);
        }
        response.setHeader("Cache-control", "private");
        response.setHeader("Content-Disposition", "attachment; fileName=\"" + fileName + "\"");
        ServletOutputStream out = response.getOutputStream();
        byte[] b = new byte[1024];
        while ((read = is.read(b)) != -1) {
            out.write(b, 0, read);
        }
        out.close();
    }
}

