/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.conprovider;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.dbforms.conprovider.ConnectionProvider;
import org.dbforms.conprovider.SingleConnectionWrapper;

public class SinglePerThreadConnectionProvider
extends ConnectionProvider {
    private static final ThreadLocal singlePerThread = new ThreadLocal();

    @Override
    protected synchronized Connection getConnection() throws SQLException {
        Connection con = (Connection)singlePerThread.get();
        if (con == null) {
            Properties props = this.getPrefs().getProperties();
            if (props != null && !props.isEmpty()) {
                props.put("user", this.getPrefs().getUser());
                props.put("password", this.getPrefs().getPassword());
                con = DriverManager.getConnection(this.getPrefs().getJdbcURL(), props);
            } else {
                con = DriverManager.getConnection(this.getPrefs().getJdbcURL(), this.getPrefs().getUser(), this.getPrefs().getPassword());
            }
            singlePerThread.set(con);
        }
        return new SingleConnectionWrapper(con);
    }

    @Override
    protected void init() throws Exception {
        Class.forName(this.getPrefs().getJdbcDriver()).newInstance();
    }
}

