/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

import java.io.Serializable;
import org.apache.commons.math.util.DoubleArray;

public class ResizableDoubleArray
implements DoubleArray,
Serializable {
    private static final long serialVersionUID = -3485529955529426875L;
    public static final int ADDITIVE_MODE = 1;
    public static final int MULTIPLICATIVE_MODE = 0;
    protected float contractionCriteria = 2.5f;
    protected float expansionFactor = 2.0f;
    protected int expansionMode = 0;
    protected int initialCapacity = 16;
    protected double[] internalArray;
    protected int numElements = 0;
    protected int startIndex = 0;

    public ResizableDoubleArray() {
        this.internalArray = new double[this.initialCapacity];
    }

    public ResizableDoubleArray(int initialCapacity) {
        this.setInitialCapacity(initialCapacity);
        this.internalArray = new double[this.initialCapacity];
    }

    public ResizableDoubleArray(int initialCapacity, float expansionFactor) {
        this.expansionFactor = expansionFactor;
        this.setInitialCapacity(initialCapacity);
        this.internalArray = new double[initialCapacity];
        this.setContractionCriteria(expansionFactor + 0.5f);
    }

    public ResizableDoubleArray(int initialCapacity, float expansionFactor, float contractionCriteria) {
        this.expansionFactor = expansionFactor;
        this.setContractionCriteria(contractionCriteria);
        this.setInitialCapacity(initialCapacity);
        this.internalArray = new double[initialCapacity];
    }

    public ResizableDoubleArray(int initialCapacity, float expansionFactor, float contractionCriteria, int expansionMode) {
        this.expansionFactor = expansionFactor;
        this.setContractionCriteria(contractionCriteria);
        this.setInitialCapacity(initialCapacity);
        this.setExpansionMode(expansionMode);
        this.internalArray = new double[initialCapacity];
    }

    public synchronized void addElement(double value) {
        ++this.numElements;
        if (this.startIndex + this.numElements > this.internalArray.length) {
            this.expand();
        }
        this.internalArray[this.startIndex + (this.numElements - 1)] = value;
        if (this.shouldContract()) {
            this.contract();
        }
    }

    public synchronized double addElementRolling(double value) {
        double discarded = this.internalArray[this.startIndex];
        if (this.startIndex + (this.numElements + 1) > this.internalArray.length) {
            this.expand();
        }
        ++this.startIndex;
        this.internalArray[this.startIndex + (this.numElements - 1)] = value;
        if (this.shouldContract()) {
            this.contract();
        }
        return discarded;
    }

    protected void checkContractExpand(float contractionCritera, float expansionFactor) {
        if (contractionCritera < expansionFactor) {
            String msg = "Contraction criteria can never be smaller than the expansion factor.  This would lead to a never ending loop of expansion and contraction as a newly expanded internal storage array would immediately satisfy the criteria for contraction";
            throw new IllegalArgumentException(msg);
        }
        if ((double)this.contractionCriteria <= 1.0) {
            String msg = "The contraction criteria must be a number larger than one.  If the contractionCriteria is less than or equal to one an endless loop of contraction and expansion would ensue as an internalArray.length == numElements would satisfy the contraction criteria";
            throw new IllegalArgumentException(msg);
        }
        if ((double)expansionFactor <= 1.0) {
            String msg = "The expansion factor must be a number greater than 1.0";
            throw new IllegalArgumentException(msg);
        }
    }

    public synchronized void clear() {
        this.numElements = 0;
        this.internalArray = new double[this.initialCapacity];
    }

    public synchronized void contract() {
        double[] tempArray = new double[this.numElements + 1];
        System.arraycopy(this.internalArray, this.startIndex, tempArray, 0, this.numElements);
        this.internalArray = tempArray;
        this.startIndex = 0;
    }

    public synchronized void discardFrontElements(int i) {
        if (i > this.numElements) {
            String msg = "Cannot discard more elements than arecontained in this array.";
            throw new IllegalArgumentException(msg);
        }
        if (i < 0) {
            String msg = "Cannot discard a negative number of elements.";
            throw new IllegalArgumentException(msg);
        }
        this.numElements -= i;
        this.startIndex += i;
        if (this.shouldContract()) {
            this.contract();
        }
    }

    protected synchronized void expand() {
        int newSize = 0;
        newSize = this.expansionMode == 0 ? (int)Math.ceil((float)this.internalArray.length * this.expansionFactor) : this.internalArray.length + Math.round(this.expansionFactor);
        double[] tempArray = new double[newSize];
        System.arraycopy(this.internalArray, 0, tempArray, 0, this.internalArray.length);
        this.internalArray = tempArray;
    }

    private synchronized void expandTo(int size) {
        double[] tempArray = new double[size];
        System.arraycopy(this.internalArray, 0, tempArray, 0, this.internalArray.length);
        this.internalArray = tempArray;
    }

    public float getContractionCriteria() {
        return this.contractionCriteria;
    }

    public synchronized double getElement(int index) {
        if (index >= this.numElements) {
            String msg = "The index specified: " + index + " is larger than the current number of elements";
            throw new ArrayIndexOutOfBoundsException(msg);
        }
        if (index >= 0) {
            return this.internalArray[this.startIndex + index];
        }
        String msg = "Elements cannot be retrieved from a negative array index";
        throw new ArrayIndexOutOfBoundsException(msg);
    }

    public synchronized double[] getElements() {
        double[] elementArray = new double[this.numElements];
        System.arraycopy(this.internalArray, this.startIndex, elementArray, 0, this.numElements);
        return elementArray;
    }

    public float getExpansionFactor() {
        return this.expansionFactor;
    }

    public int getExpansionMode() {
        return this.expansionMode;
    }

    synchronized int getInternalLength() {
        return this.internalArray.length;
    }

    public synchronized int getNumElements() {
        return this.numElements;
    }

    public synchronized double[] getValues() {
        return this.internalArray;
    }

    public void setContractionCriteria(float contractionCriteria) {
        this.checkContractExpand(contractionCriteria, this.getExpansionFactor());
        this.contractionCriteria = contractionCriteria;
    }

    public synchronized void setElement(int index, double value) {
        if (index < 0) {
            String msg = "Cannot set an element at a negative index";
            throw new ArrayIndexOutOfBoundsException(msg);
        }
        if (index + 1 > this.numElements) {
            this.numElements = index + 1;
        }
        if (this.startIndex + index >= this.internalArray.length) {
            this.expandTo(this.startIndex + (index + 1));
        }
        this.internalArray[this.startIndex + index] = value;
    }

    public void setExpansionFactor(float expansionFactor) {
        this.checkContractExpand(this.getContractionCriteria(), expansionFactor);
        this.expansionFactor = expansionFactor;
    }

    public void setExpansionMode(int expansionMode) {
        if (expansionMode != 0 && expansionMode != 1) {
            throw new IllegalArgumentException("Illegal expansionMode setting.");
        }
        this.expansionMode = expansionMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInitialCapacity(int initialCapacity) {
        if (initialCapacity > 0) {
            ResizableDoubleArray resizableDoubleArray = this;
            synchronized (resizableDoubleArray) {
                this.initialCapacity = initialCapacity;
            }
        } else {
            String msg = "The initial capacity supplied: " + initialCapacity + "must be a positive integer";
            throw new IllegalArgumentException(msg);
        }
    }

    public synchronized void setNumElements(int i) {
        if (i < 0) {
            String msg = "Number of elements must be zero or a positive integer";
            throw new IllegalArgumentException(msg);
        }
        if (this.startIndex + i > this.internalArray.length) {
            this.expandTo(this.startIndex + i);
        }
        this.numElements = i;
    }

    private synchronized boolean shouldContract() {
        if (this.expansionMode == 0) {
            return (float)this.internalArray.length / (float)this.numElements > this.contractionCriteria;
        }
        return (float)(this.internalArray.length - this.numElements) > this.contractionCriteria;
    }

    public synchronized int start() {
        return this.startIndex;
    }
}

