/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.baseobjects.NamedObjectI;
import de.memtext.baseobjects.coll.IdObjectCollection;
import de.memtext.baseobjects.coll.NamedIdObjectSet;
import de.memtext.rights.NewPasswordChecker;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.DSAHandler;
import de.memtext.util.DateUtils;
import de.memtext.util.LogUtils;
import de.memtext.util.MemoryUtils;
import de.memtext.util.StringUtils;
import de.superx.common.AbstractSicht;
import de.superx.common.DBServletException;
import de.superx.common.GraphicFormat;
import de.superx.common.MacroFieldSelection;
import de.superx.common.Maske;
import de.superx.common.RepositoryItemCollection;
import de.superx.common.SichtException;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxUser;
import de.superx.common.TemplateProcessor;
import de.superx.common.TranslationContainer;
import de.superx.servlet.FieldElementCache;
import de.superx.servlet.ServletTemplateProcessor;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import de.superx.servlet.UserInitializer;
import de.superx.util.PropsReader;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class SxPool
extends GenericObjectPool
implements NamedObjectI {
    private String name;
    private int dummy = 0;
    private int finRightVariant = 0;
    private boolean isErweitertesProtokollWanted = false;
    private static boolean isPwLogWanted = false;
    private int passwortG\u00fcltigkeit = 0;
    private Properties props = new Properties();
    private static boolean isDebugLogsWanted;
    private FieldElementCache fieldElementCache = new FieldElementCache();
    private IdObjectCollection graphicformats = new IdObjectCollection();
    private IdObjectCollection translations = new IdObjectCollection();
    private Collection makroFieldSelections = new LinkedList();
    public NamedIdObjectSet userpool = new NamedIdObjectSet();
    private NamedIdObjectSet maskenpool = new NamedIdObjectSet();
    private ServletTemplateProcessor templateProcessor;
    private HashMap repositoryMap = new HashMap();
    private String privateKeyEncoded = null;
    private String publicKeyEncoded = null;
    private boolean isRestrictedConnection = false;
    private DSAHandler dsaHandler;
    private NewPasswordChecker newPasswordChecker;
    private boolean is0FINJoker = true;
    private String excelVorlage;
    private boolean hasCustomPdfFile = false;

    SxPool(String name) throws SQLException, IOException, DBServletException {
        this.setName(name);
        try {
            this.readPropertiesAndUrl();
            System.out.print(" (" + this.props.getProperty("connectionURL") + ") ..");
        }
        catch (Exception e2) {
            System.out.println("Konnte properties / Passwort nicht lesen. " + e2);
            e2.printStackTrace();
            throw new DBServletException("Konnte properties / Passwort nicht lesen. " + e2);
        }
        this.templateProcessor = new ServletTemplateProcessor(name);
        try {
            Class.forName(this.props.getProperty("driverName"));
        }
        catch (ClassNotFoundException e1) {
            throw new DBServletException("Treiber " + this.props.getProperty("driverName") + " nicht gefunden. Ggfs. nach tomcat/common/lib kopieren.");
        }
        this.initLogging(true);
        this.setTestOnBorrow(true);
        String devMode = this.props.getProperty("developmentMode");
        SuperXManager.isDevelopmentMode = devMode == null || devMode.equals("true");
        int minIdle = 5;
        if (this.props.getProperty("minIdle") != null && !this.props.getProperty("minIdle").trim().equals("")) {
            minIdle = Integer.parseInt(this.props.getProperty("minIdle"));
        }
        this.setMinIdle(minIdle);
        int maxIdle = -1;
        if (this.props.getProperty("maxIdle") != null && !this.props.getProperty("maxIdle").trim().equals("")) {
            maxIdle = Integer.parseInt(this.props.getProperty("maxIdle"));
        }
        if (maxIdle != -1) {
            this.setMaxIdle(maxIdle);
        }
        int maxActive = -1;
        if (this.props.getProperty("maxActive") != null && !this.props.getProperty("maxActive").trim().equals("")) {
            maxActive = Integer.parseInt(this.props.getProperty("maxActive"));
        }
        this.setMaxActive(maxActive);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.props.getProperty("connectionURL"), this.props);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)this, null, "select count(*) from xdummy;", false, true);
        try {
            Class.forName("org.apache.commons.dbcp.PoolingDriver");
        }
        catch (ClassNotFoundException e2) {
            throw new DBServletException("ConnectionPool Klasse org.apache.commons.dbcp.PoolingDriver nicht gefunden.\ncommons-dbcp nach tomcat/common/lib stellen.");
        }
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.registerPool(this.getName(), (ObjectPool)this);
        ObjectPool x = driver.getConnectionPool(this.getName());
        try {
            this.initFromDB();
        }
        catch (SQLException e3) {
            String msg = "Fehler beim Aufbau des ConnectionPools ";
            if (!this.getName().equals("default")) {
                msg = String.valueOf(msg) + " f\u00fcr Mandant: " + this.getName();
            }
            msg = String.valueOf(msg) + "\nKonnte keine Connection aus dem Pool holen.\n" + e3;
            throw new SQLException(msg);
        }
        if (this.privateKeyEncoded != null) {
            this.initDSAHandler();
        }
    }

    private void setKernMaskHtmlXsl(Statement st) throws SQLException {
        int count = 0;
        ResultSet rs = st.executeQuery("select count(*) from konstanten where beschreibung='KernMaskHtmlXsl' ");
        while (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        if (count == 0) {
            rs = st.executeQuery("select max(tid) from konstanten");
            int newtid = 999;
            while (rs.next()) {
                newtid = rs.getInt(1);
            }
            rs.close();
            st.executeUpdate("insert into konstanten (tid,beschreibung,apnr) values (" + ++newtid + ", 'KernMaskHtmlXsl',0)");
        }
        int tablehtml = 1;
        if (!SuperXManager.defaultMaskXsl.equals("maske_html.xsl")) {
            tablehtml = 2;
        }
        st.executeUpdate("update konstanten set apnr=" + tablehtml + " where beschreibung='KernMaskHtmlXsl' ");
    }

    private void initHeaderFooterDB() throws SQLException {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("select id from sx_repository where art='HEADER_FOOTER'");
        HashMap<String, String> ids = new HashMap<String, String>();
        while (rs.next()) {
            String id = rs.getString(1);
            ids.put(id.trim(), "found");
        }
        rs.close();
        rs = stmt.executeQuery("select max(tid) from sx_repository ");
        int tid = 0;
        while (rs.next()) {
            tid = rs.getInt(1) + 1;
        }
        PreparedStatement pst = con.prepareStatement("insert into sx_repository(tid,id,caption,sachgebiete_id,art,aktiv,gueltig_seit,gueltig_bis)\tvalues (?,?,?,0,'HEADER_FOOTER',1,date_val('1.1.1900'),date_val('1.1.3000'))");
        if (!ids.containsKey("HTML_HEADER")) {
            pst.setInt(1, tid++);
            pst.setString(2, "HTML_HEADER");
            pst.setString(3, "HTML Kopfzeile");
            pst.execute();
        }
        if (!ids.containsKey("HTML_FOOTER")) {
            pst.setInt(1, tid++);
            pst.setString(2, "HTML_FOOTER");
            pst.setString(3, "HTML Fu\u00dfzeile");
            pst.execute();
        }
        if (!ids.containsKey("CUSTOM_PDF")) {
            pst.setInt(1, tid++);
            pst.setString(2, "CUSTOM_PDF");
            pst.setString(3, "individuelle PDF Anpassung");
            pst.execute();
        }
        if (this.getDatabaseAbbr().equals("PG")) {
            stmt.executeQuery("select sp_update_sequence('sx_repository')");
        }
        stmt.close();
    }

    private void initFromDB() throws SQLException {
        Connection con = this.getConnection();
        Statement st = con.createStatement();
        this.setKernMaskHtmlXsl(st);
        ResultSet rs = st.executeQuery("select content from sx_repository where id='privatekey'");
        while (rs.next()) {
            this.privateKeyEncoded = rs.getString(1);
        }
        rs.close();
        rs = st.executeQuery("select content from sx_repository where id='publickey'");
        while (rs.next()) {
            this.publicKeyEncoded = rs.getString(1);
        }
        rs.close();
        rs = st.executeQuery("select apnr from konstanten where beschreibung='Passwortg\u00fcltigkeit (Tage)'");
        while (rs.next()) {
            this.passwortG\u00fcltigkeit = rs.getInt(1);
        }
        rs.close();
        rs = st.executeQuery("select apnr from konstanten where beschreibung='Passwort Gro\u00df- u. Kleinb.'");
        int gro\u00dfklein = 0;
        while (rs.next()) {
            gro\u00dfklein = rs.getInt(1);
        }
        rs.close();
        int ziffern\u00f6tig = 0;
        rs = st.executeQuery("select apnr from konstanten where beschreibung='Passwort erfordert Ziffer'");
        while (rs.next()) {
            ziffern\u00f6tig = rs.getInt(1);
        }
        rs.close();
        rs = st.executeQuery("select apnr from konstanten where beschreibung='Passwortl\u00e4nge (Minimum)'");
        int minL\u00e4nge = 0;
        while (rs.next()) {
            minL\u00e4nge = rs.getInt(1);
        }
        rs.close();
        this.newPasswordChecker = new NewPasswordChecker(minL\u00e4nge, gro\u00dfklein, ziffern\u00f6tig);
        rs = st.executeQuery("select apnr from konstanten where beschreibung='Erweitertes Protokoll'");
        int loginP = 0;
        while (rs.next()) {
            loginP = rs.getInt(1);
        }
        rs.close();
        this.isErweitertesProtokollWanted = loginP == 1;
        st.close();
        con.close();
    }

    public int getPasswortG\u00fcltigkeit() {
        return this.passwortG\u00fcltigkeit;
    }

    public boolean isErweitertesProtokollWanted() {
        return this.isErweitertesProtokollWanted;
    }

    private void initLogging(boolean append) throws IOException {
        String msg;
        LogUtils.initRawFile("superx_" + this.getName(), String.valueOf(SxPool.getLogDir()) + "/superx_" + this.name + ".log", 20000, 1, true, true);
        LogUtils.initRawFile("superx_" + this.getName() + "_xml", String.valueOf(SxPool.getLogDir()) + "/superx_" + this.name + "_xml.log", 20000, 1, true, true);
        Level lev = Level.SEVERE;
        try {
            if (this.props.getProperty("logLevelSQL") != null) {
                lev = Level.parse(this.props.getProperty("logLevelSQL"));
            }
        }
        catch (IllegalArgumentException e2) {
            msg = "Ung\u00fcltiger Level f\u00fcr sqlLogger ";
            if (!this.getName().equals("default")) {
                msg = String.valueOf(msg) + "(Mandant :" + this.getName() + ") ";
            }
            msg = String.valueOf(msg) + " :" + this.props.getProperty("logLevelSQL");
            System.out.println(msg);
        }
        Logger.getLogger("superx_" + this.getName()).setLevel(lev);
        lev = Level.SEVERE;
        try {
            if (this.props.getProperty("logLevelXML") != null) {
                lev = Level.parse(this.props.getProperty("logLevelXML"));
            }
        }
        catch (IllegalArgumentException e3) {
            msg = "Ung\u00fcltiger Level f\u00fcr XMLLogger ";
            if (!this.getName().equals("default")) {
                msg = String.valueOf(msg) + "(Mandant :" + this.getName() + ") ";
            }
            msg = String.valueOf(msg) + " :" + this.props.getProperty("logLevelXML");
            System.out.println(msg);
        }
        Logger.getLogger("superx_" + this.getName() + "_xml").setLevel(lev);
    }

    private static boolean logsExists(String base) {
        return new File(String.valueOf(base) + File.separator + "logs").exists();
    }

    public static String getLogDir() {
        String base = System.getProperty("catalina.base");
        if (base == null || !SxPool.logsExists(base)) {
            base = System.getProperty("catalina.home");
        }
        if (base == null || !SxPool.logsExists(base)) {
            base = System.getProperty("tomcat.home");
        }
        if (base == null || !SxPool.logsExists(base)) {
            base = String.valueOf(File.separator) + "home" + File.separator + "superx" + File.separator + "webserver" + File.separator + "tomcat";
        }
        String targetDir = "";
        targetDir = String.valueOf(base) + File.separator + "logs";
        return targetDir;
    }

    private void readPropertiesAndUrl() throws Exception {
        String propname = "db_" + this.getName() + ".properties";
        if (this.getName().equals("default")) {
            propname = "db.properties";
        }
        this.props = PropsReader.prepareProps(new File(String.valueOf(SuperXManager.getWEB_INFPfad()) + File.separator + propname));
        if (this.props.getProperty("restrictedConnectionName") != null && !this.props.getProperty("restrictedConnectionName").trim().equals("") && this.props.getProperty("restrictedConnectionPassword") != null && !this.props.getProperty("restrictedConnectionPassword").trim().equals("")) {
            this.props.put("user", this.props.getProperty("restrictedConnectionName"));
            this.props.put("password", PropsReader.check(this.props.getProperty("restrictedConnectionPassword")));
            this.isRestrictedConnection = true;
        } else {
            this.props.put("user", this.props.getProperty("connectionName"));
            this.props.put("password", PropsReader.check(this.props.getProperty("connectionPassword")));
        }
    }

    public String getSqlDialect() {
        String result = "Informix";
        if (this.props.getProperty("driverName").indexOf("postgres") > -1) {
            result = "Postgres";
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void close() throws SQLException {
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.closePool(this.getName());
        this.closeLoggers();
    }

    private void closeLoggers() {
        int i2 = 0;
        while (i2 < Logger.getLogger("superx_" + this.name).getHandlers().length) {
            Logger.getLogger("superx_" + this.name).getHandlers()[i2].close();
            ++i2;
        }
        i2 = 0;
        while (i2 < Logger.getLogger("superx_" + this.name + "_xml").getHandlers().length) {
            Logger.getLogger("superx_" + this.name + "_xml").getHandlers()[i2].close();
            ++i2;
        }
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:" + this.getName());
    }

    public boolean hasMaske(Integer tid) {
        return this.maskenpool.containsItemWithId(tid);
    }

    public Maske getMaskenclone(Integer tid) throws CloneNotSupportedException {
        return (Maske)((Maske)this.maskenpool.getById(tid)).clone();
    }

    private void clearAll() {
        this.graphicformats.clear();
        this.translations.clear();
        this.makroFieldSelections.clear();
        for (SxUser sxUser : this.userpool) {
        }
        this.userpool.clear();
    }

    private void initTranslations() throws SQLException, DBServletException {
        this.translations = new IdObjectCollection();
        SxResultSet rs = ServletUtils.execute("Einlesen von \u00dcbersetzungen", "select distinct id from sx_captions where id is not null", this.getName());
        for (SxResultRow row : rs) {
            Object id = row.get(0);
            this.translations.add(new TranslationContainer(this.getName(), id));
        }
    }

    private void initRepository() throws SQLException, DBServletException {
        this.repositoryMap.clear();
        SxResultSet rs = ServletUtils.execute("Einlesen von Sx_repository Eintr\u00e4gen", "select trim(both from id) as id,caption,content,gueltig_seit,gueltig_bis,comment,sort1,sort2,sort3 from sx_repository where aktiv=1", this.getName());
        TemplateProcessor.repositoryToMap(rs, this.repositoryMap);
        rs = ServletUtils.execute("Einlesen von hochschulinfo f\u00fcr repository", "select name,adresse,hs_nr,kapitel from hochschulinfo", this.getName());
        for (SxResultRow zeile : rs) {
            this.repositoryMap.put("K_Name", zeile.get(0));
            this.repositoryMap.put("K_Adresse", zeile.get(1));
            this.repositoryMap.put("K_hs_nr", zeile.get(2));
            this.repositoryMap.put("K_Kapitel", zeile.get(3));
        }
        rs = ServletUtils.execute("Einlesen von konstanten f\u00fcr repository", "select trim(beschreibung),apnr from konstanten", this.getName());
        for (SxResultRow row : rs) {
            String beschreibung = (String)row.get(0);
            this.repositoryMap.put("K_" + beschreibung, row.get(1));
        }
    }

    public String localize(StringBuffer text, Locale l2) {
        return this.localize(text.toString(), l2);
    }

    public String localize(String text, Locale l2) {
        for (TranslationContainer tc : this.translations) {
            if (text.indexOf("@@@" + tc.getId() + "@@@") <= -1) continue;
            text = text.replaceAll("@@@" + tc.getId() + "@@@", tc.getContentsLong(l2));
        }
        for (TranslationContainer tc : this.translations) {
            if (text.indexOf("@@" + tc.getId() + "@@") <= -1) continue;
            text = text.replaceAll("@@" + tc.getId() + "@@", tc.getContentsShort(l2));
        }
        return text;
    }

    public String getTranslationShort(String id, Locale l2) {
        String result = "";
        if (this.translations.containsItemWithId(id)) {
            TranslationContainer tc = (TranslationContainer)this.translations.getById(id);
            result = tc.getContentsShort(l2);
        }
        return result;
    }

    private void initGraphicsFormats() throws SQLException, DBServletException {
        SxResultSet rs = ServletUtils.execute("Einlesen von Grafikformaten", "select id,charttype,caption,width,height,captionx,captiony,linex,liney,showvalues,moreattribs from graphicformat", this.getName());
        this.graphicformats.clear();
        for (SxResultRow row : rs) {
            this.graphicformats.add(new GraphicFormat(row));
        }
    }

    private void initMacroFieldSelections() throws SQLException, DBServletException {
        SxResultSet makroFieldRs = ServletUtils.execute("Einlesen von speziellen Auswahlwerten f\u00fcr makros aus macro_feld_wert", "select macro,sortnr,feldname,value from macro_feld_wert where active=1", this.getName());
        this.makroFieldSelections.clear();
        for (SxResultRow aRow : makroFieldRs) {
            MacroFieldSelection m = new MacroFieldSelection(aRow);
            if (m.getWert() != null && m.getWert().startsWith("<<SQL>>")) {
                SxResultSet result = ServletUtils.execute("Wert f\u00fcr hinterlegten makro_feld_wert " + m.getMakroid() + ", sortnr " + m.getSortnr() + " holen", m.getWert().substring(7), this.getName());
                if (result.size() == 0) {
                    throw new IllegalArgumentException("Kein Makro_feld_wert f\u00fcr makro " + m.getMakroid() + " sortnr " + m.getSortnr() + " per " + m.getWert() + " gefunden.");
                }
                SxResultRow row = (SxResultRow)result.first();
                Object o = row.get(0);
                if (o == null) {
                    throw new IllegalArgumentException("Makro_feld_wert f\u00fcr makro " + m.getMakroid() + " sortnr " + m.getSortnr() + " darf nicht null sein.");
                }
                m.setWert(o.toString());
            }
            this.makroFieldSelections.add(m);
        }
    }

    public boolean hasMakroFieldSelection(Object makroid, Integer sortNr) {
        boolean result = false;
        for (MacroFieldSelection makroFieldSelection : this.makroFieldSelections) {
            if (!makroFieldSelection.getMakroid().toString().equals(makroid.toString()) || !makroFieldSelection.getSortnr().equals(sortNr)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void applyMacroFieldSelectionTo(Object makroid, Maske maske) {
        for (MacroFieldSelection makroFieldSelection : this.makroFieldSelections) {
            if (!makroFieldSelection.getMakroid().toString().equals(makroid.toString()) || !makroFieldSelection.getSortnr().equals(maske.getSortNr())) continue;
            SuperXManager.logActivity(Level.FINE, "Setze speziellen Auswahlwert           ein f\u00fcr Makro " + makroid + " Submaske: " + maske.getName() + "          sortnr=" + makroFieldSelection.getSortnr() + "          Feld:" + makroFieldSelection.getFeldername() + "          Wert:" + makroFieldSelection.getWert());
            try {
                maske.setSpecialFieldSelection(makroFieldSelection.getFeldername(), makroFieldSelection.getWert());
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new IllegalArgumentException("Konnte f\u00fcr Maske " + maske.getName() + " (" + maske.getId() + ") den gew\u00fcnschten Wert :\"" + makroFieldSelection.getWert() + "\" f\u00fcr das Feld " + makroFieldSelection.getFeldername() + " nicht eintragen.\n" + e2);
            }
        }
    }

    public void init() throws TransformerConfigurationException, SQLException, DBServletException, IOException {
        this.initTranslations();
        this.initHeaderFooterDB();
        this.initRepository();
        this.initMacroFieldSelections();
        this.initGraphicsFormats();
        this.initFieldElementCache();
        this.initFMTemplates();
        this.initFinRights();
        this.initHeaderFooter();
    }

    private void initHeaderFooter() throws IOException {
        File customPdfFile;
        File f2;
        String pfad = String.valueOf(SuperXManager.getWEB_INFPfad()) + File.separator + ".." + File.separator + this.getName() + File.separator + "custom";
        File excelVorlageFile = new File(String.valueOf(pfad) + "vorlage.xls");
        if (excelVorlageFile.exists()) {
            this.excelVorlage = excelVorlageFile.getAbsolutePath();
        }
        if (!(f2 = new File(pfad)).exists()) {
            f2.mkdirs();
        }
        if ((customPdfFile = new File(String.valueOf(pfad) + File.separator + "custom_pdf.xsl")).exists()) {
            customPdfFile.delete();
        }
        if (this.repositoryMap.get("CUSTOM_PDF") != null && !((RepositoryItemCollection)this.repositoryMap.get("CUSTOM_PDF")).getContent().equals("")) {
            StringUtils.write(customPdfFile, ((RepositoryItemCollection)this.repositoryMap.get("CUSTOM_PDF")).getContent());
        }
        this.hasCustomPdfFile = customPdfFile.exists();
    }

    public boolean hasCustomPDFFile() {
        return this.hasCustomPdfFile;
    }

    private void initFieldElementCache() {
        SxResultSet rs;
        MemoryUtils m = new MemoryUtils();
        if (SuperXManager.isSichtenCachingWanted) {
            System.out.print("  Caching von Sichten mit statischem SQL (Mandant:" + this.getName() + ")...");
            rs = null;
            try {
                rs = ServletUtils.execute("potentielle zu cachende Sichtenquellen lesen", "select name_intern,art,quelle from sichten where tid>10 and type!=20 and aktiv=1 and substring(quelle from 7 for (length(quelle)-7)) not like '%<<%'  and quelle not like '%${%' and quelle not like '%--freemarker%' and quelle not like '%<@%' ", this.getName());
            }
            catch (Exception e2) {
                System.out.println("Error beim Einlesen potentielle zu cachende Sichtenquellen " + e2);
            }
            if (rs != null) {
                for (SxResultRow row : rs) {
                    if (!this.fieldElementCache.isSichtCachingWanted((String)row.get(2))) continue;
                    try {
                        Logger.getLogger("superx_" + this.getName()).log(Level.FINER, " Cache Sicht:  " + row.get(0));
                        SxResultSet items = ServletUtils.executeALL_el("Elemente f\u00fcr zu cachende Sicht " + row.get(0), this.fieldElementCache.generateSQL((String)row.get(2), this.getSqlDialect()), this.getName(), false).getResultSet();
                        boolean isOrganigramm = false;
                        if (row.get(1).toString().equals("Organigramm-Sicht")) {
                            isOrganigramm = true;
                        }
                        this.fieldElementCache.addSicht(this.getName(), (String)row.get(0), items, isOrganigramm);
                    }
                    catch (Exception e3) {
                        Logger.getLogger("superx_" + this.getName()).log(Level.INFO, "Problem bei Caching der Sicht " + row.get(0) + " " + e3);
                    }
                }
            }
            System.out.println("OK");
        } else {
            System.out.println("Caching von Sichten mit statischem SQL deaktiviert");
        }
        if (SuperXManager.field1Cache == null || SuperXManager.field1Cache.equals("")) {
            System.out.println("  kein Feldart 1-caching aktiviert");
        } else {
            System.out.print("  Feldart 1-caching (" + SuperXManager.field1Cache + ")...");
            m.measureBefore();
            rs = null;
            try {
                rs = ServletUtils.execute("potentielle zu cachende Felderquellen lesen", "select distinct relation from felderinfo where " + SuperXManager.field1Cache + " and art=1 and substring(relation from 7 for (length(relation)-7)) not like '%<<%' and relation not like '%${%' and relation not like '%--freemarker%' and relation not like '%<@%' and tid!=23541", this.getName());
            }
            catch (Exception e4) {
                System.out.println("Error beim Einlesen potentielle zu cachende Felderquellen " + e4);
            }
            if (rs != null) {
                TreeSet<String> sqls = new TreeSet<String>();
                String haushaltsjahr = DateUtils.getYear(new Date(new java.util.Date().getTime()));
                Hashtable<String, String> formular = new Hashtable<String, String>();
                formular.put("Haushaltsjahr", haushaltsjahr);
                for (SxResultRow row : rs) {
                    String sql = (String)row.get(0);
                    if (sql.trim().indexOf("<<SQL>>") == -1) continue;
                    sql = SqlStringUtils.generateSQL("PG", formular, sql);
                    if ((sql = AbstractSicht.getStrippedSQL(sql)).indexOf("<<") != -1) continue;
                    sqls.add(sql);
                }
                for (String sql : sqls) {
                    Logger.getLogger("superx_" + this.getName()).log(Level.FINER, " Cache Feld-SQL:  " + sql);
                    try {
                        rs = ServletUtils.executeALL_el("Felder-SQL cachen", sql, this.getName(), false).getResultSet();
                        this.fieldElementCache.add(sql, rs);
                    }
                    catch (Exception e5) {
                        Logger.getLogger("superx_" + this.getName()).log(Level.INFO, "Problem bei Caching des Feld-SQLs " + sql + " " + e5);
                    }
                }
            }
            System.out.println("OK");
        }
    }

    private void initFinRights() throws SQLException, DBServletException {
        this.finRightVariant = 0;
        Connection dbConnection = SxPools.getConnection(this.getName());
        try {
            Statement stm = dbConnection.createStatement();
            DatabaseMetaData md = dbConnection.getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet rs = md.getTables(null, null, "fin_user_kam", types);
            if (rs.next()) {
                this.finRightVariant = 1;
            }
            rs.close();
            rs = md.getColumns(null, null, "fin_user_kam", null);
            while (rs.next()) {
                if (!rs.getString(4).equals("kapitel")) continue;
                this.finRightVariant = 2;
                System.out.println("erweiterte FIN_user_kam gefunden - OK");
            }
            rs.close();
            ResultSet rs2 = stm.executeQuery("select  1 from xdummy where (select count(*) from fin_buch where kaminfo like '%k3%')>1 and (select count(*) from fin_konto_aggr where kaminfo like '%k3%')>1 union select 0 from xdummy where (select count(*) from fin_buch where kaminfo like '%k3%')=0 and (select count(*) from fin_konto_aggr where kaminfo like '%k3%')=0");
            int k3count = 0;
            while (rs2.next()) {
                k3count = rs2.getInt(1);
            }
            rs2.close();
            if (this.finRightVariant == 2 && k3count > 0) {
                this.finRightVariant = 3;
                System.out.println("erweiterte FIN_user_kam inkl. ins2/3 gefunden - OK");
            }
            stm.close();
            dbConnection.close();
        }
        catch (SQLException e2) {
            Logger.getLogger("superx_" + this.getName()).log(Level.SEVERE, e2.toString());
            SxPools.invalidate(this.getName(), dbConnection);
        }
        SxResultSet rs2 = ServletUtils.execute("", "select apnr from konstanten where beschreibung='FIN_RECHTE_0_JOKER'", this.getName());
        for (SxResultRow r : rs2) {
            System.out.println(r.get(0) + " " + r.get(0).toString().equals("0"));
            if (r.get(0) == null || !r.get(0).toString().equals("0")) continue;
            this.is0FINJoker = false;
        }
    }

    public boolean is0FINJoker() {
        return this.is0FINJoker;
    }

    public int getFinRightVariant() {
        return this.finRightVariant;
    }

    private void initCachedUsers() throws SQLException, DBServletException {
        this.userpool.clear();
        String userImCacheSql = this.props.getProperty("userCache");
        if (userImCacheSql != null && !userImCacheSql.equals("")) {
            SxResultSet rs = ServletUtils.execute("user  f\u00fcr Cache holen", userImCacheSql, this.getName());
            MemoryUtils m = new MemoryUtils();
            for (SxResultRow row : rs) {
                try {
                    this.initUser(row);
                }
                catch (Exception e2) {
                    String msg = "User " + row.get(0) + " konnte nicht aufgebaut werden. " + e2;
                    Logger.getLogger("superx_" + this.getName()).log(Level.SEVERE, msg);
                    System.err.println(msg);
                }
            }
            m.print("alle " + rs.size() + " User");
        }
    }

    private void initCachedMasks() throws SQLException, DBServletException {
        this.maskenpool.clear();
        String maskenImCacheSql = this.props.getProperty("maskCache");
        if (maskenImCacheSql != null && !maskenImCacheSql.equals("")) {
            SxResultSet rs = ServletUtils.execute("Maskentids f\u00fcr Cache holen", maskenImCacheSql, this.getName());
            MemoryUtils m = new MemoryUtils();
            for (SxResultRow row : rs) {
                try {
                    this.initMask((Integer)row.get(0));
                }
                catch (Exception e2) {
                    String msg = "Maske " + row.get(0) + " konnte nicht aufgebaut werden. " + e2;
                    Logger.getLogger("superx_" + this.getName() + "_xml").log(Level.SEVERE, msg);
                    System.err.println(msg);
                }
            }
            m.print("alle " + rs.size() + " Masken");
        }
    }

    private void initUser(SxResultRow row) throws IllegalArgumentException, SecurityException, TransformerConfigurationException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, TransformerException, KeyParentEqualException, SQLException, DBServletException {
        Integer userid = (Integer)row.get(0);
        String login_name = (String)row.get(1);
        String adminUser = row.get(2).toString();
        UserInitializer.initUser(this.getName(), login_name, userid, adminUser);
    }

    private void initMask(Integer tid) throws TransformerConfigurationException, TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, IOException, SQLException, DBServletException, NoMainEntryException {
        System.out.println("adding " + tid + " to Maskenpool");
        this.maskenpool.add(new Maske(this.getName(), null, tid, TranslationContainer.defaultLocale));
    }

    private void initFMTemplates() throws SQLException, DBServletException {
        SxResultSet rawFmTemplates = ServletUtils.execute("Hole allg. FreeMarker Templates aus der DB", "select trim(id),content from fm_templates", this.getName());
        this.templateProcessor.setTemplates(rawFmTemplates);
    }

    public GraphicFormat getGraphicFormat(String graphicFormat) {
        GraphicFormat result = null;
        try {
            this.initGraphicsFormats();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        catch (DBServletException e1) {
            e1.printStackTrace();
        }
        try {
            Integer graphicFormatNr = new Integer(graphicFormat);
            result = (GraphicFormat)this.graphicformats.getById(graphicFormatNr);
        }
        catch (RuntimeException e2) {
            throw new IllegalArgumentException("Kein GraphicFormat mit tid " + graphicFormat + " in der Datenbank gefunden.");
        }
        return result;
    }

    public ServletTemplateProcessor getTemplateProcessor() {
        return this.templateProcessor;
    }

    public static void main(String[] args) {
    }

    public String getDatabaseAbbr() {
        String result = "IDS";
        if (this.props.getProperty("driverName").indexOf("postgres") > -1) {
            result = "PG";
        }
        return result;
    }

    public HashMap getRepository() {
        return this.repositoryMap;
    }

    public void clearLogFiles() throws IOException {
        this.closeLoggers();
        this.initLogging(false);
    }

    private void initDSAHandler() throws DBServletException {
        if (this.privateKeyEncoded == null) {
            throw new IllegalStateException("privatekey war null - sx_repository auf Eintrag \u00fcberpr\u00fcfen");
        }
        if (this.publicKeyEncoded == null) {
            throw new IllegalStateException("publickey war null -  sx_repository auf Eintrag pr\u00fcfen");
        }
        try {
            this.dsaHandler = new DSAHandler(this.privateKeyEncoded, this.publicKeyEncoded);
        }
        catch (Exception e2) {
            throw new DBServletException(e2.toString());
        }
    }

    public boolean hasDSAHandler() {
        return this.dsaHandler != null;
    }

    public boolean verifiy(String data, String signature) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureException {
        if (this.dsaHandler == null) {
            throw new IllegalStateException("DSAHandler ist null, public und private key definition pr\u00fcfen");
        }
        return this.dsaHandler.verify(data, signature);
    }

    public String getPrivateKey() {
        return this.privateKeyEncoded;
    }

    public boolean isRestrictedConnection() {
        return this.isRestrictedConnection;
    }

    public NewPasswordChecker getNewPWChecker() {
        return this.newPasswordChecker;
    }

    public FieldElementCache getFieldElementCache() {
        return this.fieldElementCache;
    }

    public String getFinRightVariantName() {
        String result = "einfach";
        if (this.finRightVariant == 2) {
            result = "erweitert ohne ins2/ins3";
        }
        if (this.finRightVariant == 3) {
            result = "erweitert inkl. ins2/3";
        }
        return result;
    }

    public String customHTMLHeaderFooter(String result) {
        if (this.repositoryMap.get("HTML_HEADER") != null && !((RepositoryItemCollection)this.repositoryMap.get("HTML_HEADER")).getContent().equals("")) {
            Pattern customheadertablePattern = Pattern.compile("<table .* id=\"customheader\".*?</table>", 32);
            Matcher action = customheadertablePattern.matcher(result);
            String newstuff = ((RepositoryItemCollection)this.repositoryMap.get("HTML_HEADER")).getContent();
            result = action.replaceAll(newstuff);
        }
        if (this.repositoryMap.get("HTML_FOOTER") != null && !((RepositoryItemCollection)this.repositoryMap.get("HTML_FOOTER")).getContent().equals("")) {
            result = StringUtils.replace(result, "<!--customfooter-->", ((RepositoryItemCollection)this.repositoryMap.get("HTML_FOOTER")).getContent());
        }
        return result;
    }

    public String getExcelVorlage() {
        return this.excelVorlage;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        int version = 0;
        Connection con = this.getConnection();
        version = con.getMetaData().getDatabaseMinorVersion();
        con.close();
        return version;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        int version = 0;
        Connection con = this.getConnection();
        version = con.getMetaData().getDatabaseMajorVersion();
        con.close();
        return version;
    }
}

