/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import com.lowagie.text.DocumentException;
import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.util.DateUtils;
import de.memtext.util.ServletHelper;
import de.memtext.util.TimeUtils;
import de.memtext.util.TransletUtils;
import de.memtext.util.XMLUtils;
import de.superx.common.DBServletException;
import de.superx.common.SxUser;
import de.superx.common.TransletCache;
import de.superx.servlet.AbstractSuperXServlet;
import de.superx.servlet.MaskenContainer;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import de.superx.servlet.UserInitializer;
import de.superx.servlet.XUpdaterServlet;
import de.superx.util.SqlStringUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class SuperXManager
extends HttpServlet {
    private static final long serialVersionUID = 2L;
    private SuperXInitThread initThread;
    public static boolean isZukuenftigerStandErlaubt = true;
    public static int maxRows = 20000;
    public static String defaultMaskXsl = "maske_html.xsl";
    public static String defaultTableHtmlXsl = "tabelle_html.xsl";
    public static String defaultTableXlsXsl = "tabelle_xls.xsl";
    public static String defaultTablePdfXsl = "tabelle_fo_pdf.xsl";
    public static String sharedSecret = "";
    private static String xmenu;
    private static String xmask;
    private static String xtablehtml;
    private static String xtablexsl;
    private static String xtablepdf;
    public static boolean isSichtenCachingWanted;
    private static final String ADMIN_ONLY = "<html><head><title>SuperXManager</title></head><body><center><h3>Hier ist ein Login nur f\u00fcr Administratoren m&ouml;glich.</h3>(Cookies m&uuml;ssen aktiviert sein)<FORM ACTION=\"SuperXManager\" METHOD=\"post\"><p><p>Kennung: <br /><INPUT TYPE=\"Text\" NAME=\"kennung\" VALUE=\"superx\"></p><p><p>Passwort: <br /><INPUT TYPE=\"Password\" NAME=\"passwort\" value=\"\"></p><p>MandantenID<br><input type=\"text\" name=\"MandantenID\" value=\"default\"></p><br><INPUT TYPE=\"Submit\" NAME=\"Abschicken\" VALUE=\"Anmelden\"></FORM></center></body></html>";
    private static String pageBeginning;
    private static String pageEnd;
    private static StringBuffer activityLog;
    private static String lastFMMaskenSql;
    private static String lastMaskenSql;
    private static String lastXml;
    public static boolean isDevelopmentMode;
    private static boolean isLastSqlExtraPageWanted;
    public static boolean isXMLReturnLinkWanted;
    static String refererstart;
    public static String field1Cache;
    private static CacheUpdater cashUpdater;
    public static boolean isHis1;
    private static String webinfPfad;

    static {
        isSichtenCachingWanted = true;
        pageBeginning = "<html><head><title>SuperXManager</title></head><body><h1 align=center>SuperX Manager</h1><center>SuperX @version@ (build:@sxtimestamp@)</center>";
        pageEnd = "</body></html>";
        activityLog = new StringBuffer();
        lastMaskenSql = "--";
        lastXml = "--";
        isDevelopmentMode = true;
        isLastSqlExtraPageWanted = true;
        isXMLReturnLinkWanted = true;
        refererstart = null;
        cashUpdater = new CacheUpdater();
        isHis1 = false;
        webinfPfad = "";
    }

    public static String getMaxRowsHinweis() {
        return " Die Datenbank lieferte eine gro\u00dfe Menge an Datens\u00e4tzen. Es werden nur die ersten " + maxRows + " dargestellt. Schr\u00e4nken Sie Ihre Abfrage ggfs. weiter ein.";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        webinfPfad = this.getServletConfig().getServletContext().getRealPath("WEB-INF");
        try {
            this.initThread = new SuperXInitThread(config);
            this.initThread.start();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new ServletException((Throwable)e2);
        }
    }

    public static String getWEB_INFPfad() {
        return webinfPfad;
    }

    private void initXSLFilenames() {
        xmenu = "file:///" + this.getServletConfig().getServletContext().getRealPath("xml/menue_html.xsl");
        xmask = "file:///" + this.getServletConfig().getServletContext().getRealPath("xml/" + defaultMaskXsl);
        xtablehtml = "file:///" + this.getServletConfig().getServletContext().getRealPath("xml/" + defaultTableHtmlXsl);
        xtablexsl = "file:///" + this.getServletConfig().getServletContext().getRealPath("xml/" + defaultTableXlsXsl);
        xtablepdf = "file:///" + this.getServletConfig().getServletContext().getRealPath("xml/" + defaultTablePdfXsl);
    }

    public static void initStandardXsl() throws TransformerConfigurationException, DBServletException {
        TransletCache.getTransformer(null, xmenu);
        TransletCache.getTransformer(null, xmask);
        TransletCache.getTransformer(null, xtablehtml);
        TransletCache.getTransformer(null, xtablexsl);
    }

    public void destroy() {
        super.destroy();
        try {
            if (this.initThread != null) {
                this.initThread.destroy();
            }
            SxPools.closeAll();
            cashUpdater.setActive(false);
            cashUpdater.interrupt();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            Enumeration<Driver> en = DriverManager.getDrivers();
            while (en.hasMoreElements()) {
                Driver d2 = en.nextElement();
                try {
                    DriverManager.deregisterDriver(d2);
                    System.out.println(new Date() + " deregister " + d2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AbstractSuperXServlet.setEncoding(request);
        response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        if (ServletHelper.getParameter(request, "kennung") != null && ServletHelper.getParameter(request, "passwort") != null) {
            UserInitializer ui = new UserInitializer(request, false);
            try {
                ui.perform();
            }
            catch (Exception e2) {
                throw new ServletException("Authentification for " + ServletHelper.getParameter(request, "kennung") + " failed");
            }
        }
        if (request.getParameter("xupdater") != null) {
            XUpdaterServlet xu = new XUpdaterServlet();
            xu.doPost(request, response);
        } else {
            SxUser user = (SxUser)request.getSession().getAttribute("user");
            if (user == null || !user.isAdmin()) {
                PrintWriter output = response.getWriter();
                output.write(ADMIN_ONLY);
                output.flush();
            } else {
                SxManager m = new SxManager(request, response);
                m.run(false);
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        SxUser user = (SxUser)request.getSession().getAttribute("user");
        if (user == null || !user.isAdmin()) {
            PrintWriter output = response.getWriter();
            output.write(ADMIN_ONLY);
            output.flush();
            output.close();
        } else if (request.getParameter("xupdater") != null) {
            XUpdaterServlet xu = new XUpdaterServlet();
            xu.doGet(request, response);
        } else {
            boolean isLastSqlXmlWantend;
            PrintWriter output = response.getWriter();
            String showLastSqlXml = ServletHelper.getParameter(request, "showlastsqlxml");
            boolean bl = isLastSqlXmlWantend = showLastSqlXml != null && showLastSqlXml.equals("true");
            if (isLastSqlXmlWantend) {
                output.write(String.valueOf(pageBeginning) + this.getLastSqlXml() + pageEnd);
            } else {
                output.write(String.valueOf(this.getStandardPage(request, "")) + pageEnd);
            }
            output.flush();
            output.close();
        }
    }

    private String getLastSqlXml() {
        StringBuffer result = new StringBuffer("<br>");
        result.append("<center><table><tr>");
        result.append("<td><p align=center><b>letzter Masken sql (vom XML-Frontend)<br>vor FreeMarker-Transformation</b></p><textarea name=\"sql\" rows=20 cols=50>" + lastFMMaskenSql + "</textarea></td>");
        result.append("<td><p align=center><b>letzter Masken sql (vom XML-Frontend)</b></p><textarea name=\"sql\" rows=20 cols=50>" + lastMaskenSql + "</textarea></td>" + "<td><p align=center><b>letztes XML</b></p><textarea name=\"xml\" rows=20 cols=50>" + lastXml + "</textarea></td></tr></table></center>");
        return result.toString();
    }

    public String getStandardPage(HttpServletRequest request, String comment) {
        String m = ServletUtils.getMandantenID(request);
        StringBuffer result = new StringBuffer(String.valueOf(pageBeginning) + (m.equals("default") ? "" : "<center>(Mandant: " + m + ")<br>\n") + "\n<br>" + "<center><form action=\"SuperXManager\" method=post>" + comment + "\n<br><br><input type=submit name=\"cache\" value=\"Server-Cache aktualisieren\">&nbsp;<input type=submit name=\"clearStylesheets\" value=\"nur Stylesheet-Cache leeren\"></font><br>" + "<font>Es werden Erl&auml;uterungen und &Uuml;bersetzungen (captions) gecacht.<br>F&uuml;rs XML-Frontend auch: User,Userrechte und Sichten,<br> und auch Abfragen wenn in der db.properties eingetragen</font> <br><br>" + "<font size=+1>Entwicklungsmodus ist " + (isDevelopmentMode ? "AN" : "AUS") + " <input type=radio name=\"Entwicklungsmodus\" value=\"an\"" + (isDevelopmentMode ? "checked" : "") + ">an\n<input type=radio name=\"Entwicklungsmodus\" value=\"aus\"" + (!isDevelopmentMode ? "checked" : "") + ">aus\n" + "\n</font><input type=submit value=\"&Uuml;bernehmen\"><br>" + "(Im Entwicklungsmodus werden alle SQL-Befehle von Abfragen einzeln an die Datenbank geschickt.<br>Das dauert l&auml;nger, erm&ouml;glicht aber bessere Fehlermeldungen.)<br><br>" + "Achtung: bei Informix sollten Sie den Entwicklungsmodus nicht ausschalten, der JDBC-Treiber arbeitet dann instabil.<br><br>" + "\n<br><br><input type=submit name=\"clearlogfiles\" value=\"Log-Dateien leeren\"><br>\n");
        result.append("</form>");
        if (isLastSqlExtraPageWanted) {
            result.append(this.getLastSqlXml());
        } else {
            result.append("<a href=\"SuperXManager?showlastsqlxml=true\" target=\"_blank\">letzter SQL / XML</a><br><br><hr>");
        }
        result.append("<center><h2>LOG  <a href=\"SuperXManager\">aktualisieren<a/></h2><br>" + activityLog + "<br><hr><a href=\"SuperXManager\">LOG aktualisieren<a/>");
        result.append("<br><br>" + SxPools.getPoolFinRechteInfos());
        result.append(pageEnd);
        return result.toString();
    }

    public static void setLastMaskenSql(String sql) {
        lastMaskenSql = sql;
    }

    public static void setLastXml(String xml) {
        lastXml = xml;
    }

    static synchronized void initAll() throws KeyParentEqualException, NichtAngemeldetException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException, DBServletException, TransformerException {
        SxPools.resetAllPools();
        System.out.println(" using encoding:" + SqlStringUtils.getEncoding());
        SuperXManager.clearTransletStylesheets();
    }

    public static void initPool(HttpServletRequest request, String mandantenID) throws TransformerConfigurationException, SQLException, DBServletException, IOException {
        System.out.println(String.valueOf(DateUtils.getNowString()) + " Server Cache wird neu geladen f\u00fcr :" + mandantenID);
        MaskenContainer mc = MaskenContainer.getFromRequest(request);
        mc.clear();
        if (mandantenID.equals("default")) {
            SxPools.resetAllPools();
        } else {
            SxPools.get(mandantenID).init();
        }
        System.out.println(" using encoding:" + SqlStringUtils.getEncoding());
        SuperXManager.clearTransletStylesheets();
        SuperXManager.initStandardXsl();
    }

    public static void clearTransletStylesheets() throws TransformerConfigurationException, DBServletException {
        System.out.println(String.valueOf(DateUtils.getNowString()) + " Stylesheet-Cache geleert");
        TransletCache.clear();
    }

    public String getServletInfo() {
        return "SuperXManager";
    }

    public static void clearLog() {
        activityLog.setLength(0);
    }

    public static void logActivity(Level level, String log) {
        if (level == null) {
            level = Level.INFO;
        }
        activityLog.append(String.valueOf(TimeUtils.getNowString()) + " " + log + "<br>");
    }

    public static String getLastFMMaskenSql() {
        return lastFMMaskenSql;
    }

    public static void setLastFMMaskenSql(String lastFMMaskenSql) {
        SuperXManager.lastFMMaskenSql = lastFMMaskenSql;
    }

    public static void main(String[] args) {
        System.out.println("SuperX @version@ (build:@sxtimestamp@)");
        System.out.println(SqlStringUtils.getEncoding());
    }

    private static final class CacheUpdater
    extends Thread {
        private Date lastUpdate;
        private boolean isActive = true;

        private CacheUpdater() {
        }

        @Override
        public void run() {
            while (this.isActive) {
                Date now = new Date();
                try {
                    Thread.sleep(1800000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (now.getHours() != 7 || this.lastUpdate != null && this.lastUpdate.getDay() == now.getDay()) continue;
                try {
                    System.out.println(String.valueOf(DateUtils.getTodayString()) + " " + DateUtils.getNowString() + " Server-Cache-Aktualisierung");
                    SuperXManager.initAll();
                    this.lastUpdate = now;
                }
                catch (Exception e2) {
                    System.out.println("Server-Cache-Aktualisierung fehlgeschlagen:" + e2);
                }
            }
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void setActive(boolean isActive) {
            this.isActive = isActive;
        }
    }

    class SuperXInitThread
    extends Thread {
        private ServletConfig config;
        private boolean isDestroyWanted = false;

        public SuperXInitThread(ServletConfig config) throws SecurityException, IOException {
            this.config = config;
            String catalinaHomeDirectory = System.getProperty("catalina.home");
            File webappsDirectory = catalinaHomeDirectory != null && catalinaHomeDirectory.length() != 0 ? new File(String.valueOf(catalinaHomeDirectory) + File.separator + "webapps") : new File(SuperXManager.this.getServletConfig().getServletContext().getRealPath(".."));
            this.searchDatabasesXML(webappsDirectory);
        }

        public void destroy() {
            this.isDestroyWanted = true;
        }

        public void searchDatabasesXML(File input) throws IOException {
            if (!isHis1) {
                if (input.isDirectory()) {
                    int i2 = 0;
                    while (i2 < input.listFiles().length) {
                        this.searchDatabasesXML(input.listFiles()[i2]);
                        ++i2;
                    }
                } else if (input.getName().equalsIgnoreCase("databases.xml")) {
                    isHis1 = true;
                }
            }
        }

        @Override
        public void run() {
            if (isHis1) {
                while (!(this.isDestroyWanted || System.getProperty("SuperX-DB-PROPERTIES-SET") != null && System.getProperty("SuperX-DB-PROPERTIES-SET").equalsIgnoreCase("true"))) {
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
                System.out.println("SuperXManager startet - SuperX-DB-PROPERTIES-SET=true gefunden");
            }
            try {
                this.doInit();
            }
            catch (ServletException e3) {
                e3.printStackTrace();
                throw new IllegalStateException("SuperX Init failed " + (Object)((Object)e3));
            }
        }

        private void doInit() throws ServletException {
            String sichtcache;
            String f1;
            String mxr;
            String xsl_parser;
            String last_sql_extra_page;
            String xmlReturnLink;
            String zukuenftigerStandErlaubt;
            XMLUtils.getExceptionHandler().setWithGui(false);
            XMLUtils.getExceptionHandler().setExitWanted(false);
            ServletUtils.setPath(SuperXManager.this.getServletConfig().getServletContext().getRealPath("xml"));
            SuperXManager.this.initXSLFilenames();
            refererstart = this.config.getInitParameter("referer_start");
            if (refererstart != null && !refererstart.trim().equals("")) {
                System.out.println("Referer wird kontrolliert auf " + refererstart);
            }
            if ((zukuenftigerStandErlaubt = this.config.getInitParameter("zuk\u00fcnftigerStandErlaubt")) != null && zukuenftigerStandErlaubt.equals("false")) {
                isZukuenftigerStandErlaubt = false;
            }
            if ((xmlReturnLink = this.config.getInitParameter("xml_return_link")) != null && xmlReturnLink.equals("false")) {
                isXMLReturnLinkWanted = false;
            }
            if ((last_sql_extra_page = this.config.getInitParameter("last_sql_extra_page")) != null && last_sql_extra_page.equals("false")) {
                isLastSqlExtraPageWanted = false;
            }
            if ((xsl_parser = this.config.getInitParameter("xsl_processor")) != null) {
                TransletUtils.initFactory(xsl_parser, "org.apache.xalan.xsltc.trax.TransformerFactoryImpl");
            } else {
                TransletUtils.initFactory("net.sf.saxon.TransformerFactoryImpl", null);
            }
            System.out.println("Using xsl processor: " + TransletUtils.getUsedProcessor());
            sharedSecret = this.config.getInitParameter("sharedSecret");
            if (sharedSecret == null) {
                sharedSecret = "";
            }
            if ((mxr = this.config.getInitParameter("maxRows")) != null && !mxr.equals("")) {
                maxRows = Integer.parseInt(mxr);
            }
            System.out.println("SuperXManager: maxRows: " + maxRows + " (wenn mehr geliefert wird, werden die zusaetzlichen Datenzeilen ignoriert)");
            String defaultXsl = this.config.getInitParameter("defaultMaskXsl");
            if (defaultXsl != null && !defaultXsl.trim().equals("")) {
                defaultMaskXsl = defaultXsl;
                System.out.println("SuperXManager: defaultMaskXsl: " + defaultMaskXsl);
            }
            if ((defaultXsl = this.config.getInitParameter("defaultTableHtmlXsl")) != null && !defaultXsl.trim().equals("")) {
                defaultTableHtmlXsl = defaultXsl;
                System.out.println("SuperXManager: defaultTableHtmlXsl: " + defaultTableHtmlXsl);
            }
            if ((defaultXsl = this.config.getInitParameter("defaultTableXlsXsl")) != null && !defaultXsl.trim().equals("")) {
                defaultTableXlsXsl = defaultXsl;
                System.out.println("SuperXManager: defaultTableXlsXsl: " + defaultTableXlsXsl);
            }
            if ((defaultXsl = this.config.getInitParameter("defaultTablePdfXsl")) != null && !defaultXsl.trim().equals("")) {
                defaultTablePdfXsl = defaultXsl;
                System.out.println("SuperXManager: defaultTablePdfXsl: " + defaultTablePdfXsl);
            }
            if ((f1 = this.config.getInitParameter("field1Cache")) != null && !f1.equals("")) {
                field1Cache = f1;
            }
            if ((sichtcache = this.config.getInitParameter("sichtenCaching")) != null && sichtcache.equalsIgnoreCase("false")) {
                isSichtenCachingWanted = false;
            }
            try {
                SxPools.init();
                SuperXManager.initAll();
                SuperXManager.initStandardXsl();
                cashUpdater.start();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new ServletException("SuperX konnte nicht initialisiert werden.\n" + e2);
            }
        }
    }

    private class SxManager
    extends SuperXServletHelper {
        public SxManager(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
        }

        @Override
        protected void perform() throws IOException, IllegalArgumentException, SecurityException, KeyParentEqualException, NichtAngemeldetException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException, DBServletException, TransformerException {
            String comment = "";
            if (this.request.getParameterMap().containsKey("cache")) {
                SuperXManager.initPool(this.request, this.getMandantenID());
                SuperXManager.initStandardXsl();
                comment = "Resources neu geladen: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
            }
            if (this.request.getParameterMap().containsKey("clearStylesheets")) {
                SuperXManager.clearTransletStylesheets();
                comment = "Stylesheet-Cache geleert: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
            }
            if (this.request.getParameterMap().containsKey("clearlogfiles")) {
                SxPools.clearLogFiles();
                comment = "LogDateien geleert";
            }
            if (ServletHelper.getParameter(this.request, "Entwicklungsmodus") != null) {
                isDevelopmentMode = ServletHelper.getParameter(this.request, "Entwicklungsmodus").equals("an");
            }
            PrintWriter output = this.response.getWriter();
            this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            output.write(SuperXManager.this.getStandardPage(this.request, comment));
            output.write(pageEnd);
            output.flush();
        }
    }
}

