/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.rights;

import de.memtext.rights.AllowableHierarchy;
import de.memtext.tree.TreeEntryI;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class AllowableHierarchyUtil {
    public static void removeUnallowedNodes(AllowableHierarchy root) {
        if (!(root instanceof DefaultMutableTreeNode)) {
            throw new IllegalArgumentException(" must be a node!");
        }
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)((Object)root);
        boolean needAnotherRound = true;
        boolean killedOne = false;
        while (needAnotherRound) {
            killedOne = false;
            Enumeration<TreeNode> en = rootNode.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                AllowableHierarchy ah;
                TreeNode o = en.nextElement();
                if (o == root || (ah = (AllowableHierarchy)((Object)o)).isAnyDescendantAllowed()) continue;
                ((DefaultMutableTreeNode)((Object)ah)).removeFromParent();
                killedOne = true;
                break;
            }
            if (killedOne) continue;
            needAnotherRound = false;
        }
    }

    public static void reorg(AllowableHierarchy root) {
        if (!(root instanceof DefaultMutableTreeNode)) {
            throw new IllegalArgumentException(" must be a node!");
        }
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)((Object)root);
        boolean needAnotherRound = true;
        LinkedList<TreeNode> nodeList = new LinkedList<TreeNode>();
        while (needAnotherRound) {
            nodeList.clear();
            needAnotherRound = false;
            int i2 = 0;
            while (i2 < rootNode.getChildCount()) {
                AllowableHierarchy ah = (AllowableHierarchy)((Object)rootNode.getChildAt(i2));
                if (!ah.isAllowed()) {
                    needAnotherRound = true;
                    ((DefaultMutableTreeNode)((Object)ah)).removeFromParent();
                    int i22 = 0;
                    while (i22 < ((DefaultMutableTreeNode)((Object)ah)).getChildCount()) {
                        nodeList.add(((DefaultMutableTreeNode)((Object)ah)).getChildAt(i22));
                        ++i22;
                    }
                }
                ++i2;
            }
            Iterator it = nodeList.iterator();
            while (it.hasNext()) {
                rootNode.add((DefaultMutableTreeNode)it.next());
            }
        }
    }

    public static void markNotAllowedNodes(AllowableHierarchy root, String mark) {
        if (!(root instanceof DefaultMutableTreeNode)) {
            throw new IllegalArgumentException(" must be a node!");
        }
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)((Object)root);
        boolean i2 = false;
        Enumeration<TreeNode> en = rootNode.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            TreeEntryI te;
            AllowableHierarchy ah = (AllowableHierarchy)((Object)en.nextElement());
            if (ah.isAllowed() || (te = (TreeEntryI)((Object)ah)).getName().endsWith(mark)) continue;
            te.setName(String.valueOf(te.getName()) + mark);
        }
    }
}

