/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.IfxASFException;
import com.informix.jns.IfxJNSException;
import com.informix.jns.ServerGroup;
import com.informix.jns.ServerInfo;
import com.informix.jns.Sqlhosts;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMessage;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;

public class JnsObject {
    static final int MAX_BUFF_SIZE = 32768;
    static final int MIN_BUFF_SIZE = 140;
    static int STREAM_BUF_SIZE = 4096;
    private String ClientLocale = null;
    private String ipAddr = null;
    private String portNo = null;
    private int PortNumber = 0;
    private int groupCount = 0;
    private String gServerName = null;
    ServerGroup myGroup = null;

    public void JnsLookup(String string, Properties properties) throws IfxASFException {
        Object object;
        String string2 = null;
        try {
            int n;
            Sqlhosts sqlhosts = new Sqlhosts(properties);
            ServerInfo serverInfo = sqlhosts.getServer(string);
            if (serverInfo.isGroupEntry()) {
                this.myGroup = sqlhosts.getServerGroup(string);
                string2 = serverInfo.getOption("c");
                this.groupCount = this.myGroup.size();
                if (string2 != null && string2.equals("1") && this.groupCount > 1) {
                    object = new Random();
                    int n2 = ((Random)object).nextInt();
                    int n3 = n2 % this.groupCount;
                    if (n3 < 0) {
                        n3 = -n3;
                    }
                    this.gServerName = (String)this.myGroup.elementAt(n3);
                } else {
                    this.gServerName = (String)this.myGroup.nextElement();
                }
                serverInfo = sqlhosts.getServer(this.gServerName);
            }
            if ((string2 = serverInfo.getOption("b")) != null && (n = Integer.parseInt(string2)) > 140 && n < 32768) {
                STREAM_BUF_SIZE = n;
            }
            this.ipAddr = serverInfo.getHostname();
            this.portNo = serverInfo.getService();
        }
        catch (IfxJNSException ifxJNSException) {
            throw IfxErrMsg.getLocIfxASFException(-25563, this.ClientLocale);
        }
        try {
            this.PortNumber = Integer.parseInt(this.portNo);
        }
        catch (NumberFormatException numberFormatException) {
            int n = -1;
            n = JnsObject.getServiceByName(this.portNo);
            if (n == -1) {
                object = IfxMessage.getMessage(-931, this.portNo, this.ClientLocale);
                throw new IfxASFException(-931, (String)object);
            }
            this.PortNumber = n;
        }
    }

    public ServerGroup getServerGroup() {
        return this.myGroup;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public String getServerName() {
        return this.gServerName;
    }

    public String getIPAddr() {
        return this.ipAddr;
    }

    public String getPortNo() {
        return this.portNo;
    }

    public int getPortNumber() {
        return this.PortNumber;
    }

    public void setClientLocale(String string) {
        this.ClientLocale = string;
    }

    public String getClientLocale() {
        return this.ClientLocale;
    }

    public static int getServiceByName(String string) {
        int n = -1;
        String string2 = JnsObject.getServicesFileName();
        if (string2 == null) {
            return -1;
        }
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string2)));
            while ((string3 = bufferedReader.readLine()) != null && n == -1) {
                if (string3.length() == 0 || string3.charAt(0) == '#') continue;
                n = JnsObject.parseServicesLine(string3, string);
            }
            bufferedReader.close();
            return n;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    private static String getServicesFileName() {
        boolean bl = false;
        Process process = null;
        String string = null;
        Runtime runtime = Runtime.getRuntime();
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.indexOf("windows 9") > -1) {
            bl = true;
            try {
                process = runtime.exec("command.com /c set");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (string2.indexOf("windows") > -1) {
            bl = true;
            try {
                process = runtime.exec("cmd.exe /c set");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (bl) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            try {
                String string3;
                while ((string3 = bufferedReader.readLine()) != null) {
                    int n = string3.indexOf(61);
                    String string4 = string3.substring(0, n);
                    String string5 = string3.substring(n + 1);
                    if (!string4.toLowerCase().equals("systemroot")) continue;
                    string = string5 + "\\system32\\drivers\\etc\\services";
                }
            }
            catch (IOException iOException) {
                return null;
            }
        } else {
            string = "//etc//services";
        }
        return string;
    }

    private static int parseServicesLine(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t/");
        if (!stringTokenizer.hasMoreTokens()) {
            return -1;
        }
        String string3 = stringTokenizer.nextToken().trim();
        if (!stringTokenizer.hasMoreTokens()) {
            return -1;
        }
        String string4 = stringTokenizer.nextToken().trim();
        if (!stringTokenizer.hasMoreTokens()) {
            return -1;
        }
        String string5 = stringTokenizer.nextToken().trim();
        if (string3.equals(string2) && string5.toLowerCase().equals("tcp")) {
            try {
                return Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }
}

