/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.apache.xbean.spring.generator.AttributeMapping;
import org.apache.xbean.spring.generator.ElementMapping;
import org.apache.xbean.spring.generator.GeneratorPlugin;
import org.apache.xbean.spring.generator.LogFacade;
import org.apache.xbean.spring.generator.NamespaceMapping;
import org.apache.xbean.spring.generator.Type;
import org.apache.xbean.spring.generator.Utils;

public class XsdGenerator
implements GeneratorPlugin {
    private final File destFile;
    private LogFacade log;

    public XsdGenerator(File destFile) {
        this.destFile = destFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(NamespaceMapping namespaceMapping) throws IOException {
        File file = this.destFile;
        this.log.log("Generating XSD file: " + file + " for namespace: " + namespaceMapping.getNamespace());
        PrintWriter out = new PrintWriter(new FileWriter(file));
        try {
            this.generateSchema(out, namespaceMapping);
        }
        finally {
            out.close();
        }
    }

    private void generateSchema(PrintWriter out, NamespaceMapping namespaceMapping) {
        out.println("<?xml version='1.0'?>");
        out.println("<!-- NOTE: this file is autogenerated by XBeans -->");
        out.println();
        out.println("<xs:schema elementFormDefault='qualified'");
        out.println("           targetNamespace='" + namespaceMapping.getNamespace() + "'");
        out.println("           xmlns:xs='http://www.w3.org/2001/XMLSchema'");
        out.println("           xmlns:tns='" + namespaceMapping.getNamespace() + "'>");
        Iterator iter = namespaceMapping.getElements().iterator();
        while (iter.hasNext()) {
            ElementMapping element = (ElementMapping)iter.next();
            this.generateElementMapping(out, namespaceMapping, element);
        }
        out.println();
        out.println("</xs:schema>");
    }

    private void generateElementMapping(PrintWriter out, NamespaceMapping namespaceMapping, ElementMapping element) {
        AttributeMapping attributeMapping;
        out.println();
        out.println("  <!-- element for type: " + element.getClassName() + " -->");
        String localName = element.getElementName();
        out.println("  <xs:element name='" + localName + "'>");
        if (!this.isEmptyString(element.getDescription())) {
            out.println("    <xs:annotation>");
            out.println("      <xs:documentation><![CDATA[");
            out.println("        " + element.getDescription());
            out.println("      ]]></xs:documentation>");
            out.println("    </xs:annotation>");
        }
        out.println("    <xs:complexType>");
        int complexCount = 0;
        Iterator iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            attributeMapping = (AttributeMapping)iterator.next();
            if (Utils.isSimpleType(attributeMapping.getType())) continue;
            ++complexCount;
        }
        if (complexCount > 0) {
            out.println("      <xs:sequence>");
            iterator = element.getAttributes().iterator();
            while (iterator.hasNext()) {
                attributeMapping = (AttributeMapping)iterator.next();
                if (Utils.isSimpleType(attributeMapping.getType())) continue;
                this.generateElementMappingComplexProperty(out, namespaceMapping, attributeMapping);
            }
            out.println("      </xs:sequence>");
        }
        iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            attributeMapping = (AttributeMapping)iterator.next();
            if (Utils.isSimpleType(attributeMapping.getType())) {
                this.generateElementMappingSimpleProperty(out, attributeMapping);
                continue;
            }
            if (attributeMapping.getType().isCollection()) continue;
            this.generateElementMappingComplexPropertyAsRef(out, attributeMapping);
        }
        this.generateIDAttributeMapping(out, namespaceMapping, element);
        out.println("      <xs:anyAttribute namespace='##other' processContents='lax'/>");
        out.println("    </xs:complexType>");
        out.println("  </xs:element>");
        out.println();
    }

    private boolean isEmptyString(String str) {
        if (str == null) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void generateIDAttributeMapping(PrintWriter out, NamespaceMapping namespaceMapping, ElementMapping element) {
        Iterator iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            AttributeMapping attributeMapping = (AttributeMapping)iterator.next();
            if (!"id".equals(attributeMapping.getAttributeName())) continue;
            return;
        }
        out.println("      <xs:attribute name='id' type='xs:ID'/>");
    }

    private void generateElementMappingSimpleProperty(PrintWriter out, AttributeMapping attributeMapping) {
        if (!this.isEmptyString(attributeMapping.getDescription())) {
            out.println("      <xs:attribute name='" + attributeMapping.getAttributeName() + "' type='" + Utils.getXsdType(attributeMapping.getType()) + "'>");
            out.println("        <xs:annotation>");
            out.println("          <xs:documentation><![CDATA[");
            out.println("            " + attributeMapping.getDescription());
            out.println("          ]]></xs:documentation>");
            out.println("        </xs:annotation>");
            out.println("      </xs:attribute>");
        } else {
            out.println("      <xs:attribute name='" + attributeMapping.getAttributeName() + "' type='" + Utils.getXsdType(attributeMapping.getType()) + "'/>");
        }
    }

    private void generateElementMappingComplexPropertyAsRef(PrintWriter out, AttributeMapping attributeMapping) {
        if (!this.isEmptyString(attributeMapping.getDescription())) {
            out.println("      <xs:attribute name='" + attributeMapping.getAttributeName() + "' type='xs:string'>");
            out.println("        <xs:annotation>");
            out.println("          <xs:documentation><![CDATA[");
            out.println("            " + attributeMapping.getDescription());
            out.println("          ]]></xs:documentation>");
            out.println("        </xs:annotation>");
            out.println("      </xs:attribute>");
        } else {
            out.println("      <xs:attribute name='" + attributeMapping.getAttributeName() + "' type='xs:string'/>");
        }
    }

    private void generateElementMappingComplexProperty(PrintWriter out, NamespaceMapping namespaceMapping, AttributeMapping attributeMapping) {
        Type type = attributeMapping.getType();
        List types = type.isCollection() ? Utils.findImplementationsOf(namespaceMapping, type.getNestedType()) : Utils.findImplementationsOf(namespaceMapping, type);
        String maxOccurs = type.isCollection() ? "unbounded" : "1";
        out.println("        <xs:element name='" + attributeMapping.getAttributeName() + "' minOccurs='0' maxOccurs='1'>");
        if (!this.isEmptyString(attributeMapping.getDescription())) {
            out.println("          <xs:annotation>");
            out.println("            <xs:documentation><![CDATA[");
            out.println("              " + attributeMapping.getDescription());
            out.println("            ]]></xs:documentation>");
            out.println("          </xs:annotation>");
        }
        out.println("          <xs:complexType>");
        if (types.isEmpty()) {
            out.println("            <xs:sequence minOccurs='0' maxOccurs='" + maxOccurs + "'><xs:any/></xs:sequence>");
        } else {
            out.println("            <xs:choice minOccurs='0' maxOccurs='" + maxOccurs + "'>");
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                ElementMapping element = (ElementMapping)iterator.next();
                out.println("              <xs:element ref='tns:" + element.getElementName() + "'/>");
            }
            out.println("              <xs:any/>");
            out.println("            </xs:choice>");
        }
        out.println("          </xs:complexType>");
        out.println("        </xs:element>");
    }

    public LogFacade getLog() {
        return this.log;
    }

    public void setLog(LogFacade log) {
        this.log = log;
    }
}

