/*
 * Decompiled with CFR 0.152.
 */
package de.superx.saiku.schema;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.sql.DataSource;
import mondrian.olap.Util;
import mondrian.spi.impl.FilterDynamicSchemaProcessor;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class SuperxDynamicSchemaProcessor
extends FilterDynamicSchemaProcessor {
    public static Logger logger = Logger.getLogger(SuperxDynamicSchemaProcessor.class);
    public static final String CUSTOM_FILE_NAME = "custom.xml";
    private JdbcTemplate jt;

    public SuperxDynamicSchemaProcessor() {
        DriverManagerDataSource ds = new DriverManagerDataSource("jdbc:apache:commons:dbcp:default");
        this.jt = new JdbcTemplate((DataSource)ds);
    }

    protected String filter(String schemaUrl, Util.PropertyList connectInfo, InputStream stream) throws Exception {
        logger.info((Object)("Processing Mondrian schema from " + schemaUrl));
        return super.filter(schemaUrl, connectInfo, stream);
    }

    public String processSchema(String schemaUrl, Util.PropertyList connectInfo) throws Exception {
        boolean dbInitalSchema;
        SqlRowSet rowSet;
        Date dbModified = null;
        String dbSchema = null;
        String originalDbSchema = "";
        String dbCustomization = null;
        String fileCustomization = "";
        String filePath = "/" + schemaUrl.substring(4);
        URL fileUrl = ((Object)((Object)this)).getClass().getResource(filePath);
        File file = new File(fileUrl.getFile());
        File customFile = new File(file.getParent() + File.separator + CUSTOM_FILE_NAME);
        if (customFile.canRead()) {
            fileCustomization = com.google.common.io.Files.toString((File)customFile, (Charset)Charsets.UTF_8);
        }
        String fileSchema = super.processSchema(schemaUrl, connectInfo);
        Boolean mondrianSchemaTableExists = (Boolean)this.jt.queryForObject("SELECT sp_table_exists('mondrian_schema') from xdummy;", Boolean.class);
        if (mondrianSchemaTableExists.booleanValue() && (rowSet = this.jt.queryForRowSet("SELECT schema,original_schema,customization,created FROM mondrian_schema WHERE created = (SELECT MAX(created) FROM mondrian_schema)")).next()) {
            dbSchema = rowSet.getString(1);
            originalDbSchema = rowSet.getString(2);
            dbCustomization = rowSet.getString(3);
            dbModified = rowSet.getDate(4);
        }
        boolean dbSchemaUpToDate = originalDbSchema == null || originalDbSchema.isEmpty() || fileSchema.equals(originalDbSchema);
        boolean dbCustomizationUpToDate = fileCustomization.isEmpty() || fileCustomization.equals(dbCustomization);
        boolean bl = dbInitalSchema = dbSchema == null;
        if (!dbSchemaUpToDate || !dbCustomizationUpToDate) {
            if (mondrianSchemaTableExists.booleanValue()) {
                boolean fileSchemaNewer = true;
                if (dbInitalSchema) {
                    logger.info((Object)"Initially saving schema to db.");
                } else {
                    long fileTime = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toMillis();
                    long dbTime = dbModified != null ? dbModified.getTime() : 0L;
                    boolean bl2 = fileSchemaNewer = fileTime - dbTime > 0L;
                }
                if (fileSchemaNewer || !dbCustomizationUpToDate) {
                    dbSchema = this.customize(fileCustomization, fileSchema);
                    if (dbSchema.equals(fileSchema)) {
                        logger.warn((Object)"customization didn't change schema. Not saving to db!");
                        logger.warn((Object)fileCustomization);
                        if (!dbInitalSchema) {
                            logger.warn((Object)"Using previous schema.");
                            return dbSchema;
                        }
                        logger.warn((Object)"Saving schema to db with empty customization.");
                        fileCustomization = "";
                    }
                    this.jt.update("INSERT INTO mondrian_schema (schema,original_schema,customization,created, node) VALUES(?, ?, ?, ?, ?)", new Object[]{dbSchema, fileSchema, fileCustomization, new java.util.Date(), "NA"});
                    logger.info((Object)"Saving changed schema from file system to db.");
                }
            } else {
                logger.warn((Object)"Database table for schema does not exist.\nFalling back to schema file without customizations.\n Please upgrade component 'kern' (Administration).");
                return fileSchema;
            }
        }
        logger.info((Object)"Loading schema from db");
        return dbSchema;
    }

    String customize(String customization, String schema) {
        if (customization == null || customization.isEmpty()) {
            return schema;
        }
        Document schemaDoc = null;
        Document customDoc = null;
        Document customizedSchemaDoc = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            schemaDoc = builder.build((Reader)new StringReader(schema));
            customDoc = builder.build((Reader)new StringReader(customization));
            List custDimensions = customDoc.getRootElement().getChildren("dimension");
            LinkedHashMap<String, DimensionCustomization> customDimensions = new LinkedHashMap<String, DimensionCustomization>();
            for (Object custDimension : custDimensions) {
                customDimensions.put(custDimension.getAttributeValue("name"), new DimensionCustomization((Element)custDimension));
            }
            List dimensions = schemaDoc.getRootElement().getChildren("Dimension");
            for (Element dimension : dimensions) {
                String caption = dimension.getAttribute("caption").getValue();
                if (!customDimensions.containsKey(caption)) continue;
                ((DimensionCustomization)customDimensions.get(caption)).setDimension(dimension);
            }
            customizedSchemaDoc = this.customizeSchema(customDimensions.values());
            List<String> sqlStatements = this.generateCustomizeSql(customDimensions.values());
            this.execSql(sqlStatements);
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't customize Mondrian schema. Using original schema. Please check custom.xml");
            logger.error((Object)"Error was: ", (Throwable)e);
            return schema;
        }
        XMLOutputter xmlOutputter = new XMLOutputter();
        xmlOutputter.setFormat(Format.getPrettyFormat());
        return xmlOutputter.outputString(customizedSchemaDoc);
    }

    List<String> generateCustomizeSql(Collection<DimensionCustomization> customizations) {
        ArrayList<String> sql = new ArrayList<String>();
        for (DimensionCustomization customization : customizations) {
            String dropSql = "DROP TABLE IF EXISTS " + customization.getTableName();
            String createSql = "CREATE TABLE " + customization.getTableName() + " AS (SELECT apnr,druck,sortorder FROM dim_bp_apnr WHERE dimension_bp_id = (select D.tid from dimension_bp D where D.apnr='" + customization.getDimensionName() + "') AND apnr!=0) ORDER BY 1";
            String updateSortorderSql = "UPDATE " + customization.getTableName() + " SET sortorder = 99998 WHERE sortorder IS NULL";
            sql.add(dropSql);
            sql.add(createSql);
            sql.add(updateSortorderSql);
            for (Element level : customization.getLevels()) {
                String levelLongNameAlpha = SuperxDynamicSchemaProcessor.stringToLowerAlpha(level.getAttributeValue("name"));
                String addColumnSql = "ALTER TABLE " + customization.getTableName() + " ADD COLUMN " + levelLongNameAlpha + " VARCHAR(255)";
                sql.add(addColumnSql);
                String addSortColumnSql = "ALTER TABLE " + customization.getTableName() + " ADD COLUMN " + levelLongNameAlpha + "_sort INTEGER";
                sql.add(addSortColumnSql);
                sql.addAll(this.getLevelMappings(level, customization.getDimensionName(), levelLongNameAlpha, customization.getTableName()));
            }
        }
        return sql;
    }

    Document customizeSchema(Collection<DimensionCustomization> customizations) {
        for (DimensionCustomization customization : customizations) {
            Element dimension = customization.getDimension();
            Element origHierarchy = dimension.getChild("Hierarchy");
            boolean removeOrigHierarchy = true;
            for (Element level : customization.getLevels()) {
                String levelLongName = level.getAttributeValue("name");
                String levelLongNameAlpha = SuperxDynamicSchemaProcessor.stringToLowerAlpha(levelLongName);
                Element table = new Element("Table");
                table.setAttribute(new Attribute("name", customization.getTableName()));
                Element lev = new Element("Level");
                lev.setAttributes(Arrays.asList(new Attribute("name", levelLongName), new Attribute("caption", levelLongName), new Attribute("column", levelLongNameAlpha), new Attribute("uniqueMembers", "false"), new Attribute("ordinalColumn", levelLongNameAlpha + "_sort")));
                XMLOutputter xmlOutputter = new XMLOutputter();
                xmlOutputter.setFormat(Format.getPrettyFormat());
                logger.debug((Object)("Original Hierarchy: " + xmlOutputter.outputString(origHierarchy)));
                if (!Boolean.parseBoolean(level.getAttributeValue("addToBaseHierarchy"))) {
                    Element hierarchy = new Element("Hierarchy");
                    hierarchy.setAttributes(Arrays.asList(new Attribute("hasAll", "true"), new Attribute("caption", levelLongName), new Attribute("name", levelLongName), new Attribute("allMemberName", "Insgesamt")));
                    List origLevels = origHierarchy.getChildren("Level");
                    Element origLevel = (Element)origLevels.get(origLevels.size() - 1);
                    hierarchy.addContent((Content)table);
                    hierarchy.addContent((Content)lev);
                    hierarchy.addContent((Content)origLevel.clone());
                    logger.debug((Object)("Adding new hierarchy " + xmlOutputter.outputString(hierarchy)));
                    dimension.addContent((Content)hierarchy);
                    continue;
                }
                Element origTable = origHierarchy.getChild("Table");
                origTable.detach();
                origHierarchy.addContent(0, (Content)table);
                origHierarchy.addContent(origHierarchy.getChildren().size() - 1, (Content)lev);
                logger.debug((Object)("Modifying hierarchy " + xmlOutputter.outputString(origHierarchy)));
                removeOrigHierarchy = false;
            }
            if (!removeOrigHierarchy) continue;
        }
        return customizations.iterator().next().getSchemaDocument();
    }

    List<String> getLevelMappings(Element levelElement, String dimensionName, String levelLongNameAlpha, String tableName) {
        ArrayList<String> sql = new ArrayList<String>();
        List members = levelElement.getChildren("member");
        int sort = 0;
        for (Element member : members) {
            String memberName = member.getAttributeValue("name");
            logger.warn((Object)("Getting mapping for member " + memberName));
            Iterable mapping = Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)member.getTextTrim());
            String m = "";
            for (String apnr : mapping) {
                if (apnr.startsWith("\"") && apnr.endsWith("\"")) {
                    apnr = this.getApnrForSourceId(dimensionName, apnr.replaceAll("\"", ""));
                }
                m = m + apnr + ",";
            }
            m = m.substring(0, m.length() - 1);
            String updateSql = "UPDATE " + tableName + " SET " + levelLongNameAlpha + "='" + memberName + "' WHERE apnr IN (" + m + ")";
            sql.add(updateSql);
            String updateSortSql = "UPDATE " + tableName + " SET " + levelLongNameAlpha + "_sort=" + sort + " WHERE " + levelLongNameAlpha + " = '" + memberName + "'";
            sql.add(updateSortSql);
            ++sort;
        }
        String emptyMemberName = levelElement.getAttributeValue("emptyMember");
        if (emptyMemberName != null && !emptyMemberName.isEmpty()) {
            String updateSql = "UPDATE " + tableName + " SET " + levelLongNameAlpha + "='" + emptyMemberName + "' WHERE " + levelLongNameAlpha + " is null";
            sql.add(updateSql);
        }
        return sql;
    }

    private void execSql(List<String> sqlStatements) {
        for (String sql : sqlStatements) {
            logger.warn((Object)("EXEC: " + sql));
            this.jt.execute(sql);
        }
    }

    String getApnrForSourceId(String bluep, String sourceId) {
        String query = "SELECT apnr FROM trans_dim_bp_apnr WHERE sourcesystem_id='" + sourceId + "' AND dimension_bp_id=(select D.tid from dimension_bp D where D.apnr='" + bluep + "')";
        logger.debug((Object)query);
        String apnr = (String)this.jt.queryForObject(query, String.class);
        return apnr == null || apnr.isEmpty() ? sourceId : apnr;
    }

    public void setDataSource(DataSource ds) {
        this.jt = new JdbcTemplate(ds);
    }

    public static String stringToLowerAlpha(String s) {
        return s.toLowerCase().replaceAll("[^a-z]", "");
    }

    public static class DimensionCustomization {
        private Element dimension;
        private Element custDimension;
        private String dimensionName;
        private String dimensionCaption;
        private String tableName;
        private List<Element> levels;

        public DimensionCustomization(Element dimension, Element custDimension) {
            this(custDimension);
            this.setDimension(dimension);
        }

        public DimensionCustomization(Element custDimension) {
            this.custDimension = custDimension;
            this.levels = custDimension.getChildren("level");
        }

        public void setDimension(Element dimension) {
            this.dimension = dimension;
            this.dimensionName = dimension.getAttributeValue("name");
            this.dimensionCaption = dimension.getAttributeValue("caption");
            this.tableName = "dim_" + this.dimensionName;
        }

        public Element getDimension() {
            return this.dimension;
        }

        public Element getCustomDimension() {
            return this.custDimension;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public String getDimensionCaption() {
            return this.dimensionCaption;
        }

        public String getTableName() {
            return this.tableName;
        }

        public List<Element> getLevels() {
            return this.levels;
        }

        public Document getSchemaDocument() {
            return this.dimension.getDocument();
        }
    }
}

