/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.coll.NamedIdObjectCollection;
import de.memtext.baseobjects.coll.NamedIdObjectList;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.tree.TreeEntryI;
import de.memtext.util.EqualsUtil;
import de.memtext.util.StringUtils;
import de.memtext.util.TreeUtils;
import de.superx.common.DBServletException;
import de.superx.common.SelectableItem;
import de.superx.common.SelectableItemNode;
import de.superx.common.SelectableItemTree;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SxPools;
import de.superx.servlet.XilParserServer;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HeaderManager
implements Serializable {
    private XilParserServer xilParser = new XilParserServer();
    private String headerDelim = "";
    private HeaderTree headerTree = new HeaderTree();

    public static void main(String[] args) {
    }

    public HeaderManager() {
    }

    public HeaderManager(String tmpxil) {
        this.setXilString(tmpxil);
    }

    public boolean hasTreeFunction() {
        return this.headerTree.hasTreeFunction();
    }

    public StringBuffer getHeaders(String tmpxil, String colset, String colsort, SuperX_el result_el, Hashtable formular, String mandantenID) throws SQLException, DBServletException, TemplateException, IOException, KeyParentEqualException, NoMainEntryException {
        StringBuffer headersconcated = new StringBuffer("\n<headersconcated><![CDATA[");
        this.headerTree.col.clear();
        if (tmpxil != null) {
            this.setXilString(tmpxil);
        }
        Vector V_header = this.xilParser.getHeaderVector();
        Vector V_width = this.xilParser.getWidths();
        Vector<Vector> V_xil = new Vector<Vector>();
        V_xil.addElement(V_header);
        V_xil.addElement(V_width);
        SxResultRow explanations = this.xilParser.getExplanations(mandantenID, true, 999);
        StringBuffer result = new StringBuffer("");
        this.headerDelim = "";
        this.addCompleteHeaders(result_el, formular, mandantenID, V_header, V_width, explanations, result);
        if (tmpxil != null) {
            this.headerTree.initTree(this.xilParser.getHiddenAggregationColumns());
        }
        if (this.headerTree.hasTreeFunction()) {
            colset = this.headerTree.getColset();
        }
        if (colset != null && !colset.trim().equals("") && !colset.trim().equalsIgnoreCase("restore")) {
            StringTokenizer st = new StringTokenizer(colset, "|");
            result.append("\n<!-- nur ausgew\u00e4hlte Header, in spezieller Reihenfolge-->\n<headers count=\"" + (st.countTokens() + 1) + "\" fixed_column_count=\"" + this.xilParser.getFixedColumnCount() + "\" colset=\"" + (colset == null ? "" : colset) + "\" colsort=\"" + (colsort == null ? "" : colsort) + "\" hasAggregationHeaders=\"" + (this.hasAggregationHeaders() ? "true" : "false") + "\" hasTreeFunction=\"" + (this.hasTreeFunction() ? "true" : "false") + "\">\n");
            while (st.hasMoreTokens()) {
                int trueColumn = result_el.getTrueColumnNumber(st.nextToken());
                SingleHeader s = this.getSingleHeader(trueColumn, result_el, formular, mandantenID, V_header, V_width, explanations);
                result.append(s.getXml());
                headersconcated.append(s.getName() + "\t");
            }
        } else {
            result.append("\n<!-- Header - keine Spalten ausgeblendet oder Reihenfolge umsortiert, entspricht also in diesem Fall complete_headers-->\n");
            result.append("\n<headers count=\"" + result_el.getColumnCount() + "\" fixed_column_count=\"" + this.xilParser.getFixedColumnCount() + "\" colset=\"" + (colset == null ? "" : colset) + "\" colsort=\"" + (colsort == null ? "" : colsort) + "\" hasAggregationHeaders=\"" + (this.hasAggregationHeaders() ? "true" : "false") + "\" hasTreeFunction=\"" + (this.hasTreeFunction() ? "true" : "false") + "\">\n");
            for (int i = 0; i < result_el.getColumnCount(); ++i) {
                SingleHeader s = this.getSingleHeader(i, result_el, formular, mandantenID, V_header, V_width, explanations);
                if (s == null) continue;
                result.append(s.getXml());
                headersconcated.append(s.getName() + "\t");
            }
            if (result.indexOf("\\000") > -1) {
                // empty if block
            }
        }
        result.append("</headers>\n");
        result.append(this.headerTree.getXML(result_el, V_width));
        headersconcated.append("]]>\n</headersconcated>\n");
        result.append(headersconcated);
        return result;
    }

    private boolean hasAggregationHeaders() {
        return this.xilParser.hasAggregationHeaders();
    }

    private void addCompleteHeaders(SuperX_el result_el, Hashtable formular, String mandantenID, Vector V_header, Vector V_width, SxResultRow explanations, StringBuffer result) throws SQLException, DBServletException, KeyParentEqualException {
        result.append("\n<!-- alle Header (inkl. evtl. ausgeblendeter Spalten f\u00fcr die keine Daten ausgegeben werden) in Original-Reihenfolge-->\n<complete_headers count=\"" + result_el.getColumnCount() + "\">\n");
        for (int i = 0; i < result_el.getColumnCount(); ++i) {
            SingleHeader s = this.getSingleHeader(i, result_el, formular, mandantenID, V_header, V_width, explanations);
            if (s == null) continue;
            result.append(s.getXml());
        }
        result.append("</complete_headers>\n");
    }

    private SingleHeader getSingleHeader(int trueColumn, SuperX_el result_el, Hashtable formular, String mandantenID, Vector V_header, Vector V_width, SxResultRow explanations) throws SQLException, DBServletException, KeyParentEqualException {
        StringBuffer xml = new StringBuffer();
        String header_str = "Unbekannte Spalte";
        String header_width = "20";
        try {
            header_str = V_header.elementAt(trueColumn).toString();
            header_width = V_width.elementAt(trueColumn).toString();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Warnung: unbekannte Spalte Nr. " + trueColumn);
        }
        if (!header_str.equals("Unbekannte Spalte")) {
            SxResultRow contents = new SxResultRow(0, 1);
            if (header_str.trim().startsWith("<<SQL>>")) {
                contents = this.getSqlHeader(header_str.substring(7), formular, mandantenID);
            } else {
                contents.add(0, header_str);
                contents.add(1, "");
            }
            if (contents.isEmpty()) {
                contents.add(0, "");
                contents.add(1, "");
            }
            String wert = contents.get(0).toString();
            String fname = result_el.getColumnNames()[trueColumn];
            String caption = contents.get(1).toString();
            this.headerTree.addEntryInclParents(wert, fname);
            String x = "<header id=\"" + trueColumn + "\" width=\"" + header_width + "\"><f_name><![CDATA[" + fname + "]]></f_name><wert><![CDATA[" + wert + "]]></wert><caption>" + caption + "</caption>";
            xml.append(x);
            this.headerDelim = this.headerDelim + "^" + wert;
            xml.append("<caption_long><![CDATA[");
            if (explanations.size() > 0) {
                String expl = "";
                try {
                    expl = (String)explanations.get(trueColumn);
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("Warnung: keine Explanation f\u00fcr Spalte Nr. " + trueColumn);
                }
                if (header_str.trim().startsWith("<<SQL>>")) {
                    expl = StringUtils.replace(expl, header_str, wert);
                }
                xml.append(expl);
            }
            xml.append("]]></caption_long>");
            xml.append("</header>\n");
            SingleHeader s = new SingleHeader(wert, xml.toString());
            if (caption != "") {
                s.setName(caption);
            }
            return s;
        }
        return null;
    }

    public void setXilString(String tmpxil) {
        this.xilParser.setXilString(tmpxil);
    }

    private SxResultRow getSqlHeader(String header_str, Hashtable formular, String mandantenID) throws SQLException, DBServletException {
        SxResultRow ret = new SxResultRow(0, 1);
        String select_string = SqlStringUtils.generateSQL(SxPools.get(mandantenID).getDatabaseAbbr(), formular, header_str);
        SuperX_el header_el = ServletUtils.execute_el("SQL f\u00fcr Spaltenkopf durchf\u00fchren", select_string, true, mandantenID);
        SxResultSet resultSet = header_el.getResultSet();
        if (!resultSet.isEmpty() && (ret = (SxResultRow)resultSet.first()).size() == 1) {
            ret.add(1, "");
        }
        return ret;
    }

    public String getColset() {
        return this.headerTree.getColset();
    }

    public void openHeader(String openHeader) {
        this.headerTree.openHeader(openHeader);
    }

    public void closeHeader(String closeHeader) {
        this.headerTree.closeHeader(closeHeader);
    }

    private class SingleHeader {
        String xml;
        String name;

        SingleHeader(String name, String xml) {
            this.name = name;
            this.xml = xml;
        }

        public void setName(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        String getXml() {
            return this.xml;
        }
    }

    private class HeaderData {
        private SelectableItemNode node;
        private String headerStr;
        private String colspanIndicator;
        private boolean log = false;
        private boolean isHidden = false;

        HeaderData(SelectableItemNode node, String headerStr, String colspanIndicator) {
            this.node = node;
            this.headerStr = headerStr;
            this.colspanIndicator = colspanIndicator;
        }

        public SelectableItemNode getNodeAtLevel(int rowlevel) {
            SelectableItemNode p = this.node;
            while (p.getLevel() > rowlevel + 2) {
                p = (SelectableItemNode)p.getParent();
            }
            return p;
        }

        void cut(String potHeader) {
            if (!this.headerStr.startsWith(potHeader)) {
                throw new IllegalArgumentException("must start with " + potHeader);
            }
            this.headerStr = this.headerStr.substring(0, potHeader.length());
        }

        HeaderData getRest(String potHeader) {
            if (!this.headerStr.startsWith(potHeader)) {
                throw new IllegalArgumentException("must start with " + potHeader);
            }
            if (this.log) {
                System.out.println("header:" + potHeader + " headerStr:" + potHeader);
            }
            HeaderData result = new HeaderData(this.node, "", this.colspanIndicator);
            if (this.headerStr.length() > potHeader.length()) {
                result = new HeaderData(this.node, this.headerStr.substring(potHeader.length() + this.colspanIndicator.length()), this.colspanIndicator);
            }
            return result;
        }

        boolean hasRest(String potHeader) {
            if (!this.headerStr.startsWith(potHeader)) {
                throw new IllegalArgumentException("must start with " + potHeader);
            }
            return this.headerStr.length() > potHeader.length();
        }

        String getPotHeader() {
            return this.headerStr.substring(0, this.headerStr.indexOf(this.colspanIndicator));
        }

        boolean startsWith(String str) {
            return this.headerStr.startsWith(str);
        }

        String substring(int begin, int end) {
            return this.headerStr.substring(begin, end);
        }

        int indexOf(String str) {
            return this.headerStr.indexOf(str);
        }

        public String toString() {
            return this.headerStr;
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (o != null && o instanceof HeaderData && this.toString().equals(o.toString())) {
                result = true;
            }
            return result;
        }

        public boolean isHidden() {
            return this.isHidden;
        }

        public void setHidden(boolean isHidden) {
            this.isHidden = isHidden;
        }
    }

    private class HeaderMatrix {
        private int colCount;
        private int rowCount;
        private int currRow;
        private HeaderData[][] headers;
        private String colspanIndicator;
        private boolean log = false;

        HeaderMatrix(List list, String colspanIndicator) {
            this.colspanIndicator = colspanIndicator;
            this.colCount = list.size();
            this.headers = new HeaderData[20][this.colCount];
            int col = 0;
            for (int i = 0; i < list.size(); ++i) {
                SelectableItemNode n = (SelectableItemNode)list.get(i);
                this.headers[this.currRow][col++] = new HeaderData(n, n.getName(), colspanIndicator);
            }
            boolean isAnotherRunNeeded = true;
            boolean isRowAdded = false;
            while (isAnotherRunNeeded) {
                isRowAdded = false;
                for (col = 0; col < this.colCount; ++col) {
                    HeaderData hd2;
                    HeaderData hd = this.headers[this.currRow][col];
                    if (hd == null || hd.indexOf(colspanIndicator) <= -1) continue;
                    String potHeader = hd.getPotHeader();
                    if (col >= this.colCount - 1 || !this.headers[this.currRow][col + 1].startsWith(potHeader)) continue;
                    int followingCol = col;
                    while (followingCol < this.colCount && (hd2 = this.headers[this.currRow][followingCol]) != null && hd2.startsWith(potHeader) && hd2.hasRest(potHeader)) {
                        if (this.log) {
                            System.out.println("row " + this.currRow + " col:" + followingCol + " get Rest");
                        }
                        this.headers[this.currRow + 1][followingCol] = hd2.getRest(potHeader);
                        hd2.cut(potHeader);
                        isRowAdded = true;
                        col = followingCol++;
                    }
                }
                if (isRowAdded) {
                    ++this.currRow;
                    continue;
                }
                isAnotherRunNeeded = false;
            }
            this.updateRowCount();
            this.fillInHiddenRowSpanElements();
        }

        private void fillInHiddenRowSpanElements() {
            for (int col = 0; col < this.colCount; ++col) {
                HeaderData r0 = this.headers[0][col];
                HeaderData hiddenCopy = new HeaderData(r0.node, new String(r0.node.getId().toString()), r0.colspanIndicator);
                hiddenCopy.setHidden(true);
                for (int row = 1; row < this.rowCount; ++row) {
                    if (this.headers[row][col] != null) continue;
                    this.headers[row][col] = hiddenCopy;
                }
            }
        }

        private void updateRowCount() {
            block0: for (int i = 0; i < this.headers.length; ++i) {
                for (int i2 = 0; i2 < this.colCount; ++i2) {
                    if (this.headers[i][i2] == null) continue;
                    ++this.rowCount;
                    continue block0;
                }
            }
        }

        public String toXML(SuperX_el result_el, Vector v_widths, HeaderTree tree) {
            StringBuffer result = new StringBuffer();
            for (int row = 0; row < this.rowCount; ++row) {
                result.append("<tr>");
                HeaderData lastHeader = new HeaderData((SelectableItemNode)tree.getModel().getRoot(), "dummyColForCompare", this.colspanIndicator);
                for (int col = 0; col < this.colCount; ++col) {
                    if (this.headers[row][col].isHidden()) {
                        result.append("<th class=\"header\" isHidden=\"true\" f_name=\"" + this.headers[row][col].node.getStrukturStr() + "\"" + this.getWidth(result_el, v_widths, row, col) + "><![CDATA[" + this.headers[row][col] + "]]></th>");
                        continue;
                    }
                    if (!this.headers[row][col].equals(lastHeader)) {
                        SelectableItemNode n;
                        lastHeader = this.headers[row][col];
                        result.append("<th class=\"header\" isHidden=\"false\" f_name=\"" + this.headers[row][col].node.getStrukturStr() + "\" ");
                        int rowspan = this.getRowSpan(row, col);
                        if (rowspan > 1) {
                            result.append(" rowspan=\"" + rowspan + "\"");
                        }
                        int colspan = this.getColSpan(row, col);
                        boolean isExpanded = false;
                        if (colspan > 1) {
                            result.append(" colspan=\"" + colspan + "\"");
                        }
                        if (tree.hasAggregationKid(n = lastHeader.getNodeAtLevel(row))) {
                            isExpanded = tree.isExpanded(new TreePath(n.getPath()));
                            result.append(" isopen=\"" + isExpanded + "\" ");
                            result.append(" id=\"" + n.getEscapedId() + "\" ");
                        }
                        result.append(this.getWidth(result_el, v_widths, row, col));
                        result.append(">");
                        result.append("<![CDATA[" + lastHeader + "]]>");
                        result.append("</th>");
                        continue;
                    }
                    result.append("<th class=\"header\" isHidden=\"true\" />");
                }
                result.append("</tr>");
            }
            StringUtils.replace(result, this.colspanIndicator, " ");
            return result.toString();
        }

        private String getWidth(SuperX_el result_el, Vector v_widths, int row, int col) {
            String result = "";
            HeaderData data = this.headers[row][col];
            HeaderData sub = this.headers[row + 1][col];
            if (sub == null || sub.isHidden()) {
                int trueColumn = result_el.getTrueColumnNumber(data.node.getStrukturStr());
                result = " width=\"" + v_widths.get(trueColumn) + "\"";
            }
            return result;
        }

        public String toMultiheadersString() {
            StringBuffer result = new StringBuffer();
            for (int row = 0; row < this.rowCount; ++row) {
                result.append("<table-row>");
                HeaderData lastHeader = new HeaderData(null, "dummyColForCompare", this.colspanIndicator);
                for (int col = 0; col < this.colCount; ++col) {
                    int colspan;
                    if (this.headers[row][col] == null || this.headers[row][col].equals(lastHeader)) continue;
                    lastHeader = this.headers[row][col];
                    result.append("<table-cell ");
                    int rowspan = this.getRowSpan(row, col);
                    if (rowspan > 1) {
                        result.append(" column-number=\"" + (col + 1) + "\" number-rows-spanned=\"" + rowspan + "\"");
                    }
                    if ((colspan = this.getColSpan(row, col)) > 1) {
                        result.append(" column-number=\"" + (col + 1) + "\" number-columns-spanned=\"" + colspan + "\"");
                    }
                    result.append("><block>");
                    result.append(lastHeader + "</block></table-cell>");
                }
                result.append("</table-row>");
            }
            StringUtils.replace(result, "\n", " ");
            StringUtils.replace(result, this.colspanIndicator, "x");
            return result.toString();
        }

        private int getColSpan(int row, int col) {
            int colspan = 1;
            for (int testcol = col + 1; testcol < this.colCount && this.headers[row][testcol] != null && this.headers[row][testcol].equals(this.headers[row][col]); ++testcol) {
                ++colspan;
            }
            return colspan;
        }

        private int getRowSpan(int row, int col) {
            int rowSpan = 1;
            for (int testrow = row + 1; testrow < this.rowCount && this.headers[testrow][col].isHidden(); ++testrow) {
                ++rowSpan;
            }
            return rowSpan;
        }
    }

    private class HeaderTree
    extends SelectableItemTree {
        private static final long serialVersionUID = 1L;
        private SelectableItemNode root;
        private NamedIdObjectCollection col = new NamedIdObjectList();
        private int counter = 0;

        private HeaderTree() {
        }

        private int maxShownLevel(SelectableItemNode node) {
            int maxLevel = node.getLevel() - 1;
            if (!this.hasTreeAggregationColumn(node)) {
                maxLevel = node.getLevel() - 1 + node.getDepth();
            } else {
                boolean isExp = this.isExpanded(new TreePath(node.getPath()));
                for (int i = 0; i < node.getChildCount(); ++i) {
                    SelectableItemNode n = (SelectableItemNode)node.getChildAt(i);
                    if ((!isExp || n.getStrukturInt() == 100) && (isExp || n.getStrukturInt() != 100)) continue;
                    maxLevel = Math.max(maxLevel, this.maxShownLevel(n));
                }
            }
            return maxLevel;
        }

        String getXML(SuperX_el result_el, Vector v_widths) {
            StringBuffer result = new StringBuffer();
            HeaderMatrix matrix = new HeaderMatrix(this.getList(), "\\000");
            result.append("<aggregationHeaders>" + matrix.toXML(result_el, v_widths, this) + "</aggregationHeaders>");
            return result.toString();
        }

        void initTree(String aggregationHeaders) throws NoMainEntryException, KeyParentEqualException {
            SelectableItem i = new SelectableItem("root", "root");
            this.root = new SelectableItemNode(i);
            this.root.removeAllChildren();
            i = new SelectableItem("", "alles");
            SelectableItemNode e1 = new SelectableItemNode(i);
            this.col.add(e1);
            TreeBuild tb = new TreeBuild();
            tb.addNodesToRoot(this.root, this.col);
            this.setModel(new DefaultTreeModel(this.root));
            TreeUtils.expandAll(this);
            if (aggregationHeaders != null) {
                StringTokenizer st = new StringTokenizer(aggregationHeaders, "|");
                while (st.hasMoreElements()) {
                    String h = st.nextToken();
                    if (!this.containsItemWithId(h)) {
                        throw new IllegalArgumentException("AggregationHeader " + h + " angegeben, aber keine entsprechende Spalte gefunden");
                    }
                    SelectableItemNode n = this.getById(h);
                    n.setStrukturInt(new Integer(100));
                }
            }
            Object n = null;
        }

        List getList() {
            LinkedList list = new LinkedList();
            Enumeration<? extends TreeNode> en = this.root.getChildAt(0).children();
            while (en.hasMoreElements()) {
                SelectableItemNode n = (SelectableItemNode)en.nextElement();
                this.append(list, n);
            }
            return list;
        }

        String getColset() {
            StringBuffer buf = new StringBuffer();
            Enumeration<? extends TreeNode> en = this.root.getChildAt(0).children();
            while (en.hasMoreElements()) {
                SelectableItemNode n = (SelectableItemNode)en.nextElement();
                this.append(buf, n);
            }
            return buf.toString();
        }

        private void append(List list, SelectableItemNode node) {
            if (node.isLeaf()) {
                list.add(node);
            } else if (!this.hasTreeAggregationColumn(node)) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    this.append(list, (SelectableItemNode)node.getChildAt(i));
                }
            } else {
                boolean isExp = this.isExpanded(new TreePath(node.getPath()));
                for (int i = 0; i < node.getChildCount(); ++i) {
                    SelectableItemNode n = (SelectableItemNode)node.getChildAt(i);
                    if (isExp && n.getStrukturInt() != 100) {
                        this.append(list, n);
                    }
                    if (isExp || n.getStrukturInt() != 100) continue;
                    this.append(list, n);
                }
            }
        }

        private void append(StringBuffer buf, SelectableItemNode node) {
            if (node.isLeaf()) {
                buf.append(node.getStrukturStr() + "|");
            } else if (!this.hasTreeAggregationColumn(node)) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    this.append(buf, (SelectableItemNode)node.getChildAt(i));
                }
            } else {
                boolean isExp = this.isExpanded(new TreePath(node.getPath()));
                for (int i = 0; i < node.getChildCount(); ++i) {
                    SelectableItemNode n = (SelectableItemNode)node.getChildAt(i);
                    if (isExp && n.getStrukturInt() != 100) {
                        this.append(buf, n);
                    }
                    if (isExp || n.getStrukturInt() != 100) continue;
                    this.append(buf, n);
                }
            }
        }

        boolean hasTreeFunction() {
            return this.hasTreeAggregationColumn((SelectableItemNode)this.getModel().getRoot());
        }

        private boolean hasTreeAggregationColumn(SelectableItemNode n) {
            boolean result = n.getStrukturInt() == 100;
            Enumeration<TreeNode> en = n.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                SelectableItemNode nkid = (SelectableItemNode)en.nextElement();
                if (nkid.getStrukturInt() != 100) continue;
                result = true;
                break;
            }
            return result;
        }

        public boolean hasAggregationKid(SelectableItemNode node) {
            boolean result = false;
            for (int i = 0; i < node.getChildCount(); ++i) {
                SelectableItemNode nkid = (SelectableItemNode)node.getChildAt(i);
                if (nkid.getStrukturInt() != 100) continue;
                result = true;
                break;
            }
            return result;
        }

        void addEntryInclParents(String header, String fname) throws KeyParentEqualException {
            if (header.equals("")) {
                header = " ";
            }
            if (!this.col.containsItemWithId(header)) {
                SelectableItem i = new SelectableItem(header, header);
                i.setEscapedId(new String("" + this.counter));
                ++this.counter;
                if (fname != null) {
                    i.setStrukturStr(fname);
                }
                this.col.add(new SelectableItemNode(i));
                int pos = header.lastIndexOf("\\000");
                if (pos > -1) {
                    i.setParentKey(header.substring(0, pos));
                    this.addEntryInclParents(header.substring(0, pos), null);
                } else {
                    i.setParentKey("");
                }
            }
        }

        private SelectableItemNode getByIdCounter(String key) {
            SelectableItemNode result = null;
            Enumeration<TreeNode> en = this.root.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                SelectableItemNode nkid = (SelectableItemNode)en.nextElement();
                if (!EqualsUtil.areEqual(key, nkid.getEscapedId())) continue;
                result = nkid;
                break;
            }
            if (result == null) {
                this.dumpErrorMsg(key);
                throw new IllegalArgumentException("Kein passender Header gefunden (Details s.catalina.out)");
            }
            return result;
        }

        public void openHeader(String key) {
            SelectableItemNode n = this.getByIdCounter(key);
            this.setExpandedState(new TreePath(n.getPath()), true);
        }

        private void dumpErrorMsg(String key) {
            System.out.println("Kein Header " + key + " gefunden, moeglich gewesen waeren:");
            Enumeration<TreeNode> en = this.root.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                SelectableItemNode nkid = (SelectableItemNode)en.nextElement();
                if (nkid == this.root || nkid.getName().equals("Alles")) continue;
                System.out.println("ID-Counter:" + nkid.getEscapedId() + " name:" + nkid.getName() + " (key:" + nkid.getKey() + ")");
            }
        }

        public void closeHeader(String key) {
            SelectableItemNode n = this.getByIdCounter(key);
            this.setExpandedState(new TreePath(n.getPath()), false);
        }
    }

    private class TreeBuild {
        private Collection _elementCollection;

        private TreeBuild() {
        }

        void addNodesToRoot(DefaultMutableTreeNode root, Collection elementCollection) throws NoMainEntryException, KeyParentEqualException {
            this._elementCollection = elementCollection;
            this.insertnodes(root, null);
        }

        private void insertnodes(DefaultMutableTreeNode presentNode, Object theParent) throws NoMainEntryException, KeyParentEqualException {
            if (this._elementCollection == null) {
                throw new RuntimeException("element collection is null, set it before");
            }
            Collection result = this.getEntries(theParent);
            if (theParent == null && result.size() == 0) {
                StringBuffer buf = new StringBuffer("These elements in collection\n");
                for (TreeEntryI element : this._elementCollection) {
                    buf.append(element.toString() + "\n");
                }
                throw new NoMainEntryException(buf.toString());
            }
            for (DefaultMutableTreeNode newNode : result) {
                presentNode.add(newNode);
                TreeEntryI newEntry = (TreeEntryI)((Object)newNode);
                Object keyOfNewNode = newEntry.getOwnKey();
                if (keyOfNewNode != null && theParent == null) {
                    this.insertnodes(newNode, keyOfNewNode);
                }
                if (keyOfNewNode == null && theParent == null) {
                    throw new KeyParentEqualException(newEntry);
                }
                if (keyOfNewNode == null || theParent == null) continue;
                if (!theParent.equals(keyOfNewNode)) {
                    this.insertnodes(newNode, keyOfNewNode);
                    continue;
                }
                throw new KeyParentEqualException(newEntry);
            }
        }

        private Collection getEntries(Object checkparent) {
            LinkedList<TreeEntryI> result = new LinkedList<TreeEntryI>();
            for (TreeEntryI anEntry : this._elementCollection) {
                Object entrysParent = anEntry.getParentKey();
                if (entrysParent == null && checkparent == null) {
                    result.add(anEntry);
                }
                if (entrysParent == null || checkparent == null || !entrysParent.equals(checkparent)) continue;
                result.add(anEntry);
            }
            return result;
        }
    }
}

