/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.LogUtils;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.AbstractWebserviceClient;
import de.superx.bin.SxConnection;
import de.superx.bin.SxTransformer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WebserviceClient
extends AbstractWebserviceClient {
    private boolean isDebug = false;
    private boolean isDBConnectionPossible = true;
    private Document document;
    private Set<String> newOrUpdatedObjects = new HashSet<String>();
    private Set<String> deletedObjects = new HashSet<String>();
    private String dbpropfile;
    private String objectClass;
    private String hsnr;
    private String changesURL;
    private String changesSOAP;
    private String xmlConfig;
    private String detailURL;
    private String detailSOAP;
    private String replaceNodeName;
    private String xsl;
    private String outfile;
    private String stammdatenstart = null;
    private boolean isDeleteTmpXmlFileWanted = true;
    private static final Logger log = Logger.getLogger("wc");
    private static final String FISTL_HIERARCHIE_INFO = "<EX_FMHISV> \n            <item> \n               <MANDT></MANDT> \n               <FIKRS></FIKRS> \n               <HIVARNT>000</HIVARNT> \n               <FISTL></FISTL> \n               <HIROOT_ST></HIROOT_ST> \n               <PARENT_ST/> \n               <NEXT_ST/> \n               <CHILD_ST/> \n               <HILEVEL>0001</HILEVEL> \n            </item> \n         </EX_FMHISV>";

    public static void main(String[] args) {
        System.out.println("SuperX-WebserviceClient Version 0.9.8");
        WebserviceClient tc = new WebserviceClient();
        tc.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        try {
            XMLUtils.getExceptionHandler().setWithGui(false);
            XMLUtils.getExceptionHandler().setExitWanted(true);
            LogUtils.initRawFileDateTime("wc", "WebserviceClient.log", 100000, 1, true, false);
            log.setLevel(Level.FINEST);
            log.getHandlers()[0].setLevel(Level.FINEST);
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent("-dbproperties,-xmlconfig,-xsl,-hsnr,-out");
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.exit(1);
            }
            this.readConfig();
            this.readChanges();
            if (this.isReplyOk()) {
                this.readObjectIdSets();
                if (this.isDBConnectionPossible) {
                    this.toDeletedObjectsTable();
                }
                this.writeChangeXml();
            } else {
                String msg = "Error: Aufruf von Webservice f\u00fcr " + this.xmlConfig + " fehlgeschlagen";
                System.out.println(msg);
                log.severe(msg);
                LogUtils.close("wc");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            System.out.println("Error " + e.getMessage());
            e.printStackTrace();
            LogUtils.close("wc");
            System.exit(1);
        }
        finally {
            LogUtils.close("wc");
        }
    }

    private void readChanges() throws Exception {
        String soapString = StringUtils.replace(this.changesSOAP, "XXOBJECT_CLASSXX", this.objectClass);
        String startDatum = this.getStartDatum();
        log.log(Level.INFO, "Startdatum " + startDatum);
        System.out.println("Startdatum " + startDatum);
        soapString = StringUtils.replace(soapString, "XXSTARTDATEXX", startDatum);
        soapString = StringUtils.replace(soapString, "XXTODAYXX", new Date(new java.util.Date().getTime()).toString());
        log.fine("SOAP Aufruf:\n" + soapString);
        String result = this.readSOAP(soapString, this.changesURL).toString();
        this.document = XMLUtils.buildDocumentFromString(result, false);
        log.finest("Geaenderte Objekte Klasse " + this.objectClass);
    }

    private void readConfig() {
        this.dbpropfile = GetOpts.getValue("-dbproperties");
        this.xmlConfig = GetOpts.getValue("-xmlconfig");
        this.outfile = GetOpts.getValue("-out");
        this.xsl = GetOpts.getValue("-xsl");
        this.hsnr = GetOpts.getValue("-hsnr");
        System.out.println("\n" + DateUtils.getTodayString() + " " + DateUtils.getNowString() + "\nHochschulnummer " + this.hsnr);
        log.info("\nHochschulnummer " + this.hsnr);
        if (GetOpts.isPresent("-nodelete")) {
            this.isDeleteTmpXmlFileWanted = false;
        }
        if (GetOpts.isPresent("-pause")) {
            String p = GetOpts.getValue("-pause");
            this.pause = Integer.parseInt(p);
            System.out.println("Pause between soap calls " + this.pause);
        }
        log.log(Level.INFO, "Verarbeite " + this.xmlConfig);
        System.out.println("Verarbeite " + this.xmlConfig);
        Document dconf = XMLUtils.buildDocument(new File(this.xmlConfig));
        Node n = XMLUtils.getFirstNode(dconf, "webservice");
        this.objectClass = XMLUtils.getAttribValue(n, "object_class");
        n = XMLUtils.getFirstNode(dconf, "changesurl");
        this.changesURL = XMLUtils.getTheValue(n);
        this.changesURL = this.adaptURL(this.changesURL);
        n = XMLUtils.getFirstNode(dconf, "changessoap");
        this.changesSOAP = XMLUtils.getTheValue(n);
        this.changesSOAP = StringUtils.replace(this.changesSOAP, "XXOBJECTICLASSXX", this.objectClass);
        n = XMLUtils.getFirstNode(dconf, "detailurl");
        this.detailURL = XMLUtils.getTheValue(n);
        this.detailURL = this.adaptURL(this.detailURL);
        n = XMLUtils.getFirstNode(dconf, "detailsoap");
        this.detailSOAP = XMLUtils.getTheValue(n);
        n = XMLUtils.getFirstNode(dconf, "replacenode");
        this.replaceNodeName = XMLUtils.getAttribValue(n, "from");
    }

    private void readObjectIdSets() {
        Node changehead = XMLUtils.getFirstNode(this.document, "CHANGEHEAD");
        Iterator it = XMLUtils.getChildNodeIterator(changehead);
        int i = 1;
        while (it.hasNext()) {
            Node item = (Node)it.next();
            String objectid = XMLUtils.getChildNodeValue(item, "OBJECTID");
            String change_ind = XMLUtils.getChildNodeValue(item, "CHANGE_IND");
            if (change_ind != null && change_ind.equals("D")) {
                this.deletedObjects.add(objectid);
            } else {
                this.newOrUpdatedObjects.add(objectid);
            }
            ++i;
        }
        System.out.println("Zu loeschen " + this.deletedObjects.size() + " neu/geaendert " + this.newOrUpdatedObjects.size());
        log.info("Anzahl zu loeschender Objekte " + this.deletedObjects.size());
        log.info("Anzahl zu neuer/geaenderter Objekte " + this.newOrUpdatedObjects.size());
    }

    private void writeChangeXml() throws Exception {
        File f = File.createTempFile("webservicedata", ".xml");
        if (!this.isDeleteTmpXmlFileWanted) {
            System.out.println("Temp Datei: " + f.getAbsolutePath());
            log.info("Temp Datei: " + f.getAbsolutePath());
        }
        if (f.exists()) {
            f.delete();
        }
        PrintWriter fw = new PrintWriter(f, "UTF-8");
        BufferedWriter bfw = new BufferedWriter(fw);
        bfw.write("<newdata>\n");
        int i = 0;
        int rownr = 1;
        System.out.println(DateUtils.getTodayString() + " " + DateUtils.getNowString());
        for (String objectId : this.newOrUpdatedObjects) {
            String reply = this.getSoapDetailRequest(objectId, i);
            if (++i % 10 == 0) {
                System.out.print(i + " ");
            }
            if (this.objectClass.equals("KSTAR") && reply.indexOf("<EX_CSKB/>") > -1 || reply.indexOf("<MESSAGE>Es wurden 0000 S") > -1) continue;
            if (this.objectClass.equals("FMFCTR")) {
                reply = this.patchMissingFistlHierarchieInfo(reply);
            }
            reply = WebserviceClient.purge(reply);
            reply = StringUtils.replace(reply, "<SOAP:Envelope", "<SOAP:Envelope rownr=\"" + rownr + "\" ");
            ++rownr;
            if (!this.isDebug && reply.indexOf("<TYPE>I</TYPE>") == -1) {
                System.out.println("Fehler bei Lesen von Object " + objectId);
                System.out.println(reply);
                bfw.close();
                fw.close();
                if (f.exists()) {
                    f.delete();
                }
                System.exit(-1);
            }
            bfw.write(reply.replaceAll("<\\?xml version=\"1.0\" encoding=\".*>", ""));
        }
        System.out.println("");
        bfw.write("\n</newdata>\n");
        bfw.close();
        fw.close();
        SxTransformer sxTrans = new SxTransformer(log, this.outfile);
        sxTrans.quellstring = f.getAbsolutePath();
        sxTrans.stylesheet = this.xsl;
        sxTrans.params = "ignoreElements=EX_JEST";
        sxTrans.transformFile("text");
        if (this.isDeleteTmpXmlFileWanted) {
            f.delete();
        }
        System.out.println("    fertig: " + DateUtils.getTodayString() + " " + DateUtils.getNowString());
    }

    private String patchMissingFistlHierarchieInfo(String input) {
        String output = StringUtils.replace(input, "<EX_FMHISV/>", FISTL_HIERARCHIE_INFO);
        return output;
    }

    private String getStartDatum() throws Exception {
        String result = "2000-01-01";
        if (this.isDBConnectionPossible) {
            SxConnection myConnection = new SxConnection();
            myConnection.setPropfile(this.dbpropfile);
            Connection con = myConnection.getConnection();
            Statement stm = con.createStatement();
            ResultSet rs = stm.executeQuery("select datum from systeminfo where tid=170");
            while (rs.next()) {
                Date o = rs.getDate(1);
                if (o == null) continue;
                result = ((Object)o).toString();
            }
            rs.close();
            stm.close();
            con.close();
        }
        if (System.getProperty("stammdatenstart") != null) {
            result = System.getProperty("stammdatenstart");
        }
        return result;
    }

    private void toDeletedObjectsTable() throws Exception {
        SxConnection myConnection = new SxConnection();
        myConnection.setPropfile(this.dbpropfile);
        Connection con = myConnection.getConnection();
        PreparedStatement pst = con.prepareStatement("insert into gxstage_delete_object (object_class,object_id) values (?,?)");
        for (String objectId : this.deletedObjects) {
            pst.clearParameters();
            pst.setString(1, this.objectClass);
            pst.setString(2, objectId);
            pst.execute();
        }
        pst.close();
        con.close();
    }

    private String getSoapDetailRequest(String objectid, int i) throws Exception {
        String id = objectid.substring(4);
        String id3 = "";
        if (objectid.length() > 8) {
            id3 = objectid.substring(8);
        }
        String soapxml = StringUtils.replace(this.detailSOAP, "IDPART1", objectid.substring(0, 4));
        soapxml = StringUtils.replace(soapxml, "IDPART2", id);
        soapxml = StringUtils.replace(soapxml, "IDPART3", id3);
        soapxml = StringUtils.replace(soapxml, "XXOBJECTIDXX", objectid);
        soapxml = StringUtils.replace(soapxml, "XXHSNRXX", this.hsnr);
        if (i == 0) {
            log.finest("1. SOAP Detailaufruf:\n" + soapxml);
        }
        String res = this.readSOAP(soapxml, this.detailURL).toString();
        String result = StringUtils.replace(res, this.replaceNodeName, "response");
        return result;
    }

    private boolean isReplyOk() {
        boolean result = false;
        Node type = XMLUtils.getFirstNode(this.document, "TYPE");
        if (XMLUtils.getTheValue(type).equals("I")) {
            result = true;
        }
        return result;
    }
}

