/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.FileUtils;
import de.memtext.util.GetOpts;
import de.superx.bin.SxConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.w3c.dom.Document;

public class SxJasper {
    private static Connection myDb;
    private static Statement st;
    private static DatabaseMetaData dbmd;
    private static boolean done;
    private static String taskName;
    private static String jrxmlFileName;
    private static String jasperFileName;
    private static String jrprintFileName;
    private static String XMLfileName;
    private static String XSLfileName;
    private static String ignorePagination;
    private static String params;
    private static String logfile;
    private static String dbpropfile;
    private static SxConnection myConnection;
    private static String db_driver;
    private static String outfile;
    private static Logger logger;
    private static final String TASK_COMPILE = "compile";
    private static final String TASK_FILL = "fill";
    private static final String TASK_PRINT = "print";
    private static final String TASK_PDF = "pdf";
    private static final String TASK_RTF = "rtf";
    private static final String TASK_XML = "xml";
    private static final String TASK_XML_EMBED = "xmlEmbed";
    private static final String TASK_HTML = "html";
    private static final String TASK_XLS = "xls";
    private static final String TASK_JXL = "jxl";
    private static final String TASK_CSV = "csv";
    private static final String TASK_RUN = "run";
    private static final String TASK_FILL_IGNORE_PAGINATION = "fillIgnorePagination";
    private static String usage;

    public static void go(String[] args) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        File f;
        if (args.length == 0) {
            throw new IllegalArgumentException("Mindestens drei Parameter (Pfad zu den logger.properties, Pfad zu den db.properties, outfile) erfoderlich");
        }
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent("-logger,-JRXML");
        if (isdrin != null) {
            System.err.println("Folgende Optionen fehlen: " + isdrin);
            System.err.println(usage);
            System.exit(1);
        }
        if (GetOpts.isPresent("-logger")) {
            logfile = GetOpts.getValue("-logger");
        }
        if (GetOpts.isPresent("-JRXML")) {
            jrxmlFileName = GetOpts.getValue("-JRXML");
        }
        jasperFileName = GetOpts.isPresent("-JASPER") ? GetOpts.getValue("-JASPER") : FileUtils.getFileNameWithoutSuffix(jrxmlFileName) + ".jasper";
        jrprintFileName = GetOpts.isPresent("-JRPRINT") ? GetOpts.getValue("-JRPRINT") : FileUtils.getFileNameWithoutSuffix(jrxmlFileName) + ".jrprint";
        if (GetOpts.isPresent("-XML")) {
            XMLfileName = GetOpts.getValue("-XML");
        }
        if (GetOpts.isPresent("-IGNORE_PAGINATION")) {
            ignorePagination = GetOpts.getValue("-IGNORE_PAGINATION");
        }
        if (GetOpts.isPresent("-XSL")) {
            XSLfileName = GetOpts.getValue("-XSL");
        }
        if (GetOpts.isPresent("-OUT")) {
            outfile = GetOpts.getValue("-OUT");
        }
        if (GetOpts.isPresent("-db_properties")) {
            dbpropfile = GetOpts.getValue("-db_properties");
        }
        if (GetOpts.isPresent("-param")) {
            params = GetOpts.getValue("-param");
        }
        if (!(f = new File(logfile)).exists()) {
            throw new IOException("Datei nicht gefunden: " + logfile);
        }
        FileInputStream ins = new FileInputStream(logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        logfile = MyLogManager.getProperty(".level");
        logger.info("Using Loggging-Level " + logfile);
        try {
            JRRtfExporter exporter;
            File destFile;
            JasperPrint jasperPrint;
            File sourceFile;
            long start = System.currentTimeMillis();
            if (!jrxmlFileName.equals("")) {
                if (jasperFileName.equals("")) {
                    jasperFileName = JasperCompileManager.compileReportToFile((String)jrxmlFileName);
                } else {
                    JasperCompileManager.compileReportToFile((String)jrxmlFileName, (String)jasperFileName);
                }
                logger.info("Compile time : " + (System.currentTimeMillis() - start));
            }
            if (!jasperFileName.equals("") && (GetOpts.isPresent("-db_properties") || GetOpts.isPresent("-XML"))) {
                logger.info("Filling " + jasperFileName);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                if (!XMLfileName.equals("")) {
                    logger.info("XML-Source " + XMLfileName);
                    Document document = JRXmlUtils.parse((File)new File(XMLfileName));
                    parameters.put("XML_DATA_DOCUMENT", document);
                    parameters.put("XML_DATE_PATTERN", "dd.MM.yyyy HH:mm:ss");
                    parameters.put("XML_NUMBER_PATTERN", "###0.00;-###0.00");
                    parameters.put("XML_LOCALE", Locale.GERMAN);
                    parameters.put("REPORT_LOCALE", Locale.GERMAN);
                } else {
                    SxJasper.getConnection(logger, dbpropfile);
                }
                if (ignorePagination.equals("true")) {
                    parameters.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
                }
                if (jrprintFileName.equals("")) {
                    jrprintFileName = JasperFillManager.fillReportToFile((String)jasperFileName, parameters, (Connection)myDb);
                } else {
                    JasperFillManager.fillReportToFile((String)jasperFileName, (String)jrprintFileName, parameters, (Connection)myDb);
                }
                logger.info("Filling time : " + (System.currentTimeMillis() - start));
            }
            if (outfile.endsWith(".prn")) {
                JasperPrintManager.printReport((String)jrprintFileName, (boolean)true);
                logger.info("Printing time : " + (System.currentTimeMillis() - start));
                System.exit(0);
            }
            if (outfile.endsWith(".pdf")) {
                JasperExportManager.exportReportToPdfFile((String)jrprintFileName, (String)outfile);
                logger.info("PDF creation time : " + (System.currentTimeMillis() - start));
                System.exit(0);
            }
            if (outfile.endsWith(".rtf")) {
                sourceFile = new File(jrprintFileName);
                jasperPrint = (JasperPrint)JRLoader.loadObject((File)sourceFile);
                destFile = new File(sourceFile.getParent(), outfile);
                exporter = new JRRtfExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)destFile.toString());
                exporter.exportReport();
                logger.info("RTF creation time : " + (System.currentTimeMillis() - start));
                System.exit(0);
            }
            if (outfile.endsWith(".xml")) {
                JasperExportManager.exportReportToXmlFile((String)jrprintFileName, (String)outfile, (boolean)false);
                logger.info("XML creation time : " + (System.currentTimeMillis() - start));
                System.exit(0);
            }
            if (outfile.endsWith(".htm") || outfile.endsWith(".html")) {
                JasperExportManager.exportReportToHtmlFile((String)jrprintFileName, (String)outfile);
                logger.info("HTML creation time : " + (System.currentTimeMillis() - start));
                System.exit(0);
            }
            if (outfile.endsWith(".xls")) {
                sourceFile = new File(jrprintFileName);
                jasperPrint = (JasperPrint)JRLoader.loadObject((File)sourceFile);
                destFile = new File(sourceFile.getParent(), outfile);
                exporter = new JRXlsExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)destFile.toString());
                exporter.exportReport();
                logger.info("XLS creation time : " + (System.currentTimeMillis() - start));
                System.exit(0);
            }
            if (outfile.endsWith(".csv")) {
                sourceFile = new File(jrprintFileName);
                jasperPrint = (JasperPrint)JRLoader.loadObject((File)sourceFile);
                destFile = new File(sourceFile.getParent(), outfile);
                exporter = new JRCsvExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)destFile.toString());
                exporter.exportReport();
                logger.info("CSV creation time : " + (System.currentTimeMillis() - start));
                System.exit(0);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        logger.info("SxJasper erfolgreich beendet");
    }

    public static void instructions() {
        System.out.println("SuperX 5.2\n");
        System.out.println("\nDieses Java-Programm f\u00fchrt einen SQL-Ausdruck aus und gibt das Ergebnis aus.\n");
        System.out.println("Gebrauch:\n java doquery <Pfad zu logger-properties> <pfad zu db.properties> <sql-Ausdruck> <Ausgabeformat (txt | html | xml)>(optional) <delimiter> <mit Spalten\u00fcberschriften (true | false)>(optional) <Ausgabedatei>(optional)\n");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            SxJasper.go(args);
        }
        catch (Exception ex) {
            System.err.println("SxJasper Aufruf fehlgeschlagen.\n" + ex);
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static void getConnection(Logger logger, String propFile) throws SQLException {
        myConnection = new SxConnection();
        myConnection.setPropfile(propFile);
        logger.config("Starting Connection...");
        try {
            myDb = myConnection.getConnection();
            st = myDb.createStatement();
            dbmd = myDb.getMetaData();
        }
        catch (Exception e) {
            logger.severe("Keine DB-Verbindung: " + e.toString());
            throw new SQLException("Keine DB-Verbindung: " + e.toString());
        }
        db_driver = SxJasper.myConnection.m_DriverClass;
    }

    static {
        done = false;
        taskName = TASK_RUN;
        jrxmlFileName = "";
        jasperFileName = "";
        jrprintFileName = "";
        XMLfileName = "";
        XSLfileName = "";
        ignorePagination = "";
        params = "";
        logfile = "../conf/logging.properties";
        dbpropfile = "../conf/db.properties";
        myConnection = null;
        outfile = "";
        logger = Logger.getLogger(SxJasper.class.toString());
        usage = "-------------------------------------\nGebrauch: java de.superx.bin.SxJasper -logger=<<Pfad zu logging.properties>> -JRXML=<<jrxml-Datei>> -OUT=<<Ausgabedatei>>(optional) \n---------------------------------------------------";
    }
}

