/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.widgets;

import de.memtext.util.DateUtils;
import de.memtext.widgets.VerticalBox;
import de.memtext.widgets.WarningMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public abstract class StandBox
extends VerticalBox {
    protected JLabel lblStand = new JLabel();
    protected JButton btnStand;
    private boolean isStandChanged;

    protected StandBox() {
        this.addWithCenterAlignment(this.lblStand);
        this.btnStand = new JButton("Stand \u00e4ndern");
        this.btnStand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String neuerStand = JOptionPane.showInputDialog(StandBox.this.lblStand, "Neues Datum eingeben:", "Stand \u00e4ndern", 3);
                if (neuerStand == null) {
                    return;
                }
                if (!DateUtils.isValidDateStrict(neuerStand)) {
                    WarningMessage.show((Component)StandBox.this.lblStand, neuerStand + " ist kein g\u00fcltiges Datum\nBitte im Format tt.mm.jjjj eingeben", "Stand\u00e4nderung");
                } else {
                    try {
                        StandBox.this.performStandChange(neuerStand);
                        StandBox.this.lblStand.setText(neuerStand);
                    }
                    catch (Exception e) {
                        WarningMessage.show((Component)StandBox.this.lblStand, "Stand\u00e4nderung fehlgeschlagen.\n" + e.toString(), "Stand\u00e4nderung");
                    }
                }
            }
        });
        this.addWithCenterAlignment(this.btnStand);
    }

    public void setStandLblText(Date stand) {
        this.lblStand.setText("Stand: " + DateUtils.format(stand));
    }

    protected abstract void performStandChange(String var1) throws Exception;

    public boolean isStandChanged() {
        return this.isStandChanged;
    }

    public void setStandChanged(boolean isStandChanged) {
        this.isStandChanged = isStandChanged;
    }
}

