/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.Normalizer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class StringUtils {
    private static final String TAB_00C0 = "AAAA\u00c4AACEEEEIIIIDNOOOO\u00d6\u00d7OUUU\u00dcYT\u00dfaaaa\u00e4aaceeeeiiiidnoooo\u00f6\u00f7ouuu\u00fcytyAaAaAaCcCcCcCcDdDdEeEeEeEeEeGgGgGgGgHhHhIiIiIiIiIiJjJjKkkLlLlLlLlLlNnNnNnnNnOoOoOoOoRrRrRrSsSsSsSsTtTtTtUuUuUuUuUuUuWwYyYZzZzZzs";
    private static final HashMap<Character, String> LIGATURES = new HashMap<Character, String>(){
        {
            this.put(Character.valueOf('\u00e6'), "ae");
            this.put(Character.valueOf('\u0153'), "oe");
            this.put(Character.valueOf('\u00fe'), "th");
            this.put(Character.valueOf('\u0133'), "ij");
            this.put(Character.valueOf('\u00f0'), "dh");
            this.put(Character.valueOf('\u00c6'), "AE");
            this.put(Character.valueOf('\u0152'), "OE");
            this.put(Character.valueOf('\u00de'), "TH");
            this.put(Character.valueOf('\u00d0'), "DH");
            this.put(Character.valueOf('\u0132'), "IJ");
        }
    };

    private StringUtils() {
    }

    public static String removeAllButUmlauts(String value) {
        String source = value;
        value = Normalizer.normalize(value, Normalizer.Form.NFC);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            String l = LIGATURES.get(Character.valueOf(c));
            if (l != null) {
                sb.append(l);
                continue;
            }
            if (c < '\u00c0' || c == '\u00d8') {
                sb.append(c);
                continue;
            }
            if (c >= '\u00c0' && c <= '\u017f') {
                c = TAB_00C0.charAt(c - 192);
                sb.append(c);
                continue;
            }
            l = Normalizer.normalize(Character.toString(c), Normalizer.Form.NFKD).replaceAll("[\\p{InCombiningDiacriticalMarks}]+", "");
            sb.append(l);
        }
        return sb.toString();
    }

    public static String javascriptUmlautAdapt(String in) {
        StringBuffer sb = new StringBuffer();
        block9: for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            switch (ch) {
                case '\u00e4': {
                    sb.append("\\344");
                    continue block9;
                }
                case '\u00c4': {
                    sb.append("\\304");
                    continue block9;
                }
                case '\u00f6': {
                    sb.append("\\366");
                    continue block9;
                }
                case '\u00d6': {
                    sb.append("\\326");
                    continue block9;
                }
                case '\u00fc': {
                    sb.append("\\374");
                    continue block9;
                }
                case '\u00dc': {
                    sb.append("\\334");
                    continue block9;
                }
                case '\u00df': {
                    sb.append("\\337");
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String jsonAdapt(String in, boolean isJavascriptUmlautEncodingWanted) {
        StringBuffer sb = new StringBuffer();
        block17: for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            switch (ch) {
                case '\u00e4': {
                    if (isJavascriptUmlautEncodingWanted) {
                        sb.append("\\344");
                        continue block17;
                    }
                    sb.append("\u00e4");
                    continue block17;
                }
                case '\u00c4': {
                    if (isJavascriptUmlautEncodingWanted) {
                        sb.append("\\304");
                        continue block17;
                    }
                    sb.append("\u00c4");
                    continue block17;
                }
                case '\u00f6': {
                    if (isJavascriptUmlautEncodingWanted) {
                        sb.append("\\366");
                        continue block17;
                    }
                    sb.append("\u00f6");
                    continue block17;
                }
                case '\u00d6': {
                    if (isJavascriptUmlautEncodingWanted) {
                        sb.append("\\326");
                        continue block17;
                    }
                    sb.append("\u00d6");
                    continue block17;
                }
                case '\u00fc': {
                    if (isJavascriptUmlautEncodingWanted) {
                        sb.append("\\374");
                        continue block17;
                    }
                    sb.append("\u00fc");
                    continue block17;
                }
                case '\u00dc': {
                    if (isJavascriptUmlautEncodingWanted) {
                        sb.append("\\334");
                        continue block17;
                    }
                    sb.append("\u00dc");
                    continue block17;
                }
                case '\u00df': {
                    if (isJavascriptUmlautEncodingWanted) {
                        sb.append("\\337");
                        continue block17;
                    }
                    sb.append("\u00df");
                    continue block17;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block17;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block17;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block17;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block17;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block17;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block17;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block17;
                }
                case '/': {
                    sb.append("\\/");
                    continue block17;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block17;
                    }
                    sb.append(ch);
                }
            }
        }
        String result = sb.toString();
        if (isJavascriptUmlautEncodingWanted) {
            result = StringUtils.javascriptUmlautAdapt(result);
        }
        return result;
    }

    public static void replace(StringBuffer buf, String token, String newval) {
        if (token == null) {
            throw new IllegalArgumentException("Token must not be null");
        }
        if (newval == null) {
            throw new IllegalArgumentException("newval must not be null");
        }
        if (token.equals(newval)) {
            throw new IllegalArgumentException("token and newval must not be equal");
        }
        boolean replaced = false;
        int start = 0;
        block3: while (!replaced) {
            start = buf.toString().indexOf(token, start);
            switch (start) {
                case -1: {
                    replaced = true;
                    continue block3;
                }
            }
            int end = start + token.length();
            buf.replace(start, end, newval);
            start += newval.length();
        }
    }

    public static String nvl(String input, String nvl) {
        if (input == null) {
            return nvl;
        }
        return input;
    }

    public static String readFile(File f) throws IOException {
        String line;
        FileReader fr = new FileReader(f);
        BufferedReader bfr = new BufferedReader(fr);
        StringBuffer result = new StringBuffer();
        while ((line = bfr.readLine()) != null) {
            result.append(line + "\n");
        }
        bfr.close();
        fr.close();
        return result.toString();
    }

    public static void write(File f, String text) throws IOException {
        FileWriter fw = new FileWriter(f);
        BufferedWriter bfw = new BufferedWriter(fw);
        bfw.write(text);
        bfw.close();
        fw.close();
    }

    public static boolean containsTags(String source) {
        boolean result = false;
        if (source != null) {
            int startpos = 0;
            while (source.indexOf("<", startpos) > -1) {
                int tagend = source.indexOf(">", startpos = source.indexOf("<", startpos));
                if (tagend > -1 && tagend > startpos + 1 && source.substring(startpos, tagend).indexOf(" ") == -1) {
                    result = true;
                    break;
                }
                if (tagend > -1) {
                    startpos = tagend + 1;
                    continue;
                }
                ++startpos;
            }
            if (source.indexOf("javascript") > -1) {
                result = true;
            }
            if (source.indexOf("\u0000") > -1) {
                result = true;
            }
        }
        return result;
    }

    public static String replace(String text, String token, String newval) {
        StringBuffer buf = new StringBuffer(text);
        StringUtils.replace(buf, token, newval);
        return buf.toString();
    }

    public static Character getLastNonSpaceChar(String txt) {
        Character result = null;
        for (int pos = txt.length() - 1; pos > -1; --pos) {
            if (txt.charAt(pos) == ' ') continue;
            result = new Character(txt.charAt(pos));
            break;
        }
        return result;
    }

    public static char getLastChar(StringBuffer buf) {
        if (buf == null || buf.length() == 0) {
            throw new IllegalArgumentException("Leerer Buffer");
        }
        return buf.charAt(buf.length() - 1);
    }

    public static void deleteLastChar(StringBuffer buf) {
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
    }

    public static String deleteLastChar(String txt) {
        String result = txt;
        if (txt.length() > 0) {
            result = txt.substring(0, txt.length() - 1);
        }
        return result;
    }

    public static LinkedList getStringTokenizedList(String source, String delim) {
        LinkedList<String> result = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(source, delim);
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            result.add(next);
        }
        return result;
    }

    public static String toCommaList(Collection c) {
        StringBuffer msg = new StringBuffer();
        for (Object o : c) {
            msg.append(o + ",");
        }
        if (msg.length() > 1) {
            StringUtils.removeFromEnd(msg, ",", true);
        }
        return msg.toString();
    }

    public static void printInt(String x) {
        char ch;
        int i;
        for (i = 0; i < x.length(); ++i) {
            ch = x.charAt(i);
            System.out.print(x.charAt(i) + ",");
        }
        for (i = 0; i < x.length(); ++i) {
            ch = x.charAt(i);
            System.out.print(ch + ",");
        }
    }

    public static String trimLength(String input, int len) {
        if (input != null) {
            input = input.substring(0, Math.min(len, input.length()));
        }
        return input;
    }

    public static void main(String[] a) {
        String value = "Dr. Esta\u00f1a \u00f6\u00e4\u00fc \u00c4\u00d6\u00dc \u00df";
        String p = StringUtils.removeAllButUmlauts(value);
        System.out.println(p);
    }

    public static int count(String base, String searchFor) {
        int pos = base.indexOf(searchFor);
        int result = 0;
        while (pos > -1) {
            ++result;
            if (pos < base.length() - 1) {
                pos = base.indexOf(searchFor, pos + searchFor.length());
                continue;
            }
            pos = -1;
        }
        return result;
    }

    public static void removeFromEnd(StringBuffer source, String removeIt, boolean isExceptionWanted) {
        if (source.length() < removeIt.length()) {
            throw new IllegalArgumentException("Source: " + source + " is shorter than " + removeIt);
        }
        if (isExceptionWanted && !source.substring(source.length() - removeIt.length()).equals(removeIt)) {
            throw new IllegalArgumentException("Source: " + source + " doesn't end with " + removeIt);
        }
        source.setLength(source.length() - removeIt.length());
    }

    public static String removeFromEnd(String source, String removeIt, boolean isExceptionWanted) {
        if (source.length() < removeIt.length()) {
            throw new IllegalArgumentException("Source: " + source + " is shorter than " + removeIt);
        }
        if (isExceptionWanted && !source.endsWith(removeIt)) {
            throw new IllegalArgumentException("Source: " + source + " doesn't end with " + removeIt);
        }
        return source.substring(0, source.length() - removeIt.length());
    }

    public static void removeLastChar(StringBuffer buf) {
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
    }

    public static String filterOutput(String output) {
        if (output != null) {
            output = StringUtils.replace(output, "&", "&amp;");
            output = StringUtils.replace(output, "<", "&lt;");
            output = StringUtils.replace(output, ">", "&gt;");
            output = StringUtils.replace(output, "\"", "&quot;");
            output = StringUtils.replace(output, "'", "&#39;");
        }
        return output;
    }

    public static boolean isNullOrEmpty(String test) {
        return test == null || test.trim().isEmpty();
    }
}

