/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import java.io.File;
import java.io.FileFilter;
import java.util.StringTokenizer;

public class FilenamesFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private String description;
    private String endings;
    private String beginning;
    private boolean isAllDirsAccepted = true;

    public FilenamesFilter(String description, String endings) {
        this(description, endings, null);
    }

    public FilenamesFilter(String description, String endings, String beginning) {
        this.description = description;
        this.endings = endings;
        this.beginning = beginning;
    }

    @Override
    public boolean accept(File file) {
        boolean result = false;
        if (file.isDirectory() && this.isAllDirsAccepted) {
            result = true;
        }
        if (this.beginning == null) {
            if (this.isEndingOk(file.getName())) {
                result = true;
            }
        } else if (file.getName().startsWith(this.beginning) && this.isEndingOk(file.getName())) {
            result = true;
        }
        return result;
    }

    private boolean isEndingOk(String filename) {
        boolean result = false;
        StringTokenizer st = new StringTokenizer(this.endings, "|");
        while (st.hasMoreTokens()) {
            String ending = st.nextToken();
            if (!filename.endsWith(ending)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean isAllDirsAccepted() {
        return this.isAllDirsAccepted;
    }

    public void setAllDirsAccepted(boolean isDirAccepted) {
        this.isAllDirsAccepted = isDirAccepted;
    }
}

