/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.util.TimeUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    protected static DateFormat df = new SimpleDateFormat("dd.MM.yy");
    protected static DateFormat dfLong = new SimpleDateFormat("dd.MM.yyyy");
    protected static DateFormat dfUS = new SimpleDateFormat("yyyy-MM-dd");
    protected static DateFormat dfDateTimeUS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected static DateFormat dfTime = new SimpleDateFormat("hh:mm:ss");
    protected static DateFormat dfDateTime = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    protected static DateFormat dfDay = new SimpleDateFormat("dd");
    protected static DateFormat dfMonth = new SimpleDateFormat("MM");
    protected static DateFormat dfYear = new SimpleDateFormat("yyyy");

    protected DateUtils() {
    }

    public static String getNowString() {
        return TimeUtils.getNowString();
    }

    public static String getDay(java.sql.Date date) {
        return dfDay.format(date);
    }

    public static String getMonth(java.sql.Date date) {
        return dfMonth.format(date);
    }

    public static String getYear(java.sql.Date date) {
        return dfYear.format(date);
    }

    public static String toCommaSeparatedList(java.sql.Date date) {
        return DateUtils.getDay(date) + "," + DateUtils.getMonth(date) + "," + DateUtils.getYear(date);
    }

    public static Date create(String datestr) {
        java.sql.Date d = null;
        try {
            d = DateUtils.parse(datestr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return d;
    }

    public static java.sql.Date parse(String dateStr) throws ParseException {
        if (dateStr.equals("") || dateStr == null) {
            throw new ParseException("\"\" is unparseable", 0);
        }
        Date dt = df.parse(dateStr);
        return new java.sql.Date(dt.getTime());
    }

    public static java.sql.Date parseStrict(String dateStr) throws ParseException {
        if (dateStr.equals("") || dateStr == null) {
            throw new ParseException("\"\" is unparseable", 0);
        }
        Date dt = dfLong.parse(dateStr);
        return new java.sql.Date(dt.getTime());
    }

    public static String format(java.sql.Date date) {
        if (date == null) {
            return null;
        }
        return dfLong.format(date);
    }

    public static boolean isToday(String dateStr) throws ParseException {
        java.sql.Date d = DateUtils.parse(dateStr);
        return DateUtils.format(d).equals(DateUtils.format(new Date()));
    }

    public static boolean isValidDate(String dateString) {
        boolean result = true;
        try {
            java.sql.Date d = DateUtils.parse(dateString);
            if (d.getYear() > 10000) {
                result = false;
            }
        }
        catch (ParseException e) {
            result = false;
        }
        return result;
    }

    public static boolean isDateInFuture(java.sql.Date date) {
        return date.getTime() > new Date().getTime();
    }

    public static boolean isDateInFuture(Date date) {
        return date.getTime() > new Date().getTime();
    }

    public static boolean isValidDateStrict(String dateString) {
        boolean result = true;
        try {
            java.sql.Date d = DateUtils.parseStrict(dateString);
            if (d.getYear() > 10000) {
                result = false;
            }
        }
        catch (ParseException e) {
            result = false;
        }
        return result;
    }

    public static String getTodayString() {
        return DateUtils.format(new java.sql.Date(new Date().getTime()));
    }

    public static void main(String[] a) {
    }

    public static String formatGerman(Date date) {
        return DateFormat.getDateInstance(2, Locale.GERMANY).format(date);
    }

    public static String formatUS(Date date) {
        if (date == null) {
            return null;
        }
        return dfUS.format(date);
    }

    public static Date dateTimeParse(String dateStr) throws ParseException {
        if (dateStr.equals("") || dateStr == null) {
            return null;
        }
        return dfDateTime.parse(dateStr);
    }

    public static String dateTimeFormat(Date date) {
        if (date == null) {
            return null;
        }
        return dfDateTime.format(date);
    }

    public static String dateTimeFormatUS(Date date) {
        if (date == null) {
            return null;
        }
        return dfDateTimeUS.format(date);
    }

    public static Date makeFutureDate(java.sql.Date date, int daysLater) {
        Calendar dateOnCalendar = Calendar.getInstance();
        dateOnCalendar.setTime(date);
        dateOnCalendar.add(5, daysLater);
        return dateOnCalendar.getTime();
    }

    public static String format(Date date) {
        if (date == null) {
            return null;
        }
        return dfLong.format(date);
    }

    static {
        df.setLenient(true);
        dfLong.setLenient(false);
    }
}

