/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree.admin;

import de.memtext.dlg.OkCancelDlg;
import de.memtext.tree.admin.EntryNode;
import de.memtext.tree.admin.Field;
import de.memtext.util.WindowUtils;
import de.memtext.widgets.LabeledTextField;
import de.memtext.widgets.MultilineEditPanel;
import de.memtext.widgets.WarningMessage;
import java.awt.Frame;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class EditDlg
extends OkCancelDlg {
    private LabeledTextField keyTextField;
    private LabeledTextField nameTextField;
    private EntryNode anEntry;
    private List editFields;

    public EditDlg(Frame f, EntryNode anEntry) {
        super(f, "Bearbeiten");
        this.anEntry = anEntry;
        this.setCenter(this.getCenterPanel());
        this.pack();
        WindowUtils.center(this);
    }

    private void copyValuesToEntry() throws IllegalArgumentException {
        this.anEntry.setName(this.nameTextField.getValue().toString());
        this.anEntry.setKey(this.keyTextField.getValue());
        for (EditField ef : this.editFields) {
            ef.updateField();
        }
    }

    private JComponent getCenterPanel() {
        MultilineEditPanel editp = new MultilineEditPanel();
        this.nameTextField = new LabeledTextField("Name: ", this.anEntry.getName());
        editp.add(this.nameTextField);
        this.keyTextField = new LabeledTextField("Key: ", this.anEntry.getKey(), 12);
        this.keyTextField.add(new JLabel("key of parent: " + this.anEntry.getParentKey(), 0));
        editp.add(this.keyTextField);
        this.editFields = new LinkedList();
        Iterator it = this.anEntry.fieldIterator();
        while (it.hasNext()) {
            Field f = (Field)it.next();
            EditField ef = new EditField(f);
            this.editFields.add(ef);
            editp.add(ef);
        }
        if (this.anEntry.getErrorInfo() != null) {
            JLabel lbl = new JLabel(this.anEntry.getErrorInfo(), 0);
            editp.add(lbl);
        }
        return editp;
    }

    @Override
    protected void performOk() {
        try {
            this.copyValuesToEntry();
            this.setVisible(false);
        }
        catch (IllegalArgumentException e) {
            new WarningMessage(this, e.toString().substring(35), "Achtung").show();
        }
    }

    @Override
    protected void performCancel() {
        this.setVisible(false);
    }

    class EditField
    extends LabeledTextField {
        private Field f;

        EditField(Field f) {
            super(f.getName(), f.getValueString());
            this.f = f;
        }

        void updateField() throws IllegalArgumentException {
            this.f.setValue(this.getValue().toString());
        }
    }
}

