/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.transaction.compensating;

import javax.naming.Name;
import javax.naming.directory.ModificationItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.transaction.compensating.CompensatingTransactionOperationExecutor;

public class ModifyAttributesOperationExecutor
implements CompensatingTransactionOperationExecutor {
    private static Log log = LogFactory.getLog((Class)ModifyAttributesOperationExecutor.class);
    private LdapOperations ldapOperations;
    private Name dn;
    private ModificationItem[] compensatingModifications;
    private ModificationItem[] actualModifications;

    public ModifyAttributesOperationExecutor(LdapOperations ldapOperations, Name dn, ModificationItem[] actualModifications, ModificationItem[] compensatingModifications) {
        this.ldapOperations = ldapOperations;
        this.dn = dn;
        this.actualModifications = (ModificationItem[])actualModifications.clone();
        this.compensatingModifications = (ModificationItem[])compensatingModifications.clone();
    }

    public void rollback() {
        try {
            log.debug((Object)"Rolling back modifyAttributes operation");
            this.ldapOperations.modifyAttributes(this.dn, this.compensatingModifications);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to rollback ModifyAttributes operation, dn: " + this.dn));
        }
    }

    public void commit() {
        log.debug((Object)"Nothing to do in commit for modifyAttributes");
    }

    public void performOperation() {
        log.debug((Object)"Performing modifyAttributes operation");
        this.ldapOperations.modifyAttributes(this.dn, this.actualModifications);
    }

    Name getDn() {
        return this.dn;
    }

    LdapOperations getLdapOperations() {
        return this.ldapOperations;
    }

    ModificationItem[] getActualModifications() {
        return this.actualModifications;
    }

    ModificationItem[] getCompensatingModifications() {
        return this.compensatingModifications;
    }
}

