/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.NoSuchAttributeException;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.util.StringUtils;

public class DirContextAdapter
implements DirContextOperations {
    private static final boolean DONT_ADD_IF_DUPLICATE_EXISTS = false;
    private static final String EMPTY_STRING = "";
    private static final boolean ORDER_DOESNT_MATTER = false;
    private static Log log = LogFactory.getLog((Class)DirContextAdapter.class);
    private final Attributes originalAttrs;
    private DistinguishedName dn;
    private DistinguishedName base;
    private boolean updateMode = false;
    private Attributes updatedAttrs;
    private String referralUrl;

    public DirContextAdapter() {
        this(null, null, null);
    }

    public DirContextAdapter(String dnString) {
        this(new DistinguishedName(dnString));
    }

    public DirContextAdapter(Name dn) {
        this(null, dn);
    }

    public DirContextAdapter(Attributes attrs, Name dn) {
        this(attrs, dn, null);
    }

    public DirContextAdapter(Attributes attrs, Name dn, Name base) {
        this(attrs, dn, base, null);
    }

    public DirContextAdapter(Attributes attrs, Name dn, Name base, String referralUrl) {
        this.originalAttrs = attrs != null ? attrs : new BasicAttributes(true);
        this.dn = dn != null ? new DistinguishedName(dn) : new DistinguishedName();
        this.base = base != null ? new DistinguishedName(base) : new DistinguishedName();
        this.referralUrl = referralUrl != null ? referralUrl : EMPTY_STRING;
    }

    protected DirContextAdapter(DirContextAdapter master) {
        this.originalAttrs = (Attributes)master.originalAttrs.clone();
        this.dn = master.dn;
        this.updatedAttrs = (Attributes)master.updatedAttrs.clone();
        this.updateMode = master.updateMode;
    }

    public void setUpdateMode(boolean mode) {
        this.updateMode = mode;
        if (this.updateMode) {
            this.updatedAttrs = new BasicAttributes(true);
        }
    }

    public boolean isUpdateMode() {
        return this.updateMode;
    }

    public String[] getNamesOfModifiedAttributes() {
        ArrayList<String> tmpList = new ArrayList<String>();
        NamingEnumeration<? extends Attribute> attributesEnumeration = this.isUpdateMode() ? this.updatedAttrs.getAll() : this.originalAttrs.getAll();
        try {
            while (attributesEnumeration.hasMore()) {
                Attribute oneAttribute = attributesEnumeration.next();
                tmpList.add(oneAttribute.getID());
            }
        }
        catch (NamingException e) {
            throw LdapUtils.convertLdapException(e);
        }
        finally {
            this.closeNamingEnumeration(attributesEnumeration);
        }
        return tmpList.toArray(new String[0]);
    }

    private void closeNamingEnumeration(NamingEnumeration enumeration) {
        try {
            if (enumeration != null) {
                enumeration.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public ModificationItem[] getModificationItems() {
        if (!this.updateMode) {
            return new ModificationItem[0];
        }
        LinkedList tmpList = new LinkedList();
        NamingEnumeration<? extends Attribute> attributesEnumeration = null;
        try {
            attributesEnumeration = this.updatedAttrs.getAll();
            while (attributesEnumeration.hasMore()) {
                Attribute oneAttr = attributesEnumeration.next();
                this.collectModifications(oneAttr, tmpList);
            }
        }
        catch (NamingException e) {
            throw LdapUtils.convertLdapException(e);
        }
        finally {
            this.closeNamingEnumeration(attributesEnumeration);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Number of modifications:" + tmpList.size()));
        }
        return tmpList.toArray(new ModificationItem[tmpList.size()]);
    }

    private void collectModifications(Attribute changedAttr, List modificationList) throws NamingException {
        Attribute currentAttribute = this.originalAttrs.get(changedAttr.getID());
        if (changedAttr.equals(currentAttribute)) {
            return;
        }
        if (currentAttribute != null && currentAttribute.size() == 1 && changedAttr.size() == 1) {
            modificationList.add(new ModificationItem(2, changedAttr));
        } else if (changedAttr.size() == 0 && currentAttribute != null) {
            modificationList.add(new ModificationItem(3, changedAttr));
        } else if ((currentAttribute == null || currentAttribute.size() == 0) && changedAttr.size() > 0) {
            modificationList.add(new ModificationItem(1, changedAttr));
        } else if (changedAttr.size() > 0 && changedAttr.isOrdered()) {
            modificationList.add(new ModificationItem(2, changedAttr));
        } else if (changedAttr.size() > 0) {
            LinkedList<ModificationItem> myModifications = new LinkedList<ModificationItem>();
            this.collectModifications(currentAttribute, changedAttr, myModifications);
            if (myModifications.isEmpty()) {
                myModifications.add(new ModificationItem(2, changedAttr));
            }
            modificationList.addAll(myModifications);
        }
    }

    private void collectModifications(Attribute originalAttr, Attribute changedAttr, List modificationList) throws NamingException {
        Attribute originalClone = (Attribute)originalAttr.clone();
        BasicAttribute addedValuesAttribute = new BasicAttribute(originalAttr.getID());
        for (int i = 0; i < changedAttr.size(); ++i) {
            Object attributeValue = changedAttr.get(i);
            if (originalClone.remove(attributeValue)) continue;
            addedValuesAttribute.add(attributeValue);
        }
        if (originalClone.size() > 0) {
            modificationList.add(new ModificationItem(3, originalClone));
        }
        if (addedValuesAttribute.size() > 0) {
            modificationList.add(new ModificationItem(1, addedValuesAttribute));
        }
    }

    private boolean isEmptyAttribute(Attribute a) {
        try {
            return a == null || a.size() == 0 || a.get() == null;
        }
        catch (NamingException e) {
            return true;
        }
    }

    private boolean isChanged(String name, Object[] values, boolean orderMatters) {
        Object obj;
        int i;
        boolean emptyNewValue;
        Attribute orig = this.originalAttrs.get(name);
        Attribute prev = this.updatedAttrs.get(name);
        boolean bl = emptyNewValue = values == null || values.length == 0;
        if (emptyNewValue) {
            return orig != null;
        }
        if (orig == null) {
            return true;
        }
        if (orig.size() != values.length) {
            return true;
        }
        if (prev != null && prev.size() != values.length) {
            return true;
        }
        try {
            for (i = 0; i < orig.size(); ++i) {
                obj = orig.get(i);
                if (!(obj instanceof String)) {
                    return true;
                }
                if (!(orderMatters ? !values[i].equals(obj) : !ArrayUtils.contains((Object[])values, (Object)obj))) continue;
                return true;
            }
        }
        catch (NamingException e) {
            return true;
        }
        if (prev != null) {
            try {
                for (i = 0; i < prev.size(); ++i) {
                    obj = prev.get(i);
                    if (!(obj instanceof String)) {
                        return true;
                    }
                    if (!(orderMatters ? !values[i].equals(obj) : !ArrayUtils.contains((Object[])values, (Object)obj))) continue;
                    return true;
                }
            }
            catch (NamingException e) {
                return true;
            }
        }
        return false;
    }

    protected final boolean exists(Attribute attr) {
        return this.exists(attr.getID());
    }

    protected final boolean exists(String attrId) {
        return this.originalAttrs.get(attrId) != null;
    }

    public String getStringAttribute(String name) {
        return (String)this.getObjectAttribute(name);
    }

    public Object getObjectAttribute(String name) {
        Attribute oneAttr = this.originalAttrs.get(name);
        if (oneAttr == null) {
            return null;
        }
        try {
            return oneAttr.get();
        }
        catch (NamingException e) {
            throw LdapUtils.convertLdapException(e);
        }
    }

    public void setAttributeValue(String name, Object value) {
        if (!this.updateMode && value != null) {
            this.originalAttrs.put(name, value);
        }
        if (this.updateMode) {
            BasicAttribute attribute = new BasicAttribute(name);
            if (value != null) {
                attribute.add(value);
            }
            this.updatedAttrs.put(attribute);
        }
    }

    public void addAttributeValue(String name, Object value) {
        this.addAttributeValue(name, value, false);
    }

    public void addAttributeValue(String name, Object value, boolean addIfDuplicateExists) {
        if (!this.updateMode && value != null) {
            Attribute attr = this.originalAttrs.get(name);
            if (attr == null) {
                this.originalAttrs.put(name, value);
            } else {
                attr.add(value);
            }
        } else if (this.updateMode) {
            Attribute attr = this.updatedAttrs.get(name);
            if (attr == null) {
                if (this.originalAttrs.get(name) == null) {
                    this.updatedAttrs.put(name, value);
                } else {
                    attr = (Attribute)this.originalAttrs.get(name).clone();
                    if (addIfDuplicateExists || !attr.contains(value)) {
                        attr.add(value);
                    }
                    this.updatedAttrs.put(attr);
                }
            } else {
                attr.add(value);
            }
        }
    }

    public void removeAttributeValue(String name, Object value) {
        if (!this.updateMode && value != null) {
            Attribute attr = this.originalAttrs.get(name);
            if (attr != null) {
                attr.remove(value);
                if (attr.size() == 0) {
                    this.originalAttrs.remove(name);
                }
            }
        } else if (this.updateMode) {
            Attribute attr = this.updatedAttrs.get(name);
            if (attr == null) {
                if (this.originalAttrs.get(name) != null) {
                    attr = (Attribute)this.originalAttrs.get(name).clone();
                    attr.remove(value);
                    this.updatedAttrs.put(attr);
                }
            } else {
                attr.remove(value);
            }
        }
    }

    public void setAttributeValues(String name, Object[] values) {
        this.setAttributeValues(name, values, false);
    }

    public void setAttributeValues(String name, Object[] values, boolean orderMatters) {
        BasicAttribute a = new BasicAttribute(name, orderMatters);
        for (int i = 0; values != null && i < values.length; ++i) {
            a.add(values[i]);
        }
        if (!this.updateMode && values != null && values.length > 0) {
            this.originalAttrs.put(a);
        }
        if (this.updateMode && this.isChanged(name, values, orderMatters)) {
            this.updatedAttrs.put(a);
        }
    }

    public void update() {
        NamingEnumeration<? extends Attribute> attributesEnumeration = null;
        try {
            attributesEnumeration = this.updatedAttrs.getAll();
            while (attributesEnumeration.hasMore()) {
                Attribute a = attributesEnumeration.next();
                if (this.isEmptyAttribute(a)) {
                    this.originalAttrs.remove(a.getID());
                    continue;
                }
                this.originalAttrs.put(a);
            }
        }
        catch (NamingException e) {
            throw LdapUtils.convertLdapException(e);
        }
        finally {
            this.closeNamingEnumeration(attributesEnumeration);
        }
        this.updatedAttrs = new BasicAttributes(true);
    }

    public String[] getStringAttributes(String name) {
        try {
            return this.collectAttributeValuesAsList(name).toArray(new String[0]);
        }
        catch (NoSuchAttributeException e) {
            return null;
        }
    }

    public Object[] getObjectAttributes(String name) {
        try {
            return this.collectAttributeValuesAsList(name).toArray(new Object[0]);
        }
        catch (NoSuchAttributeException e) {
            return null;
        }
    }

    private List collectAttributeValuesAsList(String name) {
        LinkedList list = new LinkedList();
        LdapUtils.collectAttributeValues(this.originalAttrs, name, list);
        return list;
    }

    public SortedSet getAttributeSortedStringSet(String name) {
        try {
            TreeSet attrSet = new TreeSet();
            LdapUtils.collectAttributeValues(this.originalAttrs, name, attrSet);
            return attrSet;
        }
        catch (NoSuchAttributeException e) {
            return null;
        }
    }

    public void setAttribute(Attribute attribute) {
        if (!this.updateMode) {
            this.originalAttrs.put(attribute);
        } else {
            this.updatedAttrs.put(attribute);
        }
    }

    public Attributes getAttributes() {
        return this.originalAttrs;
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(String name) throws NamingException {
        if (StringUtils.hasLength((String)name)) {
            throw new NameNotFoundException();
        }
        return (Attributes)this.originalAttrs.clone();
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        if (StringUtils.hasLength((String)name)) {
            throw new NameNotFoundException();
        }
        BasicAttributes a = new BasicAttributes(true);
        for (int i = 0; i < attrIds.length; ++i) {
            Attribute target = this.originalAttrs.get(attrIds[i]);
            if (target == null) continue;
            a.put(target);
        }
        return a;
    }

    public void modifyAttributes(Name name, int modOp, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void modifyAttributes(String name, int modOp, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext getSchema(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object lookup(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object lookup(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void bind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void unbind(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void unbind(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration list(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public NameParser getNameParser(String name) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void close() throws NamingException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String getNameInNamespace() {
        DistinguishedName result = new DistinguishedName(this.dn);
        result.prepend(this.base);
        return result.toString();
    }

    public Name getDn() {
        return new DistinguishedName(this.dn);
    }

    public final void setDn(Name dn) {
        if (this.updateMode) {
            throw new IllegalStateException("Not possible to call setDn() on a DirContextAdapter in update mode");
        }
        this.dn = new DistinguishedName(dn.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append(":");
        if (this.dn != null) {
            buf.append(" dn=" + this.dn);
        }
        buf.append(" {");
        try {
            NamingEnumeration<? extends Attribute> i = this.originalAttrs.getAll();
            while (i.hasMore()) {
                Attribute attribute = i.next();
                if (attribute.size() == 1) {
                    buf.append(attribute.getID());
                    buf.append('=');
                    buf.append(attribute.get());
                } else {
                    for (int j = 0; j < attribute.size(); ++j) {
                        if (j > 0) {
                            buf.append(", ");
                        }
                        buf.append(attribute.getID());
                        buf.append('[');
                        buf.append(j);
                        buf.append("]=");
                        buf.append(attribute.get(j));
                    }
                }
                if (!i.hasMore()) continue;
                buf.append(", ");
            }
        }
        catch (NamingException e) {
            log.warn((Object)"Error in toString()");
        }
        buf.append('}');
        return buf.toString();
    }

    public String getReferralUrl() {
        return this.referralUrl;
    }

    public boolean isReferral() {
        return StringUtils.hasLength((String)this.referralUrl);
    }
}

