/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.ui.swing.checkboxtree;

import de.werum.sis.ui.swing.checkboxtree.CheckObject;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckBoxTreeModelListener
implements TreeModelListener {
    private Vector<ChangeListener> listeners = new Vector();

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addElement(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners.contains(changeListener)) {
            this.listeners.removeElement(changeListener);
        }
    }

    protected void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).stateChanged(event);
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        boolean changed = false;
        Object[] modifiedNodes = e.getChildren();
        if (modifiedNodes != null && modifiedNodes.length == 1) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)modifiedNodes[0];
            CheckObject checkObject = (CheckObject)treeNode.getUserObject();
            if (checkObject.isSelected()) {
                this.nodeSelected(treeNode);
            } else {
                this.nodeDeSelected(treeNode);
            }
            changed = true;
        } else {
            TreePath treePath = e.getTreePath();
            if (treePath != null) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                CheckObject checkObject = (CheckObject)treeNode.getUserObject();
                if (checkObject.isSelected()) {
                    this.nodeSelected(treeNode);
                } else {
                    this.nodeDeSelected(treeNode);
                }
                changed = true;
            }
        }
        if (changed) {
            this.fireStateChanged();
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    protected void nodeSelected(DefaultMutableTreeNode node) {
        if (node.getChildCount() > 0) {
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                this.setNodeSelected(child, true);
            }
        }
        for (DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent(); parent != null; parent = (DefaultMutableTreeNode)parent.getParent()) {
            Object userObj = parent.getUserObject();
            if (!(userObj instanceof CheckObject)) continue;
            ((CheckObject)userObj).setSelected(true);
        }
    }

    protected void setNodeSelected(DefaultMutableTreeNode node, boolean selected) {
        if (node == null) {
            return;
        }
        Object userObj = node.getUserObject();
        if (userObj instanceof CheckObject) {
            CheckObject checkObject = (CheckObject)userObj;
            checkObject.setSelected(selected);
        }
        if (node.getChildCount() > 0) {
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                this.setNodeSelected(child, selected);
            }
        }
    }

    protected void nodeDeSelected(DefaultMutableTreeNode node) {
        Object userObj;
        if (node == null) {
            return;
        }
        if (node.getChildCount() > 0) {
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                this.setNodeSelected(child, false);
            }
        }
        HashMap<DefaultMutableTreeNode, Boolean> nodeHasSelectedChildNodes = new HashMap<DefaultMutableTreeNode, Boolean>();
        for (DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent(); parentNode != null && (userObj = parentNode.getUserObject()) instanceof CheckObject && !this.hasSelectedChildNode(parentNode, nodeHasSelectedChildNodes); parentNode = (DefaultMutableTreeNode)parentNode.getParent()) {
            nodeHasSelectedChildNodes.put(parentNode, Boolean.FALSE);
            ((CheckObject)userObj).setSelected(false);
        }
    }

    private boolean hasSelectedChildNode(DefaultMutableTreeNode parentNode, HashMap<DefaultMutableTreeNode, Boolean> nodeHasSelectedChildNodes) {
        boolean hasSelectedChild = false;
        if (parentNode.getChildCount() > 0) {
            Enumeration<TreeNode> children = parentNode.children();
            while (children.hasMoreElements() && !hasSelectedChild) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                Boolean storedStatus = nodeHasSelectedChildNodes.get(child);
                if (storedStatus != null) {
                    if (!storedStatus.booleanValue()) continue;
                    hasSelectedChild = true;
                    break;
                }
                Object userObj = child.getUserObject();
                hasSelectedChild = userObj instanceof CheckObject ? ((CheckObject)userObj).isSelected() : true;
                if (hasSelectedChild) {
                    nodeHasSelectedChildNodes.put(child, Boolean.TRUE);
                    break;
                }
                hasSelectedChild = this.hasSelectedChildNode(child, nodeHasSelectedChildNodes);
                nodeHasSelectedChildNodes.put(child, hasSelectedChild);
            }
        }
        return hasSelectedChild;
    }
}

