/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.meta.generator;

import de.werum.sis.meta.generator.FieldDescription;
import de.werum.sis.meta.generator.ObjectDescription;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLParser
extends DefaultHandler {
    private static final String NAME = "name";
    private static final String ABSTRACT = "abstract";
    private static final String SUPER = "super";
    private static final String COMMENT = "comment";
    private static final String TYPE = "type";
    private static final String REF_CLASS = "refClass";
    private static final String DEFAULT = "default";
    private static final String OBJECT = "object";
    private static final String FIELD = "field";
    private static final String IMPORT = "import";
    private static final String GENERATEMETA = "generateMetaClass";
    private static final String STATSPEZ_OBJECT = "statspezObjects";
    private static final String FORM_OBJECT = "formObjects";
    private String objectCategory = null;
    private char[] textBuffer;
    private int bufferIndex = 0;
    private final int maxChars = 4096;
    private ObjectDescription currentObject = null;
    private FieldDescription currentField = null;
    private boolean inObject = false;
    private boolean inField = false;
    private HashMap objects = new HashMap();

    public XMLParser() {
        this.textBuffer = new char[this.maxChars];
        Arrays.fill(this.textBuffer, ' ');
    }

    public boolean parseFile(String inputFile) throws Exception {
        XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        reader.setContentHandler(this);
        reader.setErrorHandler(this);
        FileReader fr = new FileReader(inputFile);
        reader.parse(new InputSource(fr));
        return true;
    }

    public boolean parseDirectory(String directory) throws Exception {
        File directoryFile = new File(directory);
        if (directoryFile.isDirectory()) {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setContentHandler(this);
            reader.setErrorHandler(this);
            String[] fileNames = directoryFile.list();
            for (int idx = 0; idx < fileNames.length; ++idx) {
                if (fileNames[idx].equals(new String("CVS"))) continue;
                String fileName = directory + System.getProperty("file.separator") + fileNames[idx];
                System.out.println("Parse Datei " + fileName);
                FileReader fr = new FileReader(fileName);
                reader.parse(new InputSource(fr));
            }
            return true;
        }
        return false;
    }

    public Iterator getObjects() {
        return this.objects.values().iterator();
    }

    public Iterator getSortedObjects(Comparator comparator) {
        Vector vector = new Vector(this.objects.values());
        Collections.sort(vector, comparator);
        return vector.iterator();
    }

    public ObjectDescription getObject(String name) {
        if (this.objects.containsKey(name)) {
            return (ObjectDescription)this.objects.get(name);
        }
        System.out.println("Objekt '" + name + "' nicht gefunden!");
        return null;
    }

    public Vector getSubObjects(ObjectDescription object) {
        Iterator tmpObjects = this.getObjects();
        ObjectDescription item = null;
        Vector<ObjectDescription> results = new Vector<ObjectDescription>();
        while (tmpObjects.hasNext()) {
            item = (ObjectDescription)tmpObjects.next();
            if (item.getSuperClass() == null || !item.getSuperClass().equals(object.getName())) continue;
            results.add(item);
        }
        return results;
    }

    private void clearTextBuffer() {
        this.bufferIndex = 0;
    }

    public void startElement(String namespaceURI, String name, String qName, Attributes atts) {
        System.out.print("<" + name);
        if (STATSPEZ_OBJECT.equalsIgnoreCase(name)) {
            this.objectCategory = STATSPEZ_OBJECT;
        } else if (FORM_OBJECT.equalsIgnoreCase(name)) {
            this.objectCategory = FORM_OBJECT;
        } else if (OBJECT.equalsIgnoreCase(name)) {
            this.currentObject = new ObjectDescription();
            this.currentObject.setObjectCategory(this.objectCategory);
            this.inObject = true;
        } else if (FIELD.equalsIgnoreCase(name)) {
            this.currentField = new FieldDescription();
            this.inField = true;
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            System.out.print(" " + atts.getLocalName(i) + " = '" + atts.getValue(i) + "' ");
        }
        System.out.print(">");
    }

    public void endElement(String uri, String name, String qName) {
        System.out.println("</" + name + ">");
        String value = this.bufferIndex > 0 ? String.copyValueOf(this.textBuffer, 0, this.bufferIndex).trim() : "0";
        if (NAME.equalsIgnoreCase(name)) {
            if (this.inField) {
                this.currentField.setName(value);
            } else {
                this.currentObject.setName(value);
                if (value.equals("StatspezObjekt")) {
                    this.currentObject.setAbstractClass(true);
                }
            }
        } else if (ABSTRACT.equalsIgnoreCase(name)) {
            int abstractClass = this.getInteger(value);
            this.currentObject.setAbstractClass(abstractClass != 0);
        } else if (SUPER.equalsIgnoreCase(name)) {
            this.currentObject.setSuperClass(value);
        } else if (COMMENT.equalsIgnoreCase(name)) {
            if (this.inField) {
                this.currentField.setComment(value);
            } else {
                this.currentObject.setComment(value);
            }
        } else if (DEFAULT.equalsIgnoreCase(name)) {
            if (this.inField && !STATSPEZ_OBJECT.equals(this.objectCategory)) {
                this.currentField.setDefaultValue(value);
            }
        } else if (TYPE.equalsIgnoreCase(name)) {
            if (STATSPEZ_OBJECT.equals(this.objectCategory)) {
                if ("Long".equals(value)) {
                    this.currentField.setType("long");
                } else if ("Integer".equals(value)) {
                    this.currentField.setType("int");
                } else if ("Boolean".equals(value)) {
                    this.currentField.setType("boolean");
                } else if ("Short".equals(value)) {
                    this.currentField.setType("short");
                } else if ("Double".equals(value)) {
                    this.currentField.setType("double");
                } else if ("Float".equals(value)) {
                    this.currentField.setType("float");
                } else {
                    this.currentField.setType(value);
                }
            } else {
                this.currentField.setType(value);
            }
        } else if (REF_CLASS.equalsIgnoreCase(name)) {
            if (this.currentField.getType().equalsIgnoreCase("Ref")) {
                if ("StatspezObjekt".equals(value)) {
                    this.currentField.setType("MetaElement");
                } else if (!"String".equals(value)) {
                    this.currentField.setType("Meta" + value);
                } else {
                    this.currentField.setType(value);
                }
            } else if ("StatspezObjekt".equals(value)) {
                this.currentField.setType("MetaElement[]");
            } else if (!"String".equals(value)) {
                this.currentField.setType("Meta" + value + "[]");
            } else {
                this.currentField.setType(value + "[]");
            }
        } else if (FIELD.equalsIgnoreCase(name)) {
            this.currentObject.addField(this.currentField);
            this.currentField = null;
            this.inField = false;
        } else if (GENERATEMETA.equalsIgnoreCase(name)) {
            int generateMeta = this.getInteger(value);
            this.currentObject.setGenerateMetaClass(generateMeta != 0);
        } else if (IMPORT.equalsIgnoreCase(name)) {
            if (this.inObject) {
                this.currentObject.addImport(value);
            }
        } else if (OBJECT.equalsIgnoreCase(name)) {
            this.objects.put(this.currentObject.getName(), this.currentObject);
            this.currentObject = null;
            this.inObject = false;
        }
        this.clearTextBuffer();
    }

    public void characters(char[] ch, int start, int length) {
        String ausgabe = new String(ch, start, length);
        System.out.print(ausgabe);
        block4: for (int i = start; i < start + length && this.bufferIndex < this.maxChars; ++i) {
            switch (ch[i]) {
                case '\t': 
                case '\r': {
                    continue block4;
                }
                case ' ': {
                    if (this.bufferIndex > 0 && (this.textBuffer[this.bufferIndex - 1] == ' ' || this.textBuffer[this.bufferIndex - 1] == '\n')) continue block4;
                }
                default: {
                    this.textBuffer[this.bufferIndex++] = ch[i];
                }
            }
        }
    }

    public int getInteger(String value) {
        if (value.length() > 0) {
            return Integer.parseInt(value);
        }
        return 0;
    }
}

