/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.mapping.display;

import de.werum.sis.mapping.debug.Logger;
import de.werum.sis.mapping.display.MappingTreeCellRenderer;
import de.werum.sis.mapping.item.tree.MappingTreeModel;
import de.werum.sis.mapping.item.tree.MappingTreeNode;
import de.werum.sis.mapping.item.tree.MappingTreePath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MappingJTree
extends JTree {
    private static final long serialVersionUID = 3690757276252320819L;
    private static final BasicStroke dotStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f}, 0.0f);
    private int treeType_ = 0;
    private boolean hasRemovedElements_ = false;

    public MappingJTree(MappingTreeModel newModel) {
        super(newModel);
        this.setCellRenderer(new MappingTreeCellRenderer());
        this.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.setShowsRootHandles(true);
    }

    public MappingJTree(MappingTreePath[] treepath) {
        this(MappingJTree.buildTreeModel(treepath));
    }

    public void expandNode(MappingTreeNode expandNode) {
        this.expandPath(new TreePath(expandNode.getPath()));
        if (expandNode.getAllowsChildren() && expandNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = expandNode.children();
            while (e.hasMoreElements()) {
                this.expandNode((MappingTreeNode)e.nextElement());
            }
        }
    }

    public void remove(MappingTreeNode treenode) {
        if (treenode == null) {
            return;
        }
        ((MappingTreeModel)this.getModel()).removeNodeFromParent(treenode);
        this.hasRemovedElements_ = true;
    }

    public void remove(List survivor) {
        if (survivor == null || survivor.size() < 1) {
            return;
        }
        Iterator iter = this.getMappingTreeNode(survivor).iterator();
        while (iter.hasNext()) {
            this.remove((MappingTreeNode)iter.next());
        }
    }

    public void expandAll() {
        this.expandNode((MappingTreeNode)this.getModel().getRoot());
    }

    public void setModel(MappingTreeModel newModel) {
        super.setModel(newModel);
        this.hasRemovedElements_ = false;
    }

    public void selectNodes(List assignedkeys) {
        this.selectChildNodes((MappingTreeNode)this.getModel().getRoot(), assignedkeys);
    }

    public static final synchronized MappingTreeModel buildTreeModel(MappingTreePath[] treepath) {
        MappingTreeModel treemodel = new MappingTreeModel();
        if (treepath != null) {
            for (int pidx = 0; pidx < treepath.length; ++pidx) {
                treemodel.buildModel(treepath[pidx]);
                Logger.getInstance().log(40, (Object)"build TreeModel", " for: " + treepath[pidx].toString());
            }
        }
        return treemodel;
    }

    private Map getChildRows(MappingTreeNode actualnode, int defaultrownum) {
        HashMap<String, Integer> _keyindex = new HashMap<String, Integer>();
        int newdefaultrownum = defaultrownum;
        Object[] nodes = actualnode.getMappingTreeNode();
        MappingTreePath path = new MappingTreePath(nodes);
        if (this.isVisible(path)) {
            newdefaultrownum = this.getRowForPath(path);
        }
        if (actualnode.getMappingElementObject().isHasKey()) {
            _keyindex.put(actualnode.getMappingElementObject().getKey(), new Integer(newdefaultrownum));
        }
        if (!actualnode.isLeaf() && actualnode.getChildCount() > 0) {
            Enumeration<? extends TreeNode> childs = actualnode.children();
            while (childs.hasMoreElements()) {
                MappingTreeNode c = (MappingTreeNode)childs.nextElement();
                _keyindex.putAll(this.getChildRows(c, newdefaultrownum));
            }
        }
        return _keyindex;
    }

    public List getMappingTreeNode(List key) {
        if (key == null || key.size() < 1) {
            return null;
        }
        return this.getMappingTreeNodes((MappingTreeNode)this.getModel().getRoot(), key);
    }

    public MappingTreeNode getMappingTreeNode(String key) {
        if (key == null || key.equals("")) {
            return null;
        }
        ArrayList<String> keylist = new ArrayList<String>();
        keylist.add(key);
        List helper = this.getMappingTreeNodes((MappingTreeNode)this.getModel().getRoot(), keylist);
        if (helper.size() > 0) {
            return (MappingTreeNode)helper.get(0);
        }
        return null;
    }

    private List getMappingTreeNodes(MappingTreeNode actualnode, List searchkey) {
        ArrayList<MappingTreeNode> _nodelist = new ArrayList<MappingTreeNode>();
        if (actualnode.isLeaf() && actualnode.getMappingElementObject().isHasKey() && searchkey.contains(actualnode.getMappingElementObject().getKey())) {
            _nodelist.add(actualnode);
        }
        if (!actualnode.isLeaf() && actualnode.getChildCount() > 0) {
            Enumeration<? extends TreeNode> childs = actualnode.children();
            while (childs.hasMoreElements()) {
                MappingTreeNode c = (MappingTreeNode)childs.nextElement();
                _nodelist.addAll(this.getMappingTreeNodes(c, searchkey));
            }
        }
        return _nodelist;
    }

    private void selectChildNodes(MappingTreeNode actualnode, List assignedkeys) {
        Object[] nodes = actualnode.getMappingTreeNode();
        MappingTreePath path = new MappingTreePath(nodes);
        if (actualnode.getMappingElementObject().isHasKey() && assignedkeys.contains(actualnode.getMappingElementObject().getKey())) {
            this.addSelectionPath(path);
            assignedkeys.remove(actualnode.getMappingElementObject().getKey());
        }
        if (!actualnode.isLeaf() && actualnode.getChildCount() > 0) {
            Enumeration<? extends TreeNode> childs = actualnode.children();
            while (childs.hasMoreElements()) {
                MappingTreeNode c = (MappingTreeNode)childs.nextElement();
                this.selectChildNodes(c, assignedkeys);
            }
        }
    }

    public Map getIndexForKeys() {
        return this.getChildRows((MappingTreeNode)this.getModel().getRoot(), 0);
    }

    public void setType(int type) {
        this.treeType_ = type;
    }

    public int getType() {
        return this.treeType_;
    }

    public boolean hasRemovedElements() {
        return this.hasRemovedElements_;
    }

    public boolean isType(int type) {
        return this.treeType_ == type;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Stroke stroke = ((Graphics2D)g).getStroke();
        ((Graphics2D)g).setStroke(dotStroke);
        g.setColor(Color.lightGray);
        int rows = this.getRowCount();
        int y = 0;
        for (int i = 0; i <= rows; ++i) {
            g.drawLine(0, y, this.getWidth(), y);
            y += this.getRowHeight();
        }
        ((Graphics2D)g).setStroke(stroke);
    }
}

