/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.csv.filter;

import de.werum.sis.csv.filter.FilterField;
import de.werum.sis.csv.filter.FilterFieldGroup;
import de.werum.sis.csv.filter.FilterFieldSet;
import de.werum.sis.csv.filter.FilterStructure;
import java.util.LinkedList;
import java.util.List;

public class FilterFieldSetInstance
extends FilterStructure {
    private FilterFieldSet fieldSet;

    public String getNameForLanguage(String language) {
        String result = this.getName();
        if (result != null && result.length() > 0) {
            String[] names;
            int index = result.indexOf(91);
            if (index > 0) {
                result = result.substring(0, index).trim();
            }
            if (language != null && language.length() == 2 && !language.equalsIgnoreCase("de") && (names = this.getName().split("\\[")) != null && names.length > 0) {
                for (int i = 0; i < names.length; ++i) {
                    String name;
                    if (!names[i].toLowerCase().startsWith(language.toLowerCase() + ":") || (index = names[i].indexOf(93)) <= 3 || (name = names[i].substring(3, index).trim()).length() <= 0) continue;
                    result = name;
                    break;
                }
            }
        }
        return result;
    }

    public FilterFieldSetInstance(FilterFieldSet fieldSet) {
        this.fieldSet = fieldSet;
    }

    public FilterFieldSet getFieldSet() {
        return this.fieldSet;
    }

    public FilterFieldSetInstance getCopy(FilterFieldSet copiedFieldSet) {
        FilterFieldSetInstance copy = new FilterFieldSetInstance(copiedFieldSet);
        this.copyInto(copy);
        return copy;
    }

    public FilterField[] getPossibleSelectors() {
        LinkedList<FilterField> result = new LinkedList<FilterField>();
        this.getPossibleSelectors(this.getFields(), result);
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new FilterField[0]);
    }

    private void getPossibleSelectors(List<Object> fieldList, List<FilterField> result) {
        for (Object object : fieldList) {
            FilterFieldGroup fieldGroup;
            if (object instanceof FilterField) {
                FilterField field = (FilterField)object;
                if (field.getDefaultValue() == null || field.getDefaultValue().length() <= 0 || field.getPosition() == null || field.getPosition() <= 0) continue;
                result.add(field);
                continue;
            }
            if (!(object instanceof FilterFieldGroup) || (fieldGroup = (FilterFieldGroup)object).getNumber() != 1) continue;
            this.getPossibleSelectors(fieldGroup.getFields(), result);
        }
    }
}

