/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.crypt;

import de.werum.sis.crypt.CipherPacker;
import de.werum.sis.crypt.CryptProperties;
import de.werum.sis.trace.ConsoleLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;

public class CryptKeyPairGenerator {
    private ConsoleLogger lg = ConsoleLogger.getInstance();
    private CryptProperties properties;
    private KeyPairGenerator key_gen = null;
    private CipherPacker cipherPacker = null;

    public CryptKeyPairGenerator(CryptProperties properties) throws GeneralSecurityException, IOException {
        this.properties = properties;
        this.key_gen = KeyPairGenerator.getInstance(properties.getAsymetricAlgorithm(this.properties.getEncryptPackagingUserId()), properties.getProviderName(this.properties.getEncryptPackagingUserId()));
        this.key_gen.initialize(1024);
        this.cipherPacker = new CipherPacker(properties);
    }

    public void generate(String keyRef) throws GeneralSecurityException, IOException {
        URL url = new URL(this.properties.getKeyRepositoryUrl() + this.properties.getKeyStart() + keyRef + this.properties.getKeyEndPublic());
        url.openConnection();
        File pubKeyFile = new File(url.getFile());
        url = new URL(this.properties.getKeyRepositoryUrl() + this.properties.getKeyStart() + keyRef + this.properties.getKeyEndPrivate());
        url.openConnection();
        File privKeyFile = new File(url.getFile());
        if (pubKeyFile.exists() || privKeyFile.exists()) {
            this.lg.print(2, keyRef + ": Oeffentliche oder private Schluesseldatei existiert schon. Referenz ausgelassen.");
        } else {
            KeyPair key_pair = this.key_gen.generateKeyPair();
            PublicKey publicKey = key_pair.getPublic();
            PrivateKey privateKey = key_pair.getPrivate();
            FileOutputStream pub_out = new FileOutputStream(pubKeyFile);
            this.cipherPacker.packKey(pub_out, publicKey);
            pub_out.close();
            FileOutputStream priv_out = new FileOutputStream(privKeyFile);
            this.cipherPacker.packKey(priv_out, privateKey);
            priv_out.close();
            this.lg.print(3, keyRef + " generiert.");
        }
    }
}

