/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.MetaCustomSDFMerkmal;
import de.statspez.sdf.generator.meta.MetaCustomSDFMetaMerkmal;
import de.statspez.sdf.generator.meta.Types;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;

public class ParserUtil {
    public static String removeWhitespaces(String text) {
        StringBuffer buffer = new StringBuffer();
        if (text != null && text.length() > 0) {
            char[] chars = text.trim().toCharArray();
            int i = 0;
            while (i < chars.length) {
                switch (chars[i]) {
                    case '\t': 
                    case '\n': 
                    case ' ': {
                        if (buffer.length() <= 0 || buffer.charAt(buffer.length() - 1) == ' ') break;
                        buffer.append(' ');
                        break;
                    }
                    case '\r': {
                        break;
                    }
                    default: {
                        buffer.append(chars[i]);
                    }
                }
                ++i;
            }
        }
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    public static String[] getSpaceSeparatedTokens(String text) {
        String[] result = text != null && text.length() > 0 ? text.split(" ") : null;
        return result;
    }

    public static String createSpecification(MetaSDFMerkmal merkmal) {
        StringBuffer specification = new StringBuffer();
        String mask = merkmal.getMaske();
        if (!(mask != null && mask.length() != 0 || 5 != merkmal.getTyp() && 6 != merkmal.getTyp() && 7 != merkmal.getTyp())) {
            StringBuffer buffer = new StringBuffer((int)merkmal.getLaenge() + 1);
            buffer.append('-');
            int i = 0;
            while ((long)i < merkmal.getLaenge()) {
                buffer.append('#');
                ++i;
            }
            mask = buffer.toString();
        }
        specification.append("WENN NICHT WERT HAT TYP ");
        specification.append(Types.getPLType(merkmal.getTyp()));
        if (mask != null && mask.length() > 0) {
            specification.append("('");
            specification.append(ParserUtil.getEscapedPlausiString(mask));
            specification.append("')");
        }
        specification.append(" DANN RUECKGABE FALSCH ENDE\n");
        switch (merkmal.getTyp()) {
            case 1: 
            case 2: 
            case 3: {
                if (merkmal.getLaenge() > 0L && merkmal.getMinimaleLaenge() > 0L && merkmal.getLaenge() == merkmal.getMinimaleLaenge()) {
                    specification.append("WENN &WERTLAENGE(WERT) /= ");
                    specification.append(merkmal.getLaenge());
                    specification.append(" DANN RUECKGABE FALSCH ENDE\n");
                    break;
                }
                if (merkmal.getMinimaleLaenge() > 0L) {
                    specification.append("WENN &WERTLAENGE(WERT) < ");
                    specification.append(merkmal.getMinimaleLaenge());
                    specification.append(" DANN RUECKGABE FALSCH ENDE\n");
                }
                if (merkmal.getLaenge() <= 0L) break;
                specification.append("WENN &WERTLAENGE(WERT) > ");
                specification.append(merkmal.getLaenge());
                specification.append(" DANN RUECKGABE FALSCH ENDE\n");
                break;
            }
            case 6: {
                specification.append("WENN WERT < 0 DANN RUECKGABE FALSCH ENDE\n");
                break;
            }
            case 7: {
                specification.append("WENN WERT <= 0 DANN RUECKGABE FALSCH ENDE\n");
            }
        }
        String referringClassificationName = null;
        if (merkmal instanceof MetaCustomSDFMerkmal) {
            referringClassificationName = ((MetaCustomSDFMerkmal)merkmal).getReferringClassificationName();
        } else if (merkmal instanceof MetaCustomSDFMetaMerkmal) {
            referringClassificationName = ((MetaCustomSDFMetaMerkmal)merkmal).getReferringClassificationName();
        }
        if (referringClassificationName != null && referringClassificationName.length() > 0) {
            specification.append("WENN NICHT WERT IN #");
            specification.append(referringClassificationName);
            specification.append(" DANN RUECKGABE FALSCH ENDE\n");
        } else if (merkmal.getWertebereich() != null && merkmal.getWertebereich().length() > 0) {
            if (1 == merkmal.getWertTyp()) {
                specification.append("WENN NICHT WERT IN {");
                specification.append(merkmal.getWertebereich());
                specification.append("} DANN RUECKGABE FALSCH ENDE\n");
            } else if (2 == merkmal.getWertTyp()) {
                specification.append("WENN NICHT &HAT_FORMAT('");
                specification.append(ParserUtil.getEscapedPlausiString(merkmal.getWertebereich()));
                specification.append("', WERT) DANN RUECKGABE FALSCH ENDE\n");
            }
        }
        specification.append("RUECKGABE WAHR");
        return specification.toString();
    }

    public static String getEscapedPlausiString(String string) {
        StringBuffer buffer = new StringBuffer();
        if (string != null && string.length() > 0) {
            char[] chars = string.toCharArray();
            int i = 0;
            while (i < chars.length) {
                switch (chars[i]) {
                    case '\'': 
                    case '\\': {
                        buffer.append('\\');
                    }
                }
                buffer.append(chars[i]);
                ++i;
            }
        }
        return buffer.toString();
    }
}

