/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.MetaCustomSDFFeldReferenz;
import de.statspez.sdf.generator.meta.SDFTags;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.statspez.sdf.generator.parser.TypesParser;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.Reference;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IncludeVariableParser
extends SubParser {
    private MetaCustomSDFFeldReferenz feldReferenz = null;

    public IncludeVariableParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("includeVariable".equalsIgnoreCase(localName)) {
            String variable = atts.getValue("variable");
            if (variable == null) {
                throw new MetaParseException("Variable nicht definiert!");
            }
            this.feldReferenz.setReferenceName(SDFTags.dekodiereXMLName(variable));
            this.feldReferenz.setAttributRequired(TypesParser.parseRequired(atts.getValue("required")));
            this.feldReferenz.setKey(TypesParser.parseKey(atts.getValue("is-key")));
            this.resolver().registerForResolve(new Reference((MetaElementInterface)this.feldReferenz, "FEATURE", variable));
        } else if ("setValue".equalsIgnoreCase(localName)) {
            this.feldReferenz.setVorgabeWertAenderbar(TypesParser.parseMutable(atts.getValue("mutable")));
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("setValue".equalsIgnoreCase(localName)) {
            this.feldReferenz.setVorgabeWert(chars);
        } else {
            handled = false;
        }
        return handled;
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("includeVariable".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("includeVariable".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.feldReferenz = new MetaCustomSDFFeldReferenz();
            this.feldReferenz.setArt((short)1);
            this.enable();
        } else if ("setValue".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else {
            throw MetaParseException.unknownTagException((String)localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("includeVariable".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName)) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return this.feldReferenz;
    }
}

