/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.XmlResource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaManager;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltPackage;
import net.sf.saxon.s9api.streams.Steps;
import net.sf.saxon.testdriver.Spec;
import net.sf.saxon.testdriver.TestDriver;
import net.sf.saxon.testdriver.Xslt30TestSuiteDriverHE;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Environment
implements URIResolver {
    public Processor processor;
    public Map<String, XdmNode> sourceDocs = new HashMap<String, XdmNode>();
    public Map<String, String> streamedSecondaryDocs = new HashMap<String, String>();
    public String streamedContent;
    public File streamedFile;
    public String streamedInputValidation = "skip";
    public XPathCompiler xpathCompiler;
    public XQueryCompiler xqueryCompiler;
    public XsltCompiler xsltCompiler;
    public XsltExecutable xsltExecutable;
    public File exportedStylesheet;
    public XdmItem contextItem;
    public HashMap<QName, XdmValue> params = new HashMap();
    public boolean usable = true;
    public boolean failedToBuild = false;
    public FastStringBuffer paramDeclarations = new FastStringBuffer(256);
    public FastStringBuffer paramDecimalDeclarations = new FastStringBuffer(256);
    public UnparsedTextURIResolver unparsedTextResolver;
    public List<ResetAction> resetActions = new ArrayList<ResetAction>();
    public boolean schemaAvailable = false;
    public boolean outputTree = true;
    public boolean outputSerialize = false;
    public Map<String, CatalogResource> catalogResources = new HashMap<String, CatalogResource>();
    public Map<String, List<String>> jsCollections;
    private static final String DEFAULT_COLLECTION_URI = "http://www.w3.org/qt3-test-suite/default.collection.uri";

    public static Environment createLocalEnvironment(URI baseURI, int generateByteCode, boolean unfolded, Spec spec, TestDriver testDriver) {
        Environment environment = new Environment();
        environment.processor = new Processor(!testDriver.driverProc.getSaxonEdition().equals("HE"));
        environment.processor.setConfigurationProperty(Feature.OPTIMIZATION_LEVEL, (Object)testDriver.optimizerFlags);
        Environment.configureByteCode(testDriver, environment, generateByteCode);
        environment.xpathCompiler = environment.processor.newXPathCompiler();
        environment.xpathCompiler.setBaseURI(baseURI);
        environment.xqueryCompiler = environment.processor.newXQueryCompiler();
        environment.xqueryCompiler.setBaseURI(baseURI);
        environment.xsltCompiler = environment.processor.newXsltCompiler();
        if (testDriver.runWithJS) {
            environment.xsltCompiler.setTargetEdition("JS");
        }
        if (environment.processor.getSaxonEdition().equals("EE")) {
            environment.xsltCompiler.setJustInTimeCompilation(testDriver.jitFlag);
        }
        environment.xsltCompiler.setRelocatable(testDriver.relocatable);
        if (spec == Spec.XT30) {
            environment.xpathCompiler.setLanguageVersion("3.1");
        } else if (spec == Spec.XT20) {
            throw new AssertionError((Object)"Unsupported spec: XSLT 2.0");
        }
        if (unfolded) {
            testDriver.addInjection(environment.xqueryCompiler);
        }
        if (testDriver.tracing) {
            environment.xsltCompiler.setCompileWithTracing(true);
        }
        environment.processor.getUnderlyingConfiguration().setDefaultCollection(null);
        environment.processor.setConfigurationProperty(Feature.STABLE_UNPARSED_TEXT, (Object)true);
        return environment;
    }

    public static Environment processEnvironment(TestDriver driver, XPathCompiler xpc, XdmNode env, Map<String, Environment> environments, Environment defaultEnvironment) throws SaxonApiException {
        StreamSource styleSource;
        String fileName;
        Environment environment = new Environment();
        String name = env.attribute("name");
        if (name != null && !driver.quiet) {
            System.err.println("Loading environment " + name);
        }
        environment.processor = new Processor(!driver.driverProc.getSaxonEdition().equals("HE"));
        if (defaultEnvironment != null) {
            environment.processor.setConfigurationProperty(Feature.XSD_VERSION, defaultEnvironment.processor.getConfigurationProperty(Feature.XSD_VERSION));
        }
        driver.prepareForSQL(environment.processor);
        environment.processor.setConfigurationProperty(Feature.EXPATH_FILE_DELETE_TEMPORARY_FILES, (Object)true);
        environment.processor.setConfigurationProperty(Feature.LINE_NUMBERING, (Object)true);
        Environment.configureByteCode(driver, environment, driver.generateByteCode);
        environment.xpathCompiler = environment.processor.newXPathCompiler();
        environment.xpathCompiler.setBaseURI(env.getBaseURI());
        environment.xqueryCompiler = environment.processor.newXQueryCompiler();
        environment.xqueryCompiler.setBaseURI(env.getBaseURI());
        if (driver.spec.shortSpecName.equals("XT")) {
            environment.xsltCompiler = environment.processor.newXsltCompiler();
            if (driver.runWithJS) {
                environment.xsltCompiler.setTargetEdition("JS");
            }
            if (environment.processor.getSaxonEdition().equals("EE")) {
                environment.xsltCompiler.setJustInTimeCompilation(driver.jitFlag);
            }
            environment.xsltCompiler.setRelocatable(driver.relocatable);
        }
        if (driver.unfolded) {
            driver.addInjection(environment.xqueryCompiler);
        }
        DocumentBuilder builder = environment.processor.newDocumentBuilder();
        builder.setTreeModel(driver.treeModel);
        environment.sourceDocs = new HashMap<String, XdmNode>();
        if (environments != null && name != null) {
            environments.put(name, environment);
        }
        for (XdmNode prop : env.children("http://saxon.sf.net/", "property")) {
            String propName = prop.attribute("name");
            String propValue = prop.attribute("value");
            environment.processor.setConfigurationProperty(propName, (Object)propValue);
        }
        for (XdmNode dependency : env.getParent().children("dependency")) {
            if (driver.ensureDependencySatisfied(dependency, environment)) continue;
            environment.usable = false;
        }
        for (XdmNode dependency : env.getParent().select(Steps.child((String)"dependencies").then(Steps.child((String)"*"))).asList()) {
            if (driver.ensureDependencySatisfied(dependency, environment)) continue;
            environment.usable = false;
        }
        Environment.setBaseUri(driver, xpc, env, environment);
        Environment.registerCollations(xpc, env, environment);
        Environment.declareNamespaces(xpc, env, environment);
        SchemaManager manager = environment.processor.getSchemaManager();
        boolean validateSources = Environment.loadSchemaDocuments(driver, xpc, env, environment, manager);
        Environment.loadSourceDocuments(driver, xpc, env, environment, builder, manager, validateSources);
        Environment.createCollectionUriResolver(driver, xpc, env, environment, builder);
        Environment.createUnparsedTextResolver(driver, xpc, env, environment);
        Environment.registerDecimalFormats(driver, xpc, env, environment);
        Environment.declareExternalVariables(driver, xpc, env, environment);
        Environment.declareOutputControls(driver, xpc, (XdmItem)env, environment);
        for (XdmNode param : env.children("context-item")) {
            String select = param.attribute("select");
            XdmValue value = xpc.evaluate(select, null);
            environment.contextItem = value.itemAt(0);
        }
        for (XdmItem stylesheet : xpc.evaluate("package[@role='secondary']", (XdmItem)env)) {
            fileName = ((XdmNode)stylesheet).attribute("file");
            styleSource = new StreamSource(env.getBaseURI().resolve(fileName).toString());
            try {
                XsltPackage pkg = environment.xsltCompiler.compilePackage((Source)styleSource);
                environment.xsltCompiler.importPackage(pkg);
                environment.processor.getUnderlyingConfiguration().getDefaultXsltCompilerInfo().getPackageLibrary().addPackage(pkg.getUnderlyingPreparedPackage());
            }
            catch (SaxonApiException e) {
                e.printStackTrace();
                driver.println("**** failure while compiling environment-defined stylesheet package " + fileName);
                environment.failedToBuild = true;
                environment.usable = false;
            }
            catch (Exception e) {
                e.printStackTrace();
                driver.println("****Failure " + e + " in compiling environment " + name);
                environment.failedToBuild = true;
                environment.usable = false;
            }
        }
        for (XdmItem stylesheet : xpc.evaluate("stylesheet[not(@role='secondary')]", (XdmItem)env)) {
            fileName = ((XdmNode)stylesheet).attribute("file");
            styleSource = new StreamSource(env.getBaseURI().resolve(fileName).toString());
            try {
                if (driver.export) {
                    File exportFile;
                    if (driver.runWithJS) {
                        String sourceFile = env.getBaseURI().resolve(fileName).toString();
                        environment.exportedStylesheet = driver.exportStylesheet(environment.xsltCompiler, sourceFile);
                        continue;
                    }
                    if (driver.xxCompilerLocation != null && !environment.xsltCompiler.isSchemaAware()) {
                        if (driver.xxCompiler == null) {
                            XsltCompiler c = driver.driverProc.newXsltCompiler();
                            driver.xxCompiler = c.compile((Source)new StreamSource(new File(driver.xxCompilerLocation)));
                        }
                        exportFile = new File(driver.resultsDir + "/export/" + name + ".sef");
                        Xslt30Transformer transformer = driver.xxCompiler.load30();
                        transformer.setInitialMode(new QName("compile-complete"));
                        Serializer serializer = driver.driverProc.newSerializer(exportFile);
                        transformer.applyTemplates((Source)styleSource, (Destination)serializer);
                        environment.xsltExecutable = environment.xsltCompiler.loadExecutablePackage(exportFile.toURI());
                        continue;
                    }
                    exportFile = new File(driver.resultsDir + "/export/" + name + ".sef");
                    System.err.println("Exporting package to " + exportFile.getAbsolutePath());
                    XsltPackage compiledPack = environment.xsltCompiler.compilePackage((Source)styleSource);
                    compiledPack.save(exportFile);
                    environment.xsltExecutable = environment.xsltCompiler.loadExecutablePackage(exportFile.toURI());
                    continue;
                }
                environment.xsltExecutable = environment.xsltCompiler.compile((Source)styleSource);
            }
            catch (SaxonApiException e) {
                driver.println(e.getMessage());
                driver.println("**** failure while compiling environment-defined stylesheet " + fileName);
                environment.failedToBuild = true;
                environment.usable = false;
            }
        }
        return environment;
    }

    private static void configureByteCode(TestDriver driver, Environment environment, int generate) {
        if (environment.processor.getSaxonEdition().equals("EE")) {
            if (generate == 0) {
                environment.processor.setConfigurationProperty(Feature.GENERATE_BYTE_CODE, (Object)true);
                environment.processor.setConfigurationProperty(Feature.THRESHOLD_FOR_HOTSPOT_BYTE_CODE, (Object)1);
                environment.processor.setConfigurationProperty(Feature.DEBUG_BYTE_CODE, (Object)false);
                environment.processor.setConfigurationProperty(Feature.MAX_COMPILED_CLASSES, (Object)1000000);
            } else if (generate > 0) {
                environment.processor.setConfigurationProperty(Feature.GENERATE_BYTE_CODE, (Object)true);
                environment.processor.setConfigurationProperty(Feature.THRESHOLD_FOR_HOTSPOT_BYTE_CODE, (Object)generate);
                environment.processor.setConfigurationProperty(Feature.DEBUG_BYTE_CODE, (Object)false);
                environment.processor.setConfigurationProperty(Feature.MAX_COMPILED_CLASSES, (Object)1000000);
            } else {
                environment.processor.setConfigurationProperty(Feature.GENERATE_BYTE_CODE, (Object)false);
                environment.processor.setConfigurationProperty(Feature.DEBUG_BYTE_CODE, (Object)false);
            }
            if (generate >= 0 && driver.isDebugByteCode()) {
                environment.processor.setConfigurationProperty(Feature.DEBUG_BYTE_CODE, (Object)true);
                environment.processor.setConfigurationProperty(Feature.DEBUG_BYTE_CODE_DIR, (Object)"debugByteCode");
            }
        }
    }

    private static void declareOutputControls(TestDriver driver, XPathCompiler xpc, XdmItem env, Environment environment) throws SaxonApiException {
        String needsSerialization = xpc.evaluate("string((output/@serialize,'no')[1])", env).toString();
        environment.outputSerialize = "yes".equals(needsSerialization);
        String needsTree = xpc.evaluate("string((output/@tree,'yes')[1])", env).toString();
        environment.outputTree = "yes".equals(needsTree);
    }

    private static void setBaseUri(TestDriver driver, XPathCompiler xpc, XdmNode env, Environment environment) {
        for (XdmNode base : env.children("static-base-uri")) {
            String uri = base.attribute("uri");
            if (uri == null || "#UNDEFINED".equals(uri)) {
                environment.xqueryCompiler.setBaseURI(null);
                driver.println("**** Error: The BaseURI values null and #UNDEFINED are not supported in this test driver");
                continue;
            }
            try {
                environment.xpathCompiler.setBaseURI(new URI(uri));
                environment.xqueryCompiler.setBaseURI(new URI(uri));
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                driver.println("**** invalid base URI " + uri);
            }
        }
    }

    private static void registerCollations(XPathCompiler xpc, XdmNode env, Environment environment) throws SaxonApiException {
        for (XdmNode base : env.children("collation")) {
            String defaultAtt;
            String uri = base.attribute("uri");
            if (uri.equals("http://www.w3.org/2010/09/qt-fots-catalog/collation/caseblind") || uri.equals("http://www.w3.org/xslts/collation/caseblind")) {
                Configuration config = xpc.getProcessor().getUnderlyingConfiguration();
                try {
                    StringCollator collator = config.getCollation("http://saxon.sf.net/collation?ignore-case=yes");
                    environment.processor.declareCollation(uri, ((SimpleCollation)collator).getComparator());
                }
                catch (XPathException e) {
                    throw new SaxonApiException((Throwable)e);
                }
            }
            if ((defaultAtt = base.attribute("default")) == null || !defaultAtt.trim().equals("true") && !defaultAtt.trim().equals("1")) continue;
            environment.xpathCompiler.declareDefaultCollation(uri);
            environment.xqueryCompiler.declareDefaultCollation(uri);
            if (environment.xsltCompiler == null) continue;
            environment.xsltCompiler.declareDefaultCollation(uri);
        }
    }

    private static void declareNamespaces(XPathCompiler xpc, XdmNode env, Environment environment) throws SaxonApiException {
        for (XdmNode nsElement : env.children("namespace")) {
            String prefix = nsElement.attribute("prefix");
            String uri = nsElement.attribute("uri");
            environment.xpathCompiler.declareNamespace(prefix, uri);
            environment.xqueryCompiler.declareNamespace(prefix, uri);
            if (!uri.equals("http://expath.org/ns/file")) continue;
            String base = nsElement.getBaseURI().toString();
            if (base.startsWith("file:///")) {
                base = base.substring(7);
            } else if (base.startsWith("file:/")) {
                base = base.substring(5);
            }
            File file = new File(base);
            file = file.getParentFile();
            System.setProperty("expath.base.directory", file.getAbsolutePath());
        }
    }

    private static boolean loadSchemaDocuments(TestDriver driver, XPathCompiler xpc, XdmNode env, Environment environment, SchemaManager manager) throws SaxonApiException {
        boolean validateSources = false;
        for (XdmNode schema : env.children("schema")) {
            String role = schema.attribute("role");
            String xsdVersion = schema.attribute("xsd-version");
            if (manager == null) {
                driver.println("*** Processor is not schema aware");
                environment.usable = false;
                return false;
            }
            if (!driver.treeModel.isSchemaAware()) {
                driver.println("*** Tree model is not schema aware");
                environment.usable = false;
                return false;
            }
            if (xsdVersion != null) {
                manager.setXsdVersion(xsdVersion);
            } else {
                manager.setXsdVersion("1.0");
            }
            if ("secondary".equals(role)) continue;
            String href = schema.attribute("file");
            String ns = schema.attribute("uri");
            if (href == null) {
                try {
                    Source[] sources = manager.getSchemaURIResolver().resolve(ns, null, new String[0]);
                    manager.load(sources[0]);
                }
                catch (Exception e) {
                    driver.println("*** Failed to load schema by URI: " + ns + " - " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                File file = new File(env.getBaseURI().resolve(href));
                try {
                    manager.load((Source)new StreamSource(file));
                }
                catch (SaxonApiException err) {
                    driver.println("*** Failed to load schema: " + href + " - " + err.getMessage());
                }
                catch (NullPointerException err) {
                    err.printStackTrace();
                    driver.println("*** NPE: Failed to load schema: " + href + " - " + err.getMessage());
                }
            }
            xpc.importSchemaNamespace(ns);
            environment.xpathCompiler.importSchemaNamespace(ns);
            if ("source-reference".equals(role)) {
                validateSources = true;
            }
            if (!"stylesheet-import".equals(role)) continue;
            environment.xsltCompiler.setSchemaAware(true);
        }
        return validateSources;
    }

    private static void declareExternalVariables(TestDriver driver, XPathCompiler xpc, XdmNode env, Environment environment) throws SaxonApiException {
        for (XdmNode param : env.children("param")) {
            QName varQName;
            XdmValue value;
            String varName = param.attribute("name");
            String source = param.attribute("source");
            if (source != null) {
                XdmNode sourceDoc = environment.sourceDocs.get(source);
                if (sourceDoc == null) {
                    driver.println("**** Unknown source document " + source);
                }
                value = sourceDoc;
            } else {
                String select = param.attribute("select");
                value = xpc.evaluate(select, null);
            }
            boolean isStatic = Xslt30TestSuiteDriverHE.isTrue("static").test((XdmItem)param);
            int colon = varName.indexOf(58);
            if (colon >= 0) {
                NamespaceMap resolver = param.getUnderlyingNode().getAllNamespaces();
                String namespace = resolver.getURIForPrefix(varName.substring(0, colon), false);
                varQName = new QName(namespace, varName);
            } else {
                varQName = new QName(varName);
            }
            environment.xpathCompiler.declareVariable(varQName);
            if (!Xslt30TestSuiteDriverHE.isTrue("declared").test((XdmItem)param)) {
                environment.paramDeclarations.append("declare variable $" + varName + " external; ");
            }
            if (isStatic) {
                environment.xsltCompiler.setParameter(varQName, value);
                System.err.println("set " + varQName + " = " + value);
                continue;
            }
            environment.params.put(varQName, value);
        }
    }

    private static void registerDecimalFormats(TestDriver driver, XPathCompiler xpc, XdmNode env, Environment environment) throws SaxonApiException {
        for (XdmNode decimalFormat : env.children("decimal-format")) {
            DecimalFormatManager dfm = environment.xpathCompiler.getUnderlyingStaticContext().getDecimalFormatManager();
            String formatName = decimalFormat.attribute("name");
            StructuredQName formatQName = null;
            if (formatName != null) {
                if (formatName.indexOf(58) < 0) {
                    formatQName = new StructuredQName("", "", formatName);
                } else {
                    try {
                        formatQName = StructuredQName.fromLexicalQName((CharSequence)formatName, (boolean)false, (boolean)true, (NamespaceResolver)decimalFormat.getUnderlyingNode().getAllNamespaces());
                    }
                    catch (XPathException e) {
                        driver.println("**** Invalid QName as decimal-format name");
                        formatQName = new StructuredQName("", "", "error-name");
                    }
                }
                environment.paramDecimalDeclarations.append("declare decimal-format " + formatQName.getEQName() + " ");
            } else {
                environment.paramDecimalDeclarations.append("declare default decimal-format ");
            }
            DecimalSymbols symbols = formatQName == null ? dfm.getDefaultDecimalFormat() : dfm.obtainNamedDecimalFormat(formatQName);
            symbols.setHostLanguage(HostLanguage.XQUERY, driver.spec.getNumericVersion());
            for (XdmItem decimalFormatAtt : xpc.evaluate("@* except @name", (XdmItem)decimalFormat)) {
                XdmNode formatAttribute = (XdmNode)decimalFormatAtt;
                String property = formatAttribute.getNodeName().getLocalName();
                String value = formatAttribute.getStringValue();
                environment.paramDecimalDeclarations.append(property + "=\"" + value + "\" ");
                try {
                    switch (property) {
                        case "decimal-separator": {
                            symbols.setDecimalSeparator(value);
                            break;
                        }
                        case "grouping-separator": {
                            symbols.setGroupingSeparator(value);
                            break;
                        }
                        case "exponent-separator": {
                            symbols.setExponentSeparator(value);
                            break;
                        }
                        case "infinity": {
                            symbols.setInfinity(value);
                            break;
                        }
                        case "NaN": {
                            symbols.setNaN(value);
                            break;
                        }
                        case "minus-sign": {
                            symbols.setMinusSign(value);
                            break;
                        }
                        case "percent": {
                            symbols.setPercent(value);
                            break;
                        }
                        case "per-mille": {
                            symbols.setPerMille(value);
                            break;
                        }
                        case "zero-digit": {
                            symbols.setZeroDigit(value);
                            break;
                        }
                        case "digit": {
                            symbols.setDigit(value);
                            break;
                        }
                        case "pattern-separator": {
                            symbols.setPatternSeparator(value);
                            break;
                        }
                        default: {
                            driver.println("**** Unknown decimal format attribute " + property);
                            break;
                        }
                    }
                }
                catch (XPathException e) {
                    driver.println("**** " + e.getMessage());
                }
            }
            environment.paramDecimalDeclarations.append(";");
            try {
                symbols.checkConsistency(formatQName);
            }
            catch (XPathException err) {
                driver.println("**** " + err.getMessage());
            }
        }
    }

    private static void createUnparsedTextResolver(TestDriver driver, XPathCompiler xpc, XdmNode env, Environment environment) throws SaxonApiException {
        HashMap<URI, URL> resources = new HashMap<URI, URL>();
        HashMap<URI, String> encodings = new HashMap<URI, String>();
        for (XdmNode resource : env.children("resource")) {
            CatalogResource res = new CatalogResource();
            res.uri = resource.attribute("uri");
            String href = resource.attribute("file");
            res.encoding = resource.attribute("encoding");
            res.mediaType = resource.attribute("media-type");
            if (href == null) continue;
            Serializable obj = null;
            if (href.startsWith("http")) {
                try {
                    obj = res.url = new URL(href);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else {
                res.file = new File(env.getBaseURI().resolve(href));
                obj = res.file;
            }
            try {
                resources.put(new URI(res.uri), (URL)obj);
                encodings.put(new URI(res.uri), res.encoding);
                URI abs = resource.getBaseURI().resolve(res.uri);
                resources.put(abs, (URL)obj);
                encodings.put(abs, res.encoding);
                environment.catalogResources.put(abs.toString(), res);
            }
            catch (URISyntaxException e) {
                driver.println("** Invalid URI in environment: " + e.getMessage());
            }
            if (res.mediaType == null || !res.mediaType.endsWith("xquery")) continue;
            driver.registerXQueryModule(res.uri, res.file);
        }
        if (!resources.isEmpty()) {
            environment.unparsedTextResolver = (absoluteURI, encoding, config) -> {
                if (encoding == null) {
                    encoding = (String)encodings.get(absoluteURI);
                }
                if (encoding == null) {
                    encoding = "utf-8";
                }
                try {
                    Charset charset = Charset.forName(encoding);
                    CharsetDecoder decoder = charset.newDecoder();
                    decoder = decoder.onMalformedInput(CodingErrorAction.REPORT);
                    decoder = decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                    Object obj = resources.get(absoluteURI);
                    if (obj instanceof File) {
                        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)obj), decoder));
                    }
                    URL resource = (URL)resources.get(absoluteURI);
                    if (resource == null) {
                        resource = absoluteURI.toURL();
                    }
                    InputStream in = resource.openConnection().getInputStream();
                    return new BufferedReader(new InputStreamReader(in, decoder));
                }
                catch (IOException ioe) {
                    throw new XPathException(ioe.getMessage(), "FOUT1170");
                }
                catch (IllegalCharsetNameException | UnsupportedCharsetException icne) {
                    throw new XPathException("Invalid encoding name: " + encoding, "FOUT1190");
                }
            };
        }
    }

    private static void createCollectionUriResolver(TestDriver driver, XPathCompiler xpc, XdmNode env, Environment environment, DocumentBuilder builder) throws SaxonApiException {
        if (!environment.usable) {
            return;
        }
        final HashMap<String, 1> collections = new HashMap<String, 1>();
        AbstractResourceCollection collectioni = null;
        Configuration config = environment.processor.getUnderlyingConfiguration();
        for (XdmNode xdmNode : env.children("collection")) {
            URI u;
            final ArrayList<Object> resourcesi = new ArrayList<Object>();
            String collectionURI = xdmNode.attribute("uri");
            if (collectionURI == null) {
                collectionURI = "";
            }
            if (collectionURI.isEmpty()) {
                collectionURI = DEFAULT_COLLECTION_URI;
                config.setDefaultCollection(DEFAULT_COLLECTION_URI);
            }
            try {
                u = new URI(collectionURI);
            }
            catch (URISyntaxException e) {
                driver.println("**** Invalid collection URI " + collectionURI);
                break;
            }
            if (!collectionURI.equals("") && !u.isAbsolute()) {
                u = env.getBaseURI().resolve(collectionURI);
                collectionURI = u.toString();
            }
            final String cURI = collectionURI;
            collectioni = new AbstractResourceCollection(config){

                public void addResource(Resource r) {
                    resourcesi.add(r);
                }

                public String getCollectionURI() {
                    return cURI;
                }

                public Iterator<String> getResourceURIs(XPathContext context) {
                    ArrayList<String> resourceUris = new ArrayList<String>();
                    for (Resource resource : resourcesi) {
                        resourceUris.add(resource.getResourceURI());
                    }
                    return resourceUris.iterator();
                }

                public Iterator<Resource> getResources(XPathContext context) {
                    return resourcesi.iterator();
                }

                public boolean isStable(XPathContext context) {
                    return true;
                }
            };
            for (XdmNode source : xdmNode.children("source")) {
                XdmNode doc;
                String href = source.attribute("file");
                String frag = null;
                int hash = href.indexOf(35);
                if (hash > 0) {
                    frag = href.substring(hash + 1);
                    href = href.substring(0, hash);
                }
                File file = new File(env.getBaseURI().resolve(href));
                String xinc = source.attribute("xinclude");
                if ("true".equals(xinc)) {
                    StreamSource ss = new StreamSource(file);
                    AugmentedSource as = AugmentedSource.makeAugmentedSource((Source)ss);
                    as.setXIncludeAware(true);
                    doc = builder.build((Source)as);
                } else {
                    doc = builder.build(file);
                }
                if (frag != null) {
                    XdmNode selected = (XdmNode)environment.xpathCompiler.evaluateSingle("id('" + frag + "')", (XdmItem)doc);
                    if (selected == null) {
                        driver.println("**** Fragment not found: " + frag);
                        break;
                    }
                    resourcesi.add(new XmlResource(config, selected.getUnderlyingNode()));
                } else {
                    resourcesi.add(new XmlResource(config, doc.getUnderlyingNode()));
                }
                environment.sourceDocs.put(href, doc);
            }
            for (Resource resource : xdmNode.children("resources")) {
                String uri = resource.attribute("uri");
                String href = resource.attribute("file");
                String encoding = resource.attribute("encoding");
                String media = resource.attribute("media-type");
                AbstractResourceCollection.InputDetails details = new AbstractResourceCollection.InputDetails();
                details.encoding = encoding;
                details.contentType = media;
                if (href == null) continue;
                if (href.startsWith("http")) {
                    try {
                        details.resourceUri = href;
                        URL url = new URL(href);
                        URLConnection connection = url.openConnection();
                        if (details.contentType != null) continue;
                        details.contentType = connection.getContentType();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                File file = new File(env.getBaseURI().resolve(href));
                details.resourceUri = file.toURI().toString();
                try {
                    Resource resourcej = collectioni.makeResource(config, details);
                    if (resourcej != null) {
                        resourcesi.add(resourcej);
                    } else {
                        driver.println("** Error in building collection environment: Resource " + href + " not found: ");
                    }
                }
                catch (XPathException e) {
                    driver.println("** Error in building collection environment: " + e.getMessage());
                }
                if (media == null || !href.endsWith("xquery")) continue;
                driver.registerXQueryModule(uri, file);
            }
            for (XdmNode query : xdmNode.children("query")) {
                String queryExpr = query.getStringValue();
                XQueryEvaluator evaluator = environment.xqueryCompiler.compile(queryExpr).load();
                XdmValue result = evaluator.evaluate();
                for (final XdmItem itemi : result) {
                    resourcesi.add(new Resource(){

                        public String getResourceURI() {
                            return "";
                        }

                        public Item getItem(XPathContext context) {
                            return itemi.getUnderlyingValue();
                        }

                        public String getContentType() {
                            return null;
                        }
                    });
                }
            }
            collections.put(collectionURI, collectioni);
        }
        if (collections != null) {
            environment.processor.getUnderlyingConfiguration().setCollectionFinder(new CollectionFinder(){

                public ResourceCollection findCollection(XPathContext context, String collectionURI) throws XPathException {
                    if (collectionURI == null) {
                        collectionURI = "";
                    }
                    return (ResourceCollection)collections.get(collectionURI);
                }
            });
        }
        if (driver.runWithJS) {
            environment.jsCollections = new HashMap<String, List<String>>();
            for (Map.Entry entry : collections.entrySet()) {
                String uri = (String)entry.getKey();
                ArrayList<String> lexicalContents = new ArrayList<String>();
                ResourceCollection contents = (ResourceCollection)entry.getValue();
                XPathContext context = environment.processor.getUnderlyingConfiguration().getConversionContext();
                try {
                    Iterator iter = contents.getResources(context);
                    while (iter.hasNext()) {
                        Resource resource;
                        resource = (Resource)iter.next();
                        Item item = resource.getItem(context);
                        if (!(item instanceof NodeInfo)) continue;
                        String lexicalXml = QueryResult.serialize((NodeInfo)((NodeInfo)item));
                        lexicalContents.add(lexicalXml);
                    }
                }
                catch (XPathException e) {
                    e.printStackTrace();
                }
                environment.jsCollections.put(uri, lexicalContents);
            }
        }
    }

    private static void loadSourceDocuments(TestDriver driver, XPathCompiler xpc, XdmNode env, Environment environment, DocumentBuilder builder, SchemaManager manager, boolean validateSources) throws SaxonApiException {
        for (XdmNode source : env.children("source")) {
            File file;
            CatalogResource res = new CatalogResource();
            String rawUri = source.attribute("uri");
            String role = source.attribute("role");
            if (rawUri != null) {
                res.uri = env.getBaseURI().resolve(rawUri).toString();
                environment.catalogResources.put(res.uri, res);
            } else if (".".equals(role)) {
                environment.catalogResources.put("", res);
            }
            res.mediaType = source.attribute("media-type");
            if ("application/xml".equals(res.mediaType)) continue;
            String validation = source.attribute("validation");
            if (validation == null) {
                validation = "skip";
            }
            String streaming = source.attribute("streaming");
            TreeModel selectedTreeModel = builder.getTreeModel();
            if (!validateSources && validation.equals("skip")) {
                builder.setSchemaValidator(null);
            } else if (manager == null) {
                environment.usable = false;
            } else {
                if (!selectedTreeModel.isSchemaAware()) {
                    builder.setTreeModel(TreeModel.TINY_TREE);
                }
                SchemaValidator validator = manager.newSchemaValidator();
                validator.setLax("lax".equals(validation));
                builder.setSchemaValidator(validator);
                environment.xpathCompiler.setSchemaAware(true);
                environment.xqueryCompiler.setSchemaAware(true);
                if (environment.xsltCompiler != null) {
                    environment.xsltCompiler.setSchemaAware(true);
                }
            }
            String href = source.attribute("file");
            String select = source.attribute("select");
            String xinc = source.attribute("xinclude");
            if ("true".equals(streaming)) {
                if (".".equals(role)) {
                    if (href == null) {
                        environment.streamedContent = xpc.evaluate("string(content)", (XdmItem)source).toString();
                    } else {
                        res.file = environment.streamedFile = new File(env.getBaseURI().resolve(href));
                    }
                    environment.streamedInputValidation = validation;
                } else {
                    file = new File(env.getBaseURI().resolve(href));
                    environment.streamedSecondaryDocs.put(file.toURI().toString(), validation);
                    res.file = file;
                }
            } else if (driver.runWithJS || driver.isAltova) {
                if (select != null) {
                    driver.println("source select=path not supported by this test driver");
                    environment.usable = false;
                }
                if (".".equals(role)) {
                    if (href == null) {
                        environment.streamedContent = xpc.evaluate("string(content)", (XdmItem)source).toString();
                    } else {
                        res.file = environment.streamedFile = new File(env.getBaseURI().resolve(href));
                    }
                    environment.streamedInputValidation = validation;
                } else {
                    file = new File(env.getBaseURI().resolve(href));
                    environment.streamedSecondaryDocs.put(file.toURI().toString(), validation);
                    res.file = file;
                }
            } else {
                StreamSource ss;
                String baseUri;
                StringReader stringReader;
                FileInputStream fileInputStream;
                File file2;
                block54: {
                    file2 = null;
                    fileInputStream = null;
                    stringReader = null;
                    baseUri = null;
                    if (href != null) {
                        URI fileLoc = env.getBaseURI().resolve(href);
                        baseUri = fileLoc.toString();
                        if (fileLoc.getScheme().equals("file")) {
                            file2 = new File(env.getBaseURI().resolve(href));
                            if (res.uri == null) {
                                res.uri = file2.toURI().toString();
                            }
                            res.file = file2;
                        }
                        try {
                            if (file2 == null) {
                                ss = new StreamSource(fileLoc.toString());
                            } else {
                                fileInputStream = new FileInputStream(file2);
                                ss = new StreamSource(fileInputStream, res.uri);
                            }
                            if ("true".equals(xinc)) {
                                AugmentedSource as = AugmentedSource.makeAugmentedSource((Source)ss);
                                as.setXIncludeAware(true);
                                ss = as;
                            }
                            break block54;
                        }
                        catch (FileNotFoundException e) {
                            driver.println("*** failed to find source document " + href);
                            continue;
                        }
                    }
                    baseUri = res.uri;
                    if (res.uri == null) {
                        baseUri = env.getBaseURI().toString();
                    }
                    String content = xpc.evaluate("string(content)", (XdmItem)source).toString();
                    stringReader = new StringReader(content);
                    ss = new StreamSource(stringReader, baseUri);
                }
                if (selectedTreeModel.getName().equals("DOM") || selectedTreeModel.getName().equals("DOMINO")) {
                    Document doc = null;
                    try {
                        InputSource is;
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        factory.setNamespaceAware(true);
                        javax.xml.parsers.DocumentBuilder db = factory.newDocumentBuilder();
                        if (file2 != null) {
                            doc = db.parse(file2);
                        } else if (fileInputStream != null) {
                            is = new InputSource(fileInputStream);
                            is.setSystemId(baseUri);
                            doc = db.parse(is);
                        } else if (stringReader != null) {
                            is = new InputSource(stringReader);
                            is.setSystemId(baseUri);
                            doc = db.parse(is);
                        }
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        e.printStackTrace();
                    }
                    if (selectedTreeModel.getName().equals("DOM")) {
                        NodeInfo root = new DocumentWrapper((Node)doc, res.uri, environment.processor.getUnderlyingConfiguration()).getRootNode();
                        res.doc = (XdmNode)XdmValue.wrap((Sequence)root);
                    } else {
                        res.doc = driver.makeDominoTree(doc, environment.processor.getUnderlyingConfiguration(), res.uri);
                    }
                    environment.sourceDocs.put(res.uri, res.doc);
                } else {
                    try {
                        builder.setLineNumbering(true);
                        res.doc = builder.build((Source)ss);
                        environment.sourceDocs.put(res.uri, res.doc);
                        environment.sourceDocs.put(rawUri, res.doc);
                    }
                    catch (SaxonApiException e) {
                        driver.println("*** failed to build source document " + href + " - " + e.getMessage());
                    }
                }
                builder.setTreeModel(selectedTreeModel);
                XdmNode selectedItem = res.doc;
                if (select != null) {
                    XPathSelector selector = environment.xpathCompiler.compile(select).load();
                    selector.setContextItem((XdmItem)selectedItem);
                    selectedItem = selector.evaluateSingle();
                }
                if (role != null) {
                    if (".".equals(role)) {
                        environment.contextItem = selectedItem;
                    } else if (role.startsWith("$")) {
                        String varName = role.substring(1);
                        environment.params.put(new QName(varName), (XdmValue)selectedItem);
                        environment.xpathCompiler.declareVariable(new QName(varName));
                        environment.paramDeclarations.append("declare variable $" + varName + " external; ");
                    }
                }
            }
            String definesStylesheet = source.attribute("defines-stylesheet");
            if (definesStylesheet != null) {
                definesStylesheet = definesStylesheet.trim();
            }
            if (!"true".equals(definesStylesheet) && !"1".equals(definesStylesheet) || driver.runWithJS) continue;
            try {
                Source styleSource = environment.xsltCompiler.getAssociatedStylesheet(((XdmNode)environment.contextItem).asSource(), null, null, null);
                environment.xsltExecutable = environment.xsltCompiler.compile(styleSource);
            }
            catch (SaxonApiException e) {
                driver.println("*** failed to compile stylesheet referenced in source document " + href);
            }
        }
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        XdmNode node = this.sourceDocs.get(href);
        if (node == null) {
            String uri;
            if (base == null) {
                base = href;
                href = "";
            }
            try {
                uri = ResolveURI.makeAbsolute((String)href, (String)base).toString();
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                uri = href;
            }
            String val = this.streamedSecondaryDocs.get(uri);
            if (val != null) {
                StreamSource source = new StreamSource(uri);
                if (!val.equals("skip")) {
                    source = AugmentedSource.makeAugmentedSource((Source)source);
                    ((AugmentedSource)source).setSchemaValidationMode(Validation.getCode((String)val));
                }
                return source;
            }
            return null;
        }
        return node.asSource();
    }

    public CatalogResource getContextDocument() {
        return this.catalogResources.get("");
    }

    public static abstract class ResetAction {
        public abstract void reset(Environment var1);
    }

    public static class CatalogResource {
        public File file;
        public URL url;
        public String mediaType;
        public String encoding;
        public String uri;
        public XdmNode doc;
    }
}

