/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.VFS;
import org.codehaus.jackson.map.ObjectMapper;
import org.saiku.service.util.exception.SaikuServiceException;
import org.saiku.web.rest.objects.acl.Acl;
import org.saiku.web.rest.objects.acl.AclEntry;
import org.saiku.web.rest.objects.acl.enumeration.AclMethod;
import org.saiku.web.rest.objects.repository.IRepositoryObject;
import org.saiku.web.rest.objects.repository.RepositoryFileObject;
import org.saiku.web.rest.objects.repository.RepositoryFolderObject;
import org.saiku.web.rest.resources.ISaikuRepository;
import org.saiku.web.service.SessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Path(value="/saiku/{username}/repository2")
@XmlAccessorType(value=XmlAccessType.NONE)
public class BasicRepositoryResource2
implements ISaikuRepository {
    private static final Logger log = LoggerFactory.getLogger(BasicRepositoryResource2.class);
    private FileObject repo;
    private SessionService sessionService;
    private Acl acl;

    public void setPath(String path) throws Exception {
        try {
            FileSystemManager fileSystemManager;
            FileObject fileObject;
            if (!path.endsWith("" + File.separatorChar)) {
                path = path + File.separatorChar;
            }
            if ((fileObject = (fileSystemManager = VFS.getManager()).resolveFile(path)) == null) {
                throw new IOException("File cannot be resolved: " + path);
            }
            if (!fileObject.exists()) {
                throw new IOException("File does not exist: " + path);
            }
            this.repo = fileObject;
        }
        catch (Exception e) {
            log.error("Error setting path for repository: " + path, (Throwable)e);
        }
    }

    public void setAcl(Acl acl) {
        this.acl = acl;
    }

    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    @Override
    @GET
    @Produces(value={"application/json"})
    public List<IRepositoryObject> getRepository(@QueryParam(value="path") String path, @QueryParam(value="type") String type) {
        ArrayList<IRepositoryObject> objects = new ArrayList<IRepositoryObject>();
        try {
            if (path != null && (path.startsWith("/") || path.startsWith("."))) {
                throw new IllegalArgumentException("Path cannot be null or start with \"/\" or \".\" - Illegal Path: " + path);
            }
            if (this.repo != null) {
                FileObject folder = this.repo;
                if (path != null) {
                    folder = this.repo.resolveFile(path);
                } else {
                    path = this.repo.getName().getRelativeName(folder.getName());
                }
                String username = this.sessionService.getAllSessionObjects().get("username").toString();
                List roles = (List)this.sessionService.getAllSessionObjects().get("roles");
                if (!this.acl.canRead(path, username, roles)) {
                    return new ArrayList<IRepositoryObject>();
                }
                return this.getRepositoryObjects(folder, type);
            }
            throw new Exception("repo URL is null");
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return objects;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/resource/acl")
    public AclEntry getResourceAcl(@QueryParam(value="file") String file) {
        try {
            List roles;
            if (file == null || file.startsWith("/") || file.startsWith(".")) {
                throw new IllegalArgumentException("Path cannot be null or start with \"/\" or \".\" - Illegal Path: " + file);
            }
            String username = this.sessionService.getAllSessionObjects().get("username").toString();
            if (this.acl.canGrant(file, username, roles = (List)this.sessionService.getAllSessionObjects().get("roles"))) {
                return this.getAcl(file);
            }
        }
        catch (Exception e) {
            log.error("Error retrieving ACL for file: " + file, (Throwable)e);
        }
        throw new SaikuServiceException("You dont have permission to retrieve ACL for file: " + file);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/resource/acl")
    public Response setResourceAcl(@FormParam(value="file") String file, @FormParam(value="acl") String aclEntry) {
        try {
            if (file == null || file.startsWith("/") || file.startsWith(".")) {
                throw new IllegalArgumentException("Path cannot be null or start with \"/\" or \".\" - Illegal Path: " + file);
            }
            ObjectMapper mapper = new ObjectMapper();
            log.debug("Set ACL to " + file + " : " + aclEntry);
            AclEntry ae = (AclEntry)mapper.readValue(aclEntry, AclEntry.class);
            String username = this.sessionService.getAllSessionObjects().get("username").toString();
            List roles = (List)this.sessionService.getAllSessionObjects().get("roles");
            FileObject repoFile = this.repo.resolveFile(file);
            if (repoFile.exists() && this.acl.canGrant(file, username, roles)) {
                this.acl.addEntry(file, ae);
                return Response.ok().build();
            }
            log.debug("Repo file does not exist or cannot grant access. repo file:" + repoFile + " - file: " + file);
        }
        catch (Exception e) {
            log.error("An error occured while setting permissions to file: " + file, (Throwable)e);
        }
        return Response.serverError().build();
    }

    @Override
    @GET
    @Produces(value={"text/plain"})
    @Path(value="/resource")
    public Response getResource(@QueryParam(value="file") String file) {
        try {
            if (file == null || file.startsWith("/") || file.startsWith(".")) {
                throw new IllegalArgumentException("Path cannot be null or start with \"/\" or \".\" - Illegal Path: " + file);
            }
            String username = this.sessionService.getAllSessionObjects().get("username").toString();
            List roles = (List)this.sessionService.getAllSessionObjects().get("roles");
            FileObject repoFile = this.repo.resolveFile(file);
            if (!this.acl.canRead(file, username, roles)) {
                return Response.serverError().status(Response.Status.FORBIDDEN).build();
            }
            if (repoFile.exists()) {
                InputStreamReader reader = new InputStreamReader(repoFile.getContent().getInputStream());
                BufferedReader br = new BufferedReader(reader);
                String chunk = "";
                String content = "";
                while ((chunk = br.readLine()) != null) {
                    content = content + chunk + "\n";
                }
                byte[] doc = content.getBytes("UTF-8");
                return Response.ok((Object)doc, (String)"text/plain").header("content-length", (Object)doc.length).build();
            }
            throw new Exception("File does not exist:" + repoFile.getName().getPath());
        }
        catch (FileNotFoundException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception e) {
            log.error("Cannot load query (" + file + ")", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Override
    @POST
    @Path(value="/resource")
    public Response saveResource(@FormParam(value="file") String file, @FormParam(value="content") String content) {
        try {
            if (file == null || file.startsWith("/") || file.startsWith(".")) {
                throw new IllegalArgumentException("Path cannot be null or start with \"/\" or \".\" - Illegal Path: " + file);
            }
            String username = this.sessionService.getAllSessionObjects().get("username").toString();
            List roles = (List)this.sessionService.getAllSessionObjects().get("roles");
            FileObject repoFile = this.repo.resolveFile(file);
            if (!this.acl.canWrite(file, username, roles)) {
                return Response.serverError().status(Response.Status.FORBIDDEN).entity((Object)"You don't have permissions to save here!").type("text/plain").build();
            }
            if (repoFile == null) {
                throw new Exception("Repo File not found");
            }
            if (repoFile.exists()) {
                repoFile.delete();
            }
            if (!StringUtils.isNotBlank((String)content)) {
                repoFile.createFolder();
            } else {
                repoFile.createFile();
                OutputStreamWriter ow = new OutputStreamWriter(repoFile.getContent().getOutputStream());
                BufferedWriter bw = new BufferedWriter(ow);
                bw.write(content);
                bw.close();
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            log.error("Cannot save resource to ( file: " + file + ")", (Throwable)e);
            return Response.serverError().entity((Object)("Cannot save resource to ( file: " + file + ")")).type("text/plain").build();
        }
    }

    @Override
    @DELETE
    @Path(value="/resource")
    public Response deleteResource(@QueryParam(value="file") String file) {
        try {
            if (file == null || file.startsWith("/") || file.startsWith(".")) {
                throw new IllegalArgumentException("Path cannot be null or start with \"/\" or \".\" - Illegal Path: " + file);
            }
            String username = this.sessionService.getAllSessionObjects().get("username").toString();
            List roles = (List)this.sessionService.getAllSessionObjects().get("roles");
            FileObject repoFile = this.repo.resolveFile(file);
            if (repoFile != null && repoFile.exists()) {
                if (this.acl.canWrite(file, username, roles)) {
                    repoFile.delete();
                    return Response.ok().build();
                }
                return Response.serverError().status(Response.Status.FORBIDDEN).build();
            }
        }
        catch (Exception e) {
            log.error("Cannot save resource to (file: " + file + ")", (Throwable)e);
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="/resource/move")
    public Response moveResource(@FormParam(value="source") String source, @FormParam(value="target") String target) {
        try {
            if (source == null || source.startsWith("/") || source.startsWith(".")) {
                throw new IllegalArgumentException("Path cannot be null or start with \"/\" or \".\" - Illegal Path: " + source);
            }
            if (target == null || target.startsWith("/") || target.startsWith(".")) {
                throw new IllegalArgumentException("Path cannot be null or start with \"/\" or \".\" - Illegal Path: " + target);
            }
            String username = this.sessionService.getAllSessionObjects().get("username").toString();
            List roles = (List)this.sessionService.getAllSessionObjects().get("roles");
            FileObject targetFile = this.repo.resolveFile(target);
            if (!this.acl.canWrite(target, username, roles)) {
                return Response.serverError().status(Response.Status.FORBIDDEN).entity((Object)"You don't have permissions to save here!").type("text/plain").build();
            }
            if (targetFile == null) {
                throw new Exception("Repo File not found");
            }
            if (targetFile.exists()) {
                throw new Exception("Target file exists already. Cannot write: " + target);
            }
            FileObject sourceFile = this.repo.resolveFile(source);
            if (!this.acl.canRead(source, username, roles)) {
                return Response.serverError().status(Response.Status.FORBIDDEN).entity((Object)("You don't have permissions to read the source file: " + source)).build();
            }
            if (!sourceFile.exists()) {
                throw new Exception("Source file does not exist: " + source);
            }
            if (!sourceFile.canRenameTo(targetFile)) {
                throw new Exception("Cannot rename " + source + " to " + target);
            }
            sourceFile.moveTo(targetFile);
            return Response.ok().build();
        }
        catch (Exception e) {
            log.error("Cannot move resource from " + source + " to " + target, (Throwable)e);
            return Response.serverError().entity((Object)("Cannot move resource from " + source + " to " + target + " ( " + e.getMessage() + ")")).type("text/plain").build();
        }
    }

    private List<IRepositoryObject> getRepositoryObjects(FileObject root, String fileType) throws Exception {
        ArrayList<IRepositoryObject> repoObjects = new ArrayList<IRepositoryObject>();
        for (FileObject file : root.getChildren()) {
            List roles;
            String username;
            if (file.isHidden()) continue;
            String filename = file.getName().getBaseName();
            String relativePath = this.repo.getName().getRelativeName(file.getName());
            if (!this.acl.canRead(relativePath, username = this.sessionService.getAllSessionObjects().get("username").toString(), roles = (List)this.sessionService.getAllSessionObjects().get("roles"))) continue;
            List<AclMethod> acls = this.acl.getMethods(relativePath, username, roles);
            if (file.getType().equals(FileType.FILE)) {
                if (StringUtils.isNotEmpty((String)fileType) && !filename.endsWith(fileType)) continue;
                String extension = file.getName().getExtension();
                repoObjects.add(new RepositoryFileObject(filename, "#" + relativePath, extension, relativePath, acls));
            }
            if (file.getType().equals(FileType.FOLDER)) {
                repoObjects.add(new RepositoryFolderObject(filename, "#" + relativePath, relativePath, acls, this.getRepositoryObjects(file, fileType)));
            }
            Collections.sort(repoObjects, new Comparator<IRepositoryObject>(){

                @Override
                public int compare(IRepositoryObject o1, IRepositoryObject o2) {
                    if (o1.getType().equals((Object)IRepositoryObject.Type.FOLDER) && o2.getType().equals((Object)IRepositoryObject.Type.FILE)) {
                        return -1;
                    }
                    if (o1.getType().equals((Object)IRepositoryObject.Type.FILE) && o2.getType().equals((Object)IRepositoryObject.Type.FOLDER)) {
                        return 1;
                    }
                    return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
                }
            });
        }
        return repoObjects;
    }

    private AclEntry getAcl(String path) {
        AclEntry entry = this.acl.getEntry(path);
        if (entry == null) {
            entry = new AclEntry();
        }
        return entry;
    }
}

