/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.ArrayList;
import mondrian.olap.MondrianServer;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.olap.Util;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapSchema;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;

public class SaikuMondrianHelper {
    public static RolapConnection getMondrianConnection(OlapConnection con) {
        try {
            if (!(con instanceof MondrianOlap4jConnection)) {
                throw new IllegalArgumentException("Connection has to be instance of MondrianOlap4jConnection");
            }
            MondrianOlap4jConnection mcon = (MondrianOlap4jConnection)con;
            return mcon.getMondrianConnection();
        }
        catch (OlapException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MondrianServer getMondrianServer(OlapConnection con) {
        RolapConnection rcon = SaikuMondrianHelper.getMondrianConnection(con);
        return rcon != null ? rcon.getServer() : null;
    }

    public static boolean isMondrianConnection(OlapConnection con) {
        return con instanceof MondrianOlap4jConnection;
    }

    public static void setRoles(OlapConnection con, String[] roleNames) throws Exception {
        Role role;
        if (!(con instanceof MondrianOlap4jConnection)) {
            throw new IllegalArgumentException("Connection has to be instance of MondrianOlap4jConnection");
        }
        if (roleNames == null) {
            con.setRoleName(null);
            return;
        }
        MondrianOlap4jConnection mcon = (MondrianOlap4jConnection)con;
        RolapConnection rcon = SaikuMondrianHelper.getMondrianConnection((OlapConnection)mcon);
        RolapSchema schema = rcon.getSchema();
        ArrayList<Role> roleList = new ArrayList<Role>();
        for (String roleName : roleNames) {
            Role role1 = schema.lookupRole(roleName);
            if (role1 == null) {
                throw Util.newError((String)("Role '" + roleName + "' not found"));
            }
            roleList.add(role1);
        }
        switch (roleList.size()) {
            case 0: {
                role = null;
                break;
            }
            case 1: {
                role = (Role)roleList.get(0);
                break;
            }
            default: {
                role = RoleImpl.union(roleList);
            }
        }
        rcon.setRole(role);
    }
}

