/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.model.StyleDescription;
import org.apache.poi.hwpf.model.StyleSheet;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;

public final class Word2Forrest {
    Writer _out;
    HWPFDocument _doc;

    public Word2Forrest(HWPFDocument doc, OutputStream stream) throws IOException {
        int x;
        OutputStreamWriter out = new OutputStreamWriter(stream, Charset.forName("UTF-8"));
        this._out = out;
        this._doc = doc;
        this.init();
        this.openDocument();
        this.openBody();
        Range r = doc.getRange();
        StyleSheet styleSheet = doc.getStyleSheet();
        int sectionLevel = 0;
        int lenParagraph = r.numParagraphs();
        boolean inCode = false;
        for (x = 0; x < lenParagraph; ++x) {
            Paragraph p = r.getParagraph(x);
            String text = p.text();
            if (text.trim().length() == 0) continue;
            StyleDescription paragraphStyle = styleSheet.getStyleDescription((int)p.getStyleIndex());
            String styleName = paragraphStyle.getName();
            if (styleName.startsWith("Heading")) {
                int headerLevel;
                if (inCode) {
                    this.closeSource();
                    inCode = false;
                }
                if ((headerLevel = Integer.parseInt(styleName.substring(8))) > sectionLevel) {
                    this.openSection();
                } else {
                    for (int y = 0; y < sectionLevel - headerLevel + 1; ++y) {
                        this.closeSection();
                    }
                    this.openSection();
                }
                sectionLevel = headerLevel;
                this.openTitle();
                this.writePlainText(text);
                this.closeTitle();
                continue;
            }
            int cruns = p.numCharacterRuns();
            CharacterRun run = p.getCharacterRun(0);
            String fontName = run.getFontName();
            if (fontName.startsWith("Courier")) {
                if (!inCode) {
                    this.openSource();
                    inCode = true;
                }
                this.writePlainText(p.text());
                continue;
            }
            if (inCode) {
                inCode = false;
                this.closeSource();
            }
            this.openParagraph();
            this.writePlainText(p.text());
            this.closeParagraph();
        }
        for (x = 0; x < sectionLevel; ++x) {
            this.closeSection();
        }
        this.closeBody();
        this.closeDocument();
        this._out.flush();
    }

    public void init() throws IOException {
        this._out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        this._out.write("<!DOCTYPE document PUBLIC \"-//APACHE//DTD Documentation V1.1//EN\" \"./dtd/document-v11.dtd\">\r\n");
    }

    public void openDocument() throws IOException {
        this._out.write("<document>\r\n");
    }

    public void closeDocument() throws IOException {
        this._out.write("</document>\r\n");
    }

    public void openBody() throws IOException {
        this._out.write("<body>\r\n");
    }

    public void closeBody() throws IOException {
        this._out.write("</body>\r\n");
    }

    public void openSection() throws IOException {
        this._out.write("<section>");
    }

    public void closeSection() throws IOException {
        this._out.write("</section>");
    }

    public void openTitle() throws IOException {
        this._out.write("<title>");
    }

    public void closeTitle() throws IOException {
        this._out.write("</title>");
    }

    public void writePlainText(String text) throws IOException {
        this._out.write(text);
    }

    public void openParagraph() throws IOException {
        this._out.write("<p>");
    }

    public void closeParagraph() throws IOException {
        this._out.write("</p>");
    }

    public void openSource() throws IOException {
        this._out.write("<source><![CDATA[");
    }

    public void closeSource() throws IOException {
        this._out.write("]]></source>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        FileInputStream is = new FileInputStream(args[0]);
        FileOutputStream out = new FileOutputStream("test.xml");
        try {
            new Word2Forrest(new HWPFDocument((InputStream)is), out);
        }
        finally {
            ((OutputStream)out).close();
            ((InputStream)is).close();
        }
    }
}

