/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.api;

import java.io.Serializable;
import org.apache.commons.javaflow.core.ReflectionUtils;
import org.apache.commons.javaflow.core.ResumeParameter;
import org.apache.commons.javaflow.core.StackRecorder;
import org.apache.commons.javaflow.core.SuspendResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Continuation
implements Serializable {
    private static final Log log = LogFactory.getLog(Continuation.class);
    private static final long serialVersionUID = 2L;
    private final StackRecorder stackRecorder;
    private final Object value;

    private Continuation(StackRecorder stackRecorder, Object value) {
        this.stackRecorder = stackRecorder;
        this.value = value;
    }

    public static Object getContext() {
        return StackRecorder.get().getContext();
    }

    public static Continuation startSuspendedWith(Runnable target) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        return new Continuation(new StackRecorder(target), null);
    }

    public static Continuation startWith(Runnable target) {
        return Continuation.startWith(target, null);
    }

    public static Continuation startWith(Runnable target, Object pContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("starting new flow from " + ReflectionUtils.getClassName(target) + "/" + ReflectionUtils.getClassLoaderName(target)));
        }
        return Continuation.startSuspendedWith(target).resume(pContext);
    }

    public static Continuation continueWith(Continuation continuation) {
        return Continuation.continueWith(continuation, null);
    }

    public static Continuation continueWith(Continuation continuation, Object value) {
        if (continuation == null) {
            throw new IllegalArgumentException("continuation parameter must not be null.");
        }
        return continuation.resume(value);
    }

    public Continuation resume() {
        return this.resume(null);
    }

    public Continuation resume(Object value) {
        return this.resumeWith(ResumeParameter.value(value));
    }

    public void terminate() {
        this.resumeWith(ResumeParameter.exit());
    }

    protected Continuation resumeWith(ResumeParameter param) {
        StackRecorder nextStackRecorder;
        SuspendResult result;
        if (log.isDebugEnabled()) {
            log.debug((Object)("continueing with continuation " + ReflectionUtils.getClassName(this) + "/" + ReflectionUtils.getClassLoaderName(this)));
        }
        do {
            if (SuspendResult.EXIT == (result = (nextStackRecorder = new StackRecorder(this.stackRecorder)).execute(param))) {
                return null;
            }
            if (SuspendResult.CANCEL != result) continue;
            return this;
        } while (SuspendResult.AGAIN == result);
        return new Continuation(nextStackRecorder, result.value());
    }

    public boolean isSerializable() {
        return this.stackRecorder.isSerializable();
    }

    public Object value() {
        return this.value;
    }

    public static Object suspend() {
        return Continuation.suspend(null);
    }

    public static Object suspend(Object value) {
        return StackRecorder.suspend(SuspendResult.valueOf(value));
    }

    public static void exit() {
        StackRecorder.exit();
    }

    public static void again() {
        StackRecorder.suspend(SuspendResult.AGAIN);
    }

    public static void cancel() {
        StackRecorder.suspend(SuspendResult.CANCEL);
    }

    public String toString() {
        return "Continuation@" + this.hashCode() + "/" + ReflectionUtils.getClassLoaderName(this);
    }
}

