/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CombiningGenerator<E>
extends AbstractList<List<E>> {
    private final E[] elements;
    private final int size;

    public CombiningGenerator(Collection<E> elements) {
        this.elements = elements.toArray(new Object[elements.size()]);
        if (elements.size() > 31) {
            throw new IllegalArgumentException("too many elements");
        }
        this.size = 1 << this.elements.length;
    }

    public static <T> CombiningGenerator<T> of(Collection<T> elements) {
        return new CombiningGenerator<T>(elements);
    }

    @Override
    public List<E> get(final int index) {
        final int size = Integer.bitCount(index);
        return new AbstractList<E>(){

            @Override
            public E get(int index1) {
                if (index1 < 0 || index1 >= size) {
                    throw new IndexOutOfBoundsException();
                }
                int i = CombiningGenerator.nth(index1, index);
                return CombiningGenerator.this.elements[i];
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    private static int nth(int seek, int b) {
        int i = 0;
        int c = 0;
        while ((b & 1) != 1 || c++ != seek) {
            ++i;
            b >>= 1;
        }
        return i;
    }

    @Override
    public int size() {
        return this.size;
    }

    public static void main(String[] args) {
        ArrayList<String> seed = new ArrayList<String>();
        for (int i = 0; i < 8; ++i) {
            seed.add(String.valueOf(i));
        }
        CombiningGenerator result = new CombiningGenerator(seed);
        for (List list : result) {
            for (Object o : list) {
                System.out.print("|");
                System.out.print(String.valueOf(o));
            }
            System.out.println("|");
        }
    }
}

